/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.interceptor.servlet.StreamExchangeInterceptorServiceMBean;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.servlet.BeanFlowServletContext;

public class BeanFlowServlet
extends HttpServlet {
    private static final long serialVersionUID = -5548272719656324613L;
    public static final String INIT_PARAM_NAME_BEAN_FLOW_PATH_POSTFIX = "BeanFlowPathPostfix";
    public static final String INIT_PARAM_NAME_BEAN_FLOW_INVOKER_FACTORY_SERVICE_NAME = "BeanFlowInvokerFactoryServiceName";
    public static final String INIT_PARAM_NAME_VALIDATE = "Validate";
    public static final String INIT_PARAM_NAME_VALIDATE_FLOW_PREFIX = "ValidateFlowPrefix";
    public static final String INIT_PARAM_NAME_INPUT_ATTRIBUTE_NAME = "InputAttributeName";
    public static final String INIT_PARAM_NAME_OUTPUT_ATTRIBUTE_NAME = "OutputAttributeName";
    public static final String DEFAULT_BEAN_FLOW_PATH_POSTFIX = ".bf";
    public static final String DEFAULT_VALIDATE_FLOW_PREFIX = "validate";
    protected String beanFlowPathPostfix = ".bf";
    protected ServiceName beanFlowInvokerFactoryServiceName;
    protected boolean isValidate;
    protected String validateFlowPrefix = "validate";
    protected String inputAttributeName = StreamExchangeInterceptorServiceMBean.DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME;
    protected String outputAttributeName = StreamExchangeInterceptorServiceMBean.DEFAULT_RESPONSE_OBJECT_ATTRIBUTE_NAME;

    public void init() throws ServletException {
        String outputName;
        String inputName;
        String postfix = this.getBeanFlowPathPostfix();
        if (postfix != null) {
            this.beanFlowPathPostfix = postfix;
        }
        this.beanFlowInvokerFactoryServiceName = this.getBeanFlowInvokerFactoryServiceName();
        if (this.beanFlowInvokerFactoryServiceName == null) {
            throw new ServletException("BeanFlowInvokerFactoryServiceName is null.");
        }
        this.isValidate = this.isValidate();
        String prefix = this.getValidateFlowPrefix();
        if (prefix != null && prefix.length() != 0) {
            this.validateFlowPrefix = prefix;
        }
        if ((inputName = this.getInputAttributeName()) != null) {
            this.inputAttributeName = inputName;
        }
        if ((outputName = this.getOutputAttributeName()) != null) {
            this.outputAttributeName = outputName;
        }
    }

    protected ServiceName getBeanFlowInvokerFactoryServiceName() {
        ServletConfig config = this.getServletConfig();
        String serviceNameStr = config.getInitParameter(INIT_PARAM_NAME_BEAN_FLOW_INVOKER_FACTORY_SERVICE_NAME);
        if (serviceNameStr == null) {
            return null;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        return (ServiceName)editor.getValue();
    }

    protected boolean isValidate() {
        ServletConfig config = this.getServletConfig();
        String isValidateStr = config.getInitParameter(INIT_PARAM_NAME_VALIDATE);
        return isValidateStr == null ? false : Boolean.valueOf(isValidateStr);
    }

    protected String getValidateFlowPrefix() {
        ServletConfig config = this.getServletConfig();
        return config.getInitParameter(INIT_PARAM_NAME_VALIDATE_FLOW_PREFIX);
    }

    protected String getInputAttributeName() {
        ServletConfig config = this.getServletConfig();
        return config.getInitParameter(INIT_PARAM_NAME_INPUT_ATTRIBUTE_NAME);
    }

    protected String getOutputAttributeName() {
        ServletConfig config = this.getServletConfig();
        return config.getInitParameter(INIT_PARAM_NAME_OUTPUT_ATTRIBUTE_NAME);
    }

    protected String getBeanFlowPathPostfix() {
        ServletConfig config = this.getServletConfig();
        return config.getInitParameter(INIT_PARAM_NAME_BEAN_FLOW_PATH_POSTFIX);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doService(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doService(req, resp);
    }

    protected void doService(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String validateFlowName;
        String flowName = req.getPathInfo();
        if (flowName == null) {
            flowName = req.getServletPath();
        }
        if (flowName == null || flowName.length() == 0) {
            resp.sendError(404, "Flow path is null.");
            return;
        }
        if (flowName.endsWith(this.beanFlowPathPostfix)) {
            flowName = flowName.substring(0, flowName.length() - this.beanFlowPathPostfix.length());
        }
        if (flowName.length() == 0) {
            resp.sendError(404, "Flow path is null.");
            return;
        }
        BeanFlowInvokerFactory beanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
        if (!beanFlowInvokerFactory.containsFlow(flowName)) {
            resp.sendError(404, "Flow '" + flowName + "' is not found.");
            return;
        }
        BeanFlowServletContext context = new BeanFlowServletContext(req, resp, req.getAttribute(this.inputAttributeName));
        if (this.validateFlowPrefix != null && beanFlowInvokerFactory.containsFlow(validateFlowName = this.validateFlowPrefix + flowName)) {
            BeanFlowInvoker validateFlow = beanFlowInvokerFactory.createFlow(validateFlowName);
            try {
                Object ret = validateFlow.invokeFlow(context);
                if (ret != null && ret instanceof Boolean && !((Boolean)ret).booleanValue()) {
                    if (context.getOutput() != null) {
                        req.setAttribute(this.outputAttributeName, context.getOutput());
                    }
                    return;
                }
            }
            catch (Exception e) {
                throw new ServletException("Validate error.", (Throwable)e);
            }
        }
        BeanFlowInvoker flow = beanFlowInvokerFactory.createFlow(flowName);
        try {
            Object ret = flow.invokeFlow(context);
            if (context.getOutput() == null) {
                if (ret != null) {
                    req.setAttribute(this.outputAttributeName, ret);
                }
            } else {
                req.setAttribute(this.outputAttributeName, context.getOutput());
            }
        }
        catch (Exception e) {
            throw new ServletException("Flow error.", (Throwable)e);
        }
    }
}

