/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jp.ossc.nimbus.beans.NullIndexPropertyException;
import jp.ossc.nimbus.beans.NullKeyPropertyException;
import jp.ossc.nimbus.beans.NullNestPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ExceptionHandler;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ExceptionHandlingInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.util.ClassMappingTree;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class ExceptionHandlingInterceptorService
extends ServletFilterInterceptorService
implements ExceptionHandlingInterceptorServiceMBean {
    private static final long serialVersionUID = -5888057404214069278L;
    private static final String JMS_EXCEPTION_NAME = "javax.jms.JMSException";
    private static final String GET_LINKED_EXCEPTION_METHOD = "getLinkedException";
    private static final String EHI__00001 = "EHI__00001";
    protected Map exceptionAndHandlerMapping;
    protected ClassMappingTree exceptionMapForHandler;
    protected ServiceName defaultExceptionHandlerServiceName;
    protected ExceptionHandler defaultExceptionHandler;

    public void setExceptionAndHandlerMapping(Map map) {
        this.exceptionAndHandlerMapping = map;
    }

    public Map getExceptionAndHandlerMapping() {
        return this.exceptionAndHandlerMapping;
    }

    public void setDefaultExceptionHandlerServiceName(ServiceName name) {
        this.defaultExceptionHandlerServiceName = name;
    }

    public ServiceName getDefaultExceptionHandlerServiceName() {
        return this.defaultExceptionHandlerServiceName;
    }

    public void startService() throws Exception {
        if (this.exceptionAndHandlerMapping != null) {
            this.exceptionMapForHandler = new ClassMappingTree();
            NimbusClassLoader loader = NimbusClassLoader.getInstance();
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setServiceManagerName(this.getServiceManagerName());
            Iterator exNames = this.exceptionAndHandlerMapping.keySet().iterator();
            while (exNames.hasNext()) {
                String exName = (String)exNames.next();
                String name = (String)this.exceptionAndHandlerMapping.get(exName);
                String condition = null;
                int index = exName.indexOf(40);
                if (index != -1 && exName.charAt(exName.length() - 1) == ')') {
                    condition = exName.substring(index + 1, exName.length() - 1);
                    exName = exName.substring(0, index);
                }
                Class<?> clazz = Class.forName(exName, true, loader);
                editor.setAsText(name);
                ServiceName serviceName = (ServiceName)editor.getValue();
                ExceptionHandler handler = (ExceptionHandler)ServiceManagerFactory.getServiceObject(serviceName);
                if (condition == null) {
                    this.exceptionMapForHandler.add(clazz, handler);
                    continue;
                }
                Condition cond = new Condition(condition, handler);
                try {
                    cond.evaluate((Throwable)clazz.newInstance(), null, null, true);
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
                this.exceptionMapForHandler.add(clazz, cond);
            }
        }
        if (this.defaultExceptionHandlerServiceName != null) {
            this.defaultExceptionHandler = (ExceptionHandler)ServiceManagerFactory.getServiceObject(this.defaultExceptionHandlerServiceName);
        }
    }

    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            Object ret;
            block5: {
                ret = null;
                try {
                    ret = chain.invokeNext(context);
                }
                catch (Throwable th) {
                    ServletRequest request = context.getServletRequest();
                    ServletResponse response = context.getServletResponse();
                    boolean isHandled = false;
                    ExceptionHandler handler = this.getTargetExceptionHandlerCause(th, request, response);
                    if (handler != null) {
                        Throwable targetTh = this.getTargetException(this.exceptionMapForHandler, th, request, response);
                        if (targetTh == null) {
                            targetTh = th;
                        }
                        handler.handleException(targetTh, request, response);
                        isHandled = true;
                    }
                    if (isHandled) break block5;
                    throw th;
                }
            }
            return ret;
        }
        return chain.invokeNext(context);
    }

    protected ExceptionHandler getTargetExceptionHandlerCause(Throwable th, ServletRequest request, ServletResponse response) {
        ExceptionHandler handler = this.getTargetHandlerCause(this.exceptionMapForHandler, th, request, response);
        return handler == null ? this.defaultExceptionHandler : handler;
    }

    protected ExceptionHandler getTargetHandlerCause(ClassMappingTree handlerMap, Throwable th, ServletRequest request, ServletResponse response) {
        Throwable cause;
        if (handlerMap == null) {
            return null;
        }
        List handlers = handlerMap.getValueList(th.getClass());
        if (handlers != null) {
            int imax = handlers.size();
            for (int i = 0; i < imax; ++i) {
                Object handler = handlers.get(i);
                if (handler instanceof Condition) {
                    Condition condition = (Condition)handler;
                    try {
                        if (condition.evaluate(th, request, response)) {
                            return condition.handler;
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().write(EHI__00001, e);
                    }
                    continue;
                }
                return (ExceptionHandler)handler;
            }
        }
        return (cause = this.getCause(th)) == null ? null : this.getTargetHandlerCause(handlerMap, cause, request, response);
    }

    protected Throwable getTargetException(ClassMappingTree handlerMap, Throwable th, ServletRequest request, ServletResponse response) {
        Throwable cause;
        if (handlerMap == null) {
            return th;
        }
        List handlers = handlerMap.getValueList(th.getClass());
        if (handlers != null) {
            int imax = handlers.size();
            for (int i = 0; i < imax; ++i) {
                Object handler = handlers.get(i);
                if (handler instanceof Condition) {
                    Condition condition = (Condition)handler;
                    try {
                        if (condition.evaluate(th, request, response)) {
                            return th;
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().write(EHI__00001, e);
                    }
                    continue;
                }
                return th;
            }
        }
        return (cause = this.getCause(th)) == null ? null : this.getTargetException(handlerMap, cause, request, response);
    }

    protected Throwable getCause(Throwable th) {
        Throwable cause = null;
        if (th instanceof ServletException) {
            cause = ((ServletException)th).getRootCause();
        } else if (th.getClass().getName().equals(JMS_EXCEPTION_NAME)) {
            try {
                cause = (Exception)th.getClass().getMethod(GET_LINKED_EXCEPTION_METHOD, null).invoke((Object)th, null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else {
            cause = th.getCause();
        }
        return cause == th ? null : cause;
    }

    protected static class Condition
    implements Serializable {
        private static final long serialVersionUID = 1115982642791231865L;
        public static final String EXCEPTION_KEY = "exception";
        public static final String REQUEST_KEY = "request";
        public static final String RESPONSE_KEY = "response";
        public ExceptionHandler handler;
        protected transient List properties;
        protected transient Expression expression;
        protected transient List keyList;
        public String condition;
        protected static final String DELIMITER = "@";

        public Condition(String cond, ExceptionHandler handler) throws Exception {
            this.initCondition(cond);
            this.condition = cond;
            this.handler = handler;
        }

        protected void initCondition(String cond) throws Exception {
            this.keyList = new ArrayList();
            this.properties = new ArrayList();
            StringTokenizer token = new StringTokenizer(cond, DELIMITER, true);
            boolean keyFlg = false;
            String beforeToken = null;
            StringBuffer condBuf = new StringBuffer();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                if (!keyFlg) {
                    if (DELIMITER.equals(str)) {
                        keyFlg = true;
                    } else {
                        condBuf.append(str);
                    }
                } else if (DELIMITER.equals(str)) {
                    keyFlg = false;
                    if (beforeToken != null) {
                        String tmpKey = "_conditionKey$" + this.keyList.size();
                        this.keyList.add(tmpKey);
                        condBuf.append(tmpKey);
                        this.properties.add(PropertyFactory.createProperty(beforeToken));
                    } else {
                        condBuf.append(str);
                    }
                }
                beforeToken = str;
            }
            this.expression = ExpressionFactory.createExpression((String)condBuf.toString());
        }

        public boolean evaluate(Throwable th, ServletRequest request, ServletResponse response) throws Exception {
            return this.evaluate(th, request, response, false);
        }

        public boolean evaluate(Throwable th, ServletRequest request, ServletResponse response, boolean isTest) throws Exception {
            JexlContext jexlContext = JexlHelper.createContext();
            Map vars = jexlContext.getVars();
            vars.put(EXCEPTION_KEY, th);
            vars.put(REQUEST_KEY, request);
            vars.put(RESPONSE_KEY, response);
            int size = this.keyList.size();
            for (int i = 0; i < size; ++i) {
                String keyString = (String)this.keyList.get(i);
                Property property = (Property)this.properties.get(i);
                Object val = null;
                try {
                    val = property.getProperty(vars);
                }
                catch (NullNestPropertyException e) {
                }
                catch (NullKeyPropertyException e) {
                }
                catch (NullIndexPropertyException e) {
                }
                catch (InvocationTargetException e) {
                    Throwable th2 = e.getTargetException();
                    if (th2 instanceof Exception) {
                        throw (Exception)th2;
                    }
                    if (th2 instanceof Error) {
                        throw (Error)th2;
                    }
                    throw e;
                }
                jexlContext.getVars().put(keyString, val);
            }
            Object exp = this.expression.evaluate(jexlContext);
            if (exp instanceof Boolean) {
                return (Boolean)exp;
            }
            if (exp == null && isTest) {
                return true;
            }
            throw new IllegalArgumentException(this.expression.getExpression());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            try {
                this.initCondition(this.condition);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

