/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.proxy;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import jp.ossc.nimbus.core.FactoryServiceBase;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.DefaultMethodInvocationContext;
import jp.ossc.nimbus.service.aop.DefaultThreadLocalInterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChainList;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.proxy.RemoteClientServiceMBean;

public class RemoteClientService
extends FactoryServiceBase
implements RemoteClientServiceMBean {
    private static final long serialVersionUID = 3941978902210348640L;
    private String remoteInterfaceClassName;
    private Class remoteInterfaceClass;
    private ServiceName remoteServiceName;
    private ServiceName interceptorChainListServiceName;
    private ServiceName invokerServiceName;
    private Object proxy;
    private boolean isCreateNewProxy;
    private boolean isCreateInterceptorChainByProxy;

    public void setRemoteInterfaceClassName(String className) {
        this.remoteInterfaceClassName = className;
    }

    public String getRemoteInterfaceClassName() {
        return this.remoteInterfaceClassName;
    }

    public void setRemoteServiceName(ServiceName name) {
        this.remoteServiceName = name;
    }

    public ServiceName getRemoteServiceName() {
        return this.remoteServiceName;
    }

    public void setInterceptorChainListServiceName(ServiceName name) {
        this.interceptorChainListServiceName = name;
    }

    public ServiceName getInterceptorChainListServiceName() {
        return this.interceptorChainListServiceName;
    }

    public void setInvokerServiceName(ServiceName name) {
        this.invokerServiceName = name;
    }

    public ServiceName getInvokerServiceName() {
        return this.invokerServiceName;
    }

    public void setCreateNewProxy(boolean isCreate) {
        this.isCreateNewProxy = isCreate;
    }

    public boolean isCreateNewProxy() {
        return this.isCreateNewProxy;
    }

    public void setCreateInterceptorChainByProxy(boolean isCreate) {
        this.isCreateInterceptorChainByProxy = isCreate;
    }

    public boolean isCreateInterceptorChainByProxy() {
        return this.isCreateInterceptorChainByProxy;
    }

    public void startService() throws Exception {
        if (this.interceptorChainListServiceName != null) {
            InterceptorChainList list = (InterceptorChainList)ServiceManagerFactory.getServiceObject(this.interceptorChainListServiceName);
        }
        if (this.invokerServiceName != null) {
            Invoker invoker = (Invoker)ServiceManagerFactory.getServiceObject(this.invokerServiceName);
        }
        this.remoteInterfaceClass = Class.forName(this.remoteInterfaceClassName, true, NimbusClassLoader.getInstance());
    }

    protected synchronized Object createInstance() throws Exception {
        if (this.isCreateNewProxy) {
            return Proxy.newProxyInstance(NimbusClassLoader.getInstance(), new Class[]{this.remoteInterfaceClass}, (InvocationHandler)new ClientInvocationHandler(this.remoteServiceName, this.interceptorChainListServiceName, this.invokerServiceName, this.isCreateInterceptorChainByProxy));
        }
        if (this.proxy == null) {
            this.proxy = Proxy.newProxyInstance(NimbusClassLoader.getInstance(), new Class[]{this.remoteInterfaceClass}, (InvocationHandler)new ClientInvocationHandler(this.remoteServiceName, this.interceptorChainListServiceName, this.invokerServiceName, this.isCreateInterceptorChainByProxy));
        }
        return this.proxy;
    }

    private static class ClientInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 2467674523158858020L;
        private final transient InterceptorChain chain;
        private ServiceName remoteServiceName;

        public ClientInvocationHandler(ServiceName remoteServiceName, ServiceName interceptorChainListServiceName, ServiceName invokerServiceName, boolean isCreateInterceptorChainByProxy) {
            this.remoteServiceName = remoteServiceName;
            this.chain = isCreateInterceptorChainByProxy ? new DefaultThreadLocalInterceptorChain(interceptorChainListServiceName == null ? null : (InterceptorChainList)ServiceManagerFactory.getServiceObject(interceptorChainListServiceName), (Invoker)ServiceManagerFactory.getServiceObject(invokerServiceName)) : new DefaultThreadLocalInterceptorChain(interceptorChainListServiceName, invokerServiceName);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            DefaultMethodInvocationContext ctx = new DefaultMethodInvocationContext(proxy, method, args);
            if (this.remoteServiceName != null) {
                ctx.setTargetObject(this.remoteServiceName);
            }
            return this.chain.invokeNext(ctx);
        }
    }
}

