/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.queue.AbstractDistributedQueueSelectorServiceMBean;
import jp.ossc.nimbus.service.queue.DistributedQueueSelector;
import jp.ossc.nimbus.service.queue.Queue;

public abstract class AbstractDistributedQueueSelectorService
extends ServiceBase
implements DistributedQueueSelector,
AbstractDistributedQueueSelectorServiceMBean {
    private static final long serialVersionUID = -7007153954682535513L;
    protected ServiceName[] queueServiceNames;
    protected Queue[] queues;
    protected Map keyMap;
    protected Set[] keySets;

    public void setQueueServiceNames(ServiceName[] names) {
        this.queueServiceNames = names;
    }

    public ServiceName[] getQueueServiceNames() {
        return this.queueServiceNames;
    }

    public void preCreateService() throws Exception {
        super.preCreateService();
        this.keyMap = new HashMap();
    }

    public void preStartService() throws Exception {
        super.preStartService();
        if (this.queueServiceNames == null || this.queueServiceNames.length == 0) {
            throw new IllegalArgumentException("QueueServiceNames must be specified.");
        }
        this.queues = new Queue[this.queueServiceNames.length];
        this.keySets = new Set[this.queueServiceNames.length];
        for (int i = 0; i < this.queueServiceNames.length; ++i) {
            this.queues[i] = (Queue)ServiceManagerFactory.getServiceObject(this.queueServiceNames[i]);
            this.keySets[i] = new HashSet();
        }
    }

    public void postDestroyService() throws Exception {
        this.keyMap = null;
        this.keySets = null;
        super.postDestroyService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue selectQueue(Object obj) {
        Object key = this.getKey(obj);
        Queue queue = null;
        Map map = this.keyMap;
        synchronized (map) {
            queue = (Queue)this.keyMap.get(key);
            if (queue == null) {
                double minOrder = 0.0;
                Set keySet = null;
                for (int i = 0; i < this.queues.length; ++i) {
                    double order = this.getQueueOrder(i);
                    if (i != 0 && !(minOrder > order)) continue;
                    minOrder = order;
                    queue = this.queues[i];
                    keySet = this.keySets[i];
                }
                keySet.add(key);
                this.keyMap.put(key, queue);
            }
        }
        return queue;
    }

    protected double getQueueOrder(int i) {
        return (double)this.keySets[i].size() * (double)this.queues[i].getCount();
    }

    public Queue[] getQueues() {
        return this.queues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.keyMap != null) {
            Map map = this.keyMap;
            synchronized (map) {
                this.keyMap.clear();
                for (int i = 0; i < this.keySets.length; ++i) {
                    this.keySets[i].clear();
                }
            }
        }
    }

    protected abstract Object getKey(Object var1);
}

