/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.daemon;

import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.util.CsvArrayList;

public class Daemon
implements Runnable,
DaemonControl {
    protected volatile boolean isRunning;
    protected volatile boolean isBlocking;
    protected volatile boolean isSusupend;
    protected transient Thread daemonThread;
    protected String threadName;
    protected boolean isDaemon = true;
    protected DaemonRunnable runnable;
    protected boolean isGarbaging;
    protected boolean isConsuming;
    protected int priority = -1;

    public Daemon(DaemonRunnable run) {
        this.runnable = run;
    }

    public void setName(String name) {
        this.threadName = name;
        if (this.daemonThread != null) {
            this.daemonThread.setName(name);
        }
    }

    public String getName() {
        return this.threadName;
    }

    public void setPriority(int newPriority) {
        this.priority = newPriority;
        if (this.daemonThread != null) {
            this.daemonThread.setPriority(newPriority);
        }
    }

    public int getPriority() {
        return this.daemonThread == null ? this.priority : this.daemonThread.getPriority();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean runFlg) {
        this.isRunning = runFlg;
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    public void setBlocking(boolean blockFlg) {
        this.isBlocking = blockFlg;
    }

    public void setDaemon(boolean isDaemon) {
        this.isDaemon = isDaemon;
    }

    protected boolean isDaemon() {
        return this.isDaemon;
    }

    public CsvArrayList getDeamonInfo() {
        CsvArrayList parser = new CsvArrayList();
        parser.add(this.getName());
        parser.add(String.valueOf(this.isRunning()));
        parser.add(String.valueOf(this.isBlocking()));
        return parser;
    }

    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        if (!this.runnable.onStart()) {
            return;
        }
        this.daemonThread = this.getName() == null || this.getName().length() == 0 ? new Thread(this) : new Thread((Runnable)this, this.getName());
        this.daemonThread.setDaemon(this.isDaemon());
        if (this.priority > 0) {
            this.daemonThread.setPriority(this.priority);
        }
        this.setRunning(true);
        this.setBlocking(true);
        this.daemonThread.start();
    }

    public synchronized void stop() {
        this.stop(60000L);
    }

    public synchronized void stop(long millis) {
        if (this.daemonThread == null) {
            return;
        }
        if (!this.runnable.onStop()) {
            return;
        }
        this.setRunning(false);
        if (this.isBlocking() && this.daemonThread != null && this.daemonThread.isAlive()) {
            this.isSusupend = false;
        }
        if (this.daemonThread != null) {
            this.daemonThread.interrupt();
            Thread.interrupted();
            if (this.isConsuming && !this.daemonThread.isInterrupted()) {
                this.daemonThread.interrupt();
            }
        }
        this.stopWait(millis);
    }

    public synchronized void stopWait() {
        this.stopWait(0L);
    }

    public synchronized void stopWait(long millis) {
        block3: {
            long startTime = System.currentTimeMillis();
            try {
                if (this.daemonThread != null) {
                    this.daemonThread.join(millis);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                long processTime = System.currentTimeMillis() - startTime;
                if (millis <= processTime) break block3;
                this.stopWait(millis - processTime);
            }
        }
        this.daemonThread = null;
    }

    public synchronized void suspend() {
        if (this.isSusupend) {
            return;
        }
        if (!this.runnable.onSuspend()) {
            return;
        }
        this.isSusupend = true;
    }

    public synchronized void resume() {
        if (!this.isSusupend) {
            return;
        }
        if (!this.runnable.onResume()) {
            return;
        }
        this.isSusupend = false;
        if (this.daemonThread != null) {
            this.daemonThread.interrupt();
            Thread.interrupted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block18: {
            boolean breakFlg = false;
            Object waitObj = null;
            try {
                while (this.isRunning()) {
                    this.setBlocking(true);
                    while (this.isSusupend) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e1) {
                            Thread.interrupted();
                            breakFlg = true;
                            break;
                        }
                    }
                    if (breakFlg) {
                        breakFlg = false;
                        continue;
                    }
                    try {
                        waitObj = this.runnable.provide(this);
                    }
                    catch (Throwable e) {
                        Thread.interrupted();
                        waitObj = null;
                    }
                    while (this.isSusupend) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e2) {
                            Thread.interrupted();
                            breakFlg = true;
                            break;
                        }
                    }
                    this.setBlocking(false);
                    if (breakFlg) {
                        breakFlg = false;
                        continue;
                    }
                    this.isConsuming = true;
                    try {
                        this.runnable.consume(waitObj, this);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    this.isConsuming = false;
                }
                Object var5_8 = null;
                this.setRunning(false);
                this.isGarbaging = true;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.setRunning(false);
                this.isGarbaging = true;
                try {
                    this.runnable.garbage();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.isGarbaging = false;
                throw throwable;
            }
            try {
                this.runnable.garbage();
                break block18;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            {
            }
        }
        this.isGarbaging = false;
    }
}

