/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.JournalRecord;
import jp.ossc.nimbus.service.journal.JournalRecordImpl;
import jp.ossc.nimbus.service.journal.RequestJournal;
import jp.ossc.nimbus.service.journal.RequestJournalImpl;
import jp.ossc.nimbus.service.journal.ThreadManagedJournalServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.service.writer.Category;
import jp.ossc.nimbus.service.writer.MessageWriteException;

public class ThreadManagedJournalService
extends ServiceBase
implements Journal,
ThreadManagedJournalServiceMBean,
DaemonRunnable {
    private static final long serialVersionUID = 435149061357609295L;
    private static final String C_NOP = "";
    private String mWrKeyName = "JOURNAL";
    private ServiceName mEditorFinderName;
    private EditorFinder mEditorFinder;
    private ServiceName mSequenceServiceName;
    private Sequence mSequence;
    private ThreadLocal mRequestLocal;
    private ThreadLocal mCurrentLocal;
    private ThreadLocal mStepLocal;
    private ServiceName mQueueServiceName;
    private Queue mQueue;
    private DefaultQueueService defaultQueue;
    private ServiceName[] categoryNames;
    private List categories;
    private int writeDaemonSize = 1;
    private Daemon[] mDaemon;
    private int mJournalLevel;

    public void createService() throws Exception {
        this.mRequestLocal = new InheritableThreadLocal();
        this.mCurrentLocal = new InheritableThreadLocal();
        this.mStepLocal = new InheritableThreadLocal();
    }

    public void setEditorFinder(EditorFinder editorFinder) {
        this.mEditorFinder = editorFinder;
    }

    public void setQueue(Queue queue) {
        this.mQueue = queue;
    }

    public void setSequence(Sequence sequence) {
        this.mSequence = sequence;
    }

    public void setCategories(List categories) {
        this.categories = categories;
    }

    public void startService() throws Exception {
        this.mEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.mEditorFinderName);
        if (this.mSequenceServiceName != null) {
            this.mSequence = (Sequence)ServiceManagerFactory.getServiceObject(this.mSequenceServiceName);
        }
        if (this.mQueueServiceName == null) {
            if (this.mQueue == null) {
                if (this.getDefaultQueueService() == null) {
                    DefaultQueueService defaultQueue = new DefaultQueueService();
                    defaultQueue.create();
                    defaultQueue.start();
                    this.setDefaultQueueService(defaultQueue);
                } else {
                    this.getDefaultQueueService().start();
                }
                this.mQueue = this.getDefaultQueueService();
            }
        } else {
            this.mQueue = (Queue)ServiceManagerFactory.getServiceObject(this.mQueueServiceName);
        }
        if (this.categories == null) {
            this.categories = new ArrayList();
            ServiceName[] categoryNames = this.getCategoryServiceNames();
            if (categoryNames != null) {
                for (int i = 0; i < categoryNames.length; ++i) {
                    ServiceName categoryName = categoryNames[i];
                    Category category = (Category)ServiceManagerFactory.getServiceObject(categoryName);
                    this.categories.add(category);
                }
            }
        }
        this.mQueue.accept();
        this.mDaemon = new Daemon[this.writeDaemonSize];
        for (int i = 0; i < this.writeDaemonSize; ++i) {
            this.mDaemon[i] = new Daemon(this);
            this.mDaemon[i].setName("Nimbus JournalWriterDaemon " + this.getServiceNameObject() + '[' + (i + 1) + ']');
            this.mDaemon[i].start();
        }
    }

    public void stopService() {
        this.mQueue.release();
        for (int i = 0; i < this.mDaemon.length; ++i) {
            this.mDaemon[i].stop();
        }
        if (this.mQueue == this.getDefaultQueueService()) {
            this.getDefaultQueueService().stop();
            this.mQueue = null;
        }
        this.categories.clear();
        this.mSequence = null;
    }

    public void destroyService() {
        this.mRequestLocal = null;
        this.mCurrentLocal = null;
        this.mStepLocal = null;
        this.mEditorFinder = null;
        this.mSequence = null;
        if (this.mQueue == this.getDefaultQueueService()) {
            this.getDefaultQueueService().destroy();
            this.setDefaultQueueService(null);
        }
        this.mQueue = null;
        this.mDaemon = null;
        this.categories = null;
    }

    public String getRequestId() {
        if (this.mCurrentLocal == null) {
            return null;
        }
        JournalRecordImpl jr = (JournalRecordImpl)this.mCurrentLocal.get();
        if (jr != null) {
            RequestJournal rj = (RequestJournal)jr.getObject();
            return rj.getRequestId();
        }
        return null;
    }

    public void setRequestId(String requestID) {
        if (this.mCurrentLocal == null) {
            return;
        }
        JournalRecordImpl jr = (JournalRecordImpl)this.mCurrentLocal.get();
        if (jr != null) {
            RequestJournalImpl rj = (RequestJournalImpl)jr.getObject();
            rj.setRequestId(requestID);
        }
    }

    public void startJournal(String key) {
        this.startJournal(key, new Date(), null);
    }

    public void startJournal(String key, Date startTime, EditorFinder finder) {
        if (this.getState() != 3) {
            return;
        }
        JournalRecordImpl jr = (JournalRecordImpl)this.mRequestLocal.get();
        if (jr == null) {
            String id = C_NOP;
            if (this.mSequence != null) {
                id = this.mSequence.increment();
            }
            RequestJournalImpl rj = new RequestJournalImpl(false);
            rj.setStartTime(startTime);
            rj.setKey(key);
            rj.setRequestId(id);
            rj.setRoot(null, null);
            jr = new JournalRecordImpl();
            if (finder == null) {
                jr.setEditorFinder(this.mEditorFinder);
            } else {
                jr.setEditorFinder(finder);
            }
            if (key == null) {
                jr.setKey(C_NOP);
            } else {
                jr.setKey(key);
            }
            jr.setParamObj(rj);
            this.mRequestLocal.set(jr);
            this.mCurrentLocal.set(jr);
            this.mStepLocal.set(jr);
        } else {
            JournalRecordImpl curRec = (JournalRecordImpl)this.mCurrentLocal.get();
            JournalRecordImpl stepRec = (JournalRecordImpl)this.mStepLocal.get();
            RequestJournalImpl curStep = (RequestJournalImpl)stepRec.getObject();
            RequestJournalImpl newStep = new RequestJournalImpl(true);
            newStep.setKey(key);
            newStep.setRequestId(curStep.getRequestId());
            newStep.setStartTime(startTime);
            newStep.setRoot(stepRec, curRec);
            if (finder == null) {
                finder = this.mEditorFinder;
            }
            if (key == null) {
                key = C_NOP;
            }
            JournalRecord newRec = curStep.setParamObj(key, finder, newStep);
            this.mCurrentLocal.set(newRec);
            this.mStepLocal.set(newRec);
        }
    }

    public void startJournal(String key, Date startTime) {
        this.startJournal(key, startTime, null);
    }

    public void startJournal(String key, EditorFinder finder) {
        this.startJournal(key, new Date(), finder);
    }

    public boolean isStartJournal() {
        return this.mRequestLocal.get() != null;
    }

    public void endJournal() {
        this.endJournal(new Date());
    }

    protected void writeJarnal(JournalRecordImpl jr) {
        if (this.getState() != 3) {
            return;
        }
        this.mQueue.push(jr);
    }

    public void endJournal(Date endTime) {
        if (this.getState() != 3) {
            return;
        }
        JournalRecordImpl curRec = (JournalRecordImpl)this.mCurrentLocal.get();
        JournalRecordImpl stepRec = (JournalRecordImpl)this.mStepLocal.get();
        if (curRec == null || stepRec == null) {
            throw new ServiceException("JOURNALSERVICE001", "startJournal() and endJournal must be used in a pair.");
        }
        while (stepRec == null || curRec != stepRec) {
            RequestJournalImpl step = (RequestJournalImpl)stepRec.getObject();
            step.setEndTime(endTime);
            stepRec = step.getStepRoot();
        }
        RequestJournalImpl curStep = (RequestJournalImpl)curRec.getObject();
        curStep.setEndTime(endTime);
        JournalRecordImpl rootRec = curStep.getCurRoot();
        JournalRecordImpl stepRec1 = curStep.getStepRoot();
        if (rootRec == null) {
            this.writeJarnal(curRec);
            this.mRequestLocal.set(null);
            this.mCurrentLocal.set(null);
            this.mStepLocal.set(null);
        } else {
            this.mCurrentLocal.set(rootRec);
            this.mStepLocal.set(stepRec1);
        }
    }

    public void addInfo(String key, Object value, int level) {
        if (level < this.getJournalLevel()) {
            return;
        }
        this.addInfo(key, value);
    }

    public int getJournalLevel() {
        return this.mJournalLevel;
    }

    public void addInfo(String key, Object value) {
        if (this.getState() != 3) {
            return;
        }
        JournalRecordImpl stepRec = (JournalRecordImpl)this.mStepLocal.get();
        if (stepRec != null) {
            RequestJournalImpl step = (RequestJournalImpl)stepRec.getObject();
            step.setInfoObj(key, stepRec.getFinder(), value);
        }
    }

    public void addInfo(String key, Object value, EditorFinder finder) {
        if (this.getState() != 3) {
            return;
        }
        JournalRecordImpl stepRec = (JournalRecordImpl)this.mStepLocal.get();
        if (stepRec != null) {
            RequestJournalImpl step = (RequestJournalImpl)stepRec.getObject();
            step.setInfoObj(key, finder == null ? stepRec.getFinder() : finder, value);
        }
    }

    public void addInfo(String key, Object value, EditorFinder finder, int level) {
        if (this.getState() != 3) {
            return;
        }
        if (level < this.getJournalLevel()) {
            return;
        }
        this.addInfo(key, value, finder);
    }

    public void addStartStep(String key) {
        this.addStartStep(key, new Date(), null);
    }

    public void addStartStep(String key, EditorFinder finder) {
        this.addStartStep(key, new Date(), finder);
    }

    public void addStartStep(String key, Date startTime) {
        this.addStartStep(key, startTime, null);
    }

    public void addStartStep(String key, Date startTime, EditorFinder finder) {
        if (this.getState() != 3) {
            return;
        }
        JournalRecordImpl rootRec = (JournalRecordImpl)this.mRequestLocal.get();
        if (rootRec != null) {
            JournalRecordImpl curRec = (JournalRecordImpl)this.mCurrentLocal.get();
            JournalRecordImpl stepRec = (JournalRecordImpl)this.mStepLocal.get();
            RequestJournalImpl curStep = (RequestJournalImpl)curRec.getObject();
            RequestJournalImpl newStep = new RequestJournalImpl(true);
            newStep.setKey(key);
            newStep.setRequestId(curStep.getRequestId());
            newStep.setStartTime(startTime);
            newStep.setRoot(stepRec, curRec);
            if (finder == null) {
                finder = this.mEditorFinder;
            }
            if (key == null) {
                key = C_NOP;
            }
            JournalRecord newRec = curStep.setParamObj(key, finder, newStep);
            this.mStepLocal.set(newRec);
            this.mCurrentLocal.set(newRec);
        }
    }

    public void addEndStep() {
        this.addEndStep(new Date());
    }

    public void addEndStep(Date endTime) {
        if (this.getState() != 3) {
            return;
        }
        JournalRecordImpl curRec = (JournalRecordImpl)this.mStepLocal.get();
        if (curRec != null) {
            if (!curRec.isStep()) {
                return;
            }
            RequestJournalImpl curStep = (RequestJournalImpl)curRec.getObject();
            curStep.setEndTime(endTime);
            JournalRecordImpl root = curStep.getCurRoot();
            if (root != null) {
                this.mCurrentLocal.set(root);
            }
            if ((root = curStep.getStepRoot()) != null) {
                this.mStepLocal.set(root);
            }
        }
    }

    public boolean onStop() {
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    public Object provide(DaemonControl ctrl) {
        if (this.mQueue == null) {
            return null;
        }
        return this.mQueue.get(1000L);
    }

    public void consume(Object paramObj, DaemonControl ctrl) {
        if (paramObj == null) {
            return;
        }
        JournalRecord rj = (JournalRecord)paramObj;
        Object journal = rj.toObject();
        HashMap<String, Object> elements = new HashMap<String, Object>();
        elements.put(this.getWritableElementKey(), journal);
        if (this.categories != null) {
            int imax = this.categories.size();
            for (int i = 0; i < imax; ++i) {
                Category category = (Category)this.categories.get(i);
                if (!category.isEnabled()) continue;
                try {
                    category.write(elements);
                    continue;
                }
                catch (MessageWriteException e) {
                    // empty catch block
                }
            }
        }
    }

    public void garbage() {
        if (this.mQueue != null) {
            while (this.mQueue.size() > 0) {
                Object obj = this.mQueue.get(0L);
                try {
                    this.consume(obj, null);
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean onStart() {
        return true;
    }

    public void setEditorFinderName(ServiceName name) {
        this.mEditorFinderName = name;
    }

    public ServiceName getEditorFinderName() {
        return this.mEditorFinderName;
    }

    public void setSequenceServiceName(ServiceName name) {
        this.mSequenceServiceName = name;
    }

    public ServiceName getSequenceServiceName() {
        return this.mSequenceServiceName;
    }

    public void setCategoryServiceNames(ServiceName[] names) {
        this.categoryNames = names;
    }

    public ServiceName[] getCategoryServiceNames() {
        return this.categoryNames;
    }

    public void setQueueServiceName(ServiceName name) {
        this.mQueueServiceName = name;
    }

    public ServiceName getQueueServiceName() {
        return this.mQueueServiceName;
    }

    protected DefaultQueueService getDefaultQueueService() {
        return this.defaultQueue;
    }

    protected void setDefaultQueueService(DefaultQueueService queue) {
        this.defaultQueue = queue;
    }

    public String getWritableElementKey() {
        return this.mWrKeyName;
    }

    public void setWritableElementKey(String string) {
        this.mWrKeyName = string;
    }

    public void setJournalLevel(int level) {
        this.mJournalLevel = level;
    }

    public void setWriteDaemonSize(int size) {
        this.writeDaemonSize = size;
    }

    public int getWriteDaemonSize() {
        return this.writeDaemonSize;
    }

    public String getCurrentJournalString(ServiceName finderServiceName) {
        EditorFinder finder = (EditorFinder)ServiceManagerFactory.getServiceObject(finderServiceName);
        return this.getCurrentJournalString(finder);
    }

    public String getCurrentJournalString(EditorFinder finder) {
        JournalRecordImpl curRec = (JournalRecordImpl)this.mCurrentLocal.get();
        if (curRec == null) {
            return C_NOP;
        }
        Object journal = curRec.toObject(finder);
        return journal == null ? null : journal.toString();
    }
}

