/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.msgresource;

import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.byteconvert.ByteConverter;
import jp.ossc.nimbus.service.msgresource.CommonMessageFormat;
import jp.ossc.nimbus.service.msgresource.MessageFormat;
import jp.ossc.nimbus.service.msgresource.MessageResourceDefine;
import jp.ossc.nimbus.service.msgresource.MessageResourceUtil;
import jp.ossc.nimbus.util.StringOperator;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TextMessageFormat
extends CommonMessageFormat
implements MessageFormat,
MessageResourceDefine {
    private String mNewLineDefinition = "\\n";
    private String mConstPayloadStr = null;

    public TextMessageFormat(ByteConverter converter) {
        super(converter);
    }

    public String marshal(Message msg) {
        if (!(msg instanceof TextMessage)) {
            return null;
        }
        StringBuffer ret = new StringBuffer("[property]");
        ret.append(this.dumpProperties(msg));
        ret.append("[payload]");
        TextMessage textMsg = (TextMessage)msg;
        try {
            ret.append(textMsg.getText());
        }
        catch (JMSException e) {
            throw new ServiceException("MESSAGERESOURCEFACTORY100", "getText() Failed", e);
        }
        return ret.toString();
    }

    public Message unMarshal(QueueSession session) {
        TextMessage textMsg = null;
        try {
            textMsg = session.createTextMessage();
        }
        catch (Exception e) {
            throw new ServiceException("MESSAGERESOURCEFACTOR104", "PayLoad Setting failed.", e);
        }
        String recordStr = null;
        Properties prop = null;
        if (this.mMessageInput != null) {
            recordStr = this.mMessageInput.getInputString();
            prop = this.mMessageInput.getMessageHeadProp();
            this.mMessageInput.nextLine();
        }
        this.setMessageHeadProperties((Message)textMsg, prop);
        if (this.mConstPayloadStr != null && recordStr != null) {
            recordStr = this.mConstPayloadStr + recordStr;
        }
        String lineSep = System.getProperty("line.separator");
        String payloadStr = StringOperator.replaceString(recordStr, this.mNewLineDefinition, lineSep);
        this.setPayload(textMsg, payloadStr);
        return textMsg;
    }

    protected void setPayload(TextMessage msg, String str) {
        if (str == null) {
            return;
        }
        try {
            msg.setText(str);
        }
        catch (JMSException e) {
            throw new ServiceException("MESSAGERESOURCEFACTOR105", "PayLoad Setting failed.", e);
        }
    }

    protected void sendPayloadParse(Element elem, boolean fileSpecifiedFlag) {
        NodeList newLineDefs = elem.getElementsByTagName("NEWLINEDEF_TAG_NAME");
        if (newLineDefs.getLength() > 1) {
            throw new ServiceException("MESSAGERESOURCEFACTORY103", "<newlinedef>is can be exists only one.");
        }
        for (int rCnt = 0; rCnt < newLineDefs.getLength(); ++rCnt) {
            Element newLineDef = (Element)newLineDefs.item(rCnt);
            this.mNewLineDefinition = MessageResourceUtil.getValue(newLineDef);
        }
        NodeList list = elem.getElementsByTagName("payload");
        if (list.getLength() > 1) {
            throw new ServiceException("MESSAGERESOURCEFACTORY102", "<payload>is can be exists only one.");
        }
        for (int rCnt = 0; rCnt < list.getLength(); ++rCnt) {
            Element payLoad = (Element)list.item(rCnt);
            NodeList payLoadItems = payLoad.getElementsByTagName("item");
            if (payLoadItems.getLength() > 1) {
                throw new ServiceException("MESSAGERESOURCEFACTORY103", "<item>is can be exists only one.");
            }
            for (int rCount = 0; rCount < payLoadItems.getLength(); ++rCount) {
                Element payLoadItem = (Element)payLoadItems.item(rCount);
                this.mConstPayloadStr = MessageResourceUtil.getValue(payLoadItem);
            }
        }
    }

    protected void recvPayloadParse(Element elem) {
    }
}

