/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainer;
import jp.ossc.nimbus.service.queue.QueueHandlerContainerServiceMBean;

public class QueueHandlerContainerService
extends ServiceBase
implements QueueHandlerContainer,
QueueHandlerContainerServiceMBean {
    private static final long serialVersionUID = -6527205946658554031L;
    protected ServiceName queueServiceName;
    protected Queue requestQueue;
    protected Daemon[] daemons;
    protected QueueReceiver[] invokers;
    protected int queueHandlerSize = 1;
    protected ServiceName queueHandlerServiceName;
    protected QueueHandler queueHandler;
    protected boolean isDaemonQueueHandler = true;
    protected long waitTimeout = -1L;
    protected int maxRetryCount = 0;
    protected long retryInterval = 1000L;
    protected String handlingErrorMessageId = "QHC__00001";
    protected String retryOverErrorMessageId = "QHC__00002";
    protected int queueHandlerThreadPriority = -1;
    protected boolean isReleaseQueue = true;

    public void setQueueServiceName(ServiceName name) {
        this.queueServiceName = name;
    }

    public ServiceName getQueueServiceName() {
        return this.queueServiceName;
    }

    public void setQueueHandlerServiceName(ServiceName name) {
        if (this.queueHandlerServiceName == null) {
            this.queueHandlerServiceName = name;
            if (this.daemons != null) {
                for (int i = 0; i < this.daemons.length; ++i) {
                    this.daemons[i].resume();
                }
            }
        } else {
            this.queueHandlerServiceName = name;
        }
    }

    public ServiceName getQueueHandlerServiceName() {
        return this.queueHandlerServiceName;
    }

    public void setQueueHandlerSize(int size) {
        this.queueHandlerSize = size;
    }

    public int getQueueHandlerSize() {
        return this.queueHandlerSize;
    }

    public void setReleaseQueue(boolean isRelease) {
        this.isReleaseQueue = isRelease;
    }

    public boolean isReleaseQueue() {
        return this.isReleaseQueue;
    }

    public void setWaitTimeout(long timeout) {
        this.waitTimeout = timeout;
    }

    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    public void setMaxRetryCount(int count) {
        this.maxRetryCount = count;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void setRetryInterval(long interval) {
        this.retryInterval = interval;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setHandlingErrorMessageId(String id) {
        this.handlingErrorMessageId = id;
    }

    public String getHandlingErrorMessageId() {
        return this.handlingErrorMessageId;
    }

    public void setRetryOverErrorMessageId(String id) {
        this.retryOverErrorMessageId = id;
    }

    public String getRetryOverErrorMessageId() {
        return this.retryOverErrorMessageId;
    }

    public int getActiveQueueHandlerSize() {
        if (this.invokers == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.invokers.length; ++i) {
            if (!this.invokers[i].isActive) continue;
            ++count;
        }
        return count;
    }

    public void setDaemonQueueHandler(boolean isDaemon) {
        this.isDaemonQueueHandler = isDaemon;
    }

    public boolean isDaemonQueueHandler() {
        return this.isDaemonQueueHandler;
    }

    public void setQueueHandlerThreadPriority(int newPriority) {
        this.queueHandlerThreadPriority = newPriority;
    }

    public int getQueueHandlerThreadPriority() {
        return this.queueHandlerThreadPriority;
    }

    public void startService() throws Exception {
        if (this.getQueueServiceName() == null) {
            if (this.getQueueService() == null) {
                throw new IllegalArgumentException("Queue is null");
            }
        } else {
            this.setQueueService((Queue)ServiceManagerFactory.getServiceObject(this.queueServiceName));
        }
        this.getQueueService().accept();
        if (this.queueHandlerSize < 0) {
            throw new IllegalArgumentException("queueHandlerSize < 0.");
        }
        this.invokers = new QueueReceiver[this.queueHandlerSize];
        this.daemons = new Daemon[this.queueHandlerSize];
        for (int i = 0; i < this.queueHandlerSize; ++i) {
            this.invokers[i] = new QueueReceiver();
            this.invokers[i].handler = this.getQueueHandler();
            this.daemons[i] = new Daemon(this.invokers[i]);
            this.daemons[i].setDaemon(this.isDaemonQueueHandler);
            this.daemons[i].setName(this.getServiceNameObject() + " QueueReceiver" + (i + 1));
            if (this.queueHandlerThreadPriority > 0) {
                this.daemons[i].setPriority(this.queueHandlerThreadPriority);
            }
            if (this.invokers[i].handler == null) {
                this.daemons[i].suspend();
            }
            this.daemons[i].start();
        }
    }

    public void stopService() throws Exception {
        for (int i = 0; i < this.daemons.length; ++i) {
            this.daemons[i].stop();
            this.daemons[i] = null;
            this.invokers[i] = null;
        }
        if (this.isReleaseQueue) {
            this.getQueueService().release();
        }
        this.daemons = null;
        this.invokers = null;
    }

    public void setQueueService(Queue queue) {
        this.requestQueue = queue;
    }

    public Queue getQueueService() {
        return this.requestQueue;
    }

    public void setQueueHandler(QueueHandler handler) {
        if (this.queueHandler == null) {
            this.queueHandler = handler;
            if (this.daemons != null) {
                for (int i = 0; i < this.daemons.length; ++i) {
                    this.daemons[i].resume();
                }
            }
        } else {
            this.queueHandler = handler;
        }
    }

    public QueueHandler getQueueHandler() {
        if (this.queueHandler != null) {
            return this.queueHandler;
        }
        if (this.queueHandlerServiceName != null) {
            return (QueueHandler)ServiceManagerFactory.getServiceObject(this.queueHandlerServiceName);
        }
        return null;
    }

    public void push(Object item) {
        this.getQueueService().push(item);
    }

    public Object get() {
        throw new UnsupportedOperationException();
    }

    public Object get(long timeOutMs) {
        throw new UnsupportedOperationException();
    }

    public Object peek() {
        return this.getQueueService().peek();
    }

    public Object peek(long timeOutMs) {
        return this.getQueueService().peek(timeOutMs);
    }

    public void remove(Object item) {
        this.getQueueService().remove(item);
    }

    public void clear() {
        this.getQueueService().clear();
    }

    public int size() {
        return this.getQueueService().size();
    }

    public long getCount() {
        return this.getQueueService().getCount();
    }

    public void accept() {
        this.getQueueService().accept();
    }

    public void release() {
        this.getQueueService().release();
    }

    protected class QueueReceiver
    implements DaemonRunnable {
        protected QueueHandler handler;
        public boolean isActive;

        protected QueueReceiver() {
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) {
            if (this.handler == null) {
                this.handler = QueueHandlerContainerService.this.getQueueHandler();
                if (this.handler == null) {
                    return null;
                }
            }
            return QueueHandlerContainerService.this.getQueueService().get(QueueHandlerContainerService.this.waitTimeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consume(Object dequeued, DaemonControl ctrl) {
            if (this.handler == null) {
                return;
            }
            boolean isRetry = false;
            int retryCount = 0;
            do {
                block19: {
                    try {
                        this.isActive = true;
                        try {
                            this.handler.handleDequeuedObject(dequeued);
                            isRetry = false;
                        }
                        catch (Throwable th) {
                            if (QueueHandlerContainerService.this.maxRetryCount > 0) {
                                if (retryCount >= QueueHandlerContainerService.this.maxRetryCount) {
                                    isRetry = false;
                                    try {
                                        this.handler.handleRetryOver(dequeued, th);
                                    }
                                    catch (Throwable th2) {
                                        QueueHandlerContainerService.this.getLogger().write(QueueHandlerContainerService.this.retryOverErrorMessageId, dequeued, th);
                                    }
                                } else {
                                    isRetry = true;
                                    try {
                                        isRetry = this.handler.handleError(dequeued, th);
                                    }
                                    catch (Throwable th2) {
                                        QueueHandlerContainerService.this.getLogger().write(QueueHandlerContainerService.this.handlingErrorMessageId, dequeued, th);
                                    }
                                }
                                break block19;
                            }
                            isRetry = false;
                            try {
                                this.handler.handleError(dequeued, th);
                            }
                            catch (Throwable th2) {
                                QueueHandlerContainerService.this.getLogger().write(QueueHandlerContainerService.this.handlingErrorMessageId, dequeued, th);
                            }
                        }
                    }
                    finally {
                        this.isActive = false;
                    }
                }
                if (isRetry && QueueHandlerContainerService.this.retryInterval > 0L) {
                    try {
                        Thread.sleep(QueueHandlerContainerService.this.retryInterval);
                    }
                    catch (InterruptedException e) {
                        isRetry = false;
                    }
                }
                ++retryCount;
            } while (isRetry);
        }

        public void garbage() {
            if (QueueHandlerContainerService.this.getQueueService() != null) {
                while (QueueHandlerContainerService.this.getQueueService().size() > 0) {
                    this.consume(QueueHandlerContainerService.this.getQueueService().get(0L), null);
                }
            }
        }
    }
}

