/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.writer.Category;
import jp.ossc.nimbus.service.writer.DistributedCategoryServiceMBean;
import jp.ossc.nimbus.service.writer.MessageWriteException;

public class DistributedCategoryService
extends ServiceBase
implements DistributedCategoryServiceMBean {
    private static final long serialVersionUID = 1605519537623731512L;
    protected boolean isEnabled = true;
    protected ServiceName[] categoryServiceNames;
    protected Category[] categories;
    protected ServiceName queueServiceName;
    protected Queue queue;
    protected DefaultQueueService defaultQueue;
    protected Daemon[] daemons;
    protected boolean isDaemon = true;
    protected int threadPriority = -1;
    protected String writeErrorLogMessageId;

    public void setCategoryServiceNames(ServiceName[] names) {
        this.categoryServiceNames = names;
    }

    public ServiceName[] getCategoryServiceNames() {
        return this.categoryServiceNames;
    }

    public void setQueueServiceName(ServiceName name) {
        this.queueServiceName = name;
    }

    public ServiceName getQueueServiceName() {
        return this.queueServiceName;
    }

    public void setThreadPriority(int newPriority) {
        this.threadPriority = newPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setDaemon(boolean isDaemon) {
        this.isDaemon = isDaemon;
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public void setWriteErrorLogMessageId(String id) {
        this.writeErrorLogMessageId = id;
    }

    public String getWriteErrorLogMessageId() {
        return this.writeErrorLogMessageId;
    }

    public void setCategories(Category[] categories) {
        this.categories = categories;
    }

    public void setQueue(Queue container) {
        this.queue = container;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public void startService() throws Exception {
        if (this.categoryServiceNames != null) {
            this.categories = new Category[this.categoryServiceNames.length];
            int max = this.categoryServiceNames.length;
            for (int i = 0; i < max; ++i) {
                this.categories[i] = (Category)ServiceManagerFactory.getServiceObject(this.categoryServiceNames[i]);
            }
        }
        if (this.categories == null || this.categories.length == 0) {
            throw new IllegalArgumentException("Categories is null.");
        }
        if (this.queueServiceName != null) {
            this.queue = (Queue)ServiceManagerFactory.getServiceObject(this.queueServiceName);
        }
        if (this.queue == null) {
            this.defaultQueue = new DefaultQueueService();
            this.defaultQueue.create();
            this.defaultQueue.start();
            this.queue = this.defaultQueue;
        }
        this.queue.accept();
        CategoryWriter[] writers = new CategoryWriter[this.categories.length];
        this.daemons = new Daemon[this.categories.length];
        for (int i = 0; i < this.categories.length; ++i) {
            writers[i] = new CategoryWriter();
            writers[i].category = this.categories[i];
            this.daemons[i] = new Daemon(writers[i]);
            this.daemons[i].setDaemon(this.isDaemon);
            this.daemons[i].setName(this.getServiceNameObject() + " CategoryWriter" + (i + 1));
            if (this.threadPriority > 0) {
                this.daemons[i].setPriority(this.threadPriority);
            }
            this.daemons[i].start();
        }
    }

    public void stopService() throws Exception {
        for (int i = 0; i < this.daemons.length; ++i) {
            this.daemons[i].stop();
            this.daemons[i] = null;
        }
        this.getQueue().release();
        this.daemons = null;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    public void write(Object elements) throws MessageWriteException {
        if (!this.isEnabled()) {
            return;
        }
        this.getQueue().push(elements);
    }

    protected class CategoryWriter
    implements DaemonRunnable {
        protected Category category;

        protected CategoryWriter() {
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) {
            return DistributedCategoryService.this.getQueue().get(1000L);
        }

        public void consume(Object dequeued, DaemonControl ctrl) {
            block3: {
                if (dequeued == null) {
                    return;
                }
                try {
                    this.category.write(dequeued);
                }
                catch (MessageWriteException e) {
                    if (DistributedCategoryService.this.writeErrorLogMessageId == null) break block3;
                    DistributedCategoryService.this.getLogger().write(DistributedCategoryService.this.writeErrorLogMessageId, e);
                }
            }
        }

        public void garbage() {
            if (DistributedCategoryService.this.getQueue() != null) {
                while (DistributedCategoryService.this.getQueue() != null && DistributedCategoryService.this.getQueue().size() > 0) {
                    this.consume(DistributedCategoryService.this.getQueue().get(0L), null);
                }
            }
        }
    }
}

