/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import [Ljava.lang.String;;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import jp.ossc.nimbus.beans.IndexedProperty;
import jp.ossc.nimbus.beans.NestedProperty;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.beans.dataset.PropertySetException;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.Converter;

public class DataSetServletRequestParameterConverter
implements Converter {
    public static final String DEFAULT_DATASET_PARAMETER_NAME = "ds";
    protected Map dataSetMap = new HashMap();
    protected BeanFlowInvokerFactory beanFlowInvokerFactory;
    protected Map propertyCache = Collections.synchronizedMap(new HashMap());
    protected String dataSetParameterName = "ds";
    protected boolean isIgnoreUnknownParameter;

    public void setDataSet(String name, DataSet dataSet) {
        if (dataSet.getName() == null) {
            dataSet.setName(name);
        }
        this.dataSetMap.put(name, dataSet);
    }

    public void setBeanFlowInvokerFactory(BeanFlowInvokerFactory factory) {
        this.beanFlowInvokerFactory = factory;
    }

    public void setDataSetParameterName(String name) {
        this.dataSetParameterName = name;
    }

    public String getDataSetParameterName() {
        return this.dataSetParameterName;
    }

    public void setIgnoreUnknownParameter(boolean isIgnore) {
        this.isIgnoreUnknownParameter = isIgnore;
    }

    public boolean isIgnoreUnknownParameter() {
        return this.isIgnoreUnknownParameter;
    }

    public Object convert(Object obj) throws ConvertException {
        if (!(obj instanceof ServletRequest)) {
            return null;
        }
        ServletRequest request = (ServletRequest)obj;
        Map paramMap = request.getParameterMap();
        if (paramMap == null || paramMap.size() == 0) {
            return null;
        }
        String defaultDsName = request.getParameter(this.dataSetParameterName);
        HashMap<String, DataSet> currentDsMap = new HashMap<String, DataSet>();
        Iterator entries = paramMap.entrySet().iterator();
        while (entries.hasNext()) {
            String propStr;
            Property prop;
            Map.Entry entry = entries.next();
            String key = (String)entry.getKey();
            int index = key.indexOf(35);
            if (index == -1 || index == key.length() - 1) continue;
            String dsName = null;
            dsName = index == 0 ? defaultDsName : key.substring(0, index);
            if (dsName == null) continue;
            DataSet ds = (DataSet)currentDsMap.get(dsName);
            if (ds == null) {
                if (this.dataSetMap.containsKey(dsName)) {
                    ds = ((DataSet)this.dataSetMap.get(dsName)).cloneSchema();
                } else if (this.beanFlowInvokerFactory != null && this.beanFlowInvokerFactory.containsFlow(dsName)) {
                    BeanFlowInvoker beanFlowInvoker = this.beanFlowInvokerFactory.createFlow(dsName);
                    Object ret = null;
                    try {
                        ret = beanFlowInvoker.invokeFlow(null);
                    }
                    catch (Exception e) {
                        throw new ConvertException("Exception occured in BeanFlow '" + dsName + "'", e);
                    }
                    if (!(ret instanceof DataSet)) {
                        throw new ConvertException("Result of BeanFlow '" + dsName + "' is not DataSet.");
                    }
                    ds = (DataSet)ret;
                } else {
                    if (this.isIgnoreUnknownParameter) continue;
                    throw new ConvertException("Unknown DataSet : " + dsName);
                }
                currentDsMap.put(dsName, ds);
            }
            if ((prop = (Property)this.propertyCache.get(propStr = key.substring(index + 1))) == null) {
                try {
                    prop = PropertyFactory.createProperty(propStr);
                    if (this.isIgnoreUnknownParameter) {
                        prop.setIgnoreNullProperty(true);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new ConvertException("Parameter '" + key + "' is illegal.", e);
                }
                this.propertyCache.put(propStr, prop);
            }
            String[] vals = (String[])entry.getValue();
            try {
                if (prop instanceof NestedProperty) {
                    Property thisProp = ((NestedProperty)prop).getThisProperty();
                    if (thisProp instanceof NestedProperty) {
                        Property nestedProp = ((NestedProperty)prop).getNestedProperty();
                        Property nestedProp2 = ((NestedProperty)thisProp).getNestedProperty();
                        if (nestedProp2 instanceof IndexedProperty) {
                            Property thisProp2 = ((NestedProperty)thisProp).getThisProperty();
                            Object thisObj = thisProp2.getProperty(ds);
                            if (thisObj == null) {
                                if (this.isIgnoreUnknownParameter) continue;
                                throw new ConvertException("Parameter '" + key + "' is illegal.");
                            }
                            if (thisObj instanceof RecordList) {
                                this.setRecordListProperty((RecordList)thisObj, nestedProp.getPropertyName(), ((IndexedProperty)nestedProp2).getIndex(), vals);
                                continue;
                            }
                            prop.setProperty(ds, vals[vals.length - 1]);
                            continue;
                        }
                        Object thisObj = thisProp.getProperty(ds);
                        if (thisObj == null) {
                            if (this.isIgnoreUnknownParameter) continue;
                            throw new ConvertException("Parameter '" + key + "' is illegal.");
                        }
                        if (thisObj instanceof RecordList) {
                            this.setRecordListProperty((RecordList)thisObj, nestedProp.getPropertyName(), vals);
                            continue;
                        }
                        if (thisObj instanceof Record) {
                            this.setRecordProperty((Record)thisObj, nestedProp.getPropertyName(), nestedProp.getPropertyType(thisObj), vals);
                            continue;
                        }
                        nestedProp.setProperty(thisObj, vals[vals.length - 1]);
                        continue;
                    }
                    Object thisObj = thisProp.getProperty(ds);
                    if (thisObj == null) {
                        if (this.isIgnoreUnknownParameter) continue;
                        throw new ConvertException("Parameter '" + key + "' is illegal.");
                    }
                    Property nestedProp = ((NestedProperty)prop).getNestedProperty();
                    if (thisObj instanceof RecordList) {
                        this.setRecordListProperty((RecordList)thisObj, nestedProp.getPropertyName(), vals);
                        continue;
                    }
                    if (thisObj instanceof Record) {
                        this.setRecordProperty((Record)thisObj, nestedProp.getPropertyName(), nestedProp.getPropertyType(thisObj), vals);
                        continue;
                    }
                    nestedProp.setProperty(thisObj, vals[vals.length - 1]);
                    continue;
                }
                throw new ConvertException("Parameter '" + key + "' is illegal.");
            }
            catch (PropertySetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ConvertException) {
                    throw (ConvertException)cause;
                }
                if (this.isIgnoreUnknownParameter) continue;
                throw new ConvertException("Parameter '" + key + "' is illegal.", e);
            }
            catch (NoSuchPropertyException e) {
                if (this.isIgnoreUnknownParameter) continue;
                throw new ConvertException("Parameter '" + key + "' is illegal.", e);
            }
            catch (InvocationTargetException e) {
                throw new ConvertException("Parameter '" + key + "' is illegal.", e.getTargetException());
            }
        }
        if (currentDsMap.size() == 0) {
            return null;
        }
        if (currentDsMap.size() == 1) {
            return currentDsMap.values().iterator().next();
        }
        return currentDsMap;
    }

    protected void setRecordProperty(Record record, String name, Class propType, String[] vals) throws PropertySetException {
        if (propType == null || propType.equals(Object.class) || propType.equals(String;.class)) {
            record.setProperty(name, (Object)vals);
        } else if (propType.isArray() && vals.length != 1) {
            record.setParseProperty(name, (Object)vals);
        } else {
            record.setParseProperty(name, (Object)vals[vals.length - 1]);
        }
    }

    protected void setRecordListProperty(RecordList recList, String name, String[] vals) throws PropertySetException {
        for (int i = 0; i < vals.length; ++i) {
            Record rec = null;
            if (recList.size() > i) {
                rec = recList.getRecord(i);
            } else {
                rec = recList.createRecord();
                recList.addRecord(rec);
            }
            rec.setParseProperty(name, (Object)vals[i]);
        }
    }

    protected void setRecordListProperty(RecordList recList, String name, int index, String[] vals) throws PropertySetException {
        Record rec = null;
        if (recList.size() > index) {
            rec = recList.getRecord(index);
        } else {
            for (int i = recList.size(); i <= index; ++i) {
                rec = recList.createRecord();
                recList.addRecord(rec);
            }
        }
        rec.setParseProperty(name, (Object)vals[0]);
    }
}

