
import java.sql.*;
import java.util.*;

import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.connection.PersistentManager;
import jp.ossc.nimbus.service.connection.PersistentException;

/**
 * TvTsNXB
 */
public class Main{
    
    public static final void main(String[] args){
        
        // T[rX`t@C[h
        if(ServiceManagerFactory.loadManager("service-definition.xml")){
            System.out.println("T[rX`̓ǂݍ݂ɐ܂B");
            
            // ConnectionFactoryT[rX擾
            ConnectionFactory factory = (ConnectionFactory)ServiceManagerFactory
                .getServiceObject("ConnectionFactory");
            
            // PersistentManagerT[rX擾
            PersistentManager pm = (PersistentManager)ServiceManagerFactory
                .getServiceObject("PersistentManager");
            
            Connection con = null;
            try{
                // Connection̎擾
                con = factory.getConnection();
                
                // UserIuWFNgi
                int updateCount = pm.persist(
                    con,
                    "insert into MYUSER(name, age, sex) values(?, ?, ?)",
                    new User("Yamada tarou", 20, "0"),
                    new String[]{"Name", "Age", "Sex"}
                );
                System.out.println("INSERT =" + updateCount);
                
                // UserIuWFNg[h
                User user = (User)pm.load(
                    con,
                    "select name, age, sex from MYUSER",
                    null,
                    null,
                    new User(),
                    new String[]{"Name", "Age", "Sex"}
                );
                System.out.println("[hUser=" + user);
                
                // UserIuWFNg̔zi
                updateCount = pm.persist(
                    con,
                    "insert into MYUSER(name, age, sex) values(?, ?, ?)",
                    new User[]{
                        new User("Yamada hanako", 40, "1"),
                        new User("Tanaka kenji", 25, "0")
                    },
                    new String[]{"Name", "Age", "Sex"}
                );
                System.out.println("INSERT =" + updateCount);
                
                // UserIuWFNg̃Xg[h
                List userList = (List)pm.load(
                    con,
                    "select name, age, sex from MYUSER",
                    null,
                    null,
                    User.class,
                    new String[]{"Name", "Age", "Sex"}
                );
                System.out.println("[hUser̃XgF");
                for(int i = 0, imax = userList.size(); i < imax; i++){
                    System.out.println("    " + userList.get(i));
                }
                
                // UserIuWFNg[h
                userList = (List)pm.load(
                    con,
                    "select name, age, sex from MYUSER where sex=?",
                    "0",
                    null,
                    User.class,
                    new String[]{"Name", "Age", "Sex"}
                );
                System.out.println("\"sex0\"Ń[hUser̃XgF");
                for(int i = 0, imax = userList.size(); i < imax; i++){
                    System.out.println("    " + userList.get(i));
                }
                
                // UserIuWFNg폜
                updateCount = pm.persist(
                    con,
                    "delete from MYUSER where name=?",
                    userList,
                    new String[]{"Name"}
                );
                System.out.println("DELETE =" + updateCount);
                
                // UserIuWFNg̃Xg[h
                userList = (List)pm.load(
                    con,
                    "select name, age, sex from MYUSER",
                    null,
                    null,
                    User.class,
                    new String[]{"Name", "Age", "Sex"}
                );
                System.out.println("폜̃[hUser̃XgF");
                for(int i = 0, imax = userList.size(); i < imax; i++){
                    System.out.println("    " + userList.get(i));
                }
            }catch(ConnectionFactoryException e){
                e.printStackTrace();
                System.exit(-1);
            }catch(PersistentException e){
                e.printStackTrace();
                System.exit(-1);
            }finally{
                if(con != null){
                    try{
                        con.close();
                    }catch(SQLException e){
                        e.printStackTrace();
                    }
                }
            }
        }else{
            System.out.println("T[rX`̓ǂݍ݂Ɏs܂B");
        }
        
        // T[rX`t@CA[h
        ServiceManagerFactory.unloadManager("service-definition.xml");
    }
    
    public static class User{
        private String name;
        private int age;
        private String sex;
        
        public User(){}
        
        public User(String name, int age, String sex){
            this.name = name;
            this.age = age;
            this.sex = sex;
        }
        
        public void setName(String name){
            this.name = name;
        }
        public String getName(){
            return name;
        }
        public void setAge(int age){
            this.age = age;
        }
        public int getAge(){
            return age;
        }
        public void setSex(String sex){
            this.sex = sex;
        }
        public String getSex(){
            return sex;
        }
        public String toString(){
            return '{' + name + ", " + age + ", " + sex + '}';
        }
    }
}