
import java.io.*;
import java.net.*;

import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.util.converter.DataSetJSONConverter;
import jp.ossc.nimbus.util.converter.StringStreamConverter;

/**
 * TvPsNXB
 */
public class Main{
    
    public static final void main(String[] args) throws Exception{
        
        // T[oƐڑ
        Socket socket = new Socket("localhost", 10000);
        
        // v𑗐Mo̓Xg[擾
        PrintWriter pw = new PrintWriter(socket.getOutputStream());
        
        // ANVo
        pw.println("Hello");
        
        // MDataSet𐶐
        DataSet ds = new DataSet("HelloRequest");
        ds.setHeaderSchema(
            ":name,java.lang.String\n"
             + ":message,java.lang.String"
        );
        ds.getHeader().setProperty("name", "Hoge");
        ds.getHeader().setProperty("message", "Hello!!");
        
        // DataSetJSONϊsConverter𐶐
        DataSetJSONConverter dsConverter = new DataSetJSONConverter();
        dsConverter.setOutputSchema(false);
        StringStreamConverter strConverter = new StringStreamConverter();
        
        // DataSetJSONɕϊďo
        pw.print((String)strConverter.convertToObject(dsConverter.convertToStream(ds)));
        pw.flush();
        
        // M̓Xg[擾
        DataInputStream dis = new DataInputStream(socket.getInputStream());
        
        // Xe[^Xǂݍ
        int status = dis.readInt();
        System.out.println("response staus=" + status);
        
        // f[^ǂݍ
        int length = dis.readInt();
        System.out.println("response length=" + length);
        
        // 퉞̏ꍇ
        if(status == 200){
            // f[^ǂݍ
            byte[] data = new byte[length];
            dis.read(data);
            
            // MDataSet𐶐
            DataSet resDs = new DataSet("HelloResponse");
            resDs.setHeaderSchema(
                ":message,java.lang.String"
            );
            
            // f[^JSONDataSetɕϊ
            resDs = (DataSet)dsConverter.convertToObject(new ByteArrayInputStream(data), resDs);
            
            System.out.println(ds.getHeader().getProperty("message"));
        }
        // ُ퉞̏ꍇ
        else{
            System.out.println("Error occurred.");
        }
        
        // T[oƐؒf
        socket.close();
    }
    
}