/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.AbstractCacheService;
import jp.ossc.nimbus.service.cache.Cache;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.DefaultCachedReference;
import jp.ossc.nimbus.service.cache.MemoryCacheServiceMBean;
import jp.ossc.nimbus.service.cache.PersistableCache;

public class MemoryCacheService
extends AbstractCacheService
implements Serializable,
PersistableCache,
MemoryCacheServiceMBean {
    private static final long serialVersionUID = -1701042314659441524L;
    private ServiceName persistCacheServiceName;
    private boolean isLoadOnStart = true;
    private boolean isSaveOnStop = true;

    public void setPersistCacheServiceName(ServiceName name) {
        this.persistCacheServiceName = name;
    }

    public ServiceName getPersistCacheServiceName() {
        return this.persistCacheServiceName;
    }

    public void setLoadOnStart(boolean isLoad) {
        this.isLoadOnStart = isLoad;
    }

    public boolean isLoadOnStart() {
        return this.isLoadOnStart;
    }

    public void setSaveOnStop(boolean isSave) {
        this.isSaveOnStop = isSave;
    }

    public boolean isSaveOnStop() {
        return this.isSaveOnStop;
    }

    public void startService() throws Exception {
        if (this.isLoadOnStart) {
            this.load();
        }
    }

    public void stopService() throws Exception {
        if (this.isSaveOnStop) {
            this.save();
        }
    }

    protected CachedReference createCachedReference(Object obj) {
        return new DefaultCachedReference(obj);
    }

    public synchronized void load() throws Exception {
        if (this.persistCacheServiceName != null) {
            Cache persistCache = (Cache)ServiceManagerFactory.getServiceObject(this.persistCacheServiceName);
            CachedReference[] refs = persistCache.toArray();
            for (int i = 0; i < refs.length; ++i) {
                this.add(refs[i].get());
            }
        }
    }

    public synchronized void save() throws Exception {
        if (this.persistCacheServiceName != null) {
            Cache persistCache = (Cache)ServiceManagerFactory.getServiceObject(this.persistCacheServiceName);
            persistCache.clear();
            CachedReference[] refs = this.toArray();
            for (int i = 0; i < refs.length; ++i) {
                persistCache.add(refs[i].get());
            }
        }
    }
}

