/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.http.httpclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.http.HttpRequest;
import jp.ossc.nimbus.service.http.HttpRequestCreateException;
import jp.ossc.nimbus.util.converter.StreamConverter;
import jp.ossc.nimbus.util.converter.StreamStringConverter;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.params.HttpMethodParams;

public abstract class HttpRequestImpl
implements HttpRequest,
Cloneable {
    public static final String HTTP_VERSION_0_9 = "0.9";
    public static final String HTTP_VERSION_1_0 = "1.0";
    public static final String HTTP_VERSION_1_1 = "1.1";
    protected static final String HEADER_CONTENT_TYPE = "Content-Type";
    protected static final String HEADER_CHARSET = "charset";
    protected static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    protected static final String CONTENT_ENCODING_DEFLATE = "deflate";
    protected static final String CONTENT_ENCODING_GZIP = "gzip";
    protected static final String CONTENT_ENCODING_X_GZIP = "x-gzip";
    protected String actionName;
    protected String url;
    protected String httpVersion;
    protected Map headerMap;
    protected String contentType;
    protected String characterEncoding;
    protected String queryString;
    protected Map parameterMap;
    protected InputStream inputStream;
    protected ByteArrayOutputStream outputStream;
    protected boolean isDoAuthentication;
    protected boolean isFollowRedirects;
    protected Object inputObject;
    protected ServiceName streamConverterServiceName;
    protected StreamConverter streamConverter;
    protected byte[] inputBytes;
    protected int deflateLength = -1;
    protected Map httpMethodParamMap;

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String name) {
        this.actionName = name;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String version) {
        this.httpVersion = version;
    }

    public Set getHeaderNameSet() {
        return this.headerMap == null ? new HashSet() : this.headerMap.keySet();
    }

    public String getHeader(String name) {
        String[] headers = this.getHeaders(name);
        if (headers == null) {
            return null;
        }
        return headers[0];
    }

    public String[] getHeaders(String name) {
        if (this.headerMap == null) {
            return null;
        }
        return (String[])this.headerMap.get(name);
    }

    public Map getHeaderMap() {
        return this.headerMap;
    }

    public void setHeader(String name, String value) {
        if (this.headerMap == null) {
            this.headerMap = new HashMap();
        }
        this.headerMap.put(name, new String[]{value});
    }

    public void setHeaders(String name, String[] value) {
        if (this.headerMap == null) {
            this.headerMap = new HashMap();
        }
        this.headerMap.put(name, value);
    }

    public void addHeader(String name, String value) {
        String[] vals;
        if (this.headerMap == null) {
            this.headerMap = new HashMap();
        }
        if ((vals = (String[])this.headerMap.get(name)) == null) {
            vals = new String[]{value};
            this.headerMap.put(name, vals);
        } else {
            String[] newVals = new String[vals.length + 1];
            System.arraycopy(vals, 0, newVals, 0, vals.length);
            newVals[newVals.length - 1] = value;
            this.headerMap.put(name, newVals);
        }
    }

    public void removeHeader(String name) {
        if (this.headerMap == null) {
            return;
        }
        this.headerMap.remove(name);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String query) {
        this.queryString = query;
    }

    public Set getParameterNameSet() {
        return this.parameterMap == null ? new HashSet() : this.parameterMap.keySet();
    }

    public String getParameter(String name) {
        String[] params = this.getParameters(name);
        if (params == null) {
            return null;
        }
        return params[0];
    }

    public String[] getParameters(String name) {
        if (this.parameterMap == null) {
            return null;
        }
        return (String[])this.parameterMap.get(name);
    }

    public Map getParameterMap() {
        return this.parameterMap;
    }

    public void setParameter(String name, String value) {
        String[] vals;
        if (this.parameterMap == null) {
            this.parameterMap = new LinkedHashMap();
        }
        if ((vals = (String[])this.parameterMap.get(name)) == null) {
            vals = new String[]{value};
            this.parameterMap.put(name, vals);
        } else {
            String[] newVals = new String[vals.length + 1];
            System.arraycopy(vals, 0, newVals, 0, vals.length);
            newVals[newVals.length - 1] = value;
            this.parameterMap.put(name, newVals);
        }
    }

    public void setParameters(String name, String[] value) {
        if (this.parameterMap == null) {
            this.parameterMap = new LinkedHashMap();
        }
        this.parameterMap.put(name, value);
    }

    public void setInputStream(InputStream is) {
        this.inputStream = is;
    }

    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayOutputStream();
        }
        return this.outputStream;
    }

    public void setObject(Object input) {
        this.inputObject = input;
    }

    public Object getObject() {
        return this.inputObject;
    }

    public void setDoAuthentication(boolean isDo) {
        this.isDoAuthentication = isDo;
    }

    public boolean isDoAuthentication() {
        return this.isDoAuthentication;
    }

    public void setFollowRedirects(boolean isRedirects) {
        this.isFollowRedirects = isRedirects;
    }

    public boolean isFollowRedirects() {
        return this.isFollowRedirects;
    }

    public Set getHttpMethodParamNameSet() {
        return this.httpMethodParamMap == null ? new HashSet() : this.httpMethodParamMap.keySet();
    }

    public void setHttpMethodParam(String name, Object value) {
        if (this.httpMethodParamMap == null) {
            this.httpMethodParamMap = new HashMap();
        }
        this.httpMethodParamMap.put(name, value);
    }

    public Object getHttpMethodParam(String name) {
        if (this.httpMethodParamMap == null) {
            return null;
        }
        return this.httpMethodParamMap.get(name);
    }

    public Map getHttpMethodParamMap() {
        if (this.httpMethodParamMap == null) {
            this.httpMethodParamMap = new HashMap();
        }
        return this.httpMethodParamMap;
    }

    public void setStreamConverterServiceName(ServiceName name) {
        this.streamConverterServiceName = name;
    }

    public ServiceName getStreamConverterServiceName() {
        return this.streamConverterServiceName;
    }

    public void setStreamConverter(StreamConverter converter) {
        this.streamConverter = converter;
    }

    public StreamConverter getStreamConverter() {
        return this.streamConverter;
    }

    public void setDeflateLength(int length) {
        this.deflateLength = length;
    }

    public int getDeflateLength() {
        return this.deflateLength;
    }

    public byte[] getInputBytes() {
        return this.inputBytes;
    }

    protected abstract HttpMethodBase instanciateHttpMethod() throws Exception;

    protected void initHttpMethod(HttpMethodBase method) throws Exception {
        byte[] bytes;
        ByteArrayOutputStream baos;
        String name;
        Iterator names;
        if (this.url != null) {
            method.setURI(new URI(this.url, true));
        }
        HttpMethodParams params = method.getParams();
        if (this.httpMethodParamMap != null) {
            names = this.httpMethodParamMap.keySet().iterator();
            while (names.hasNext()) {
                name = (String)names.next();
                Object value = this.httpMethodParamMap.get(name);
                params.setParameter(name, value);
            }
        }
        if (this.httpVersion != null) {
            if (HTTP_VERSION_0_9.equals(this.httpVersion)) {
                params.setVersion(HttpVersion.HTTP_0_9);
            } else if (HTTP_VERSION_1_0.equals(this.httpVersion)) {
                params.setVersion(HttpVersion.HTTP_1_0);
            } else if (HTTP_VERSION_1_1.equals(this.httpVersion)) {
                params.setVersion(HttpVersion.HTTP_1_1);
            }
        }
        if (this.contentType != null) {
            StringBuffer buf = new StringBuffer(this.contentType);
            if (this.characterEncoding != null) {
                buf.append(';').append(HEADER_CHARSET).append('=').append(this.characterEncoding);
            }
            method.addRequestHeader(HEADER_CONTENT_TYPE, buf.toString());
        }
        if (this.queryString != null) {
            method.setQueryString(this.queryString);
        }
        if (this.parameterMap != null) {
            this.initParameter(method, this.parameterMap);
        }
        if (this.inputStream != null) {
            baos = new ByteArrayOutputStream();
            bytes = new byte[1024];
            int length = 0;
            while ((length = this.inputStream.read(bytes)) != -1) {
                baos.write(bytes, 0, length);
            }
            this.inputBytes = baos.toByteArray();
        } else if (this.outputStream != null && this.outputStream.size() != 0) {
            this.inputBytes = this.outputStream.toByteArray();
        } else if (this.inputObject != null) {
            if (this.streamConverter == null && this.streamConverterServiceName == null) {
                throw new HttpRequestCreateException("StreamConverter is null.");
            }
            baos = new ByteArrayOutputStream();
            bytes = new byte[1024];
            int length = 0;
            StreamConverter converter = this.streamConverter;
            if (this.streamConverterServiceName != null) {
                converter = (StreamConverter)ServiceManagerFactory.getServiceObject(this.streamConverterServiceName);
            }
            if (this.characterEncoding != null && converter instanceof StreamStringConverter) {
                ((StreamStringConverter)converter).setCharacterEncodingToStream(this.characterEncoding);
            }
            InputStream is = converter.convertToStream(this.inputObject);
            while ((length = is.read(bytes)) != -1) {
                baos.write(bytes, 0, length);
            }
            this.inputBytes = baos.toByteArray();
        }
        if (this.inputBytes == null) {
            this.removeHeader(HEADER_CONTENT_ENCODING);
        } else {
            this.initInputStream(method, this.compress(this.inputBytes));
        }
        if (this.headerMap != null) {
            names = this.headerMap.keySet().iterator();
            while (names.hasNext()) {
                name = (String)names.next();
                String[] vals = (String[])this.headerMap.get(name);
                for (int i = 0; i < vals.length; ++i) {
                    if (HEADER_CONTENT_TYPE.equals(name) && method.getRequestHeader(name) != null) continue;
                    method.addRequestHeader(name, vals[i]);
                }
            }
        }
        if (this.isDoAuthentication != method.getDoAuthentication()) {
            method.setDoAuthentication(this.isDoAuthentication);
        }
        if (this.isFollowRedirects != method.getFollowRedirects()) {
            method.setFollowRedirects(this.isFollowRedirects);
        }
    }

    protected InputStream compress(byte[] inputBytes) throws IOException {
        String encode = this.getHeader(HEADER_CONTENT_ENCODING);
        if (encode == null) {
            return new ByteArrayInputStream(inputBytes);
        }
        if (encode.indexOf(CONTENT_ENCODING_DEFLATE) == -1 && encode.indexOf(CONTENT_ENCODING_GZIP) == -1 && encode.indexOf(CONTENT_ENCODING_X_GZIP) == -1 || this.deflateLength != -1 && inputBytes.length < this.deflateLength) {
            this.removeHeader(HEADER_CONTENT_ENCODING);
            return new ByteArrayInputStream(inputBytes);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream os = baos;
        if (encode.indexOf(CONTENT_ENCODING_DEFLATE) != -1) {
            os = new DeflaterOutputStream(os);
        } else if (encode.indexOf(CONTENT_ENCODING_GZIP) != -1 || encode.indexOf(CONTENT_ENCODING_X_GZIP) != -1) {
            os = new GZIPOutputStream(os);
        } else {
            throw new IOException("Can not compress. [" + encode + "]");
        }
        os.write(inputBytes, 0, inputBytes.length);
        os.flush();
        os.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    protected abstract void initParameter(HttpMethodBase var1, Map var2) throws Exception;

    protected abstract void initInputStream(HttpMethodBase var1, InputStream var2) throws Exception;

    public HttpMethodBase createHttpMethod() throws HttpRequestCreateException {
        HttpMethodBase httpMethod = null;
        try {
            httpMethod = this.instanciateHttpMethod();
            this.initHttpMethod(httpMethod);
        }
        catch (HttpRequestCreateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpRequestCreateException(e);
        }
        return httpMethod;
    }

    public Object clone() throws CloneNotSupportedException {
        HttpRequestImpl clone = (HttpRequestImpl)super.clone();
        if (clone.headerMap != null) {
            clone.headerMap = new HashMap(this.headerMap);
        }
        if (clone.parameterMap != null) {
            clone.parameterMap = new LinkedHashMap(this.parameterMap);
        }
        return clone;
    }
}

