/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import jp.ossc.nimbus.ioc.UnitOfWork;
import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.UnitOfWorkJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class UnitOfWorkJournalEditorService
extends BlockJournalEditorServiceBase
implements UnitOfWorkJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 4874986389010798L;
    protected static final String HEADER = "[UnitOfWork]";
    private static final String STATUS_HEADER = "Status : ";
    private static final String UNIT_OF_WORK_SIZE_HEADER = "UnitOfWork size : ";
    private static final String UNIT_OF_WORK_EXECUTE_SIZE_HEADER = "UnitOfWork execute size : ";
    private static final String COMMAND_SIZE_HEADER = "Command size : ";
    private static final String COMMAND_EXECUTE_SIZE_HEADER = "Command execute size : ";
    private static final String EXCEPTION_COUNT_HEADER = "Exception count : ";
    private static final String EXCEPTIONS_HEADER = "Exceptions : ";
    private static final String COMMANDS_HEADER = "Commands : ";
    private static final String STATUS_BEFORE = "Before";
    private static final String STATUS_COMPLETE = "Complete";
    private static final String STATUS_ERROR = "Error";
    private static final String STATUS_UNKNOWN = "Unknown";
    private boolean isOutputStatus = true;
    private boolean isOutputUnitOfWorkSize = true;
    private boolean isOutputUnitOfWorkExecuteSize = true;
    private boolean isOutputCommandSize = true;
    private boolean isOutputCommandExecuteSize = true;
    private boolean isOutputExceptionCount = true;
    private boolean isOutputExceptions = true;
    private boolean isOutputCommandBases = true;

    public UnitOfWorkJournalEditorService() {
        this.setHeader(HEADER);
    }

    public void setOutputStatus(boolean isOutput) {
        this.isOutputStatus = isOutput;
    }

    public boolean isOutputStatus() {
        return this.isOutputStatus;
    }

    public void setOutputUnitOfWorkSize(boolean isOutput) {
        this.isOutputUnitOfWorkSize = isOutput;
    }

    public boolean isOutputUnitOfWorkSize() {
        return this.isOutputUnitOfWorkSize;
    }

    public void setOutputUnitOfWorkExecuteSize(boolean isOutput) {
        this.isOutputUnitOfWorkExecuteSize = isOutput;
    }

    public boolean isOutputUnitOfWorkExecuteSize() {
        return this.isOutputUnitOfWorkExecuteSize;
    }

    public void setOutputCommandSize(boolean isOutput) {
        this.isOutputCommandSize = isOutput;
    }

    public boolean isOutputCommandSize() {
        return this.isOutputCommandSize;
    }

    public void setOutputCommandExecuteSize(boolean isOutput) {
        this.isOutputCommandExecuteSize = isOutput;
    }

    public boolean isOutputCommandExecuteSize() {
        return this.isOutputCommandExecuteSize;
    }

    public void setOutputExceptionCount(boolean isOutput) {
        this.isOutputExceptionCount = isOutput;
    }

    public boolean isOutputExceptionCount() {
        return this.isOutputExceptionCount;
    }

    public void setOutputExceptions(boolean isOutput) {
        this.isOutputExceptions = isOutput;
    }

    public boolean isOutputExceptions() {
        return this.isOutputExceptions;
    }

    public void setOutputCommandBases(boolean isOutput) {
        this.isOutputCommandBases = isOutput;
    }

    public boolean isOutputCommandBases() {
        return this.isOutputCommandBases;
    }

    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        UnitOfWork unitOfWork = (UnitOfWork)value;
        boolean isMake = false;
        if (this.isOutputStatus()) {
            this.makeStatusFormat(finder, key, unitOfWork, buf);
            isMake = true;
        }
        if (this.isOutputUnitOfWorkSize()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeUnitOfWorkSizeFormat(finder, key, unitOfWork, buf);
            isMake = true;
        }
        if (this.isOutputUnitOfWorkExecuteSize()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeUnitOfWorkExecuteSizeFormat(finder, key, unitOfWork, buf);
            isMake = true;
        }
        if (this.isOutputCommandSize()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeCommandSizeFormat(finder, key, unitOfWork, buf);
            isMake = true;
        }
        if (this.isOutputCommandExecuteSize()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeCommandExecuteSizeFormat(finder, key, unitOfWork, buf);
            isMake = true;
        }
        if (this.isOutputExceptionCount()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeExceptionCountFormat(finder, key, unitOfWork, buf);
            isMake = true;
        }
        if (this.isOutputExceptions()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeExceptionsFormat(finder, key, unitOfWork, buf);
            isMake = true;
        }
        if (this.isOutputCommandBases()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeCommandBasesFormat(finder, key, unitOfWork, buf);
            isMake = true;
        }
        return isMake;
    }

    protected StringBuffer makeStatusFormat(EditorFinder finder, Object key, UnitOfWork unitOfWork, StringBuffer buf) {
        buf.append(STATUS_HEADER);
        switch (unitOfWork.getStatus()) {
            case -1: {
                buf.append(STATUS_BEFORE);
                break;
            }
            case 0: {
                buf.append(STATUS_COMPLETE);
                break;
            }
            case 1: {
                buf.append(STATUS_ERROR);
                break;
            }
            default: {
                buf.append(STATUS_UNKNOWN);
            }
        }
        return buf;
    }

    protected StringBuffer makeUnitOfWorkSizeFormat(EditorFinder finder, Object key, UnitOfWork unitOfWork, StringBuffer buf) {
        return buf.append(UNIT_OF_WORK_SIZE_HEADER).append(unitOfWork.unitOfWorkSize());
    }

    protected StringBuffer makeUnitOfWorkExecuteSizeFormat(EditorFinder finder, Object key, UnitOfWork unitOfWork, StringBuffer buf) {
        return buf.append(UNIT_OF_WORK_EXECUTE_SIZE_HEADER).append(unitOfWork.unitOfWorkExecuteSize());
    }

    protected StringBuffer makeCommandSizeFormat(EditorFinder finder, Object key, UnitOfWork unitOfWork, StringBuffer buf) {
        return buf.append(COMMAND_SIZE_HEADER).append(unitOfWork.commandSize());
    }

    protected StringBuffer makeCommandExecuteSizeFormat(EditorFinder finder, Object key, UnitOfWork unitOfWork, StringBuffer buf) {
        return buf.append(COMMAND_EXECUTE_SIZE_HEADER).append(unitOfWork.commandExecuteSize());
    }

    protected StringBuffer makeExceptionCountFormat(EditorFinder finder, Object key, UnitOfWork unitOfWork, StringBuffer buf) {
        return buf.append(EXCEPTION_COUNT_HEADER).append(unitOfWork.getExceptionCount());
    }

    protected StringBuffer makeExceptionsFormat(EditorFinder finder, Object key, UnitOfWork unitOfWork, StringBuffer buf) {
        buf.append(EXCEPTIONS_HEADER);
        Throwable[] exceptions = unitOfWork.getExceptions();
        if (exceptions == null || exceptions.length == 0) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        for (int i = 0; i < exceptions.length; ++i) {
            this.makeObjectFormat(finder, null, exceptions[i], subBuf);
            if (i == exceptions.length - 1) continue;
            subBuf.append(this.getLineSeparator());
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }

    protected StringBuffer makeCommandBasesFormat(EditorFinder finder, Object key, UnitOfWork unitOfWork, StringBuffer buf) {
        buf.append(COMMANDS_HEADER);
        if (unitOfWork.size() == 0) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        int imax = unitOfWork.size();
        for (int i = 0; i < imax; ++i) {
            this.makeObjectFormat(finder, null, unitOfWork.getCommand(i), subBuf);
            if (i == imax - 1) continue;
            subBuf.append(this.getLineSeparator());
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }
}

