/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ConnectionCreateException;
import jp.ossc.nimbus.service.publish.GroupClientConnectionFactoryImpl;
import jp.ossc.nimbus.service.publish.GroupConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.publish.GroupServerConnectionImpl;
import jp.ossc.nimbus.service.publish.RemoteClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.service.repository.Repository;

public class GroupConnectionFactoryService
extends ServiceBase
implements ClientConnectionFactory,
ServerConnectionFactory,
GroupConnectionFactoryServiceMBean {
    private static final long serialVersionUID = -5236361194646557697L;
    private ServiceName jndiRepositoryServiceName;
    private String jndiName = "publish/ClientConnectionFactory";
    private int rmiPort;
    private Repository jndiRepository;
    private Map subjectMap;
    private GroupServerConnectionImpl serverConnection;
    private GroupClientConnectionFactoryImpl clientConnectionFactory;

    public void setJndiName(String name) {
        this.jndiName = name;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiRepositoryServiceName(ServiceName name) {
        this.jndiRepositoryServiceName = name;
    }

    public ServiceName getJndiRepositoryServiceName() {
        return this.jndiRepositoryServiceName;
    }

    public void setRMIPort(int port) {
        this.rmiPort = port;
    }

    public int getRMIPort() {
        return this.rmiPort;
    }

    public void addSubjectMapping(SubjectMapping mapping) {
        ArrayList<SubjectMapping> mappings = (ArrayList<SubjectMapping>)this.subjectMap.get(mapping.getSubject());
        if (mappings == null) {
            mappings = new ArrayList<SubjectMapping>();
            this.subjectMap.put(mapping.getSubject(), mappings);
        }
        mappings.add(mapping);
    }

    public List getSubjectMappings(String subject) {
        return this.subjectMap == null ? null : (List)this.subjectMap.get(subject);
    }

    public Map getSubjectMappingMap() {
        return this.subjectMap;
    }

    public Repository getJndiRepository() {
        return this.jndiRepository;
    }

    public void setJndiRepository(Repository repository) {
        this.jndiRepository = repository;
    }

    public void createService() throws Exception {
        this.subjectMap = Collections.synchronizedMap(new LinkedHashMap());
    }

    public void startService() throws Exception {
        RemoteClientConnectionFactory remoteClientConnectionFactory;
        if (this.subjectMap.size() == 0) {
            throw new IllegalArgumentException("SubjectMappings is null.");
        }
        if (this.jndiRepositoryServiceName != null) {
            this.jndiRepository = (Repository)ServiceManagerFactory.getServiceObject(this.jndiRepositoryServiceName);
        }
        this.serverConnection = new GroupServerConnectionImpl();
        this.clientConnectionFactory = new GroupClientConnectionFactoryImpl();
        Iterator mappingsItr = this.subjectMap.values().iterator();
        while (mappingsItr.hasNext()) {
            List mappings = (List)mappingsItr.next();
            int imax = mappings.size();
            for (int i = 0; i < imax; ++i) {
                ClientConnectionFactory ccFactory;
                SubjectMapping mapping = (SubjectMapping)mappings.get(i);
                ServerConnectionFactory serverConnectionFactory = mapping.getServerConnectionFactory();
                if (serverConnectionFactory == null && mapping.getServerConnectionFactoryServiceName() != null) {
                    serverConnectionFactory = (ServerConnectionFactory)ServiceManagerFactory.getServiceObject(mapping.getServerConnectionFactoryServiceName());
                }
                if (serverConnectionFactory != null) {
                    ServerConnection connection = serverConnectionFactory.getServerConnection();
                    if (connection == null) {
                        throw new IllegalArgumentException("ServerConnection is null." + mapping);
                    }
                    this.serverConnection.addServerConnection(mapping.getSubject(), mapping.getKeyPattern(), connection);
                }
                if ((ccFactory = mapping.getClientConnectionFactory()) == null && mapping.getClientConnectionFactoryServiceName() != null) {
                    ccFactory = mapping.getServerConnectionFactory() == null && mapping.getServerConnectionFactoryServiceName() != null && mapping.getServerConnectionFactoryServiceName().equals(mapping.getClientConnectionFactoryServiceName()) ? (ClientConnectionFactory)((Object)serverConnectionFactory) : (ClientConnectionFactory)ServiceManagerFactory.getServiceObject(mapping.getClientConnectionFactoryServiceName());
                }
                if (ccFactory == null && mapping.getClientConnectionFactoryJndiName() != null) {
                    if (this.jndiRepository == null) {
                        throw new IllegalArgumentException("JndiRepository is null." + mapping);
                    }
                    ccFactory = (ClientConnectionFactory)this.jndiRepository.get(mapping.getClientConnectionFactoryJndiName());
                    if (ccFactory == null) {
                        throw new IllegalArgumentException("ClientConnectionFactory is null." + mapping);
                    }
                }
                if (ccFactory != null) {
                    this.clientConnectionFactory.addClientConnectionFactory(mapping.getSubject(), mapping.getKeyPattern(), ccFactory);
                }
                if (serverConnectionFactory != null || ccFactory != null) continue;
                throw new IllegalArgumentException("ServerConnectionFactory and ClientConnectionFactory is null." + mapping);
            }
        }
        if (this.jndiRepository != null && this.jndiName != null && !this.jndiRepository.register(this.jndiName, remoteClientConnectionFactory = new RemoteClientConnectionFactory(this, this.rmiPort))) {
            throw new Exception("Could not register in jndiRepository.");
        }
    }

    public void stopService() throws Exception {
        if (this.jndiRepository != null) {
            this.jndiRepository.unregister(this.jndiName);
        }
        this.serverConnection = null;
        this.clientConnectionFactory = null;
    }

    public ClientConnection getClientConnection() throws ConnectionCreateException, RemoteException {
        return this.clientConnectionFactory.getClientConnection();
    }

    public int getClientCount() throws RemoteException {
        return this.clientConnectionFactory.getClientCount();
    }

    public ServerConnection getServerConnection() throws ConnectionCreateException {
        return this.serverConnection;
    }

    public static class SubjectMapping
    implements Serializable {
        private static final long serialVersionUID = 3520091409575956334L;
        private String subject;
        private Pattern keyPattern;
        private String clientConnectionFactoryJndiName;
        private ServiceName clientConnectionFactoryServiceName;
        private ClientConnectionFactory clientConnectionFactory;
        private ServiceName serverConnectionFactoryServiceName;
        private ServerConnectionFactory serverConnectionFactory;

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setKey(String pattern) {
            this.keyPattern = Pattern.compile(pattern);
        }

        public String getKey() {
            return this.keyPattern == null ? null : this.keyPattern.pattern();
        }

        public Pattern getKeyPattern() {
            return this.keyPattern;
        }

        public void setKeyPattern(Pattern pattern) {
            this.keyPattern = pattern;
        }

        public void setClientConnectionFactoryJndiName(String name) {
            this.clientConnectionFactoryJndiName = name;
        }

        public String getClientConnectionFactoryJndiName() {
            return this.clientConnectionFactoryJndiName;
        }

        public void setClientConnectionFactoryServiceName(ServiceName name) {
            this.clientConnectionFactoryServiceName = name;
        }

        public ServiceName getClientConnectionFactoryServiceName() {
            return this.clientConnectionFactoryServiceName;
        }

        public void setClientConnectionFactory(ClientConnectionFactory factory) {
            this.clientConnectionFactory = factory;
        }

        public ClientConnectionFactory getClientConnectionFactory() {
            return this.clientConnectionFactory;
        }

        public void setServerConnectionFactoryServiceName(ServiceName name) {
            this.serverConnectionFactoryServiceName = name;
        }

        public ServiceName getServerConnectionFactoryServiceName() {
            return this.serverConnectionFactoryServiceName;
        }

        public void setServerConnectionFactory(ServerConnectionFactory factory) {
            this.serverConnectionFactory = factory;
        }

        public ServerConnectionFactory getServerConnectionFactory() {
            return this.serverConnectionFactory;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append('{');
            buf.append("subject=").append(this.subject);
            buf.append(", key=").append(this.keyPattern == null ? null : this.keyPattern.pattern());
            buf.append(", clientConnectionFactoryJndiName=").append(this.clientConnectionFactoryJndiName);
            buf.append(", clientConnectionFactoryServiceName=").append(this.clientConnectionFactoryServiceName);
            buf.append(", clientConnectionFactory=").append(this.clientConnectionFactory);
            buf.append(", serverConnectionFactoryServiceName=").append(this.serverConnectionFactoryServiceName);
            buf.append(", serverConnectionFactory=").append(this.serverConnectionFactory);
            buf.append('}');
            return buf.toString();
        }
    }
}

