/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ConnectionCreateException;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageCreateException;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.MessageListener;
import jp.ossc.nimbus.service.publish.MessageReceiver;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.RequestConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.publish.RequestMessageListener;
import jp.ossc.nimbus.service.publish.RequestServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.service.publish.ServerConnectionListener;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class RequestConnectionFactoryService
extends ServiceBase
implements ServerConnectionFactory,
MessageReceiver,
RequestConnectionFactoryServiceMBean {
    private static final long serialVersionUID = -3122390503708261498L;
    private ServiceName serverConnectionFactoryServiceName;
    private RequestServerConnectionImpl serverConnection;
    private ServiceName messageReceiverServiceName;
    private MessageReceiver messageReceiver;
    private Map messageListenerMap;
    private int sequence;
    private boolean isAsynchResponse;
    private int responseRetryCount = 1;
    private long responseRetryInterval = 50L;
    private Timer timeoutTimer;

    public void setServerConnectionFactoryServiceName(ServiceName name) {
        this.serverConnectionFactoryServiceName = name;
    }

    public ServiceName getServerConnectionFactoryServiceName() {
        return this.serverConnectionFactoryServiceName;
    }

    public void setMessageReceiverServiceName(ServiceName name) {
        this.messageReceiverServiceName = name;
    }

    public ServiceName getMessageReceiverServiceName() {
        return this.messageReceiverServiceName;
    }

    public void setAsynchResponse(boolean isAsynch) {
        this.isAsynchResponse = isAsynch;
    }

    public boolean isAsynchResponse() {
        return this.isAsynchResponse;
    }

    public void setResponseRetryCount(int count) {
        this.responseRetryCount = count;
    }

    public int getResponseRetryCount() {
        return this.responseRetryCount;
    }

    public void setResponseRetryInterval(long interval) {
        this.responseRetryInterval = interval;
    }

    public long getResponseRetryInterval() {
        return this.responseRetryInterval;
    }

    public void createService() throws Exception {
        this.messageListenerMap = Collections.synchronizedMap(new HashMap());
    }

    public void startService() throws Exception {
        this.timeoutTimer = new Timer(true);
        if (this.messageReceiverServiceName == null) {
            throw new IllegalArgumentException("MessageReceiverServiceName must be specified.");
        }
        this.messageReceiver = (MessageReceiver)ServiceManagerFactory.getServiceObject(this.messageReceiverServiceName);
        if (this.serverConnectionFactoryServiceName == null) {
            throw new IllegalArgumentException("ServerConnectionFactoryServiceName must be specified.");
        }
        ServerConnectionFactory serverConnectionFactory = (ServerConnectionFactory)ServiceManagerFactory.getServiceObject(this.serverConnectionFactoryServiceName);
        this.serverConnection = new RequestServerConnectionImpl(serverConnectionFactory.getServerConnection());
    }

    public void stopService() throws Exception {
        this.serverConnection.close();
        this.serverConnection = null;
        this.sequence = 0;
        this.timeoutTimer.cancel();
        this.timeoutTimer = null;
    }

    public void destroyService() throws Exception {
        this.messageListenerMap = null;
    }

    public ServerConnection getServerConnection() throws ConnectionCreateException {
        return this.serverConnection;
    }

    public void addSubject(MessageListener listener, String subject) throws MessageSendException {
        this.addSubject(listener, subject, null);
    }

    public void addSubject(MessageListener listener, String subject, String[] keys) throws MessageSendException {
        listener = this.getMessageListenerWrapper(listener, true);
        this.messageReceiver.addSubject(listener, subject, keys);
    }

    private MessageListener getMessageListenerWrapper(MessageListener listener, boolean isNew) {
        if (listener instanceof RequestMessageListener) {
            MessageListener wrapper = (MessageListener)this.messageListenerMap.get(listener);
            if (wrapper == null && isNew) {
                wrapper = new MessageListenerWrapper((RequestMessageListener)listener);
                this.messageListenerMap.put(listener, wrapper);
            }
            listener = wrapper;
        }
        return listener;
    }

    public void removeSubject(MessageListener listener, String subject) throws MessageSendException {
        this.removeSubject(listener, subject, null);
    }

    public void removeSubject(MessageListener listener, String subject, String[] keys) throws MessageSendException {
        MessageListener lst = listener;
        boolean hasWrapper = false;
        if (lst instanceof RequestMessageListener) {
            MessageListener wrapper = (MessageListener)this.messageListenerMap.get(lst);
            if (wrapper == null) {
                return;
            }
            hasWrapper = true;
            lst = wrapper;
        }
        this.messageReceiver.removeSubject(lst, subject, keys);
        Set subjects = this.messageReceiver.getSubjects(lst);
        if (hasWrapper && (subjects == null || subjects.size() == 0)) {
            this.messageListenerMap.remove(listener);
        }
    }

    public void removeMessageListener(MessageListener listener) throws MessageSendException {
        if (listener instanceof RequestMessageListener) {
            MessageListener wrapper = (MessageListener)this.messageListenerMap.remove(listener);
            if (wrapper == null) {
                return;
            }
            listener = wrapper;
        }
        this.messageReceiver.removeMessageListener(listener);
    }

    public Set getSubjects(MessageListener listener) {
        listener = this.getMessageListenerWrapper(listener, false);
        return this.messageReceiver == null ? null : this.messageReceiver.getSubjects(listener);
    }

    public Set getKeys(MessageListener listener, String subject) {
        listener = this.getMessageListenerWrapper(listener, false);
        return this.messageReceiver == null ? null : this.messageReceiver.getKeys(listener, subject);
    }

    public ClientConnection getClientConnection() {
        return this.messageReceiver == null ? null : this.messageReceiver.getClientConnection();
    }

    public void connect() throws Exception {
        this.messageReceiver.connect();
    }

    public void close() {
        this.messageReceiver.close();
    }

    public boolean isConnected() {
        return this.messageReceiver == null ? false : this.messageReceiver.isConnected();
    }

    public void startReceive() throws MessageSendException {
        this.messageReceiver.startReceive();
    }

    public void stopReceive() throws MessageSendException {
        this.messageReceiver.stopReceive();
    }

    public boolean isStartReceive() {
        return this.messageReceiver == null ? false : this.messageReceiver.isStartReceive();
    }

    public Object getId() {
        return this.messageReceiver == null ? null : this.messageReceiver.getId();
    }

    private synchronized int getSequence() {
        return ++this.sequence;
    }

    private static class ResponseMessage
    extends AbstractMessage {
        public ResponseMessage() {
        }

        public ResponseMessage(Object source, int sequence, Object obj) {
            super(source, sequence, obj);
        }
    }

    private static class RequestMessage
    extends AbstractMessage {
        private String responseSubject;
        private String responseKey;

        public RequestMessage() {
        }

        public RequestMessage(Object source, int sequence, String responseSubject, String responseKey, Object obj) {
            super(source, sequence, obj);
            this.responseSubject = responseSubject;
            this.responseKey = responseKey;
        }

        public String getResponseSubject(Message request) {
            if (this.responseSubject != null) {
                return this.responseSubject;
            }
            return request.getSubject();
        }

        public String getResponseKey(Message request) {
            if (this.responseSubject != null || this.responseKey != null) {
                return this.responseKey;
            }
            return request.getKey();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.responseSubject);
            out.writeObject(this.responseKey);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.responseSubject = (String)in.readObject();
            this.responseKey = (String)in.readObject();
        }
    }

    private static abstract class AbstractMessage
    implements Externalizable {
        private Object sourceId;
        private Object object;
        private int sequence;

        public AbstractMessage() {
        }

        public AbstractMessage(Object source, int sequence, Object obj) {
            this.sourceId = source;
            this.sequence = sequence;
            this.object = obj;
        }

        public Object getSourceId() {
            return this.sourceId;
        }

        public int getSequence() {
            return this.sequence;
        }

        public Object getObject() {
            return this.object;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.sourceId);
            out.writeInt(this.sequence);
            out.writeObject(this.object);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.sourceId = in.readObject();
            this.sequence = in.readInt();
            this.object = in.readObject();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append('{');
            buf.append("sourceId=").append(this.sourceId);
            buf.append(", sequence=").append(this.sequence);
            buf.append(", object=").append(this.object);
            buf.append('}');
            return buf.toString();
        }
    }

    private class MessageListenerWrapper
    implements MessageListener {
        private RequestMessageListener requestMessageListener;

        public MessageListenerWrapper(RequestMessageListener listener) {
            this.requestMessageListener = listener;
        }

        public void onMessage(Message message) {
            Object obj = null;
            try {
                obj = message.getObject();
            }
            catch (MessageException e) {
                // empty catch block
            }
            if (obj instanceof RequestMessage) {
                RequestMessage request = (RequestMessage)obj;
                Object requestObj = request.getObject();
                try {
                    message.setObject(requestObj);
                }
                catch (MessageException e) {
                    // empty catch block
                }
                Message responseMessage = this.requestMessageListener.onRequestMessage(request.getSourceId(), request.getSequence(), message, request.getResponseSubject(message), request.getResponseKey(message));
                if (responseMessage == null) {
                    return;
                }
                responseMessage.addDestinationId(request.getSourceId());
                try {
                    Object responseObj = responseMessage.getObject();
                    responseMessage.setObject(new ResponseMessage(RequestConnectionFactoryService.this.messageReceiver.getId(), request.getSequence(), responseObj));
                }
                catch (MessageException e) {
                    e.printStackTrace();
                }
                int count = 0;
                do {
                    Set receivers;
                    if ((receivers = RequestConnectionFactoryService.this.serverConnection.getReceiveClientIds(responseMessage)) != null && receivers.contains(request.getSourceId())) {
                        try {
                            if (RequestConnectionFactoryService.this.isAsynchResponse) {
                                RequestConnectionFactoryService.this.serverConnection.sendAsynch(responseMessage);
                            } else {
                                RequestConnectionFactoryService.this.serverConnection.send(responseMessage);
                            }
                            break;
                        }
                        catch (MessageSendException e) {
                            e.printStackTrace();
                        }
                    }
                    ++count;
                    try {
                        Thread.sleep(RequestConnectionFactoryService.this.responseRetryInterval);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                } while (count <= RequestConnectionFactoryService.this.responseRetryCount);
            } else if (obj instanceof ResponseMessage) {
                ResponseMessage response = (ResponseMessage)obj;
                Object responseObj = response.getObject();
                try {
                    message.setObject(responseObj);
                }
                catch (MessageException e) {
                    // empty catch block
                }
                RequestConnectionFactoryService.this.serverConnection.reply(message, response);
            } else {
                this.requestMessageListener.onMessage(message);
            }
        }
    }

    private class RequestServerConnectionImpl
    implements RequestServerConnection {
        private ServerConnection serverConnection;
        private Map responseMap = Collections.synchronizedMap(new HashMap());
        private boolean isClosed;

        public RequestServerConnectionImpl(ServerConnection serverConnection) {
            this.serverConnection = serverConnection;
        }

        public Message createMessage(String subject, String key) throws MessageCreateException {
            return this.serverConnection.createMessage(subject, key);
        }

        public Message castMessage(Message message) throws MessageException {
            return this.serverConnection.castMessage(message);
        }

        public void send(Message message) throws MessageSendException {
            this.serverConnection.send(message);
        }

        public void sendAsynch(Message message) throws MessageSendException {
            this.serverConnection.send(message);
        }

        public void addServerConnectionListener(ServerConnectionListener listener) {
            this.serverConnection.addServerConnectionListener(listener);
        }

        public void removeServerConnectionListener(ServerConnectionListener listener) {
            this.serverConnection.removeServerConnectionListener(listener);
        }

        public int getClientCount() {
            return this.serverConnection.getClientCount();
        }

        public Set getClientIds() {
            return this.serverConnection.getClientIds();
        }

        public Set getReceiveClientIds(Message message) {
            return this.serverConnection.getReceiveClientIds(message);
        }

        public Set getSubjects(Object id) {
            return this.serverConnection.getSubjects(id);
        }

        public Set getKeys(Object id, String subject) {
            return this.serverConnection.getKeys(id, subject);
        }

        public Message[] request(Message message, int replyCount, long timeout) throws MessageSendException {
            return this.request(message, null, null, replyCount, timeout);
        }

        public Message[] request(Message message, String responseSubject, String responseKey, int replyCount, long timeout) throws MessageSendException {
            if (this.isClosed) {
                throw new MessageSendException("Closed.");
            }
            Set requestClients = this.serverConnection.getReceiveClientIds(message);
            if (requestClients.size() == 0) {
                return new Message[0];
            }
            int sequence = RequestConnectionFactoryService.this.getSequence();
            try {
                message.setObject(new RequestMessage(RequestConnectionFactoryService.this.messageReceiver.getId(), sequence, responseSubject, responseKey, message.getObject()));
            }
            catch (MessageException e) {
                throw new MessageSendException(e);
            }
            ResponseContainer container = new ResponseContainer(requestClients, replyCount);
            Integer sequenceVal = new Integer(sequence);
            this.responseMap.put(sequenceVal, container);
            container.init();
            try {
                this.serverConnection.send(message);
                Message[] messageArray = container.getResponse(timeout);
                return messageArray;
            }
            catch (InterruptedException e) {
                throw new MessageSendException(e);
            }
            finally {
                this.responseMap.remove(sequenceVal);
            }
        }

        public void request(Message message, int replyCount, long timeout, RequestServerConnection.ResponseCallBack callback) throws MessageSendException {
            this.request(message, null, null, replyCount, timeout, callback);
        }

        public void request(Message message, String responseSubject, String responseKey, int replyCount, long timeout, RequestServerConnection.ResponseCallBack callback) throws MessageSendException {
            if (this.isClosed) {
                throw new MessageSendException("Closed.");
            }
            Set requestClients = this.serverConnection.getReceiveClientIds(message);
            if (requestClients.size() == 0) {
                callback.onResponse(null, true);
                return;
            }
            int sequence = RequestConnectionFactoryService.this.getSequence();
            try {
                message.setObject(new RequestMessage(RequestConnectionFactoryService.this.messageReceiver.getId(), sequence, responseSubject, responseKey, message.getObject()));
            }
            catch (MessageException e) {
                throw new MessageSendException(e);
            }
            Integer sequenceVal = new Integer(sequence);
            ResponseContainer container = new ResponseContainer(sequenceVal, requestClients, replyCount, timeout, callback);
            this.responseMap.put(sequenceVal, container);
            if (timeout > 0L) {
                container.startTimer();
            }
            try {
                this.serverConnection.send(message);
            }
            catch (MessageSendException e) {
                if (timeout > 0L) {
                    container.cancel();
                }
                throw e;
            }
        }

        public void response(Object sourceId, int sequence, Message message) throws MessageSendException {
            message.addDestinationId(sourceId);
            try {
                Object responseObj = message.getObject();
                message.setObject(new ResponseMessage(RequestConnectionFactoryService.this.messageReceiver.getId(), sequence, responseObj));
            }
            catch (MessageException e) {
                throw new MessageSendException(e);
            }
            int count = 0;
            do {
                Set receivers;
                if ((receivers = this.serverConnection.getReceiveClientIds(message)) != null && receivers.contains(sourceId)) {
                    try {
                        if (RequestConnectionFactoryService.this.isAsynchResponse) {
                            this.serverConnection.sendAsynch(message);
                            break;
                        }
                        this.serverConnection.send(message);
                        break;
                    }
                    catch (MessageSendException e) {
                        if (count > RequestConnectionFactoryService.this.responseRetryCount) {
                            throw e;
                        }
                        e.printStackTrace();
                    }
                }
                ++count;
                try {
                    Thread.sleep(RequestConnectionFactoryService.this.responseRetryInterval);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (count <= RequestConnectionFactoryService.this.responseRetryCount);
        }

        protected void reply(Message message, ResponseMessage response) {
            ResponseContainer container = (ResponseContainer)this.responseMap.get(new Integer(response.getSequence()));
            if (container == null) {
                return;
            }
            container.onResponse(message, response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.isClosed = true;
            Map map = this.responseMap;
            synchronized (map) {
                Iterator itr = this.responseMap.values().iterator();
                while (itr.hasNext()) {
                    ResponseContainer container = (ResponseContainer)itr.next();
                    itr.remove();
                    container.interrupt();
                }
            }
        }

        private class ResponseContainer
        extends TimerTask {
            private SynchronizeMonitor monitor = new WaitSynchronizeMonitor();
            private List responseList = new ArrayList();
            private final Set requestClients;
            private final int replyCount;
            private RequestServerConnection.ResponseCallBack callback;
            private long timeout;
            private Object key;

            public ResponseContainer(Set requestClients, int replyCount) {
                this.requestClients = requestClients;
                this.replyCount = replyCount;
            }

            public ResponseContainer(Object key, Set requestClients, int replyCount, long timeout, RequestServerConnection.ResponseCallBack callback) {
                this.key = key;
                this.requestClients = requestClients;
                this.replyCount = replyCount;
                this.timeout = timeout;
                this.callback = callback;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized void onResponse(Message message, ResponseMessage response) {
                this.requestClients.remove(response.getSourceId());
                List list = this.responseList;
                synchronized (list) {
                    this.responseList.add(message);
                }
                if (this.callback == null) {
                    if (this.requestClients.size() == 0 || this.replyCount > 0 && this.responseList.size() >= this.replyCount) {
                        this.monitor.notifyAllMonitor();
                    }
                } else {
                    boolean isLast;
                    boolean bl = isLast = this.requestClients.size() == 0 || this.replyCount > 0 && this.responseList.size() >= this.replyCount;
                    if (isLast) {
                        if (this.timeout > 0L) {
                            this.cancel();
                        }
                        RequestServerConnectionImpl.this.responseMap.remove(this.key);
                    }
                    this.callback.onResponse(message, isLast);
                }
            }

            public void init() {
                this.monitor.initMonitor();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Message[] getResponse(long timeout) throws InterruptedException {
                try {
                    this.monitor.waitMonitor(timeout);
                }
                finally {
                    this.monitor.releaseMonitor();
                }
                List list = this.responseList;
                synchronized (list) {
                    return this.responseList.toArray(new Message[this.responseList.size()]);
                }
            }

            public void interrupt() {
                Thread[] threads = this.monitor.getWaitThreads();
                for (int i = 0; i < threads.length; ++i) {
                    threads[i].interrupt();
                }
            }

            public void startTimer() {
                RequestConnectionFactoryService.this.timeoutTimer.schedule((TimerTask)this, this.timeout);
            }

            public void run() {
                RequestServerConnectionImpl.this.responseMap.remove(this.key);
                this.callback.onResponse(null, true);
            }
        }
    }
}

