/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.udp;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import jp.ossc.nimbus.service.publish.udp.MessageId;

public class WindowId
extends MessageId {
    public short windowNo;
    private transient MessageId messageId;

    public WindowId() {
    }

    public WindowId(int sequence, short windowNo) {
        super(sequence);
        this.windowNo = windowNo;
    }

    public MessageId toMessageId() {
        if (this.messageId == null) {
            this.messageId = new MessageId(this.sequence);
        }
        return this.messageId;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeShort(this.windowNo);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.windowNo = in.readShort();
    }

    public int compareTo(Object o) {
        WindowId cmp = (WindowId)o;
        int result = super.compareTo(o);
        if (result != 0) {
            return result;
        }
        if (this.windowNo == cmp.windowNo) {
            return 0;
        }
        return this.windowNo > cmp.windowNo ? 1 : -1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof WindowId)) {
            return false;
        }
        WindowId cmp = (WindowId)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.windowNo == cmp.windowNo;
    }

    public int hashCode() {
        return super.hashCode() + this.windowNo;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.deleteCharAt(buf.length() - 1);
        buf.append(", windowNo=").append(this.windowNo);
        buf.append('}');
        return buf.toString();
    }
}

