/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.connection;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Map;
import java.util.Properties;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.connection.JDBCConnectionFactoryServiceMBean;

public class JDBCConnectionFactoryService
extends ServiceBase
implements ConnectionFactory,
JDBCConnectionFactoryServiceMBean,
Serializable {
    private static final long serialVersionUID = -1395958772628393323L;
    private String driverName;
    private String connectionURL;
    private String userName;
    private String password;
    private Properties info = new Properties();
    private boolean isAutoCommit = true;

    @Override
    public void startService() throws Exception {
        if (this.getDriverName() == null) {
            throw new IllegalArgumentException("Driver name is null.");
        }
        if (this.getConnectionURL() == null) {
            throw new IllegalArgumentException("Connection URL is null.");
        }
        if (this.getUserName() != null && this.getPassword() == null || this.getUserName() == null && this.getPassword() != null) {
            throw new IllegalArgumentException("Only one of the two cannot specify \"UserName\" and \"Password.\"");
        }
        if (this.getUserName() != null && this.getConnectionProperties().size() != 0) {
            throw new IllegalArgumentException("It cannot specify simultaneously \"UserName\" and \"ConnectionProperties.\"");
        }
        Class.forName(this.getDriverName(), true, NimbusClassLoader.getInstance());
    }

    @Override
    public Connection getConnection() throws ConnectionFactoryException {
        Connection con = null;
        try {
            con = this.getUserName() != null ? DriverManager.getConnection(this.getConnectionURL(), this.getUserName(), this.getPassword()) : (this.getConnectionProperties().size() != 0 ? DriverManager.getConnection(this.getConnectionURL(), this.getConnectionProperties()) : DriverManager.getConnection(this.getConnectionURL()));
            con.setAutoCommit(this.isAutoCommit);
        }
        catch (Exception e) {
            throw new ConnectionFactoryException(e);
        }
        return con;
    }

    @Override
    public void setDriverName(String name) {
        this.driverName = name;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public void setConnectionURL(String url) {
        this.connectionURL = url;
    }

    @Override
    public String getConnectionURL() {
        return this.connectionURL;
    }

    @Override
    public void setUserName(String name) {
        this.userName = name;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setConnectionProperties(Properties prop) {
        this.info.putAll((Map<?, ?>)prop);
    }

    @Override
    public Properties getConnectionProperties() {
        return this.info;
    }

    @Override
    public void setAutoCommit(boolean isAuto) {
        this.isAutoCommit = isAuto;
    }

    @Override
    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }
}

