/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ga;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.util.Random;
import jp.ossc.nimbus.service.ga.AbstractGene;
import jp.ossc.nimbus.service.ga.Gene;

public class FloatGene
extends AbstractGene {
    public static final int CROSSOVER_SINGLE_POINT = 1;
    public static final int CROSSOVER_TWO_POINT = 2;
    public static final int CROSSOVER_UNIFORM_POINT = 3;
    public static final int CROSSOVER_ALL_POINT = 4;
    public static final int CROSSOVER_AVERAGE = 5;
    public static final int CROSSOVER_RANDOM_RANGE = 6;
    public static final int MUTATE_SINGLE = 1;
    public static final int MUTATE_UNIFORM = 2;
    protected float maxValue = Float.MAX_VALUE;
    protected float minValue = -3.4028235E38f;
    protected float randomRangeMargin = 0.01f;

    public FloatGene() {
        this.crossoverType = 6;
        this.mutateType = 2;
    }

    public void setMaxValue(float max) {
        this.maxValue = max;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(float min) {
        this.minValue = min;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setRandomRangeMargin(float margin) {
        this.randomRangeMargin = margin;
    }

    public float getRandomRangeMargin() {
        return this.randomRangeMargin;
    }

    @Override
    public void random(Random random) {
        this.setValue(new Float(this.randomValue(random)));
    }

    protected float randomValue(Random random) {
        float result = 0.0f;
        if (this.maxValue == this.minValue) {
            result = this.maxValue;
        } else if (this.maxValue >= 0.0f && this.minValue >= 0.0f) {
            float range = this.maxValue - this.minValue;
            result = random.nextFloat() * range + this.minValue;
        } else if (this.maxValue < 0.0f && this.minValue < 0.0f) {
            float range = Math.abs(this.maxValue - this.minValue);
            result = -(random.nextFloat() * range) + this.maxValue;
        } else {
            boolean isPlus = random.nextBoolean();
            result = isPlus ? random.nextFloat() * this.maxValue : random.nextFloat() * this.minValue;
        }
        return result;
    }

    @Override
    public void crossover(Random random, Gene gene) {
        float result = 0.0f;
        switch (this.crossoverType) {
            case 1: {
                result = this.crossoverBySinglePoint(random, gene);
                break;
            }
            case 2: {
                result = this.crossoverByTwoPoint(random, gene);
                break;
            }
            case 4: {
                result = this.crossoverByAllPoint(random, gene);
                break;
            }
            case 5: {
                result = this.crossoverByAverage(random, gene);
                break;
            }
            case 3: {
                result = this.crossoverByUniformPoint(random, gene);
                break;
            }
            default: {
                result = this.crossoverByRandomRange(random, gene);
            }
        }
        this.setValue(new Float(this.mutate(random, result)));
    }

    protected int getMaxBitIndex(float val1, float val2) {
        float val = Math.max(Math.abs(val1), Math.abs(val2));
        int tmpValue = Float.floatToIntBits(val);
        for (int i = 0; i < 31; ++i) {
            tmpValue <<= i + 1;
            if ((float)(tmpValue >>= i + 1) == val) continue;
            return i + 1;
        }
        return 32;
    }

    protected float crossoverBySinglePoint(Random random, Gene gene) {
        float result;
        float floatVal1 = ((Float)this.value).floatValue();
        float floatVal2 = ((Float)gene.getValue()).floatValue();
        int maxBitIndex = this.getMaxBitIndex(floatVal1, floatVal2);
        int crossoverPoint = 0;
        if (maxBitIndex >= 31) {
            return ((Float)gene.getValue()).floatValue();
        }
        crossoverPoint = maxBitIndex == 30 ? 31 : random.nextInt(32 - maxBitIndex - 1) + 1;
        int val1 = Float.floatToIntBits(floatVal1);
        int val2 = Float.floatToIntBits(floatVal2);
        val1 >>= crossoverPoint;
        val1 <<= crossoverPoint;
        boolean isMinus = Math.abs(val2) != val2;
        val2 <<= 31 - crossoverPoint;
        val2 >>>= 31 - crossoverPoint;
        if (isMinus) {
            val2 = -val2;
        }
        if ((result = Float.intBitsToFloat(val1 | val2)) > this.maxValue || result < this.minValue) {
            result = this.crossoverBySinglePoint(random, gene);
        }
        return result;
    }

    protected float crossoverByTwoPoint(Random random, Gene gene) {
        float floatVal1 = ((Float)this.value).floatValue();
        float floatVal2 = ((Float)gene.getValue()).floatValue();
        int maxBitIndex = this.getMaxBitIndex(floatVal1, floatVal2);
        int crossoverPoint1 = 0;
        int crossoverPoint2 = 0;
        if (maxBitIndex >= 31) {
            return ((Float)gene.getValue()).floatValue();
        }
        if (maxBitIndex == 30) {
            return this.crossoverBySinglePoint(random, gene);
        }
        if (maxBitIndex == 29) {
            crossoverPoint1 = 2;
            crossoverPoint2 = 1;
        } else {
            crossoverPoint1 = random.nextInt(32 - maxBitIndex - 2) + 2;
            crossoverPoint2 = random.nextInt(crossoverPoint1 - 1) + 1;
        }
        int mask = 0;
        for (int i = 32; i >= 1; --i) {
            if (i > crossoverPoint1 || i <= crossoverPoint2) {
                mask |= 1;
            }
            if (i == 1) continue;
            mask <<= 1;
        }
        int val1 = Float.floatToIntBits(floatVal1);
        int val2 = Float.floatToIntBits(floatVal2);
        float result = Float.intBitsToFloat((val1 &= mask) | (val2 &= ~mask));
        if (result > this.maxValue || result < this.minValue) {
            result = this.crossoverByTwoPoint(random, gene);
        }
        return result;
    }

    protected float crossoverByUniformPoint(Random random, Gene gene) {
        int val2;
        float floatVal2;
        float floatVal1 = ((Float)this.value).floatValue();
        int maxBitIndex = this.getMaxBitIndex(floatVal1, floatVal2 = ((Float)gene.getValue()).floatValue());
        if (maxBitIndex >= 31) {
            return ((Float)gene.getValue()).floatValue();
        }
        int mask = 0;
        for (int i = 32; i >= 1; --i) {
            if (i <= 32 - maxBitIndex && random.nextBoolean()) {
                mask |= 1;
            }
            if (i == 1) continue;
            mask <<= 1;
        }
        int val1 = Float.floatToIntBits(floatVal1);
        float result = Float.intBitsToFloat(val1 & ~mask | (val2 = Float.floatToIntBits(floatVal2)) & mask);
        if (result > this.maxValue || result < this.minValue) {
            result = this.crossoverByTwoPoint(random, gene);
        }
        return result;
    }

    protected float crossoverByAllPoint(Random random, Gene gene) {
        return ((Float)gene.getValue()).floatValue();
    }

    protected float crossoverByAverage(Random random, Gene gene) {
        BigDecimal val1 = new BigDecimal(((Float)this.value).doubleValue());
        BigDecimal val2 = new BigDecimal(((Float)gene.getValue()).doubleValue());
        BigDecimal sum = val1.add(val2);
        BigDecimal result = sum.divide(new BigDecimal(2.0), 6);
        return result.floatValue();
    }

    protected float crossoverByRandomRange(Random random, Gene gene) {
        float val1 = ((Float)this.value).floatValue();
        float val2 = ((Float)gene.getValue()).floatValue();
        float range = Math.abs(val1 - val2);
        float margin = this.randomRangeMargin == 0.0f ? 0.0f : range * this.randomRangeMargin;
        float result = random.nextFloat() * (range + margin) + Math.min(val1, val2) - margin / 2.0f;
        if (result > this.maxValue) {
            result = this.maxValue;
        } else if (result < this.minValue) {
            result = this.minValue;
        }
        return result;
    }

    protected float mutate(Random random, float val) {
        float result = val;
        if (this.isMutate(random)) {
            switch (this.mutateType) {
                case 2: {
                    result = this.mutateByUniform(random, val);
                    break;
                }
                default: {
                    result = this.mutateBySingle(random, val);
                }
            }
        }
        return result;
    }

    protected float mutateBySingle(Random random, float val) {
        int intBits;
        float result = val;
        int maxBitIndex = this.getMaxBitIndex(this.maxValue, this.minValue);
        do {
            int index = random.nextInt(32 - maxBitIndex);
            int mask = 1;
            if (index > 0) {
                mask <<= index;
            }
            if (((intBits = Float.floatToIntBits(val)) & mask) == 0) {
                intBits |= mask;
                continue;
            }
            intBits &= ~mask;
        } while ((result = Float.intBitsToFloat(intBits)) > this.maxValue || result < this.minValue);
        return result;
    }

    protected float mutateByUniform(Random random, float val) {
        return this.randomValue(random);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeFloat(this.maxValue);
        out.writeFloat(this.minValue);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.maxValue = in.readFloat();
        this.minValue = in.readFloat();
    }
}

