/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jp.ossc.nimbus.ioc.FacadeValue;
import jp.ossc.nimbus.service.journal.editor.FacadeValueJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.UnitOfWorkJournalEditorService;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class FacadeValueJournalEditorService
extends UnitOfWorkJournalEditorService
implements FacadeValueJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = -456435540265845118L;
    protected static final String HEADER = "[FacadeValue]";
    private static final String HEADERS_HEADER = "Headers : ";
    protected static final String DEFAULT_SECRET_STRING = "******";
    protected static final String HEADER_SEPARATOR = " = ";
    protected boolean isOutputHeaders = true;
    protected String[] enabledHeaders;
    protected Set enabledHeaderSet;
    protected String[] secretHeaders;
    protected Set secretHeaderSet;
    protected String secretString = "******";

    public FacadeValueJournalEditorService() {
        this.setHeader(HEADER);
    }

    @Override
    public void setOutputHeaders(boolean isOutput) {
        this.isOutputHeaders = isOutput;
    }

    @Override
    public boolean isOutputHeaders() {
        return this.isOutputHeaders;
    }

    @Override
    public void setEnabledHeaders(String[] names) {
        this.enabledHeaders = names;
    }

    @Override
    public String[] getEnabledHeaders() {
        return this.enabledHeaders;
    }

    @Override
    public void setSecretHeaders(String[] names) {
        this.secretHeaders = names;
    }

    @Override
    public String[] getSecretHeaders() {
        return this.secretHeaders;
    }

    @Override
    public void setSecretString(String str) {
        this.secretString = str;
    }

    @Override
    public String getSecretString() {
        return this.secretString;
    }

    @Override
    public void startService() throws Exception {
        int i;
        if (this.enabledHeaders != null) {
            if (this.enabledHeaderSet == null) {
                this.enabledHeaderSet = new HashSet();
            }
            for (i = 0; i < this.enabledHeaders.length; ++i) {
                this.enabledHeaderSet.add(this.enabledHeaders[i]);
            }
        }
        if (this.secretHeaders != null) {
            if (this.secretHeaderSet == null) {
                this.secretHeaderSet = new HashSet();
            }
            for (i = 0; i < this.secretHeaders.length; ++i) {
                this.secretHeaderSet.add(this.secretHeaders[i]);
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.enabledHeaderSet != null) {
            this.enabledHeaderSet.clear();
        }
        if (this.secretHeaderSet != null) {
            this.secretHeaderSet.clear();
        }
    }

    @Override
    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        boolean isMake = super.processBlock(finder, key, value, buf);
        FacadeValue facadeVal = (FacadeValue)value;
        if (this.isOutputHeaders()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeHeadersFormat(finder, key, facadeVal, buf);
            isMake = true;
        }
        return isMake;
    }

    protected StringBuffer makeHeadersFormat(EditorFinder finder, Object key, FacadeValue facadeVal, StringBuffer buf) {
        buf.append(HEADERS_HEADER);
        Iterator names = facadeVal.getHederKeys().iterator();
        if (!names.hasNext()) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        while (names.hasNext()) {
            String name = (String)names.next();
            if (!this.enabledHeaderSet.isEmpty() && !this.enabledHeaderSet.contains(name)) continue;
            subBuf.append(name);
            subBuf.append(HEADER_SEPARATOR);
            if (this.secretHeaderSet.contains(name)) {
                subBuf.append(this.getSecretString());
            } else {
                this.makeObjectFormat(finder, null, facadeVal.getHeader(name), subBuf);
            }
            if (!names.hasNext()) continue;
            subBuf.append(this.getLineSeparator());
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }
}

