/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.lang.IllegalServiceStateException;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.writer.SimpleElement;
import jp.ossc.nimbus.service.writer.WritableElement;
import jp.ossc.nimbus.service.writer.WritableRecord;
import jp.ossc.nimbus.service.writer.WritableRecordFactory;
import jp.ossc.nimbus.service.writer.WritableRecordFactoryServiceMBean;

public class WritableRecordFactoryService
extends ServiceBase
implements WritableRecordFactory,
WritableRecordFactoryServiceMBean,
Serializable {
    private static final long serialVersionUID = 5249532509800152052L;
    protected static final String SIMPLE_ELEMENT_NAME = SimpleElement.class.getName();
    protected String mFormat;
    protected List mParsedElements;
    protected Properties mImplClasses;
    protected Properties mImplServiceNames;
    protected Map mImplServiceNameMap;

    @Override
    public void setImplementClasses(Properties prop) {
        this.mImplClasses = prop;
    }

    @Override
    public Properties getImplementClasses() {
        return this.mImplClasses;
    }

    @Override
    public void setImplementServiceNames(Properties prop) {
        this.mImplServiceNames = prop;
    }

    @Override
    public Properties getImplementServiceNames() {
        return this.mImplServiceNames;
    }

    @Override
    public void setFormat(String fmt) {
        this.mFormat = fmt;
    }

    @Override
    public String getFormat() {
        return this.mFormat;
    }

    @Override
    public void createService() throws Exception {
        if (this.mImplClasses == null) {
            this.mImplClasses = new Properties();
        }
        this.mImplServiceNameMap = new HashMap();
    }

    @Override
    public void startService() throws Exception {
        try {
            this.mParsedElements = this.parseFormat(this.mFormat);
        }
        catch (IllegalArgumentException ex) {
            this.getLogger().write("SSWRF00001", (Object)this.mFormat, (Throwable)ex);
            throw ex;
        }
        Collection<Object> implClasses = this.mImplClasses.values();
        for (String string : implClasses) {
            try {
                this.getInstance(string);
            }
            catch (ServiceException e) {
                this.getLogger().write("SSWRF00002", (Object)string, (Throwable)e);
                throw e;
            }
        }
        if (this.mImplServiceNames != null) {
            this.mImplServiceNameMap.clear();
            ServiceNameEditor serviceNameEditor = new ServiceNameEditor();
            serviceNameEditor.setServiceManagerName(this.getServiceManagerName());
            for (String string : this.mImplServiceNames.keySet()) {
                serviceNameEditor.setAsText(this.mImplServiceNames.getProperty(string));
                this.mImplServiceNameMap.put(string, serviceNameEditor.getValue());
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        this.mParsedElements = null;
    }

    @Override
    public void destroyService() throws Exception {
        this.mImplClasses = null;
    }

    @Override
    public WritableRecord createRecord(Object elements) {
        if (this.getState() != 3) {
            throw new IllegalServiceStateException(this);
        }
        WritableRecord writableRec = new WritableRecord();
        if (this.mFormat == null || this.mFormat.length() == 0) {
            Iterator keys = this.getElementKeys(elements).iterator();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                WritableElement elem = this.createElement(key, this.getElementValue(key, elements));
                writableRec.addElement(elem);
            }
        } else {
            int max = this.mParsedElements.size();
            for (int rCnt = 0; rCnt < max; ++rCnt) {
                ParsedElement parsedElem = (ParsedElement)this.mParsedElements.get(rCnt);
                if (parsedElem.isKeyElement()) {
                    String key = parsedElem.getValue();
                    WritableElement elem = this.createElement(key, this.getElementValue(key, elements));
                    if (elem == null) continue;
                    writableRec.addElement(elem);
                    continue;
                }
                SimpleElement simpleElem = new SimpleElement();
                simpleElem.setKey(simpleElem);
                simpleElem.setValue(parsedElem.getValue());
                writableRec.addElement(simpleElem);
            }
        }
        return writableRec;
    }

    protected Set getElementKeys(Object elements) {
        return ((Map)elements).keySet();
    }

    protected WritableElement createElement(String key, Object val) {
        WritableElement writableElem = null;
        if (this.getImplementClass(key) == null) {
            if (this.getImplementServiceName(key) == null) {
                writableElem = this.getInstance(SIMPLE_ELEMENT_NAME);
            } else {
                try {
                    writableElem = (WritableElement)ServiceManagerFactory.getServiceObject(this.getImplementServiceName(key));
                }
                catch (ServiceNotFoundException e) {
                    writableElem = this.getInstance(SIMPLE_ELEMENT_NAME);
                }
            }
        } else {
            String implClassName = this.getImplementClass(key);
            writableElem = this.getInstance(implClassName);
        }
        writableElem.setKey(key);
        writableElem.setValue(val);
        this.postCreateElement(writableElem);
        return writableElem;
    }

    protected void setImplementClass(String key, String className) {
        this.mImplClasses.put(key, className);
    }

    protected String getImplementClass(String key) {
        return (String)this.mImplClasses.get(key);
    }

    protected ServiceName getImplementServiceName(String key) {
        return (ServiceName)this.mImplServiceNameMap.get(key);
    }

    protected void postCreateElement(WritableElement elem) {
    }

    protected Object getElementValue(String key, Object elements) {
        return ((Map)elements).get(key);
    }

    protected WritableElement getInstance(String className) {
        WritableElement writableElem = null;
        try {
            Class<?> clazz = Class.forName(className, true, NimbusClassLoader.getInstance());
            writableElem = (WritableElement)clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("WRITABLERECORDFACTORY002", "IllegalAccess When creatCuiOperator() ", e);
        }
        catch (InstantiationException e) {
            throw new ServiceException("WRITABLERECORDFACTORY003", "Instanting failed", e);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("WRITABLERECORDFACTORY004", "Class not found. name is " + className, e);
        }
        return writableElem;
    }

    protected List parseFormat(String format) {
        if (format == null || format.length() == 0) {
            return null;
        }
        ArrayList<ParsedElement> result = new ArrayList<ParsedElement>();
        StringBuffer word = new StringBuffer("");
        boolean isStartKey = false;
        boolean isEscape = false;
        int max = format.length();
        block4: for (int i = 0; i < max; ++i) {
            char c = format.charAt(i);
            switch (c) {
                case '%': {
                    ParsedElement elem;
                    if (isEscape) {
                        word.append(c);
                        isEscape = false;
                        continue block4;
                    }
                    if (isStartKey) {
                        if (word.length() != 0) {
                            elem = new ParsedElement(word.toString(), true);
                            result.add(elem);
                            word.setLength(0);
                            isStartKey = false;
                            continue block4;
                        }
                        throw new IllegalArgumentException("Keyword must not be null. : " + format);
                    }
                    if (word.length() > 0) {
                        elem = new ParsedElement(word.toString(), false);
                        result.add(elem);
                        word.setLength(0);
                    }
                    isStartKey = true;
                    continue block4;
                }
                case '\\': {
                    if (isEscape) {
                        word.append(c);
                        isEscape = false;
                        continue block4;
                    }
                    isEscape = true;
                    continue block4;
                }
                default: {
                    if (isEscape) {
                        throw new IllegalArgumentException("'' is escape character. : " + format);
                    }
                    word.append(c);
                }
            }
        }
        if (isEscape) {
            throw new IllegalArgumentException("'' is escape character. : " + format);
        }
        if (isStartKey) {
            throw new IllegalArgumentException("'%' is key separator character. : " + format);
        }
        if (word.length() > 0) {
            ParsedElement elem = new ParsedElement(word.toString(), false);
            result.add(elem);
            word.setLength(0);
        }
        return result;
    }

    protected static class ParsedElement
    implements Serializable {
        private static final long serialVersionUID = 6554326776504636150L;
        protected String mVal;
        protected boolean mIsKeyWord;

        public ParsedElement(String val, boolean isKey) {
            this.mVal = val;
            this.mIsKeyWord = isKey;
        }

        public String getValue() {
            return this.mVal;
        }

        public boolean isKeyElement() {
            return this.mIsKeyWord;
        }
    }
}

