/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.DefaultInterceptorChain;
import jp.ossc.nimbus.service.aop.DefaultInterceptorChainFactoryServiceMBean;
import jp.ossc.nimbus.service.aop.DefaultInterceptorChainList;
import jp.ossc.nimbus.service.aop.DefaultThreadLocalInterceptorChain;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChainFactory;
import jp.ossc.nimbus.service.aop.InterceptorChainList;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.invoker.MethodReflectionCallInvokerService;
import jp.ossc.nimbus.service.cache.CacheMap;

public class DefaultInterceptorChainFactoryService
extends ServiceBase
implements InterceptorChainFactory,
DefaultInterceptorChainFactoryServiceMBean {
    private static final long serialVersionUID = 8047982449933936760L;
    private Map interceptorChainListMapping;
    private Map keyAndChainListMap;
    private Map interceptorMapping;
    private Map keyAndInterceptorMap;
    private Map invokerMapping;
    private Map keyAndInvokerMap;
    private ServiceName defaultInterceptorChainListServiceName;
    private InterceptorChainList defaultInterceptorChainList;
    private ServiceName defaultInvokerServiceName;
    private Invoker defaultInvoker;
    private boolean isRegexEnabled;
    private int regexMatchFlag;
    private ServiceName interceptorChainCacheMapServiceName;
    private CacheMap chainCache;
    private boolean isUseThreadLocalInterceptorChain = true;

    public void setInterceptorChainListMapping(Map mapping) {
        this.interceptorChainListMapping = mapping;
    }

    public Map getInterceptorChainListMapping() {
        return this.interceptorChainListMapping;
    }

    public void setInterceptorMapping(Map mapping) {
        this.interceptorMapping = mapping;
    }

    public Map getInterceptorMapping() {
        return this.interceptorMapping;
    }

    public void setDefaultInterceptorChainListServiceName(ServiceName name) {
        this.defaultInterceptorChainListServiceName = name;
    }

    public ServiceName getDefaultInterceptorChainListServiceName() {
        return this.defaultInterceptorChainListServiceName;
    }

    public void setInvokerMapping(Map mapping) {
        this.invokerMapping = mapping;
    }

    public Map getInvokerMapping() {
        return this.invokerMapping;
    }

    public void setDefaultInvokerServiceName(ServiceName name) {
        this.defaultInvokerServiceName = name;
    }

    public ServiceName getDefaultInvokerServiceName() {
        return this.defaultInvokerServiceName;
    }

    public void setRegexEnabled(boolean isEnable) {
        this.isRegexEnabled = isEnable;
    }

    public boolean isRegexEnabled() {
        return this.isRegexEnabled;
    }

    public void setRegexMatchFlag(int flag) {
        this.regexMatchFlag = flag;
    }

    public int getRegexMatchFlag() {
        return this.regexMatchFlag;
    }

    public void setInterceptorChainCacheMapServiceName(ServiceName name) {
        this.interceptorChainCacheMapServiceName = name;
    }

    public ServiceName getInterceptorChainCacheMapServiceName() {
        return this.interceptorChainCacheMapServiceName;
    }

    public void setUseThreadLocalInterceptorChain(boolean isUse) {
        this.isUseThreadLocalInterceptorChain = isUse;
    }

    public boolean isUseThreadLocalInterceptorChain() {
        return this.isUseThreadLocalInterceptorChain;
    }

    public void createService() throws Exception {
        this.keyAndChainListMap = new LinkedHashMap();
        this.keyAndInterceptorMap = new LinkedHashMap();
        this.keyAndInvokerMap = new LinkedHashMap();
    }

    public void startService() throws Exception {
        ServiceName name;
        String nameStr;
        Object key;
        String keyStr;
        Iterator keys;
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setServiceManagerName(this.getServiceManagerName());
        if (this.interceptorChainListMapping != null) {
            keys = this.interceptorChainListMapping.keySet().iterator();
            while (keys.hasNext()) {
                keyStr = (String)keys.next();
                key = keyStr;
                if (this.isRegexEnabled) {
                    key = Pattern.compile(keyStr, this.regexMatchFlag);
                }
                nameStr = (String)this.interceptorChainListMapping.get(keyStr);
                editor.setAsText(nameStr);
                name = (ServiceName)editor.getValue();
                InterceptorChainList chainList = (InterceptorChainList)ServiceManagerFactory.getServiceObject(name);
                this.keyAndChainListMap.put(key, chainList);
            }
        }
        if (this.interceptorMapping != null) {
            keys = this.interceptorMapping.keySet().iterator();
            while (keys.hasNext()) {
                keyStr = (String)keys.next();
                key = keyStr;
                if (this.isRegexEnabled) {
                    key = Pattern.compile(keyStr, this.regexMatchFlag);
                }
                nameStr = (String)this.interceptorMapping.get(keyStr);
                editor.setAsText(nameStr);
                name = (ServiceName)editor.getValue();
                this.keyAndInterceptorMap.put(key, name);
            }
        }
        if (this.defaultInterceptorChainListServiceName != null) {
            this.defaultInterceptorChainList = (InterceptorChainList)ServiceManagerFactory.getServiceObject(this.defaultInterceptorChainListServiceName);
        }
        if (this.defaultInvokerServiceName == null) {
            MethodReflectionCallInvokerService invoker = new MethodReflectionCallInvokerService();
            invoker.create();
            invoker.start();
            this.defaultInvoker = invoker;
        } else {
            this.defaultInvoker = (Invoker)ServiceManagerFactory.getServiceObject(this.defaultInvokerServiceName);
        }
        if (this.interceptorChainCacheMapServiceName != null) {
            this.chainCache = (CacheMap)ServiceManagerFactory.getServiceObject(this.interceptorChainCacheMapServiceName);
        }
    }

    public void stopService() throws Exception {
        this.keyAndChainListMap.clear();
        this.keyAndInterceptorMap.clear();
        this.keyAndInvokerMap.clear();
        if (this.chainCache != null) {
            this.chainCache.clear();
        }
    }

    public void destroyService() throws Exception {
        this.keyAndChainListMap = null;
        this.keyAndInterceptorMap = null;
        this.keyAndInvokerMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterceptorChain getInterceptorChain(Object key) {
        DefaultInterceptorChain chain;
        String keyStr;
        String string = keyStr = key == null ? null : key.toString();
        if (this.chainCache != null) {
            CacheMap cacheMap = this.chainCache;
            synchronized (cacheMap) {
                if (this.chainCache.containsKey(keyStr)) {
                    return (InterceptorChain)this.chainCache.get(keyStr);
                }
            }
        }
        InterceptorChainList chainList = null;
        Invoker invoker = null;
        if (keyStr == null) {
            chainList = this.defaultInterceptorChainList;
            invoker = this.defaultInvoker;
        } else if (this.isRegexEnabled) {
            Pattern pattern;
            Iterator keys;
            if (this.keyAndChainListMap.size() != 0) {
                keys = this.keyAndChainListMap.keySet().iterator();
                while (keys.hasNext()) {
                    pattern = (Pattern)keys.next();
                    if (!pattern.matcher(keyStr).matches()) continue;
                    chainList = (InterceptorChainList)this.keyAndChainListMap.get(pattern);
                    break;
                }
            }
            if (chainList == null && this.keyAndInterceptorMap.size() != 0) {
                keys = this.keyAndInterceptorMap.keySet().iterator();
                while (keys.hasNext()) {
                    pattern = (Pattern)keys.next();
                    if (!pattern.matcher(keyStr).matches()) continue;
                    if (chainList == null) {
                        chainList = new DefaultInterceptorChainList();
                    }
                    ServiceName name = (ServiceName)this.keyAndInterceptorMap.get(pattern);
                    Interceptor interceptor = (Interceptor)ServiceManagerFactory.getServiceObject(name);
                    ((DefaultInterceptorChainList)chainList).addInterceptor(interceptor);
                    break;
                }
            }
            if (this.keyAndInvokerMap.size() != 0) {
                keys = this.keyAndInvokerMap.keySet().iterator();
                while (keys.hasNext()) {
                    pattern = (Pattern)keys.next();
                    if (!pattern.matcher(keyStr).matches()) continue;
                    invoker = (Invoker)this.keyAndInvokerMap.get(pattern);
                    break;
                }
            }
        } else {
            if (this.keyAndChainListMap.size() != 0) {
                chainList = (InterceptorChainList)this.keyAndChainListMap.get(keyStr);
            }
            if (this.keyAndInvokerMap.size() != 0) {
                invoker = (Invoker)this.keyAndInvokerMap.get(keyStr);
            }
        }
        if (chainList == null) {
            chainList = this.defaultInterceptorChainList;
        }
        if (invoker == null) {
            invoker = this.defaultInvoker;
        }
        DefaultInterceptorChain defaultInterceptorChain = chain = this.isUseThreadLocalInterceptorChain ? new DefaultThreadLocalInterceptorChain(chainList, invoker) : new DefaultInterceptorChain(chainList, invoker);
        if (this.chainCache != null) {
            CacheMap cacheMap = this.chainCache;
            synchronized (cacheMap) {
                if (this.chainCache.containsKey(keyStr)) {
                    return (InterceptorChain)this.chainCache.get(keyStr);
                }
                this.chainCache.put(keyStr, this.chainCache);
            }
        }
        return chain;
    }
}

