/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.publish.DefaultPublishContainerServiceMBean;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.MessageListener;
import jp.ossc.nimbus.service.publish.MessageReceiver;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.PublishContainer;
import jp.ossc.nimbus.service.publish.Servant;
import jp.ossc.nimbus.service.queue.Queue;

public class DefaultPublishContainerService
extends ServiceBase
implements DefaultPublishContainerServiceMBean,
PublishContainer {
    private static final long serialVersionUID = -3800977450032100141L;
    private static final String MSG_ID_00001 = "DPC__00001";
    private static final String MSG_ID_00002 = "DPC__00002";
    private List servants;
    private Map messageListenerMap;
    private volatile int servantNum;
    private int maxServantNum;
    private long publishCount;
    private ServiceName queueServiceName;
    private Queue queue;
    private MessageReceiver messageReceiver;
    private Daemon daemon;
    private int threadPriority = -1;

    public void setMaxServantNum(int maxServant) {
        this.maxServantNum = maxServant;
    }

    public int getMaxServantNum() {
        return this.maxServantNum;
    }

    public void setQueueServiceName(ServiceName name) {
        this.queueServiceName = name;
    }

    public ServiceName getQueueServiceName() {
        return this.queueServiceName;
    }

    public void setThreadPriority(int priority) {
        this.threadPriority = priority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setMessageReceiver(MessageReceiver receiver) {
        this.messageReceiver = receiver;
    }

    public void createService() throws Exception {
        this.servants = new ArrayList();
        this.messageListenerMap = Collections.synchronizedMap(new HashMap());
    }

    public void startService() throws Exception {
        if (this.maxServantNum <= 0) {
            throw new IllegalArgumentException("maxServantNum is illegal : " + this.maxServantNum);
        }
        if (this.servants.size() == 0) {
            for (int i = 0; i < this.maxServantNum; ++i) {
                this.servants.add(null);
            }
        }
        if (this.queueServiceName != null) {
            this.queue = (Queue)ServiceManagerFactory.getServiceObject(this.queueServiceName);
            this.queue.accept();
            this.daemon = new Daemon(new MessageHandler());
            this.daemon.setName("Nimbus PublishContainerMessageHandlerDaemon " + this.getServiceNameObject());
            if (this.threadPriority > 0) {
                this.daemon.setPriority(this.threadPriority);
            }
            this.daemon.start();
        }
    }

    public void stopService() throws Exception {
        if (this.daemon != null) {
            this.daemon.stop();
            this.daemon = null;
            this.queue.release();
        }
        for (int i = 0; i < this.maxServantNum; ++i) {
            Servant servant = (Servant)this.servants.get(i);
            if (servant == null) continue;
            this.ejectServant(servant, true);
        }
        this.servantNum = 0;
    }

    public void destroyService() throws Exception {
        this.servants = null;
        this.messageListenerMap = null;
    }

    public int getVacantServantNum() {
        return this.maxServantNum - this.servantNum;
    }

    public int getServantNum() {
        return this.servantNum;
    }

    public void handleMessage(Object msg) {
        if (msg == null || this.servantNum == 0) {
            return;
        }
        if (this.queue == null) {
            this.internalHandleMessage(msg);
        } else {
            this.queue.push(msg);
        }
    }

    protected void internalHandleMessage(Object msg) {
        if (msg != null && this.servants != null) {
            for (int i = 0; i < this.maxServantNum; ++i) {
                Servant sv = (Servant)this.servants.get(i);
                if (sv == null || !sv.isConnect()) continue;
                try {
                    sv.sendMessage(msg);
                    continue;
                }
                catch (MessageSendException e) {
                    this.getLogger().write(MSG_ID_00001, e);
                }
            }
        }
    }

    public synchronized boolean entryServant(Servant servant) {
        if (this.servantNum >= this.maxServantNum) {
            return false;
        }
        if (this.servants.contains(servant)) {
            return false;
        }
        for (int i = 0; i < this.maxServantNum; ++i) {
            if (this.servants.get(i) != null) continue;
            servant.setContainer(this);
            this.servants.set(i, servant);
            if (this.messageReceiver != null) {
                this.messageListenerMap.put(servant, new MessageListenerImpl(servant));
            }
            ++this.servantNum;
            return true;
        }
        return false;
    }

    public synchronized boolean ejectServant(Servant servant) {
        return this.ejectServant(servant, false);
    }

    public synchronized boolean ejectServant(Servant servant, boolean isForced) {
        int index = this.servants.indexOf(servant);
        if (index != -1) {
            if (!servant.close(isForced) && !isForced) {
                return false;
            }
            this.publishCount += servant.getPublishCount();
            MessageListener listener = (MessageListener)this.messageListenerMap.remove(servant);
            if (listener != null && this.messageReceiver != null) {
                try {
                    this.messageReceiver.removeMessageListener(listener);
                }
                catch (MessageSendException e) {
                    // empty catch block
                }
            }
            servant.setContainer(null);
            this.servants.set(index, null);
            --this.servantNum;
        }
        return true;
    }

    public Set garbage() {
        HashSet<Servant> result = null;
        for (int i = 0; i < this.maxServantNum; ++i) {
            Servant servant = (Servant)this.servants.get(i);
            if (servant == null || servant.isAlive() || !this.ejectServant(servant, true)) continue;
            this.getLogger().write(MSG_ID_00002, (Object)servant.getID());
            if (result == null) {
                result = new HashSet<Servant>();
            }
            result.add(servant);
        }
        return result;
    }

    public synchronized long getPublishCount() {
        long count = this.publishCount;
        for (int i = 0; i < this.maxServantNum; ++i) {
            Servant servant = (Servant)this.servants.get(i);
            if (servant == null) continue;
            count += servant.getPublishCount();
        }
        return count;
    }

    public void addSubject(Servant servant, String subject) throws MessageSendException {
        MessageListener listener = (MessageListener)this.messageListenerMap.get(servant);
        if (listener != null && this.messageReceiver != null) {
            this.messageReceiver.addSubject(listener, subject);
        }
    }

    public void addSubject(Servant servant, String subject, String[] keys) throws MessageSendException {
        MessageListener listener = (MessageListener)this.messageListenerMap.get(servant);
        if (listener != null && this.messageReceiver != null) {
            this.messageReceiver.addSubject(listener, subject, keys);
        }
    }

    public void removeSubject(Servant servant, String subject) throws MessageSendException {
        MessageListener listener = (MessageListener)this.messageListenerMap.get(servant);
        if (listener != null && this.messageReceiver != null) {
            this.messageReceiver.removeSubject(listener, subject);
        }
    }

    public void removeSubject(Servant servant, String subject, String[] keys) throws MessageSendException {
        MessageListener listener = (MessageListener)this.messageListenerMap.get(servant);
        if (listener != null && this.messageReceiver != null) {
            this.messageReceiver.removeSubject(listener, subject, keys);
        }
    }

    protected void handleMessage(Servant servant, Message message) {
        if (servant.isConnect()) {
            try {
                servant.sendMessage(message.getObject());
            }
            catch (MessageException e) {
                this.getLogger().write(MSG_ID_00001, e);
            }
            catch (MessageSendException e) {
                this.getLogger().write(MSG_ID_00001, e);
            }
        }
    }

    private class MessageListenerImpl
    implements MessageListener {
        private Servant servant;

        public MessageListenerImpl(Servant servant) {
            this.servant = servant;
        }

        public void onMessage(Message message) {
            DefaultPublishContainerService.this.handleMessage(this.servant, message);
        }
    }

    private class MessageHandler
    implements DaemonRunnable {
        private MessageHandler() {
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) throws Throwable {
            if (DefaultPublishContainerService.this.queue == null) {
                return null;
            }
            return DefaultPublishContainerService.this.queue.get(1000L);
        }

        public void consume(Object paramObj, DaemonControl ctrl) {
            if (paramObj == null) {
                return;
            }
            DefaultPublishContainerService.this.internalHandleMessage(paramObj);
        }

        public void garbage() {
            if (DefaultPublishContainerService.this.queue != null) {
                while (DefaultPublishContainerService.this.queue.size() > 0) {
                    this.consume(DefaultPublishContainerService.this.queue.get(0L), DefaultPublishContainerService.this.daemon);
                }
            }
        }
    }
}

