/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.udp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.io.Externalizer;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ConnectionCreateException;
import jp.ossc.nimbus.service.publish.RemoteClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.service.publish.ServerConnectionListener;
import jp.ossc.nimbus.service.publish.udp.ClientConnectionImpl;
import jp.ossc.nimbus.service.publish.udp.ConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.publish.udp.ServerConnectionImpl;
import jp.ossc.nimbus.service.repository.Repository;

public class ConnectionFactoryService
extends ServiceBase
implements ServerConnectionFactory,
ClientConnectionFactory,
ConnectionFactoryServiceMBean {
    private static final long serialVersionUID = -2055475909898211264L;
    private String clientAddressPropertyName;
    private String clientPortPropertyName;
    private int clientReconnectCount;
    private long clientReconnectInterval;
    private long clientReconnectBufferTime;
    private long missingWindowTimeout = 1000L;
    private int missingWindowCount = 0;
    private long newMessagePollingInterval = 1000L;
    private String serverAddress;
    private int serverPort;
    private int serverBacklog;
    private boolean isNIO;
    private ServiceName nioSocketFactoryServiceName;
    private ServiceName serverSocketFactoryServiceName;
    private ServiceName socketFactoryServiceName;
    private String multicastGroupAddress;
    private int multicastPort = 2000;
    private int timeToLive = 1;
    private int unicastPort;
    private int windowSize = 1024;
    private long sendBufferTime = 5000L;
    private int localPort;
    private ServiceName jndiRepositoryServiceName;
    private String jndiName = "publish/ClientConnectionFactory";
    private int rmiPort;
    private ServiceName[] serverConnectionListenerServiceNames;
    private int sendThreadSize = 1;
    private ServiceName sendQueueServiceName;
    private int asynchSendThreadSize;
    private ServiceName asynchSendQueueServiceName;
    private ServiceName asynchSendQueueFactoryServiceName;
    private int requestHandleThreadSize;
    private ServiceName requestHandleQueueServiceName;
    private ServiceName externalizerServiceName;
    private int maxSendRetryCount;
    private boolean isAcknowledge;
    private String serverSendErrorMessageId = "PCFT_00001";
    private String serverSendErrorRetryOverMessageId = "PCFT_00002";
    private String serverResponseErrorMessageId = "PCFT_00005";
    private String serverMessageLostErrorMessageId = "PCFT_00007";
    private int serverMessageRecycleBufferSize;
    private int serverWindowRecycleBufferSize;
    private String clientServerCloseMessageId = "PCFT_00008";
    private String clientReceiveWarnMessageId = "PCFT_00003";
    private String clientReceiveErrorMessageId = "PCFT_00004";
    private String clientMessageLostErrorMessageId = "PCFT_00006";
    private long clientResponseTimeout = 30000L;
    private int clientPacketRecycleBufferSize;
    private int clientWindowRecycleBufferSize;
    private int clientMessageRecycleBufferSize;
    private ServerSocketFactory serverSocketFactory;
    private ServerConnectionImpl serverConnection;
    private SocketFactory socketFactory;
    private jp.ossc.nimbus.util.net.SocketFactory nioSocketFactory;
    private Repository jndiRepository;
    private Externalizer externalizer;
    private List serverConnectionListeners;

    public void setClientAddressPropertyName(String name) {
        this.clientAddressPropertyName = name;
    }

    public String getClientAddressPropertyName() {
        return this.clientAddressPropertyName;
    }

    public void setClientPortPropertyName(String name) {
        this.clientPortPropertyName = name;
    }

    public String getClientPortPropertyName() {
        return this.clientPortPropertyName;
    }

    public void setClientReconnectCount(int count) {
        this.clientReconnectCount = count;
    }

    public int getClientReconnectCount() {
        return this.clientReconnectCount;
    }

    public void setClientReconnectInterval(long interval) {
        this.clientReconnectInterval = interval;
    }

    public long getClientReconnectInterval() {
        return this.clientReconnectInterval;
    }

    public void setClientReconnectBufferTime(long interval) {
        this.clientReconnectBufferTime = interval;
    }

    public long getClientReconnectBufferTime() {
        return this.clientReconnectBufferTime;
    }

    public void setMissingWindowTimeout(long interval) {
        this.missingWindowTimeout = interval;
    }

    public long getMissingWindowTimeout() {
        return this.missingWindowTimeout;
    }

    public void setMissingWindowCount(int count) {
        this.missingWindowCount = count;
    }

    public int getMissingWindowCount() {
        return this.missingWindowCount;
    }

    public void setNewMessagePollingInterval(long interval) {
        this.newMessagePollingInterval = interval;
    }

    public long getNewMessagePollingInterval() {
        return this.newMessagePollingInterval;
    }

    public void setServerAddress(String address) {
        this.serverAddress = address;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerPort(int port) {
        this.serverPort = port;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isNIO() {
        return this.isNIO;
    }

    public void setNIO(boolean isNIO) {
        this.isNIO = isNIO;
    }

    public void setServerBacklog(int backlog) {
        this.serverBacklog = backlog;
    }

    public int getServerBacklog() {
        return this.serverBacklog;
    }

    public void setServerSocketFactoryServiceName(ServiceName name) {
        this.serverSocketFactoryServiceName = name;
    }

    public ServiceName getServerSocketFactoryServiceName() {
        return this.serverSocketFactoryServiceName;
    }

    public void setSocketFactoryServiceName(ServiceName name) {
        this.socketFactoryServiceName = name;
    }

    public ServiceName getSocketFactoryServiceName() {
        return this.socketFactoryServiceName;
    }

    public void setNIOSocketFactoryServiceName(ServiceName name) {
        this.nioSocketFactoryServiceName = name;
    }

    public ServiceName getNIOSocketFactoryServiceName() {
        return this.nioSocketFactoryServiceName;
    }

    public void setMulticastGroupAddress(String ip) {
        this.multicastGroupAddress = ip;
    }

    public String getMulticastGroupAddress() {
        return this.multicastGroupAddress;
    }

    public void setMulticastPort(int port) {
        this.multicastPort = port;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public void setTimeToLive(int ttl) {
        this.timeToLive = ttl;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setUnicastPort(int port) {
        this.unicastPort = port;
    }

    public int getUnicastPort() {
        return this.unicastPort;
    }

    public void setWindowSize(int bytes) {
        this.windowSize = bytes;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setSendBufferTime(long time) {
        this.sendBufferTime = time;
    }

    public long getSendBufferTime() {
        return this.sendBufferTime;
    }

    public void setLocalPort(int port) {
        this.localPort = port;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setJndiName(String name) {
        this.jndiName = name;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiRepositoryServiceName(ServiceName name) {
        this.jndiRepositoryServiceName = name;
    }

    public ServiceName getJndiRepositoryServiceName() {
        return this.jndiRepositoryServiceName;
    }

    public void setRMIPort(int port) {
        this.rmiPort = port;
    }

    public int getRMIPort() {
        return this.rmiPort;
    }

    public void setSendQueueServiceName(ServiceName name) {
        this.sendQueueServiceName = name;
    }

    public ServiceName getSendQueueServiceName() {
        return this.sendQueueServiceName;
    }

    public void setSendThreadSize(int threadSize) {
        this.sendThreadSize = threadSize;
    }

    public int getSendThreadSize() {
        return this.sendThreadSize;
    }

    public void setAsynchSendQueueServiceName(ServiceName name) {
        this.asynchSendQueueServiceName = name;
    }

    public ServiceName getAsynchSendQueueServiceName() {
        return this.asynchSendQueueServiceName;
    }

    public void setAsynchSendQueueFactoryServiceName(ServiceName name) {
        this.asynchSendQueueFactoryServiceName = name;
    }

    public ServiceName getAsynchSendQueueFactoryServiceName() {
        return this.asynchSendQueueFactoryServiceName;
    }

    public void setAsynchSendThreadSize(int threadSize) {
        this.asynchSendThreadSize = threadSize;
    }

    public int getAsynchSendThreadSize() {
        return this.asynchSendThreadSize;
    }

    public void setRequestHandleQueueServiceName(ServiceName name) {
        this.requestHandleQueueServiceName = name;
    }

    public ServiceName getRequestHandleQueueServiceName() {
        return this.requestHandleQueueServiceName;
    }

    public void setRequestHandleThreadSize(int threadSize) {
        this.requestHandleThreadSize = threadSize;
    }

    public int getRequestHandleThreadSize() {
        return this.requestHandleThreadSize;
    }

    public void setExternalizerServiceName(ServiceName name) {
        this.externalizerServiceName = name;
    }

    public ServiceName getExternalizerServiceName() {
        return this.externalizerServiceName;
    }

    public void setServerConnectionListenerServiceNames(ServiceName[] names) {
        this.serverConnectionListenerServiceNames = names;
    }

    public ServiceName[] getServerConnectionListenerServiceNames() {
        return this.serverConnectionListenerServiceNames;
    }

    public void setMaxSendRetryCount(int count) {
        this.maxSendRetryCount = count;
    }

    public int getMaxSendRetryCount() {
        return this.maxSendRetryCount;
    }

    public void setAcknowledge(boolean isAck) {
        this.isAcknowledge = isAck;
    }

    public boolean isAcknowledge() {
        return this.isAcknowledge;
    }

    public void setServerSendErrorMessageId(String id) {
        this.serverSendErrorMessageId = id;
    }

    public String getServerSendErrorMessageId() {
        return this.serverSendErrorMessageId;
    }

    public void setServerSendErrorRetryOverMessageId(String id) {
        this.serverSendErrorRetryOverMessageId = id;
    }

    public String getServerSendErrorRetryOverMessageId() {
        return this.serverSendErrorRetryOverMessageId;
    }

    public void setServerResponseErrorMessageId(String id) {
        this.serverResponseErrorMessageId = id;
    }

    public String getServerResponseErrorMessageId() {
        return this.serverResponseErrorMessageId;
    }

    public void setServerMessageLostErrorMessageId(String id) {
        this.serverMessageLostErrorMessageId = id;
    }

    public String getServerMessageLostErrorMessageId() {
        return this.serverMessageLostErrorMessageId;
    }

    public void setServerMessageRecycleBufferSize(int size) {
        this.serverMessageRecycleBufferSize = size;
    }

    public int getServerMessageRecycleBufferSize() {
        return this.serverMessageRecycleBufferSize;
    }

    public void setServerWindowRecycleBufferSize(int size) {
        this.serverWindowRecycleBufferSize = size;
    }

    public int getServerWindowRecycleBufferSize() {
        return this.serverWindowRecycleBufferSize;
    }

    public void setClientServerCloseMessageId(String id) {
        this.clientServerCloseMessageId = id;
    }

    public String getClientServerCloseMessageId() {
        return this.clientServerCloseMessageId;
    }

    public void setClientReceiveWarnMessageId(String id) {
        this.clientReceiveWarnMessageId = id;
    }

    public String getClientReceiveWarnMessageId() {
        return this.clientReceiveWarnMessageId;
    }

    public void setClientReceiveErrorMessageId(String id) {
        this.clientReceiveErrorMessageId = id;
    }

    public String getClientReceiveErrorMessageId() {
        return this.clientReceiveErrorMessageId;
    }

    public void setClientMessageLostErrorMessageId(String id) {
        this.clientMessageLostErrorMessageId = id;
    }

    public String getClientMessageLostErrorMessageId() {
        return this.clientMessageLostErrorMessageId;
    }

    public void setClientResponseTimeout(long timeout) {
        this.clientResponseTimeout = timeout;
    }

    public long getClientResponseTimeout() {
        return this.clientResponseTimeout;
    }

    public void setClientPacketRecycleBufferSize(int size) {
        this.clientPacketRecycleBufferSize = size;
    }

    public int getClientPacketRecycleBufferSize() {
        return this.clientPacketRecycleBufferSize;
    }

    public void setClientWindowRecycleBufferSize(int size) {
        this.clientWindowRecycleBufferSize = size;
    }

    public int getClientWindowRecycleBufferSize() {
        return this.clientWindowRecycleBufferSize;
    }

    public void setClientMessageRecycleBufferSize(int size) {
        this.clientMessageRecycleBufferSize = size;
    }

    public int getClientMessageRecycleBufferSize() {
        return this.clientMessageRecycleBufferSize;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.serverSocketFactory = factory;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public void setSocketFactory(SocketFactory factory) {
        this.socketFactory = factory;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setNIOSocketFactory(jp.ossc.nimbus.util.net.SocketFactory factory) {
        this.nioSocketFactory = factory;
    }

    public jp.ossc.nimbus.util.net.SocketFactory getNIOSocketFactory() {
        return this.nioSocketFactory;
    }

    public void setExternalizer(Externalizer ext) {
        this.externalizer = ext;
    }

    public Externalizer getExternalizer() {
        return this.externalizer;
    }

    public void addServerConnectionListener(ServerConnectionListener listener) {
        if (this.serverConnectionListeners == null) {
            this.serverConnectionListeners = new ArrayList();
        }
        this.serverConnectionListeners.add(listener);
    }

    public void removeServerConnectionListener(ServerConnectionListener listener) {
        if (this.serverConnectionListeners == null) {
            return;
        }
        this.serverConnectionListeners.remove(listener);
    }

    public void clearServerConnectionListeners() {
        if (this.serverConnectionListeners == null) {
            return;
        }
        this.serverConnectionListeners.clear();
    }

    public ServerConnectionListener[] getServerConnectionListeners() {
        return this.serverConnectionListeners == null ? null : this.serverConnectionListeners.toArray(new ServerConnectionListener[this.serverConnectionListeners.size()]);
    }

    public long getSendCount() {
        return this.serverConnection == null ? 0L : this.serverConnection.getSendCount();
    }

    public long getSendPacketCount() {
        return this.serverConnection == null ? 0L : this.serverConnection.getSendPacketCount();
    }

    public void resetSendCount() {
        if (this.serverConnection == null) {
            return;
        }
        this.serverConnection.resetSendCount();
    }

    public long getAverageSendProcessTime() {
        return this.serverConnection == null ? 0L : this.serverConnection.getAverageSendProcessTime();
    }

    public Set getClients() {
        if (this.serverConnection == null) {
            return new HashSet();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        HashSet<SocketAddress> result = new HashSet<SocketAddress>();
        for (int i = 0; i < clientArray.length; ++i) {
            SocketAddress address;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || (address = socket.getRemoteSocketAddress()) == null) continue;
            result.add(address);
        }
        return result;
    }

    public int getClientSize() {
        return this.serverConnection.getClients().size();
    }

    public Set getEnabledClients() {
        if (this.serverConnection == null) {
            return new HashSet();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        HashSet<SocketAddress> result = new HashSet<SocketAddress>();
        for (int i = 0; i < clientArray.length; ++i) {
            SocketAddress address;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || !clientArray[i].isEnabled() || (address = socket.getRemoteSocketAddress()) == null) continue;
            result.add(address);
        }
        return result;
    }

    public Set getDisabledClients() {
        if (this.serverConnection == null) {
            return new HashSet();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        HashSet<SocketAddress> result = new HashSet<SocketAddress>();
        for (int i = 0; i < clientArray.length; ++i) {
            SocketAddress address;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || clientArray[i].isEnabled() || (address = socket.getRemoteSocketAddress()) == null) continue;
            result.add(address);
        }
        return result;
    }

    public void enabledClient(String address, int port) {
        this.setEnabledClient(address, port, true);
    }

    public void disabledClient(String address, int port) {
        this.setEnabledClient(address, port, false);
    }

    public Set getSubjects(String address, int port) {
        if (this.serverConnection == null) {
            return new HashSet();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        for (int i = 0; i < clientArray.length; ++i) {
            InetSocketAddress remoteAddress;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || (remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress()) == null || !remoteAddress.getAddress().getHostAddress().equals(address) && !remoteAddress.getAddress().getHostName().equalsIgnoreCase(address) || port != remoteAddress.getPort()) continue;
            return clientArray[i].getSubjects();
        }
        return new HashSet();
    }

    public Set getKeys(String address, int port, String subject) {
        if (this.serverConnection == null) {
            return new HashSet();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        for (int i = 0; i < clientArray.length; ++i) {
            InetSocketAddress remoteAddress;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || (remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress()) == null || !remoteAddress.getAddress().getHostAddress().equals(address) && !remoteAddress.getAddress().getHostName().equalsIgnoreCase(address) || port != remoteAddress.getPort()) continue;
            return clientArray[i].getKeys(subject);
        }
        return new HashSet();
    }

    private void setEnabledClient(String address, int port, boolean isEnabled) {
        if (this.serverConnection == null) {
            return;
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        for (int i = 0; i < clientArray.length; ++i) {
            InetSocketAddress remoteAddress;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || clientArray[i].isEnabled() == isEnabled || (remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress()) == null || !remoteAddress.getAddress().getHostAddress().equals(address) && !remoteAddress.getAddress().getHostName().equalsIgnoreCase(address) || port > 0 && port != remoteAddress.getPort()) continue;
            clientArray[i].setEnabled(isEnabled);
        }
    }

    public Map getSendCountsByClient() {
        if (this.serverConnection == null) {
            return new HashMap();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        HashMap<SocketAddress, Long> result = new HashMap<SocketAddress, Long>();
        for (int i = 0; i < clientArray.length; ++i) {
            SocketAddress address;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || (address = socket.getRemoteSocketAddress()) == null) continue;
            result.put(address, new Long(clientArray[i].getSendCount()));
        }
        return result;
    }

    public Map getAverageSendProcessTimesByClient() {
        if (this.serverConnection == null) {
            return new HashMap();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        HashMap<SocketAddress, Long> result = new HashMap<SocketAddress, Long>();
        for (int i = 0; i < clientArray.length; ++i) {
            SocketAddress address;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || (address = socket.getRemoteSocketAddress()) == null) continue;
            result.put(address, new Long(clientArray[i].getAverageSendProcessTime()));
        }
        return result;
    }

    public void resetSendCountsByClient() {
        if (this.serverConnection == null) {
            return;
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        for (int i = 0; i < clientArray.length; ++i) {
            clientArray[i].resetSendCount();
        }
    }

    public Map getInterpolateRequestCountsByClient() {
        if (this.serverConnection == null) {
            return new HashMap();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        HashMap<SocketAddress, Long> result = new HashMap<SocketAddress, Long>();
        for (int i = 0; i < clientArray.length; ++i) {
            SocketAddress address;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || (address = socket.getRemoteSocketAddress()) == null) continue;
            result.put(address, new Long(clientArray[i].getInterpolateRequestCount()));
        }
        return result;
    }

    public void resetInterpolateRequestCountsByClient() {
        if (this.serverConnection == null) {
            return;
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        for (int i = 0; i < clientArray.length; ++i) {
            clientArray[i].resetInterpolateRequestCount();
        }
    }

    public Map getNewMessagePollingCountsByClient() {
        if (this.serverConnection == null) {
            return new HashMap();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        HashMap<SocketAddress, Long> result = new HashMap<SocketAddress, Long>();
        for (int i = 0; i < clientArray.length; ++i) {
            SocketAddress address;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || (address = socket.getRemoteSocketAddress()) == null) continue;
            result.put(address, new Long(clientArray[i].getNewMessagePollingCount()));
        }
        return result;
    }

    public void resetNewMessagePollingCountsByClient() {
        if (this.serverConnection == null) {
            return;
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        for (int i = 0; i < clientArray.length; ++i) {
            clientArray[i].resetNewMessagePollingCount();
        }
    }

    public Map getLostCountsByClient() {
        if (this.serverConnection == null) {
            return new HashMap();
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        HashMap<SocketAddress, Long> result = new HashMap<SocketAddress, Long>();
        for (int i = 0; i < clientArray.length; ++i) {
            SocketAddress address;
            Socket socket = clientArray[i].getSocket();
            if (socket == null || (address = socket.getRemoteSocketAddress()) == null) continue;
            result.put(address, new Long(clientArray[i].getLostCount()));
        }
        return result;
    }

    public void resetLostCountsByClient() {
        if (this.serverConnection == null) {
            return;
        }
        Set clients = this.serverConnection.getClients();
        ServerConnectionImpl.ClientImpl[] clientArray = clients.toArray(new ServerConnectionImpl.ClientImpl[clients.size()]);
        for (int i = 0; i < clientArray.length; ++i) {
            clientArray[i].resetLostCount();
        }
    }

    public int getMaxWindowCount() {
        return this.serverConnection == null ? 0 : this.serverConnection.getMaxWindowCount();
    }

    public double getAverageWindowCount() {
        return this.serverConnection == null ? 0.0 : this.serverConnection.getAverageWindowCount();
    }

    public int getMostOldSendBufferSequence() {
        return this.serverConnection == null ? 0 : this.serverConnection.getMostOldSendBufferSequence();
    }

    public Date getMostOldSendBufferTime() {
        return this.serverConnection == null ? null : this.serverConnection.getMostOldSendBufferTime();
    }

    public int getSendBufferSize() {
        return this.serverConnection == null ? 0 : this.serverConnection.getSendBufferSize();
    }

    public long getAverageAsynchSendProcessTime() {
        return this.serverConnection == null ? 0L : this.serverConnection.getAverageAsynchSendProcessTime();
    }

    public long getAverageRequestHandleProcessTime() {
        return this.serverConnection == null ? 0L : this.serverConnection.getAverageRequestHandleProcessTime();
    }

    public void startService() throws Exception {
        if (this.clientReconnectCount > 0 && this.serverPort == 0) {
            throw new IllegalArgumentException("When clientReconnectCount is more than 0, serverPort must not be 0.");
        }
        if (this.serverAddress == null) {
            this.serverAddress = InetAddress.getLocalHost().getHostAddress();
        }
        if (this.externalizerServiceName != null) {
            this.externalizer = (Externalizer)ServiceManagerFactory.getServiceObject(this.externalizerServiceName);
        }
        InetSocketAddress sendSocketAddress = null;
        InetAddress group = null;
        if (this.multicastGroupAddress != null) {
            group = InetAddress.getByName(this.multicastGroupAddress);
        }
        sendSocketAddress = new InetSocketAddress(this.serverAddress, this.localPort);
        if (this.isNIO) {
            if (this.nioSocketFactoryServiceName != null) {
                this.nioSocketFactory = (jp.ossc.nimbus.util.net.SocketFactory)ServiceManagerFactory.getServiceObject(this.nioSocketFactoryServiceName);
            }
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.socket().setReuseAddress(true);
            serverSocketChannel.socket().bind(new InetSocketAddress(this.serverAddress, this.serverPort), this.serverBacklog);
            if (this.serverPort == 0) {
                this.serverPort = serverSocketChannel.socket().getLocalPort();
            }
            serverSocketChannel.configureBlocking(false);
            this.serverConnection = new ServerConnectionImpl(serverSocketChannel, this.externalizer, this.sendThreadSize, this.sendQueueServiceName, this.asynchSendThreadSize, this.asynchSendQueueServiceName, this.asynchSendQueueFactoryServiceName, this.requestHandleThreadSize, this.requestHandleQueueServiceName, this.nioSocketFactory, sendSocketAddress, group, this.multicastGroupAddress == null ? this.unicastPort : this.multicastPort);
        } else {
            ServerSocket serverSocket = null;
            if (this.serverSocketFactory == null) {
                if (this.serverSocketFactoryServiceName == null) {
                    serverSocket = new ServerSocket(this.serverPort, this.serverBacklog, InetAddress.getByName(this.serverAddress));
                } else {
                    this.serverSocketFactory = (ServerSocketFactory)ServiceManagerFactory.getServiceObject(this.serverSocketFactoryServiceName);
                }
            }
            if (serverSocket == null) {
                serverSocket = this.serverSocketFactory.createServerSocket(this.serverPort, this.serverBacklog, InetAddress.getByName(this.serverAddress));
            }
            if (this.serverPort == 0) {
                this.serverPort = serverSocket.getLocalPort();
            }
            this.serverConnection = new ServerConnectionImpl(serverSocket, this.externalizer, this.sendThreadSize, this.sendQueueServiceName, this.asynchSendThreadSize, this.asynchSendQueueServiceName, this.asynchSendQueueFactoryServiceName, sendSocketAddress, group, this.multicastGroupAddress == null ? this.unicastPort : this.multicastPort);
        }
        this.serverConnection.setWindowSize(this.getWindowSize());
        this.serverConnection.setSendBufferTime(this.getSendBufferTime());
        this.serverConnection.setTimeToLive(this.timeToLive);
        this.serverConnection.setLogger(this.getLogger());
        this.serverConnection.setMaxSendRetryCount(this.maxSendRetryCount);
        this.serverConnection.setSendErrorMessageId(this.serverSendErrorMessageId);
        this.serverConnection.setSendErrorRetryOverMessageId(this.serverSendErrorRetryOverMessageId);
        this.serverConnection.setResponseErrorMessageId(this.serverResponseErrorMessageId);
        this.serverConnection.setMessageLostErrorMessageId(this.serverMessageLostErrorMessageId);
        this.serverConnection.setAcknowledge(this.isAcknowledge);
        if (this.serverMessageRecycleBufferSize > 0) {
            this.serverConnection.setMessageRecycleBufferSize(this.serverMessageRecycleBufferSize);
        }
        if (this.serverWindowRecycleBufferSize > 0) {
            this.serverConnection.setWindowRecycleBufferSize(this.serverWindowRecycleBufferSize);
        }
        if (this.serverConnectionListenerServiceNames != null) {
            for (int i = 0; i < this.serverConnectionListenerServiceNames.length; ++i) {
                this.serverConnection.addServerConnectionListener((ServerConnectionListener)ServiceManagerFactory.getServiceObject(this.serverConnectionListenerServiceNames[i]));
            }
        }
        if (this.serverConnectionListeners != null) {
            int imax = this.serverConnectionListeners.size();
            for (int i = 0; i < imax; ++i) {
                this.serverConnection.addServerConnectionListener((ServerConnectionListener)this.serverConnectionListeners.get(i));
            }
        }
        if (this.socketFactoryServiceName != null) {
            this.socketFactory = (SocketFactory)ServiceManagerFactory.getServiceObject(this.socketFactoryServiceName);
        }
        if (this.jndiRepositoryServiceName != null) {
            this.jndiRepository = (Repository)ServiceManagerFactory.getServiceObject(this.jndiRepositoryServiceName);
            RemoteClientConnectionFactory remoteClientConnectionFactory = new RemoteClientConnectionFactory(this, this.rmiPort);
            if (!this.jndiRepository.register(this.jndiName, remoteClientConnectionFactory)) {
                throw new Exception("Could not register in jndiRepository.");
            }
        }
    }

    public void stopService() throws Exception {
        if (this.jndiRepository != null) {
            this.jndiRepository.unregister(this.jndiName);
        }
        if (this.serverConnection != null) {
            this.serverConnection.close();
            this.serverConnection = null;
        }
    }

    public ServerConnection getServerConnection() throws ConnectionCreateException {
        return this.serverConnection;
    }

    public ClientConnection getClientConnection() throws ConnectionCreateException {
        ClientConnectionImpl connection = new ClientConnectionImpl(this.serverAddress, this.serverPort, this.socketFactory, this.multicastGroupAddress, this.multicastGroupAddress == null ? this.unicastPort : this.multicastPort, this.externalizer, this.getServiceNameObject());
        if (this.clientAddressPropertyName != null) {
            connection.setBindAddressPropertyName(this.clientAddressPropertyName);
        }
        if (this.clientPortPropertyName != null) {
            connection.setBindPortPropertyName(this.clientPortPropertyName);
        }
        connection.setServerCloseMessageId(this.clientServerCloseMessageId);
        connection.setReceiveWarnMessageId(this.clientReceiveWarnMessageId);
        connection.setReceiveErrorMessageId(this.clientReceiveErrorMessageId);
        connection.setMessageLostErrorMessageId(this.clientMessageLostErrorMessageId);
        connection.setReconnectCount(this.clientReconnectCount);
        connection.setReconnectInterval(this.clientReconnectInterval);
        connection.setReconnectBufferTime(this.clientReconnectBufferTime);
        connection.setWindowSize(this.windowSize);
        connection.setMissingWindowTimeout(this.missingWindowTimeout);
        connection.setMissingWindowCount(this.missingWindowCount);
        connection.setNewMessagePollingInterval(this.newMessagePollingInterval);
        connection.setResponseTimeout(this.clientResponseTimeout);
        if (this.clientPacketRecycleBufferSize > 0) {
            connection.setPacketRecycleBufferSize(this.clientPacketRecycleBufferSize);
        }
        if (this.clientWindowRecycleBufferSize > 0) {
            connection.setWindowRecycleBufferSize(this.clientWindowRecycleBufferSize);
        }
        if (this.clientMessageRecycleBufferSize > 0) {
            connection.setMessageRecycleBufferSize(this.clientMessageRecycleBufferSize);
        }
        connection.setAcknowledge(this.isAcknowledge);
        return connection;
    }

    public int getClientCount() {
        return this.serverConnection == null ? 0 : this.serverConnection.getClientCount();
    }
}

