/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import java.io.Serializable;
import jp.ossc.nimbus.lang.IllegalServiceStateException;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.DelayQueueServiceMBean;

public class DelayQueueService
extends DefaultQueueService
implements DelayQueueServiceMBean,
Serializable {
    private static final long serialVersionUID = 4071276435068575666L;
    private long delayTime = -1L;
    private boolean isDelay = true;

    public void setDelayTime(long millis) {
        this.delayTime = millis;
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    public boolean isDelay() {
        return this.isDelay;
    }

    public void setDelay(boolean isDelay) {
        boolean isChangeNoDelay = this.isDelay && !isDelay;
        this.isDelay = isDelay;
        if (isChangeNoDelay) {
            this.peekMonitor.notifyAllMonitor();
            if (this.isSafeGetOrder) {
                this.getMonitor.notifyMonitor();
            } else {
                this.getMonitor.notifyAllMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Object item) {
        if (this.getState() != 3 || this.fourceEndFlg) {
            throw new IllegalServiceStateException(this);
        }
        if (!(item instanceof QueueElement)) {
            item = new QueueElement(item);
        }
        if (this.maxThresholdSize > 0 && (this.pushMonitor.isWait() || this.size() >= this.maxThresholdSize) && !this.fourceEndFlg) {
            try {
                this.pushMonitor.initAndWaitMonitor();
            }
            catch (InterruptedException e) {
                return;
            }
            finally {
                this.pushMonitor.releaseMonitor();
            }
        }
        if (this.cache == null) {
            this.queueElements.add(item);
        } else {
            CachedReference ref = this.cache.add(item);
            if (ref != null) {
                ref.addCacheRemoveListener(this);
                this.queueElements.add(ref);
            } else {
                this.queueElements.add(item);
            }
        }
        int size = this.size();
        if ((long)size > this.maxDepth) {
            this.maxDepth = size;
        }
        ++this.count;
        ++this.countDelta;
        this.lastPushedTime = System.currentTimeMillis();
        this.peekMonitor.notifyAllMonitor();
        if (this.getMonitor.isWait()) {
            Object firstElement;
            long waitTime = 0L;
            if (this.isDelay && (firstElement = this.getQueueElement(false)) != EMPTY) {
                waitTime = this.delayTime - (System.currentTimeMillis() - ((QueueElement)firstElement).pushTime);
            }
            if (!this.isDelay || waitTime <= 0L) {
                if (this.isSafeGetOrder) {
                    this.getMonitor.notifyMonitor();
                } else {
                    this.getMonitor.notifyAllMonitor();
                }
            }
        }
        if (this.pushMonitor.isWait() && this.size() < this.maxThresholdSize) {
            this.pushMonitor.notifyMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getQueueElement(long timeOutMs, boolean isRemove) {
        Object var6_6;
        block33: {
            Object object;
            block32: {
                if (this.delayTime <= 0L) return super.getQueueElement(timeOutMs, isRemove);
                if (!this.isDelay) {
                    return super.getQueueElement(timeOutMs, isRemove);
                }
                long processTime = 0L;
                try {
                    Object firstElement;
                    if (isRemove) {
                        this.getMonitor.initMonitor();
                    } else {
                        this.peekMonitor.initMonitor();
                    }
                    while (!this.fourceEndFlg) {
                        long proc;
                        block31: {
                            long curSleepTime = 0L;
                            if (!(this.size() <= 0 || isRemove && this.isSafeGetOrder && !this.getMonitor.isFirst())) {
                                firstElement = this.getQueueElement(false);
                                if (firstElement == EMPTY) continue;
                                long currentTime = System.currentTimeMillis();
                                curSleepTime = this.delayTime - (currentTime - ((QueueElement)firstElement).pushTime);
                                if (!this.isDelay || curSleepTime <= 0L) {
                                    Object element = this.getQueueElement(isRemove);
                                    if (element == EMPTY) continue;
                                    this.getMonitor.releaseMonitor();
                                    if (isRemove && this.size() > 0 && this.getMonitor.isWait()) {
                                        if (this.isSafeGetOrder) {
                                            this.getMonitor.notifyMonitor();
                                        } else {
                                            this.getMonitor.notifyAllMonitor();
                                        }
                                    }
                                    if (isRemove) {
                                        if (this.pushMonitor.isWait() && this.size() < this.maxThresholdSize) {
                                            this.pushMonitor.notifyMonitor();
                                        }
                                        Object object2 = element == null ? null : ((QueueElement)element).rawElement;
                                        Object var14_14 = null;
                                        if (isRemove) {
                                            this.getMonitor.releaseMonitor();
                                            return object2;
                                        }
                                        this.peekMonitor.releaseMonitor();
                                        return object2;
                                    }
                                } else if (this.getMonitor.isWait()) {
                                    this.getMonitor.notifyMonitor();
                                }
                            }
                            curSleepTime = curSleepTime == 0L ? (timeOutMs >= 0L ? timeOutMs - processTime : this.sleepTime) : Math.min(curSleepTime, timeOutMs >= 0L ? timeOutMs - processTime : this.sleepTime);
                            if (this.fourceEndFlg || timeOutMs == 0L || timeOutMs > 0L && timeOutMs <= processTime) break;
                            proc = 0L;
                            if (timeOutMs >= 0L) {
                                proc = System.currentTimeMillis();
                            }
                            try {
                                Object firstElement2;
                                if (curSleepTime <= 0L) break block31;
                                long waitTime = 0L;
                                if (this.size() != 0 && this.isDelay && (firstElement2 = this.getQueueElement(false)) != EMPTY) {
                                    waitTime = this.delayTime - (System.currentTimeMillis() - ((QueueElement)firstElement2).pushTime);
                                }
                                if (this.size() == 0 || !isRemove || this.isSafeGetOrder && !this.getMonitor.isFirst() || waitTime > 0L) {
                                    this.getMonitor.initAndWaitMonitor(curSleepTime);
                                }
                            }
                            catch (InterruptedException e) {
                                Object var11_12 = null;
                                Object var14_15 = null;
                                if (isRemove) {
                                    this.getMonitor.releaseMonitor();
                                    return var11_12;
                                }
                                this.peekMonitor.releaseMonitor();
                                return var11_12;
                            }
                        }
                        if (timeOutMs < 0L) continue;
                        proc = System.currentTimeMillis() - proc;
                        processTime += proc;
                    }
                    if (this.fourceEndFlg) {
                        Object element = this.getQueueElement(isRemove);
                        object = element == null || element == EMPTY ? null : ((QueueElement)element).rawElement;
                        break block32;
                    }
                    if (isRemove && this.size() > 0 && this.getMonitor.isWait()) {
                        long waitTime = 0L;
                        if (this.isDelay && (firstElement = this.getQueueElement(false)) != EMPTY) {
                            waitTime = this.delayTime - (System.currentTimeMillis() - ((QueueElement)firstElement).pushTime);
                        }
                        if (!this.isDelay || waitTime <= 0L) {
                            if (this.isSafeGetOrder) {
                                this.getMonitor.notifyMonitor();
                            } else {
                                this.getMonitor.notifyAllMonitor();
                            }
                        }
                    }
                    var6_6 = null;
                    break block33;
                }
                catch (Throwable throwable) {
                    Object var14_18 = null;
                    if (isRemove) {
                        this.getMonitor.releaseMonitor();
                        throw throwable;
                    }
                    this.peekMonitor.releaseMonitor();
                    throw throwable;
                }
            }
            Object var14_16 = null;
            if (isRemove) {
                this.getMonitor.releaseMonitor();
                return object;
            }
            this.peekMonitor.releaseMonitor();
            return object;
        }
        Object var14_17 = null;
        if (isRemove) {
            this.getMonitor.releaseMonitor();
            return var6_6;
        }
        this.peekMonitor.releaseMonitor();
        return var6_6;
    }

    public static class QueueElement
    implements Serializable {
        private static final long serialVersionUID = 3734646743111972208L;
        public Object rawElement;
        public long pushTime;

        public QueueElement(Object element) {
            this(element, System.currentTimeMillis());
        }

        public QueueElement(Object element, long time) {
            this.rawElement = element;
            this.pushTime = time;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append('{');
            buf.append("raw=").append(this.rawElement);
            buf.append(",time=").append(this.pushTime);
            buf.append('}');
            return buf.toString();
        }
    }
}

