/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import java.io.Serializable;
import jp.ossc.nimbus.core.FactoryService;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.queue.DefaultQueueFactoryService;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.queue.ThreadLocalQueueServiceMBean;

public class ThreadLocalQueueService
extends ServiceBase
implements Queue,
ThreadLocalQueueServiceMBean,
Serializable {
    private static final long serialVersionUID = 6381359533066826317L;
    private DefaultQueueFactoryService defaultQueueFactory;
    private FactoryService queueFactory;
    private ServiceName queueFactoryServiceName;
    private ThreadLocal threadLocalQueues;

    public void setQueueFactoryServiceName(ServiceName name) {
        this.queueFactoryServiceName = name;
    }

    public ServiceName getQueueFactoryServiceName() {
        return this.queueFactoryServiceName;
    }

    public void createService() throws Exception {
        this.threadLocalQueues = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return ThreadLocalQueueService.this.queueFactory.newInstance();
            }
        };
    }

    public void startService() throws Exception {
        if (this.queueFactoryServiceName != null) {
            this.queueFactory = (FactoryService)((Object)ServiceManagerFactory.getService(this.getQueueFactoryServiceName()));
        }
        if (this.queueFactory == null) {
            if (this.getDefaultQueueFactoryService() == null) {
                DefaultQueueFactoryService defaultQueueFactory = new DefaultQueueFactoryService();
                defaultQueueFactory.create();
                defaultQueueFactory.start();
                this.setDefaultQueueFactoryService(defaultQueueFactory);
            } else {
                this.getDefaultQueueFactoryService().start();
            }
            this.queueFactory = this.getDefaultQueueFactoryService();
        }
    }

    public void stopService() throws Exception {
        if (this.getQueueFactoryService() == this.getDefaultQueueFactoryService()) {
            this.getDefaultQueueFactoryService().stop();
        }
    }

    public void destroyService() throws Exception {
        if (this.getQueueFactoryService() == this.getDefaultQueueFactoryService() && this.getDefaultQueueFactoryService() != null) {
            this.getDefaultQueueFactoryService().destroy();
            this.setDefaultQueueFactoryService(null);
        }
        this.threadLocalQueues = null;
    }

    protected void setQueueFactoryService(FactoryService queueFactory) {
        this.queueFactory = queueFactory;
    }

    protected FactoryService getQueueFactoryService() {
        return this.queueFactory;
    }

    protected DefaultQueueFactoryService getDefaultQueueFactoryService() {
        return this.defaultQueueFactory;
    }

    protected void setDefaultQueueFactoryService(DefaultQueueFactoryService queueFactory) {
        this.defaultQueueFactory = queueFactory;
    }

    protected Queue getThreadLocalQueue() {
        return (Queue)this.threadLocalQueues.get();
    }

    public void push(Object item) {
        this.getThreadLocalQueue().push(item);
    }

    public Object get() {
        return this.getThreadLocalQueue().get();
    }

    public Object get(long timeOutMs) {
        return this.getThreadLocalQueue().get(timeOutMs);
    }

    public Object peek() {
        return this.getThreadLocalQueue().peek();
    }

    public Object peek(long timeOutMs) {
        return this.getThreadLocalQueue().peek(timeOutMs);
    }

    public void remove(Object item) {
        this.getThreadLocalQueue().remove(item);
    }

    public void clear() {
        this.getThreadLocalQueue().clear();
    }

    public int size() {
        return this.getThreadLocalQueue().size();
    }

    public void accept() {
        this.getThreadLocalQueue().accept();
    }

    public void release() {
        this.getThreadLocalQueue().release();
    }

    public long getCount() {
        return this.getThreadLocalQueue().getCount();
    }

    public void clearAll() {
        this.threadLocalQueues = new ThreadLocal();
    }
}

