/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.repository;

import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.repository.RMIRepositoryServiceMBean;
import jp.ossc.nimbus.service.repository.Repository;

public class RMIRepositoryService
extends ServiceBase
implements Repository,
RMIRepositoryServiceMBean {
    private static final long serialVersionUID = -6700424417078458836L;
    private String host;
    private int port = 1099;
    private boolean isCreateRegistry;
    private Registry registry;
    private Set registeredNameSet;

    public void setHostName(String host) {
        this.host = host;
    }

    public String getHostName() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isCreateRegistry() {
        return this.isCreateRegistry;
    }

    public void setCreateRegistry(boolean isCreate) {
        this.isCreateRegistry = isCreate;
    }

    public void createService() throws Exception {
        this.registeredNameSet = Collections.synchronizedSet(new HashSet());
    }

    public void startService() throws Exception {
        if (this.isCreateRegistry) {
            try {
                this.registry = LocateRegistry.createRegistry(this.port);
            }
            catch (RemoteException e) {
                this.registry = LocateRegistry.getRegistry(this.port);
            }
        } else {
            this.registry = LocateRegistry.getRegistry(this.host, this.port);
        }
    }

    public void stopService() throws Exception {
        String[] registeredNames = this.registeredNameSet.toArray(new String[this.registeredNameSet.size()]);
        for (int i = 0; i < registeredNames.length; ++i) {
            this.unregister(registeredNames[i]);
        }
        this.registry = null;
    }

    public void destroyService() throws Exception {
        this.registeredNameSet = null;
    }

    public Object get(String name) {
        try {
            return this.registry == null ? null : this.registry.lookup(name);
        }
        catch (RemoteException e) {
            return null;
        }
        catch (NotBoundException e) {
            return null;
        }
    }

    public boolean register(String name, Object obj) {
        if (this.registry == null || !(obj instanceof Remote)) {
            return false;
        }
        try {
            this.registry.bind(name, (Remote)obj);
            this.registeredNameSet.add(name);
            return true;
        }
        catch (AlreadyBoundException e) {
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean unregister(String name) {
        if (this.registry == null) {
            return false;
        }
        try {
            this.registry.unbind(name);
            this.registeredNameSet.remove(name);
            return true;
        }
        catch (NotBoundException e) {
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean isRegistered(String name) {
        return this.registeredNameSet == null ? false : this.registeredNameSet.contains(name);
    }

    public Set nameSet() {
        return new HashSet(this.registeredNameSet);
    }

    public Set registeredSet() {
        HashSet<Object> result = new HashSet<Object>();
        Iterator names = this.nameSet().iterator();
        while (names.hasNext()) {
            Object obj = this.get((String)names.next());
            if (obj == null) continue;
            result.add(obj);
        }
        return result;
    }
}

