/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.semaphore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import jp.ossc.nimbus.service.semaphore.Semaphore;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class MemorySemaphore
implements Semaphore,
Serializable {
    private static final long serialVersionUID = -408553618405283847L;
    protected volatile int mResourceCnt = -1;
    protected volatile int mInitialResource = -1;
    protected volatile boolean mFourceEndFlg = false;
    protected transient SynchronizeMonitor getMonitor = new WaitSynchronizeMonitor();
    protected transient Set usedThreads = Collections.synchronizedSet(new HashSet());
    protected transient Map threadTasks = Collections.synchronizedMap(new HashMap());
    protected long sleepTime = 10000L;
    protected long checkInterval = -1L;
    protected transient ResourceChecker checker;
    protected int maxUsedResource;
    protected int maxWaitedCount;
    protected transient Timer forceFreeTimer = new Timer(true);
    protected boolean isThreadBinding = true;

    public boolean getResource() {
        return this.getResource(-1L);
    }

    public boolean getResource(int maxWaitCount) {
        return this.getResource(-1L, maxWaitCount);
    }

    public boolean getResource(long timeOutMiliSecond) {
        return this.getResource(timeOutMiliSecond, -1);
    }

    public boolean getResource(long timeOutMiliSecond, int maxWaitCount) {
        return this.getResource(timeOutMiliSecond, maxWaitCount, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getResource(long timeOutMiliSecond, int maxWaitCount, long forceFreeMiliSecond) {
        Thread current = Thread.currentThread();
        if (this.mResourceCnt <= 0 && maxWaitCount > 0 && this.getMonitor.getWaitCount() > maxWaitCount || this.mFourceEndFlg) {
            return false;
        }
        this.getMonitor.initMonitor();
        long timeOutMs = -1L;
        if (timeOutMiliSecond >= 0L) {
            timeOutMs = timeOutMiliSecond;
        }
        long processTime = 0L;
        try {
            while (!this.mFourceEndFlg) {
                if (this.mResourceCnt > 0) {
                    boolean isGet = false;
                    SynchronizeMonitor synchronizeMonitor = this.getMonitor;
                    synchronized (synchronizeMonitor) {
                        if (this.mResourceCnt > 0) {
                            --this.mResourceCnt;
                            this.getMonitor.releaseMonitor();
                            int nowUsed = this.mInitialResource - this.mResourceCnt;
                            if (nowUsed > this.maxUsedResource) {
                                this.maxUsedResource = nowUsed;
                            }
                            isGet = true;
                        }
                    }
                    if (isGet) {
                        if (this.isThreadBinding) {
                            ForceFreeTimerTask task = null;
                            if (forceFreeMiliSecond > 0L) {
                                task = new ForceFreeTimerTask(current);
                                this.forceFreeTimer.schedule((TimerTask)task, forceFreeMiliSecond);
                            }
                            this.usedThreads.add(current);
                            if (this.threadTasks.containsKey(current)) {
                                Object tasks = this.threadTasks.get(current);
                                ArrayList<Object> taskList = null;
                                if (tasks instanceof List) {
                                    taskList = (ArrayList<Object>)tasks;
                                } else {
                                    taskList = new ArrayList<Object>();
                                    taskList.add(tasks);
                                    this.threadTasks.put(current, taskList);
                                }
                                taskList.add(task);
                            } else {
                                this.threadTasks.put(current, task);
                            }
                        }
                        if (this.mResourceCnt > 0 && this.getMonitor.isWait()) {
                            this.getMonitor.notifyMonitor();
                        }
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    int nowWaited = this.getMonitor.getWaitCount();
                    if (nowWaited > this.maxWaitedCount) {
                        this.maxWaitedCount = nowWaited;
                    }
                }
                long proc = 0L;
                Thread tasks = current;
                synchronized (tasks) {
                    if (this.mFourceEndFlg || timeOutMs >= 0L && timeOutMs <= processTime) {
                        break;
                    }
                    if (timeOutMs >= 0L) {
                        proc = System.currentTimeMillis();
                    }
                }
                int priority = current.getPriority();
                try {
                    if (this.mResourceCnt <= 0) {
                        long curSleepTime;
                        if (priority < 10) {
                            try {
                                current.setPriority(priority + 1);
                            }
                            catch (SecurityException e) {
                                // empty catch block
                            }
                        }
                        long l = curSleepTime = timeOutMs >= 0L ? timeOutMs - processTime : this.sleepTime;
                        if (curSleepTime > 0L && this.mResourceCnt <= 0) {
                            this.getMonitor.waitMonitor(curSleepTime);
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (!this.getMonitor.isNotify()) {
                        boolean bl = false;
                        this.getMonitor.releaseMonitor();
                        return bl;
                    }
                }
                finally {
                    try {
                        current.setPriority(priority);
                    }
                    catch (SecurityException e) {}
                }
                {
                    if (timeOutMs < 0L) continue;
                    proc = System.currentTimeMillis() - proc;
                    processTime += proc;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.getMonitor.releaseMonitor();
        }
    }

    public void freeResource() {
        this.freeResource(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeResource(Thread usedThread) {
        Object object;
        boolean isUsed = false;
        if (this.isThreadBinding) {
            object = usedThread;
            synchronized (object) {
                if (this.usedThreads.contains(usedThread)) {
                    isUsed = true;
                    Object tasks = this.threadTasks.get(usedThread);
                    if (tasks instanceof List) {
                        List taskList = (List)tasks;
                        TimerTask task = (TimerTask)taskList.remove(0);
                        if (task != null) {
                            task.cancel();
                        }
                        if (taskList.size() == 0) {
                            this.threadTasks.remove(usedThread);
                            this.usedThreads.remove(usedThread);
                        }
                    } else {
                        TimerTask task = (TimerTask)tasks;
                        if (task != null) {
                            task.cancel();
                        }
                        this.threadTasks.remove(usedThread);
                        this.usedThreads.remove(usedThread);
                    }
                }
            }
        }
        object = this.getMonitor;
        synchronized (object) {
            if ((this.isThreadBinding && isUsed || !this.isThreadBinding) && this.mResourceCnt < this.mInitialResource && this.mResourceCnt < this.mInitialResource) {
                ++this.mResourceCnt;
            }
        }
        if (this.mFourceEndFlg || this.mResourceCnt > 0) {
            this.getMonitor.notifyMonitor();
        }
    }

    public int getResourceCapacity() {
        return this.mInitialResource;
    }

    public void setResourceCapacity(int capa) {
        if (this.mInitialResource == -1) {
            this.mInitialResource = capa;
            this.mResourceCnt = capa;
        }
    }

    public int getResourceRemain() {
        return this.mResourceCnt;
    }

    public int getWaitingCount() {
        return this.getMonitor.getWaitCount();
    }

    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setCheckInterval(long millis) {
        this.checkInterval = millis;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public synchronized void release() {
        if (this.checker != null) {
            this.checker.isStop = true;
            this.checker = null;
        }
        this.mFourceEndFlg = true;
        while (this.getMonitor.isWait()) {
            this.getMonitor.notifyMonitor();
        }
        while (this.usedThreads.size() != 0) {
            Object[] threads = this.usedThreads.toArray();
            for (int i = 0; i < threads.length; ++i) {
                this.freeResource((Thread)threads[i]);
            }
        }
        this.mResourceCnt = this.mInitialResource;
        this.forceFreeTimer.cancel();
        this.forceFreeTimer = new Timer(true);
    }

    public synchronized void accept() {
        this.mFourceEndFlg = false;
        if (this.checkInterval > 0L) {
            this.checker = new ResourceChecker();
            this.checker.start();
        }
    }

    public int getMaxUsedResource() {
        return this.maxUsedResource;
    }

    public int getMaxWaitedCount() {
        return this.maxWaitedCount;
    }

    public void setThreadBinding(boolean isBinding) {
        this.isThreadBinding = isBinding;
    }

    public boolean isThreadBinding() {
        return this.isThreadBinding;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getMonitor = new WaitSynchronizeMonitor();
        this.usedThreads = Collections.synchronizedSet(new HashSet());
        this.threadTasks = Collections.synchronizedMap(new HashMap());
        this.forceFreeTimer = new Timer(true);
    }

    protected class ResourceChecker
    extends Thread {
        public boolean isStop;

        public ResourceChecker() {
            super("Nimbus SemaphoreResourceCheckDaemon");
            this.setDaemon(true);
        }

        public void run() {
            while (!this.isStop && MemorySemaphore.this.checkInterval > 0L) {
                try {
                    Thread.sleep(MemorySemaphore.this.checkInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (MemorySemaphore.this.mResourceCnt <= 0) continue;
                MemorySemaphore.this.getMonitor.notifyMonitor();
            }
        }
    }

    protected class ForceFreeTimerTask
    extends TimerTask {
        protected Thread usedThread;

        public ForceFreeTimerTask(Thread usedThread) {
            this.usedThread = usedThread;
        }

        public void run() {
            MemorySemaphore.this.freeResource(this.usedThread);
        }
    }
}

