/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.util.SynchronizeMonitor;

public class SleepSynchronizeMonitor
implements SynchronizeMonitor,
Serializable {
    private static final long serialVersionUID = -842881189032766657L;
    private long infiniteWaitInterval = 1000L;
    protected transient Map monitorFlagMap = Collections.synchronizedMap(new LinkedHashMap());
    protected boolean isClosed;

    public void setInfiniteWaitInterval(long interval) {
        this.infiniteWaitInterval = interval;
    }

    public long getInfiniteWaitInterval() {
        return this.infiniteWaitInterval;
    }

    public boolean initMonitor() {
        return this.initMonitor(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initMonitor(Thread thread) {
        Object object;
        if (this.isClosed) {
            return true;
        }
        MonitorFlag monitorFlag = (MonitorFlag)this.monitorFlagMap.get(thread);
        if (monitorFlag == null) {
            monitorFlag = new MonitorFlag();
            object = this.monitorFlagMap;
            synchronized (object) {
                this.monitorFlagMap.put(thread, monitorFlag);
            }
        }
        object = monitorFlag;
        synchronized (object) {
            boolean isNotify = monitorFlag.isNotify;
            monitorFlag.isWait = false;
            monitorFlag.isNotify = false;
            return isNotify;
        }
    }

    public void releaseMonitor() {
        Thread currentThread = Thread.currentThread();
        this.releaseMonitor(currentThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseMonitor(Thread currentThread) {
        MonitorFlag monitorFlag = null;
        Object object = this.monitorFlagMap;
        synchronized (object) {
            monitorFlag = (MonitorFlag)this.monitorFlagMap.get(currentThread);
            this.monitorFlagMap.remove(currentThread);
        }
        if (monitorFlag != null) {
            object = monitorFlag;
            synchronized (object) {
                monitorFlag.isWait = false;
                monitorFlag.isNotify = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllMonitor() {
        Map map = this.monitorFlagMap;
        synchronized (map) {
            Object[] threads = this.monitorFlagMap.keySet().toArray();
            for (int i = 0; i < threads.length; ++i) {
                this.releaseMonitor((Thread)threads[i]);
            }
        }
    }

    public void initAndWaitMonitor() throws InterruptedException {
        this.initAndWaitMonitor(-1L);
    }

    public boolean initAndWaitMonitor(long timeout) throws InterruptedException {
        return !this.initMonitor() ? this.waitMonitor(timeout) : true;
    }

    public void waitMonitor() throws InterruptedException {
        this.waitMonitor(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitMonitor(long timeout) throws InterruptedException {
        MonitorFlag monitorFlag;
        boolean bl;
        if (this.isClosed) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        Thread currentThread = Thread.currentThread();
        MonitorFlag monitorFlag2 = (MonitorFlag)this.monitorFlagMap.get(currentThread);
        if (monitorFlag2 == null) {
            return false;
        }
        if (monitorFlag2.isNotify) {
            return true;
        }
        MonitorFlag monitorFlag3 = monitorFlag2;
        synchronized (monitorFlag3) {
            monitorFlag2.isWait = true;
        }
        try {
            long waitTime = timeout;
            while (!monitorFlag2.isNotify) {
                block29: {
                    if (timeout > 0L) {
                        block28: {
                            if (waitTime >= 0L) {
                                try {
                                    Thread.sleep(waitTime);
                                }
                                catch (InterruptedException e) {
                                    if (monitorFlag2.isNotify) break block28;
                                    throw e;
                                }
                            }
                        }
                        if ((waitTime = timeout - (System.currentTimeMillis() - startTime)) <= 0L) {
                            break;
                        }
                    } else {
                        try {
                            Thread.sleep(this.infiniteWaitInterval);
                        }
                        catch (InterruptedException e) {
                            if (monitorFlag2.isNotify) break block29;
                            throw e;
                        }
                    }
                }
                if (!this.isClosed) continue;
                bl = true;
                Object var11_14 = null;
                monitorFlag = monitorFlag2;
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            MonitorFlag monitorFlag4 = monitorFlag2;
            synchronized (monitorFlag4) {
                monitorFlag2.isWait = false;
                Thread.interrupted();
            }
            throw throwable;
        }
        {
            synchronized (monitorFlag) {
                monitorFlag2.isWait = false;
                Thread.interrupted();
            }
            return bl;
        }
        Object var11_15 = null;
        MonitorFlag monitorFlag5 = monitorFlag2;
        synchronized (monitorFlag5) {
            monitorFlag2.isWait = false;
            Thread.interrupted();
        }
        MonitorFlag monitorFlag6 = monitorFlag2;
        synchronized (monitorFlag6) {
            boolean isNotify = monitorFlag2.isNotify;
            monitorFlag2.isNotify = false;
            return isNotify;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMonitor() {
        if (this.monitorFlagMap.size() != 0) {
            Map.Entry entry = null;
            Map map = this.monitorFlagMap;
            synchronized (map) {
                if (this.monitorFlagMap.size() != 0) {
                    entry = this.monitorFlagMap.entrySet().iterator().next();
                }
            }
            if (entry != null) {
                MonitorFlag monitorFlag;
                MonitorFlag monitorFlag2 = monitorFlag = (MonitorFlag)entry.getValue();
                synchronized (monitorFlag2) {
                    monitorFlag.isNotify = true;
                    if (monitorFlag.isWait) {
                        ((Thread)entry.getKey()).interrupt();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAllMonitor() {
        if (this.monitorFlagMap.size() != 0) {
            Object[] entries = null;
            Map map = this.monitorFlagMap;
            synchronized (map) {
                if (this.monitorFlagMap.size() != 0) {
                    entries = this.monitorFlagMap.entrySet().toArray();
                }
            }
            if (entries != null) {
                for (int i = 0; i < entries.length; ++i) {
                    MonitorFlag monitorFlag;
                    Map.Entry entry = (Map.Entry)entries[i];
                    MonitorFlag monitorFlag2 = monitorFlag = (MonitorFlag)entry.getValue();
                    synchronized (monitorFlag2) {
                        monitorFlag.isNotify = true;
                        if (monitorFlag.isWait) {
                            ((Thread)entry.getKey()).interrupt();
                        }
                        continue;
                    }
                }
            }
        }
    }

    public boolean isNotify() {
        if (this.isClosed) {
            return true;
        }
        Thread currentThread = Thread.currentThread();
        MonitorFlag monitorFlag = (MonitorFlag)this.monitorFlagMap.get(currentThread);
        return monitorFlag != null && monitorFlag.isNotify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirst() {
        if (this.monitorFlagMap.size() == 0) {
            return false;
        }
        Thread currentThread = Thread.currentThread();
        if (!this.monitorFlagMap.containsKey(currentThread)) {
            return false;
        }
        Thread first = null;
        Map map = this.monitorFlagMap;
        synchronized (map) {
            if (this.monitorFlagMap.size() != 0) {
                first = (Thread)this.monitorFlagMap.keySet().iterator().next();
            }
        }
        return first == null ? false : first.equals(currentThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWait() {
        if (this.monitorFlagMap.size() != 0) {
            Object[] flags = null;
            Map map = this.monitorFlagMap;
            synchronized (map) {
                if (this.monitorFlagMap.size() != 0) {
                    flags = this.monitorFlagMap.values().toArray();
                }
            }
            if (flags != null) {
                for (int i = 0; i < flags.length; ++i) {
                    if (!((MonitorFlag)flags[i]).isWait) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWaitCount() {
        int count = 0;
        if (this.monitorFlagMap.size() != 0) {
            Object[] flags = null;
            Map map = this.monitorFlagMap;
            synchronized (map) {
                if (this.monitorFlagMap.size() != 0) {
                    flags = this.monitorFlagMap.values().toArray();
                }
            }
            if (flags != null) {
                for (int i = 0; i < flags.length; ++i) {
                    if (!((MonitorFlag)flags[i]).isWait) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread[] getWaitThreads() {
        ArrayList result = new ArrayList();
        if (this.monitorFlagMap.size() != 0) {
            Object[] entries = null;
            Map map = this.monitorFlagMap;
            synchronized (map) {
                if (this.monitorFlagMap.size() != 0) {
                    entries = this.monitorFlagMap.entrySet().toArray();
                }
            }
            if (entries != null) {
                for (int i = 0; i < entries.length; ++i) {
                    Map.Entry entry = (Map.Entry)entries[i];
                    if (!((MonitorFlag)entry.getValue()).isWait) continue;
                    result.add(entry.getKey());
                }
            }
        }
        return result.toArray(new Thread[result.size()]);
    }

    public void close() {
        this.isClosed = true;
        this.notifyAllMonitor();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.monitorFlagMap = Collections.synchronizedMap(new LinkedHashMap());
    }

    protected static final class MonitorFlag
    implements Serializable {
        private static final long serialVersionUID = 3458888948264232416L;
        public volatile boolean isWait;
        public volatile boolean isNotify;

        protected MonitorFlag() {
        }
    }
}

