/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.net;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;

public class ServerSocket
extends java.net.ServerSocket {
    protected Map socketProperties;

    public ServerSocket() throws IOException {
    }

    public ServerSocket(int port) throws IOException {
        super(port);
    }

    public ServerSocket(int port, int backlog) throws IOException {
        super(port, backlog);
    }

    public ServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        super(port, backlog, bindAddr);
    }

    public Socket accept() throws IOException {
        return this.applySocketProperties(super.accept());
    }

    public void setSocketProperties(Map props) {
        if (props == null || props.size() == 0) {
            if (this.socketProperties != null) {
                this.socketProperties = null;
            }
            return;
        }
        Iterator names = props.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            this.setSocketProperty(name, props.get(name));
        }
    }

    public void setSocketProperty(String name, Object value) {
        if (this.socketProperties == null) {
            this.socketProperties = new LinkedHashMap();
        }
        Property prop = PropertyFactory.createProperty(name);
        this.socketProperties.put(prop, value);
    }

    public Object getSocketProperty(String name) {
        if (this.socketProperties == null) {
            return null;
        }
        Iterator props = this.socketProperties.keySet().iterator();
        while (props.hasNext()) {
            Property prop = (Property)props.next();
            if (!prop.getPropertyName().equals(name)) continue;
            return this.socketProperties.get(prop);
        }
        return null;
    }

    protected Socket applySocketProperties(Socket socket) throws IOException {
        try {
            if (this.socketProperties != null && this.socketProperties.size() != 0) {
                Iterator props = this.socketProperties.keySet().iterator();
                while (props.hasNext()) {
                    Property prop = (Property)props.next();
                    prop.setProperty(socket, this.socketProperties.get(prop));
                }
            }
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw new UndeclaredThrowableException(target);
        }
        catch (NoSuchPropertyException e) {
            throw new UndeclaredThrowableException(e);
        }
        return socket;
    }
}

