/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.validator;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.util.validator.ValidateException;
import jp.ossc.nimbus.util.validator.Validator;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class ConditionValidator
implements Validator,
Serializable {
    private static final long serialVersionUID = -8050401813918879584L;
    private Condition condition;

    public void setCondition(String condition) throws ValidateException {
        this.condition = new Condition(condition);
    }

    public String getCondition() {
        return this.condition == null ? null : this.condition.toString();
    }

    public boolean validate(Object obj) throws ValidateException {
        return this.condition == null ? true : this.condition.evaluate(obj);
    }

    private static class Condition
    implements Serializable {
        private static final long serialVersionUID = 7720035195219210280L;
        private transient List properties;
        private transient Expression expression;
        private transient List keyList;
        private String condition;
        private static final String DELIMITER = "@";
        private static final String VALUE = "value";

        Condition() throws ValidateException {
            this("true");
        }

        Condition(String cond) throws ValidateException {
            this.initCondition(cond);
        }

        private void initCondition(String cond) throws ValidateException {
            StringTokenizer token = new StringTokenizer(cond, DELIMITER, true);
            boolean keyFlg = false;
            String beforeToken = null;
            StringBuffer condBuf = new StringBuffer();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                if (!keyFlg) {
                    if (DELIMITER.equals(str)) {
                        keyFlg = true;
                    } else {
                        condBuf.append(str);
                    }
                } else if (DELIMITER.equals(str)) {
                    keyFlg = false;
                    if (beforeToken != null) {
                        if (!beforeToken.startsWith(VALUE)) {
                            throw new ValidateException("Illegal condition. " + cond);
                        }
                        if (this.keyList == null) {
                            this.keyList = new ArrayList();
                        }
                        String tmpKey = "_constrainKey$" + this.keyList.size();
                        this.keyList.add(tmpKey);
                        condBuf.append(tmpKey);
                        if (this.properties == null) {
                            this.properties = new ArrayList();
                        }
                        if (VALUE.equals(beforeToken)) {
                            this.properties.add(null);
                        } else {
                            beforeToken = beforeToken.charAt(VALUE.length()) == '.' ? beforeToken.substring(VALUE.length() + 1) : beforeToken.substring(VALUE.length());
                            Property prop = PropertyFactory.createProperty(beforeToken);
                            prop.setIgnoreNullProperty(true);
                            this.properties.add(prop);
                        }
                    } else {
                        condBuf.append(str);
                    }
                }
                beforeToken = str;
            }
            try {
                this.expression = ExpressionFactory.createExpression((String)condBuf.toString());
            }
            catch (Exception e) {
                throw new ValidateException(e);
            }
            this.evaluate("", true);
            this.condition = cond;
        }

        public boolean evaluate(Object object) throws ValidateException {
            return this.evaluate(object, false);
        }

        protected boolean evaluate(Object object, boolean isTest) throws ValidateException {
            JexlContext jexlContext = JexlHelper.createContext();
            jexlContext.getVars().put(VALUE, object);
            if (object != null && this.keyList != null) {
                int size = this.keyList.size();
                for (int i = 0; i < size; ++i) {
                    String keyString = (String)this.keyList.get(i);
                    Property property = (Property)this.properties.get(i);
                    Object val = null;
                    if (property == null) {
                        val = object;
                    } else {
                        try {
                            val = property.getProperty(object);
                        }
                        catch (NoSuchPropertyException e) {
                        }
                        catch (InvocationTargetException e) {
                            // empty catch block
                        }
                    }
                    jexlContext.getVars().put(keyString, val);
                }
            }
            try {
                Object exp = this.expression.evaluate(jexlContext);
                if (exp instanceof Boolean) {
                    return (Boolean)exp;
                }
                if (exp == null && isTest) {
                    return true;
                }
                throw new ValidateException(this.expression.getExpression());
            }
            catch (Exception e) {
                throw new ValidateException(e);
            }
        }

        public String toString() {
            return this.condition;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            try {
                this.initCondition(this.condition);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

