/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import jp.ossc.nimbus.core.AspectTranslator;

public class NimbusClassLoader
extends ClassLoader {
    protected static final Map classLoader = new WeakHashMap();
    protected static final Map vmTranslators = new HashMap();
    protected final Map translators = new HashMap();
    private static final String CLASS_EXTEND = ".class";
    private boolean isLoadNotTransformClass = false;

    protected NimbusClassLoader(ClassLoader parent) {
        super(parent);
    }

    public static synchronized NimbusClassLoader getInstance() {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (contextLoader instanceof NimbusClassLoader) {
            return (NimbusClassLoader)contextLoader;
        }
        NimbusClassLoader loader = (NimbusClassLoader)classLoader.get(contextLoader);
        if (loader == null) {
            loader = new NimbusClassLoader(contextLoader);
            classLoader.put(contextLoader, loader);
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVMAspectTranslator(AspectTranslator translator) {
        Map map = vmTranslators;
        synchronized (map) {
            List<AspectTranslator> list = null;
            if (vmTranslators.containsKey(translator.getAspectKey())) {
                list = (List)vmTranslators.get(translator.getAspectKey());
            } else {
                list = new ArrayList();
                vmTranslators.put(translator.getAspectKey(), list);
            }
            if (!list.contains(translator)) {
                list.add(translator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeVMAspectTranslator(AspectTranslator translator) {
        Map map = vmTranslators;
        synchronized (map) {
            if (vmTranslators.containsKey(translator.getAspectKey())) {
                List list = (List)vmTranslators.get(translator.getAspectKey());
                list.remove(translator);
                if (list.size() == 0) {
                    vmTranslators.remove(translator.getAspectKey());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AspectTranslator[] getVMAspectTranslators() {
        Map map = vmTranslators;
        synchronized (map) {
            AspectTranslator[] result = new AspectTranslator[vmTranslators.size()];
            List[] lists = vmTranslators.values().toArray(new List[vmTranslators.size()]);
            for (int i = 0; i < lists.length; ++i) {
                result[i] = (AspectTranslator)lists[i].get(0);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAspectTranslator(AspectTranslator translator) {
        Map map = this.translators;
        synchronized (map) {
            List<AspectTranslator> list = null;
            if (this.translators.containsKey(translator.getAspectKey())) {
                list = (List)this.translators.get(translator.getAspectKey());
            } else {
                list = new ArrayList();
                this.translators.put(translator.getAspectKey(), list);
            }
            if (!list.contains(translator)) {
                list.add(translator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAspectTranslator(AspectTranslator translator) {
        Map map = this.translators;
        synchronized (map) {
            if (this.translators.containsKey(translator.getAspectKey())) {
                List list = (List)this.translators.get(translator.getAspectKey());
                list.remove(translator);
                if (list.size() == 0) {
                    this.translators.remove(translator.getAspectKey());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AspectTranslator[] getAspectTranslators() {
        Map map = this.translators;
        synchronized (map) {
            AspectTranslator[] result = new AspectTranslator[this.translators.size()];
            List[] lists = this.translators.values().toArray(new List[this.translators.size()]);
            for (int i = 0; i < lists.length; ++i) {
                result[i] = (AspectTranslator)lists[i].get(0);
            }
            return result;
        }
    }

    public void setLoadNotTransformClass(boolean isLoad) {
        this.isLoadNotTransformClass = isLoad;
    }

    public boolean isLoadNotTransformClass() {
        return this.isLoadNotTransformClass;
    }

    public synchronized Class loadClassLocally(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public synchronized Class loadClassLocally(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, true);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Class loadClass(String name, boolean resolve, boolean isLocally) throws ClassNotFoundException {
        if (vmTranslators.size() == 0 && this.translators.size() == 0 && !this.isLoadNotTransformClass) {
            return super.loadClass(name, resolve);
        }
        if (NimbusClassLoader.isNonLoadableClassName(name)) {
            return super.loadClass(name, resolve);
        }
        boolean isNonTranslatableClass = NimbusClassLoader.isNonTranslatableClassName(name);
        if (isNonTranslatableClass && !this.isLoadNotTransformClass) {
            return super.loadClass(name, resolve);
        }
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass != null) {
            return loadedClass;
        }
        URL classUrl = this.getClassURL(name);
        if (classUrl == null) {
            return super.loadClass(name, resolve);
        }
        byte[] bytecode = this.loadByteCode(classUrl);
        if (bytecode == null) {
            return super.loadClass(name, resolve);
        }
        URL codeSourceUrl = this.getCodeSourceURL(name, classUrl);
        if (codeSourceUrl == null) {
            return super.loadClass(name, resolve);
        }
        ProtectionDomain domain = this.getProtectionDomain(codeSourceUrl);
        boolean isTransform = false;
        byte[] transformedBytes = bytecode;
        if (!isNonTranslatableClass) {
            byte[] tmpBytes;
            AspectTranslator translator;
            int i;
            int max;
            Object[] keys;
            Map map = vmTranslators;
            synchronized (map) {
                keys = vmTranslators.keySet().toArray();
                max = keys.length;
                for (i = 0; i < max; ++i) {
                    translator = (AspectTranslator)((List)vmTranslators.get(keys[i])).get(0);
                    tmpBytes = translator.transform(this, name, domain, transformedBytes);
                    if (tmpBytes == null) continue;
                    isTransform = true;
                    transformedBytes = tmpBytes;
                }
            }
            map = this.translators;
            synchronized (map) {
                keys = this.translators.keySet().toArray();
                max = keys.length;
                for (i = 0; i < max; ++i) {
                    translator = (AspectTranslator)((List)this.translators.get(keys[i])).get(0);
                    tmpBytes = translator.transform(this, name, domain, transformedBytes);
                    if (tmpBytes == null) continue;
                    isTransform = true;
                    transformedBytes = tmpBytes;
                }
            }
        }
        if (isTransform || isLocally || this.isLoadNotTransformClass) {
            this.definePackage(name);
            Class<?> clazz = this.defineClass(name, transformedBytes, 0, transformedBytes.length, domain);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        int innerClassIndex = name.lastIndexOf(36);
        if (innerClassIndex != -1 && name.length() - 1 != innerClassIndex && this.findLoadedClass(name.substring(0, innerClassIndex)) != null) {
            return this.loadClass(name, resolve, true);
        }
        return super.loadClass(name, resolve);
    }

    public static boolean isNonLoadableClassName(String classname) {
        return classname.startsWith("org.omg.") || classname.startsWith("org.w3c.") || classname.startsWith("org.xml.sax.") || classname.startsWith("sunw.") || classname.startsWith("sun.") || classname.startsWith("java.") || classname.startsWith("javax.") || classname.startsWith("com.sun.") || classname.equals("jp.ossc.nimbus.core.NimbusClassLoader") || classname.equals("jp.ossc.nimbus.core.AspectTranslator");
    }

    public static boolean isNonTranslatableClassName(String classname) {
        return classname.startsWith("jp.ossc.nimbus.service.aop.");
    }

    protected void definePackage(String className) {
        int index = className.lastIndexOf(46);
        if (index == -1) {
            return;
        }
        try {
            this.definePackage(className.substring(0, index), null, null, null, null, null, null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected URL getClassURL(String classname) {
        String classRsrcName = classname.replace('.', '/') + CLASS_EXTEND;
        return this.getResource(classRsrcName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] loadByteCode(URL classURL) {
        byte[] bytecode = null;
        InputStream is = null;
        try {
            is = classURL.openStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] tmp = new byte[1024];
            int read = 0;
            while ((read = is.read(tmp)) > 0) {
                baos.write(tmp, 0, read);
            }
            bytecode = baos.toByteArray();
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bytecode;
    }

    protected URL getCodeSourceURL(String classname, URL classURL) {
        String classRsrcName = classname.replace('.', '/') + CLASS_EXTEND;
        String urlAsString = classURL.toString();
        int index = urlAsString.indexOf(classRsrcName);
        if (index == -1) {
            return classURL;
        }
        urlAsString = urlAsString.substring(0, index);
        try {
            return new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected ProtectionDomain getProtectionDomain(URL codesourceUrl) {
        Certificate[] certificates = null;
        CodeSource cs = new CodeSource(codesourceUrl, certificates);
        PermissionCollection permissions = Policy.getPolicy().getPermissions(cs);
        return new ProtectionDomain(cs, permissions);
    }
}

