/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

public class CSVReader
extends LineNumberReader {
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_SEPARATOR_ESCAPE = '\\';
    public static final char DEFAULT_ENCLOSURE = '\"';
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected char separator = (char)44;
    protected char separatorEscape = (char)92;
    protected char enclosure = (char)34;
    protected boolean isIgnoreEmptyLine;
    protected boolean isIgnoreLineEndSeparator;
    protected boolean isEnclosed;
    protected boolean isTrim;
    protected String nullValue;
    protected String commentPrefix;
    protected boolean isUnescapeLineSeparatorInEnclosure;
    protected CSVIterator iterator;
    protected ReaderWrapper readerWrapper = (ReaderWrapper)this.lock;

    public CSVReader() {
        super(new ReaderWrapper());
    }

    public CSVReader(Reader reader) {
        super(new ReaderWrapper(reader));
    }

    public CSVReader(int size) {
        super(new ReaderWrapper(), size);
    }

    public CSVReader(Reader reader, int size) {
        super(new ReaderWrapper(reader), size);
    }

    public void setReader(Reader reader) {
        this.readerWrapper.setReader(reader);
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparatorEscape(char escape) {
        this.separatorEscape = escape;
    }

    public char getSeparatorEscape() {
        return this.separatorEscape;
    }

    public void setEnclosure(char enclosure) {
        this.enclosure = enclosure;
    }

    public char getEnclosure() {
        return this.enclosure;
    }

    public void setIgnoreEmptyLine(boolean isIgnore) {
        this.isIgnoreEmptyLine = isIgnore;
    }

    public boolean isIgnoreEmptyLine() {
        return this.isIgnoreEmptyLine;
    }

    public void setIgnoreLineEndSeparator(boolean isIgnore) {
        this.isIgnoreLineEndSeparator = isIgnore;
    }

    public boolean isIgnoreLineEndSeparator() {
        return this.isIgnoreLineEndSeparator;
    }

    public void setEnclosed(boolean isEnclosed) {
        this.isEnclosed = isEnclosed;
    }

    public boolean isEnclosed() {
        return this.isEnclosed;
    }

    public void setTrim(boolean isTrim) {
        this.isTrim = isTrim;
    }

    public boolean isTrim() {
        return this.isTrim;
    }

    public void setNullValue(String value) {
        this.nullValue = value;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public void setCommentPrefix(String value) {
        this.commentPrefix = value;
    }

    public String getCommentPrefix() {
        return this.commentPrefix;
    }

    public void setUnescapeLineSeparatorInEnclosure(boolean isUnescape) {
        this.isUnescapeLineSeparatorInEnclosure = isUnescape;
    }

    public boolean isUnescapeLineSeparatorInEnclosure() {
        return this.isUnescapeLineSeparatorInEnclosure;
    }

    public long skipLine(long line) throws IOException {
        int result = 0;
        result = 0;
        while ((long)result < line && super.readLine() != null) {
            ++result;
        }
        return result;
    }

    public long skipCSVLine(long line) throws IOException {
        List csv = null;
        int result = 0;
        result = 0;
        while ((long)result < line && (csv = this.readCSVLineList(csv)) != null) {
            ++result;
        }
        return result;
    }

    public String[] readCSVLine() throws IOException {
        List csv = this.readCSVLineList();
        return csv == null ? null : csv.toArray(new String[csv.size()]);
    }

    public List readCSVLineList() throws IOException {
        return this.readCSVLineList(null);
    }

    public List readCSVLineList(List csv) throws IOException {
        return CSVReader.toList(this, csv, this.separator, this.separatorEscape, this.isEnclosed, this.enclosure, this.nullValue, this.commentPrefix, this.isIgnoreEmptyLine, this.isIgnoreLineEndSeparator, this.isTrim, this.isUnescapeLineSeparatorInEnclosure);
    }

    @Override
    public String readLine() throws IOException {
        if (this.readerWrapper.getReader() instanceof BufferedReader) {
            return ((BufferedReader)this.readerWrapper.getReader()).readLine();
        }
        return super.readLine();
    }

    private static List toList(BufferedReader reader, List csv, char separator, char separatorEscape, boolean isEnclosed, char enclosure, String nullValue, String commentPrefix, boolean isIgnoreEmptyLine, boolean isIgnoreLineEndSeparator, boolean isTrim, boolean isUnescapeLineSeparatorInEnclosure) throws IOException {
        String line = null;
        do {
            if ((line = reader.readLine()) == null) {
                if (csv != null) {
                    csv.clear();
                }
                return null;
            }
            if ((!isIgnoreEmptyLine || line.length() != 0) && (commentPrefix == null || !line.startsWith(commentPrefix))) continue;
            line = null;
            if (!(reader instanceof LineNumberReader)) continue;
            LineNumberReader lnr = (LineNumberReader)reader;
            lnr.setLineNumber(lnr.getLineNumber() - 1);
        } while (line == null);
        if (csv == null) {
            csv = new ArrayList<String>();
        } else {
            csv.clear();
        }
        if (line.length() == 0) {
            return csv;
        }
        StringBuffer buf = new StringBuffer();
        boolean inEnclosure = false;
        boolean isEncElement = false;
        do {
            if (inEnclosure) {
                line = reader.readLine();
                if (line == null) break;
                if (reader instanceof LineNumberReader) {
                    LineNumberReader lnr = (LineNumberReader)reader;
                    lnr.setLineNumber(lnr.getLineNumber() - 1);
                }
                buf.append(LINE_SEPARATOR);
            }
            char c = '\u0000';
            int imax = line.length();
            for (int i = 0; i < imax; ++i) {
                c = line.charAt(i);
                if (c == enclosure) {
                    if (isEnclosed) {
                        if (inEnclosure && imax - 1 != i && line.charAt(i + 1) == enclosure) {
                            buf.append(enclosure);
                            ++i;
                            continue;
                        }
                        if (i > 2 && line.charAt(i - 1) != separator && imax - 1 != i && line.charAt(i + 1) != separator || !inEnclosure && (imax - 1 == i || buf.length() != 0)) {
                            buf.append(c);
                            continue;
                        }
                        boolean bl = inEnclosure = !inEnclosure;
                        if (inEnclosure) continue;
                        isEncElement = true;
                        continue;
                    }
                    buf.append(c);
                    continue;
                }
                if (c == separator) {
                    if (inEnclosure) {
                        buf.append(c);
                        continue;
                    }
                    if (!isEncElement && isTrim) {
                        CSVReader.trim(buf);
                    }
                    String element = buf.toString();
                    if (nullValue == null) {
                        csv.add(element);
                    } else if (nullValue.equals(element)) {
                        csv.add(null);
                    } else {
                        csv.add(element);
                    }
                    buf.setLength(0);
                    isEncElement = false;
                    continue;
                }
                if (c == separatorEscape) {
                    if (imax - 1 != i) {
                        char nextChar = line.charAt(i + 1);
                        if (!inEnclosure) {
                            if (nextChar == separator || nextChar == separatorEscape || nextChar == enclosure) {
                                buf.append(nextChar);
                                ++i;
                                continue;
                            }
                            if (nextChar == 'r') {
                                buf.append('\r');
                                ++i;
                                continue;
                            }
                            if (nextChar == 'n') {
                                buf.append('\n');
                                ++i;
                                continue;
                            }
                            buf.append(c);
                            continue;
                        }
                        if (isUnescapeLineSeparatorInEnclosure) {
                            if (nextChar == 'r') {
                                buf.append('\r');
                                ++i;
                                continue;
                            }
                            if (nextChar == 'n') {
                                buf.append('\n');
                                ++i;
                                continue;
                            }
                            buf.append(c);
                            continue;
                        }
                        buf.append(c);
                        continue;
                    }
                    buf.append(c);
                    continue;
                }
                buf.append(c);
            }
            if (inEnclosure || c == separator && isIgnoreLineEndSeparator && buf.length() == 0) continue;
            String element = buf.toString();
            if (nullValue == null) {
                csv.add(element);
                continue;
            }
            if (nullValue.equals(element)) {
                csv.add(null);
                continue;
            }
            csv.add(element);
        } while (inEnclosure);
        return csv;
    }

    protected static StringBuffer trim(StringBuffer buf) {
        int i;
        int index = 0;
        int max = buf.length();
        for (i = 0; i < max; ++i) {
            char c = buf.charAt(i);
            if (Character.isWhitespace(c)) continue;
            index = i;
            break;
        }
        if (index != 0) {
            buf.delete(0, index);
        }
        index = buf.length();
        i = buf.length();
        while (--i >= 0) {
            char c = buf.charAt(i);
            if (Character.isWhitespace(c)) continue;
            index = i;
            break;
        }
        if (index != buf.length() - 1) {
            buf.delete(index, buf.length());
        }
        return buf;
    }

    public static String[] toArray(String str, char separator, char separatorEscape, char enclosure, String nullValue, String commentPrefix, boolean isIgnoreEmptyLine, boolean isIgnoreLineEndSeparator, boolean isTrim, boolean isUnescapeLineSeparatorInEnclosure) {
        if (str == null || str.length() == 0) {
            return new String[0];
        }
        StringReader sr = new StringReader(str);
        BufferedReader br = new BufferedReader(sr);
        List list = null;
        try {
            list = CSVReader.toList(br, null, separator, separatorEscape, true, enclosure, nullValue, commentPrefix, isIgnoreEmptyLine, isIgnoreLineEndSeparator, isTrim, isUnescapeLineSeparatorInEnclosure);
        }
        catch (IOException e) {
            return new String[0];
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] toArray(String str, char separator, char separatorEscape, String nullValue, String commentPrefix, boolean isIgnoreEmptyLine, boolean isIgnoreLineEndSeparator, boolean isTrim, boolean isUnescapeLineSeparatorInEnclosure) {
        if (str == null || str.length() == 0) {
            return new String[0];
        }
        StringReader sr = new StringReader(str);
        BufferedReader br = new BufferedReader(sr);
        List list = null;
        try {
            list = CSVReader.toList(br, null, separator, separatorEscape, false, '\"', nullValue, commentPrefix, isIgnoreEmptyLine, isIgnoreLineEndSeparator, isTrim, isUnescapeLineSeparatorInEnclosure);
        }
        catch (IOException e) {
            return new String[0];
        }
        return list.toArray(new String[list.size()]);
    }

    public static List toList(String str, List result, char separator, char separatorEscape, char enclosure, String nullValue, String commentPrefix, boolean isIgnoreEmptyLine, boolean isIgnoreLineEndSeparator, boolean isTrim, boolean isUnescapeLineSeparatorInEnclosure) {
        if (result == null) {
            result = new ArrayList();
        }
        if (str == null || str.length() == 0) {
            result.clear();
            return result;
        }
        StringReader sr = new StringReader(str);
        BufferedReader br = new BufferedReader(sr);
        try {
            result = CSVReader.toList(br, result, separator, separatorEscape, true, enclosure, nullValue, commentPrefix, isIgnoreEmptyLine, isIgnoreLineEndSeparator, isTrim, isUnescapeLineSeparatorInEnclosure);
        }
        catch (IOException e) {
            return result;
        }
        return result;
    }

    public static List toList(String str, List result, char separator, char separatorEscape, String nullValue, String commentPrefix, boolean isIgnoreEmptyLine, boolean isIgnoreLineEndSeparator, boolean isTrim, boolean isUnescapeLineSeparatorInEnclosure) {
        if (result == null) {
            result = new ArrayList();
        }
        if (str == null || str.length() == 0) {
            result.clear();
            return result;
        }
        StringReader sr = new StringReader(str);
        BufferedReader br = new BufferedReader(sr);
        try {
            result = CSVReader.toList(br, result, separator, separatorEscape, false, '\"', nullValue, commentPrefix, isIgnoreEmptyLine, isIgnoreLineEndSeparator, isTrim, isUnescapeLineSeparatorInEnclosure);
        }
        catch (IOException e) {
            return result;
        }
        return result;
    }

    public CSVIterator iterator() {
        if (this.iterator == null) {
            this.iterator = new CSVIterator();
        }
        return this.iterator;
    }

    public CSVReader cloneReader() {
        return this.cloneReader(new CSVReader());
    }

    protected CSVReader cloneReader(CSVReader clone) {
        clone.separator = this.separator;
        clone.separatorEscape = this.separatorEscape;
        clone.enclosure = this.enclosure;
        clone.isIgnoreEmptyLine = this.isIgnoreEmptyLine;
        clone.isIgnoreLineEndSeparator = this.isIgnoreLineEndSeparator;
        clone.isEnclosed = this.isEnclosed;
        clone.nullValue = this.nullValue;
        clone.commentPrefix = this.commentPrefix;
        clone.isUnescapeLineSeparatorInEnclosure = this.isUnescapeLineSeparatorInEnclosure;
        return clone;
    }

    private static class ReaderWrapper
    extends Reader {
        private Reader realReader;
        private static Method READ_CHARBUFFER_METHOD = null;

        public ReaderWrapper() {
        }

        public ReaderWrapper(Reader reader) {
            this.realReader = reader;
        }

        public Reader getReader() {
            return this.realReader;
        }

        public void setReader(Reader reader) {
            this.realReader = reader;
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            if (READ_CHARBUFFER_METHOD == null) {
                throw new UnsupportedOperationException("No such method.");
            }
            if (this.realReader == null) {
                return -1;
            }
            try {
                return (Integer)READ_CHARBUFFER_METHOD.invoke((Object)this.realReader, target);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw new UndeclaredThrowableException(th);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e.toString());
            }
        }

        @Override
        public int read() throws IOException {
            if (this.realReader == null) {
                return -1;
            }
            return this.realReader.read();
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            if (this.realReader == null) {
                return -1;
            }
            return this.realReader.read(cbuf);
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.realReader == null) {
                return -1;
            }
            return this.realReader.read(cbuf, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.realReader == null) {
                return 0L;
            }
            return this.realReader.skip(n);
        }

        @Override
        public boolean ready() throws IOException {
            if (this.realReader == null) {
                return false;
            }
            return this.realReader.ready();
        }

        @Override
        public boolean markSupported() {
            if (this.realReader == null) {
                return false;
            }
            return this.realReader.markSupported();
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            if (this.realReader == null) {
                throw new IOException("Reader is null.");
            }
            this.realReader.mark(readAheadLimit);
        }

        @Override
        public void reset() throws IOException {
            if (this.realReader != null) {
                this.realReader.reset();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.realReader != null) {
                this.realReader.close();
            }
        }

        static {
            try {
                READ_CHARBUFFER_METHOD = Reader.class.getMethod("read", CharBuffer.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public class CSVElements
    extends ArrayList {
        private static final long serialVersionUID = 6079322185163530516L;
        private boolean wasNull;

        private CSVElements() {
        }

        @Override
        public void clear() {
            this.wasNull = false;
            super.clear();
        }

        public boolean wasNull() {
            return this.wasNull;
        }

        @Override
        public Object get(int index) {
            Object obj = super.get(index);
            this.wasNull = obj == null;
            return obj;
        }

        public String getString(int index) {
            String str = (String)this.get(index);
            this.wasNull = str == null;
            return str;
        }

        public byte getByte(int index) throws NumberFormatException {
            return this.getByte(index, 10);
        }

        public byte getByte(int index, int radix) throws NumberFormatException {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0;
            }
            return Byte.parseByte(str, radix);
        }

        public short getShort(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0;
            }
            return Short.parseShort(str);
        }

        public char getChar(int index) {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return '\u0000';
            }
            return str.charAt(0);
        }

        public int getInt(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0;
            }
            return Integer.parseInt(str);
        }

        public long getLong(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0L;
            }
            return Long.parseLong(str);
        }

        public float getFloat(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0.0f;
            }
            return Float.parseFloat(str);
        }

        public double getDouble(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0.0;
            }
            return Double.parseDouble(str);
        }

        public boolean getBoolean(int index) {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return false;
            }
            return Boolean.valueOf(str);
        }

        public BigInteger getBigInteger(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return null;
            }
            return new BigInteger(str);
        }

        public BigDecimal getBigDecimal(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return null;
            }
            return new BigDecimal(str);
        }
    }

    public class CSVIterator {
        private boolean hasNext = false;
        private CSVElements elements = new CSVElements();

        private CSVIterator() {
        }

        public boolean hasNext() throws IOException {
            if (this.hasNext) {
                return this.hasNext;
            }
            List result = CSVReader.this.readCSVLineList(this.elements);
            this.hasNext = result != null;
            return this.hasNext;
        }

        public Object next() throws IOException {
            return this.nextElements();
        }

        public CSVElements nextElements() throws IOException {
            if (!this.hasNext && !this.hasNext()) {
                return null;
            }
            this.hasNext = false;
            return this.elements;
        }
    }
}

