/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.BeanFlowJournalMetricsInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.MetricsInfo;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.performance.PerformanceRecorder;
import jp.ossc.nimbus.service.writer.Category;
import jp.ossc.nimbus.service.writer.MessageWriteException;

public class BeanFlowJournalMetricsInterceptorService
extends ServiceBase
implements Interceptor,
DaemonRunnable,
BeanFlowJournalMetricsInterceptorServiceMBean {
    private static final Comparator COMP = new MetricsInfoComparator();
    private static final String LINE_SEP = System.getProperty("line.separator");
    private ServiceName journalServiceName;
    private Journal journal;
    private ServiceName editorFinderServiceName;
    private EditorFinder editorFinder;
    private Map metricsInfos;
    private boolean isEnabled = true;
    private boolean isCalculateOnlyNormal;
    private String dateFormat = "HH:mm:ss.SSS";
    private long outputInterval = 60000L;
    private boolean isResetByOutput;
    private Properties flowAndCategoryServiceNameMapping;
    private Map flowAndCategoryMap;
    private Daemon writerDaemon;
    private ServiceName categoryServiceName;
    private Category metricsCategory;
    private boolean isOutputTimestamp = false;
    private boolean isOutputCount = true;
    private boolean isOutputExceptionCount = false;
    private boolean isOutputErrorCount = false;
    private boolean isOutputLastTime = false;
    private boolean isOutputLastExceptionTime = false;
    private boolean isOutputLastErrorTime = false;
    private boolean isOutputBestJournalSize = true;
    private boolean isOutputBestJournalSizeTime = false;
    private boolean isOutputWorstJournalSize = true;
    private boolean isOutputWorstJournalSizeTime = false;
    private boolean isOutputAverageJournalSize = true;
    private ServiceName performanceRecorderServiceName;
    private PerformanceRecorder performanceRecorder;

    @Override
    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    @Override
    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    @Override
    public void setEditorFinderServiceName(ServiceName name) {
        this.editorFinderServiceName = name;
    }

    @Override
    public ServiceName getEditorFinderServiceName() {
        return this.editorFinderServiceName;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setCalculateOnlyNormal(boolean isCalc) {
        this.isCalculateOnlyNormal = isCalc;
    }

    @Override
    public boolean isCalculateOnlyNormal() {
        return this.isCalculateOnlyNormal;
    }

    @Override
    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public String displayMetricsInfo() {
        MetricsInfo[] infos = this.metricsInfos.values().toArray(new MetricsInfo[this.metricsInfos.size()]);
        Arrays.sort(infos, COMP);
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
        StringBuffer buf = new StringBuffer();
        buf.append("\"No.\"");
        if (this.isOutputCount) {
            buf.append(",\"Count\"");
        }
        if (this.isOutputExceptionCount) {
            buf.append(",\"ExceptionCount\"");
        }
        if (this.isOutputErrorCount) {
            buf.append(",\"ErrorCount\"");
        }
        if (this.isOutputLastTime) {
            buf.append(",\"LastTime\"");
        }
        if (this.isOutputLastExceptionTime) {
            buf.append(",\"LastExceptionTime\"");
        }
        if (this.isOutputLastErrorTime) {
            buf.append(",\"LastErrorTime\"");
        }
        if (this.isOutputBestJournalSize) {
            buf.append(",\"Best size\"");
        }
        if (this.isOutputBestJournalSizeTime) {
            buf.append(",\"Best size time\"");
        }
        if (this.isOutputWorstJournalSize) {
            buf.append(",\"Worst size\"");
        }
        if (this.isOutputWorstJournalSizeTime) {
            buf.append(",\"Worst size time\"");
        }
        if (this.isOutputAverageJournalSize) {
            buf.append(",\"Average performance[ms]\"");
        }
        buf.append(",\"Flow\"");
        buf.append(LINE_SEP);
        for (int i = 0; i < infos.length; ++i) {
            buf.append('\"').append(i + 1).append('\"');
            if (this.isOutputCount) {
                buf.append(',').append('\"').append(infos[i].count).append('\"');
            }
            if (this.isOutputExceptionCount) {
                buf.append(',').append('\"').append(infos[i].exceptionCount).append('\"');
            }
            if (this.isOutputErrorCount) {
                buf.append(',').append('\"').append(infos[i].errorCount).append('\"');
            }
            if (this.isOutputLastTime) {
                if (infos[i].lastTime == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append(',').append('\"').append(format.format(new Date(infos[i].lastTime))).append('\"');
                }
            }
            if (this.isOutputLastExceptionTime) {
                if (infos[i].lastExceptionTime == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append(',').append('\"').append(format.format(new Date(infos[i].lastExceptionTime))).append('\"');
                }
            }
            if (this.isOutputLastErrorTime) {
                if (infos[i].lastErrorTime == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append('\"').append(',').append(format.format(new Date(infos[i].lastErrorTime))).append('\"');
                }
            }
            if (this.isOutputBestJournalSize) {
                buf.append(',').append('\"').append(infos[i].bestPerformance).append('\"');
            }
            if (this.isOutputBestJournalSizeTime) {
                if (infos[i].bestPerformanceTime == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append(',').append('\"').append(format.format(new Date(infos[i].bestPerformanceTime))).append('\"');
                }
            }
            if (this.isOutputWorstJournalSize) {
                buf.append(',').append('\"').append(infos[i].worstPerformance).append('\"');
            }
            if (this.isOutputWorstJournalSizeTime) {
                if (infos[i].worstPerformanceTime == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append(',').append('\"').append(format.format(new Date(infos[i].worstPerformanceTime))).append('\"');
                }
            }
            if (this.isOutputAverageJournalSize) {
                buf.append(',').append('\"').append(infos[i].getAveragePerformance()).append('\"');
            }
            buf.append(',').append('\"').append(infos[i].key).append('\"');
            buf.append(LINE_SEP);
        }
        if (this.isOutputTimestamp) {
            buf.append(format.format(new Date())).append(LINE_SEP);
        }
        return buf.toString();
    }

    @Override
    public void reset() {
        this.metricsInfos.clear();
    }

    @Override
    public MetricsInfo getMetricsInfo(String flow) {
        return (MetricsInfo)this.metricsInfos.get(flow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getMetricsInfos() {
        if (this.metricsInfos == null) {
            return new HashMap();
        }
        Map map = this.metricsInfos;
        synchronized (map) {
            return new HashMap(this.metricsInfos);
        }
    }

    @Override
    public void setOutputInterval(long interval) {
        this.outputInterval = interval;
    }

    @Override
    public long getOutputInterval() {
        return this.outputInterval;
    }

    @Override
    public void setResetByOutput(boolean isReset) {
        this.isResetByOutput = isReset;
    }

    @Override
    public boolean isResetByOutput() {
        return this.isResetByOutput;
    }

    @Override
    public void setFlowAndCategoryServiceNameMapping(Properties mapping) {
        this.flowAndCategoryServiceNameMapping = mapping;
    }

    @Override
    public Properties getFlowAndCategoryServiceNameMapping() {
        return this.flowAndCategoryServiceNameMapping;
    }

    @Override
    public void setCategoryServiceName(ServiceName name) {
        this.categoryServiceName = name;
    }

    @Override
    public ServiceName getCategoryServiceName() {
        return this.categoryServiceName;
    }

    @Override
    public void setOutputCount(boolean isOutput) {
        this.isOutputCount = isOutput;
    }

    @Override
    public boolean isOutputCount() {
        return this.isOutputCount;
    }

    @Override
    public void setOutputExceptionCount(boolean isOutput) {
        this.isOutputExceptionCount = isOutput;
    }

    @Override
    public boolean isOutputExceptionCount() {
        return this.isOutputExceptionCount;
    }

    @Override
    public void setOutputErrorCount(boolean isOutput) {
        this.isOutputErrorCount = isOutput;
    }

    @Override
    public boolean isOutputErrorCount() {
        return this.isOutputErrorCount;
    }

    @Override
    public void setOutputLastTime(boolean isOutput) {
        this.isOutputLastTime = isOutput;
    }

    @Override
    public boolean isOutputLastTime() {
        return this.isOutputLastTime;
    }

    @Override
    public void setOutputLastExceptionTime(boolean isOutput) {
        this.isOutputLastExceptionTime = isOutput;
    }

    @Override
    public boolean isOutputLastExceptionTime() {
        return this.isOutputLastExceptionTime;
    }

    @Override
    public void setOutputLastErrorTime(boolean isOutput) {
        this.isOutputLastErrorTime = isOutput;
    }

    @Override
    public boolean isOutputLastErrorTime() {
        return this.isOutputLastErrorTime;
    }

    @Override
    public void setOutputBestJournalSize(boolean isOutput) {
        this.isOutputBestJournalSize = isOutput;
    }

    @Override
    public boolean isOutputBestJournalSize() {
        return this.isOutputBestJournalSize;
    }

    @Override
    public void setOutputBestJournalSizeTime(boolean isOutput) {
        this.isOutputBestJournalSizeTime = isOutput;
    }

    @Override
    public boolean isOutputBestJournalSizeTime() {
        return this.isOutputBestJournalSizeTime;
    }

    @Override
    public void setOutputWorstJournalSize(boolean isOutput) {
        this.isOutputWorstJournalSize = isOutput;
    }

    @Override
    public boolean isOutputWorstJournalSize() {
        return this.isOutputWorstJournalSize;
    }

    @Override
    public void setOutputWorstJournalSizeTime(boolean isOutput) {
        this.isOutputWorstJournalSizeTime = isOutput;
    }

    @Override
    public boolean isOutputWorstJournalSizeTime() {
        return this.isOutputWorstJournalSizeTime;
    }

    @Override
    public void setOutputAverageJournalSize(boolean isOutput) {
        this.isOutputAverageJournalSize = isOutput;
    }

    @Override
    public boolean isOutputAverageJournalSize() {
        return this.isOutputAverageJournalSize;
    }

    @Override
    public void setOutputTimestamp(boolean isOutput) {
        this.isOutputTimestamp = isOutput;
    }

    @Override
    public boolean isOutputTimestamp() {
        return this.isOutputTimestamp;
    }

    @Override
    public void setPerformanceRecorderServiceName(ServiceName name) {
        this.performanceRecorderServiceName = name;
    }

    @Override
    public ServiceName getPerformanceRecorderServiceName() {
        return this.performanceRecorderServiceName;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    @Override
    public void createService() throws Exception {
        this.metricsInfos = Collections.synchronizedMap(new HashMap());
        this.flowAndCategoryMap = new HashMap();
    }

    @Override
    public void startService() throws Exception {
        if (this.journalServiceName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        }
        if (this.editorFinderServiceName != null) {
            this.editorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.editorFinderServiceName);
        }
        this.metricsInfos.clear();
        if (this.flowAndCategoryServiceNameMapping != null && this.flowAndCategoryServiceNameMapping.size() != 0) {
            ServiceNameEditor nameEditor = new ServiceNameEditor();
            nameEditor.setServiceManagerName(this.getServiceManagerName());
            for (String string : this.flowAndCategoryServiceNameMapping.keySet()) {
                String nameStr = this.flowAndCategoryServiceNameMapping.getProperty(string);
                nameEditor.setAsText(nameStr);
                ServiceName name = (ServiceName)nameEditor.getValue();
                Category category = (Category)ServiceManagerFactory.getServiceObject(name);
                this.flowAndCategoryMap.put(string, category);
            }
        }
        if (this.categoryServiceName != null) {
            this.metricsCategory = (Category)ServiceManagerFactory.getServiceObject(this.categoryServiceName);
        }
        if (this.performanceRecorderServiceName != null) {
            this.performanceRecorder = (PerformanceRecorder)ServiceManagerFactory.getServiceObject(this.performanceRecorderServiceName);
        }
        if (this.flowAndCategoryMap != null && this.flowAndCategoryMap.size() != 0 || this.metricsCategory != null) {
            this.writerDaemon = new Daemon(this);
            this.writerDaemon.setName("Nimbus MetricsWriteDaemon " + this.getServiceNameObject());
            this.writerDaemon.start();
        }
    }

    @Override
    public void stopService() throws Exception {
        System.out.println(this.displayMetricsInfo());
        if (this.writerDaemon != null) {
            this.writerDaemon.stop();
            this.writerDaemon = null;
        }
        this.flowAndCategoryMap.clear();
    }

    @Override
    public void destroyService() throws Exception {
        this.metricsInfos = null;
        this.flowAndCategoryMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        Object target;
        Object object;
        long start = 0L;
        boolean isError = false;
        boolean isException = false;
        try {
            object = chain.invokeNext(context);
        }
        catch (Exception e) {
            try {
                isException = true;
                throw e;
                catch (Error err) {
                    isError = true;
                    throw err;
                }
            }
            catch (Throwable throwable) {
                Object target2;
                if (this.getState() != 3) throw throwable;
                if (!this.isEnabled()) throw throwable;
                if (this.journal == null) throw throwable;
                String journalStr = this.journal.getCurrentJournalString(this.editorFinder);
                if (this.performanceRecorder != null) {
                    this.performanceRecorder.recordValue(System.currentTimeMillis(), journalStr == null ? 0L : (long)journalStr.length());
                }
                if (!((target2 = context.getTargetObject()) instanceof BeanFlowInvoker)) throw throwable;
                BeanFlowInvoker invoker = (BeanFlowInvoker)target2;
                String flow = invoker.getFlowName();
                MetricsInfo metricsInfo = null;
                Map map = this.metricsInfos;
                synchronized (map) {
                    metricsInfo = (MetricsInfo)this.metricsInfos.get(flow);
                    if (metricsInfo == null) {
                        metricsInfo = new MetricsInfo(flow, this.isCalculateOnlyNormal);
                        this.metricsInfos.put(flow, metricsInfo);
                    }
                    metricsInfo.calculate(journalStr == null ? 0L : (long)journalStr.length(), isException, isError);
                    throw throwable;
                }
            }
        }
        if (this.getState() != 3) return object;
        if (!this.isEnabled()) return object;
        if (this.journal == null) return object;
        String journalStr = this.journal.getCurrentJournalString(this.editorFinder);
        if (this.performanceRecorder != null) {
            this.performanceRecorder.recordValue(System.currentTimeMillis(), journalStr == null ? 0L : (long)journalStr.length());
        }
        if (!((target = context.getTargetObject()) instanceof BeanFlowInvoker)) return object;
        BeanFlowInvoker invoker = (BeanFlowInvoker)target;
        String flow = invoker.getFlowName();
        MetricsInfo metricsInfo = null;
        Map map = this.metricsInfos;
        synchronized (map) {
            metricsInfo = (MetricsInfo)this.metricsInfos.get(flow);
            if (metricsInfo == null) {
                metricsInfo = new MetricsInfo(flow, this.isCalculateOnlyNormal);
                this.metricsInfos.put(flow, metricsInfo);
            }
            metricsInfo.calculate(journalStr == null ? 0L : (long)journalStr.length(), isException, isError);
            return object;
        }
    }

    @Override
    public boolean onStart() {
        return true;
    }

    @Override
    public boolean onStop() {
        return true;
    }

    @Override
    public boolean onSuspend() {
        return true;
    }

    @Override
    public boolean onResume() {
        return true;
    }

    @Override
    public Object provide(DaemonControl ctrl) {
        try {
            ctrl.sleep(this.outputInterval, true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void consume(Object dequeued, DaemonControl ctrl) {
        MetricsInfo[] infos;
        Date timestamp = new Date();
        if (this.flowAndCategoryMap != null && this.flowAndCategoryMap.size() != 0) {
            for (String flow : this.flowAndCategoryMap.keySet()) {
                Category category = (Category)this.flowAndCategoryMap.get(flow);
                MetricsInfo info = (MetricsInfo)this.metricsInfos.get(flow);
                if (info == null || category == null) continue;
                try {
                    category.write(this.createRecord(timestamp, info));
                }
                catch (MessageWriteException messageWriteException) {}
            }
        }
        if (this.metricsCategory != null) {
            infos = this.metricsInfos.values().toArray(new MetricsInfo[this.metricsInfos.size()]);
            Arrays.sort(infos, COMP);
            for (int i = 0; i < infos.length; ++i) {
                try {
                    this.metricsCategory.write(this.createRecord(timestamp, i + 1, infos[i]));
                    continue;
                }
                catch (MessageWriteException messageWriteException) {
                    // empty catch block
                }
            }
        }
        if (this.isResetByOutput) {
            infos = this.metricsInfos.values().toArray(new MetricsInfo[this.metricsInfos.size()]);
            for (int i = 0; i < infos.length; ++i) {
                infos[i].reset();
            }
        }
    }

    private Map createRecord(Date timestamp, MetricsInfo info) {
        return this.createRecord(timestamp, -1, info);
    }

    private Map createRecord(Date timestamp, int order, MetricsInfo info) {
        HashMap<String, Object> record = new HashMap<String, Object>();
        if (this.isOutputTimestamp) {
            record.put("Timestamp", timestamp);
        }
        if (order > 0) {
            record.put("Order", new Integer(order));
        }
        record.put("Flow", info.getKey());
        if (this.isOutputCount) {
            record.put("Count", new Long(info.getCount()));
        }
        if (this.isOutputExceptionCount) {
            record.put("ExceptionCount", new Long(info.getExceptionCount()));
        }
        if (this.isOutputErrorCount) {
            record.put("ErrorCount", new Long(info.getErrorCount()));
        }
        if (this.isOutputLastTime) {
            record.put("LastTime", info.getLastTime() == 0L ? null : new Date(info.getLastTime()));
        }
        if (this.isOutputLastExceptionTime) {
            record.put("LastExceptionTime", info.getLastExceptionTime() == 0L ? null : new Date(info.getLastExceptionTime()));
        }
        if (this.isOutputLastErrorTime) {
            record.put("LastErrorTime", info.getLastErrorTime() == 0L ? null : new Date(info.getLastErrorTime()));
        }
        if (this.isOutputBestJournalSize) {
            record.put("BestJournalSize", new Long(info.getBestPerformance()));
        }
        if (this.isOutputBestJournalSizeTime) {
            record.put("BestJournalSizeTime", info.getBestPerformanceTime() == 0L ? null : new Date(info.getBestPerformanceTime()));
        }
        if (this.isOutputWorstJournalSize) {
            record.put("WorstJournalSize", new Long(info.getWorstPerformance()));
        }
        if (this.isOutputWorstJournalSizeTime) {
            record.put("WorstJournalSizeTime", info.getWorstPerformanceTime() == 0L ? null : new Date(info.getWorstPerformanceTime()));
        }
        if (this.isOutputAverageJournalSize) {
            record.put("AverageJournalSize", new Long(info.getAveragePerformance()));
        }
        return record;
    }

    @Override
    public void garbage() {
    }

    private static class MetricsInfoComparator
    implements Comparator {
        private MetricsInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            long sortKey2;
            MetricsInfo info1 = (MetricsInfo)o1;
            MetricsInfo info2 = (MetricsInfo)o2;
            long sortKey1 = info1.getAveragePerformance() * info1.count;
            if (sortKey1 > (sortKey2 = info2.getAveragePerformance() * info2.count)) {
                return -1;
            }
            if (sortKey1 < sortKey2) {
                return 1;
            }
            return 0;
        }
    }
}

