/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.DefaultMethodInvocationContext;
import jp.ossc.nimbus.service.aop.DefaultThreadLocalInterceptorChain;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.interceptor.ReturnInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.invoker.MethodReflectionCallInvokerService;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class ReturnInterceptorService
extends ServiceBase
implements Interceptor,
Serializable,
ReturnInterceptorServiceMBean {
    private static final long serialVersionUID = 6314705352031037858L;
    private Map returnValues;
    private Map returnServiceNames;
    private List returnConditions;
    private Object returnValue;
    private ServiceName returnServiceName;
    private Class returnInterfaceClass;
    private ServiceName interceptorChainListServiceName;
    private ProxyInvocationHandler invocationHandler;
    private Object proxy;
    private boolean isEnabled = true;

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setReturnValue(String condition, Object value) {
        if (this.returnValues == null) {
            this.returnValues = new LinkedHashMap();
        }
        this.returnValues.put(condition, value);
    }

    @Override
    public Object getReturnValue(String condition) {
        return this.returnValues == null ? null : this.returnValues.get(condition);
    }

    @Override
    public void setReturnValue(Object value) {
        this.returnValue = value;
    }

    @Override
    public Object getReturnValue() {
        return this.returnValue;
    }

    @Override
    public void setReturnServiceName(String condition, ServiceName name) {
        if (this.returnServiceNames == null) {
            this.returnServiceNames = new LinkedHashMap();
        }
        this.returnValues.put(condition, name);
    }

    @Override
    public ServiceName getReturnServiceName(String condition) {
        return this.returnServiceNames == null ? null : (ServiceName)this.returnServiceNames.get(condition);
    }

    @Override
    public void setReturnServiceName(ServiceName name) {
        this.returnServiceName = name;
    }

    @Override
    public ServiceName getReturnServiceName() {
        return this.returnServiceName;
    }

    @Override
    public void setReturnInterfaceClass(Class clazz) {
        this.returnInterfaceClass = clazz;
    }

    @Override
    public Class getReturnInterfaceClass() {
        return this.returnInterfaceClass;
    }

    @Override
    public void setInterceptorChainListServiceName(ServiceName name) {
        this.interceptorChainListServiceName = name;
    }

    @Override
    public ServiceName getInterceptorChainListServiceName() {
        return this.interceptorChainListServiceName;
    }

    @Override
    public void startService() throws Exception {
        String condition;
        if (this.returnConditions != null) {
            this.returnConditions.clear();
        }
        if (this.returnValues != null && this.returnValues.size() != 0) {
            if (this.returnConditions == null) {
                this.returnConditions = new ArrayList();
            }
            for (Map.Entry entry : this.returnValues.entrySet()) {
                condition = (String)entry.getKey();
                Object value = entry.getValue();
                this.returnConditions.add(new Condition(condition, value));
            }
        }
        if (this.returnServiceNames != null && this.returnServiceNames.size() != 0) {
            if (this.returnConditions == null) {
                this.returnConditions = new ArrayList();
            }
            for (Map.Entry entry : this.returnServiceNames.entrySet()) {
                condition = (String)entry.getKey();
                ServiceName name = (ServiceName)entry.getValue();
                this.returnConditions.add(new Condition(condition, name));
            }
        }
        if (this.returnInterfaceClass != null && this.interceptorChainListServiceName != null) {
            MethodReflectionCallInvokerService invoker = new MethodReflectionCallInvokerService();
            invoker.create();
            invoker.start();
            this.invocationHandler = new ProxyInvocationHandler(this.interceptorChainListServiceName, invoker);
            this.proxy = Proxy.newProxyInstance(NimbusClassLoader.getInstance(), new Class[]{this.returnInterfaceClass}, (InvocationHandler)this.invocationHandler);
        }
    }

    @Override
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3 && this.isEnabled) {
            if (this.returnConditions != null && this.returnConditions.size() != 0) {
                int imax = this.returnConditions.size();
                for (int i = 0; i < imax; ++i) {
                    Condition condition = (Condition)this.returnConditions.get(i);
                    if (!condition.evaluate(context)) continue;
                    return condition.getReturnValue();
                }
            }
            if (this.returnValue != null) {
                return this.returnValue;
            }
            if (this.returnServiceName != null) {
                return ServiceManagerFactory.getServiceObject(this.returnServiceName);
            }
            if (this.proxy != null && this.invocationHandler != null) {
                Object ret = chain.invokeNext(context);
                if (ret == null) {
                    return null;
                }
                this.invocationHandler.setTarget(ret);
                return this.proxy;
            }
        }
        return chain.invokeNext(context);
    }

    private static class ProxyInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 538686435253235644L;
        private final InterceptorChain chain;
        private transient ThreadLocal target = new ThreadLocal();

        public ProxyInvocationHandler(ServiceName interceptorChainListServiceName, Invoker invoker) {
            DefaultThreadLocalInterceptorChain chain = new DefaultThreadLocalInterceptorChain();
            chain.setInterceptorChainListServiceName(interceptorChainListServiceName);
            chain.setInvoker(invoker);
            this.chain = chain;
        }

        public void setTarget(Object target) {
            this.target.set(target);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            DefaultMethodInvocationContext ctx = new DefaultMethodInvocationContext(this.target.get(), method, args);
            return this.chain.invokeNext(ctx);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(this.target.get());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.target = new ThreadLocal();
            this.target.set(in.readObject());
        }
    }

    private class Condition
    implements Serializable {
        private static final long serialVersionUID = 8865216875252550610L;
        private transient List properties;
        private transient Expression expression;
        private transient List keyList;
        private String condition;
        private Object returnValue;
        private ServiceName returnServiceName;
        private static final String DELIMITER = "@";

        Condition(String cond) throws Exception {
            this.initCondition(cond);
        }

        private void initCondition(String cond) throws Exception {
            this.keyList = new ArrayList();
            this.properties = new ArrayList();
            StringTokenizer token = new StringTokenizer(cond, DELIMITER, true);
            boolean keyFlg = false;
            String beforeToken = null;
            StringBuffer condBuf = new StringBuffer();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                if (!keyFlg) {
                    if (DELIMITER.equals(str)) {
                        keyFlg = true;
                    } else {
                        condBuf.append(str);
                    }
                } else if (DELIMITER.equals(str)) {
                    keyFlg = false;
                    if (beforeToken != null) {
                        String tmpKey = "_conditionKey$" + this.keyList.size();
                        this.keyList.add(tmpKey);
                        condBuf.append(tmpKey);
                        Property prop = PropertyFactory.createProperty(beforeToken);
                        prop.setIgnoreNullProperty(true);
                        this.properties.add(prop);
                    } else {
                        condBuf.append(str);
                    }
                }
                beforeToken = str;
            }
            this.expression = ExpressionFactory.createExpression((String)condBuf.toString());
            this.evaluate("", true);
            this.condition = cond;
        }

        Condition(String cond, Object value) throws Exception {
            this(cond);
            this.returnValue = value;
        }

        Condition(String cond, ServiceName name) throws Exception {
            this(cond);
            this.returnServiceName = name;
        }

        public Object getReturnValue() {
            if (this.returnValue != null) {
                return this.returnValue;
            }
            if (this.returnServiceName != null) {
                return ServiceManagerFactory.getServiceObject(this.returnServiceName);
            }
            return null;
        }

        public boolean evaluate(Object object) {
            return this.evaluate(object, false);
        }

        protected boolean evaluate(Object object, boolean isTest) {
            JexlContext jexlContext = JexlHelper.createContext();
            int size = this.keyList.size();
            for (int i = 0; i < size; ++i) {
                String keyString = (String)this.keyList.get(i);
                Property property = (Property)this.properties.get(i);
                Object val = null;
                try {
                    val = property.getProperty(object);
                }
                catch (NoSuchPropertyException noSuchPropertyException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                jexlContext.getVars().put(keyString, val);
            }
            try {
                Object exp = this.expression.evaluate(jexlContext);
                if (exp instanceof Boolean) {
                    return (Boolean)exp;
                }
                if (exp == null && isTest) {
                    return true;
                }
                throw new IllegalArgumentException(this.expression.getExpression());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            try {
                this.initCondition(this.condition);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

