/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.HttpResponseCacheInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class HttpResponseCacheInterceptorService
extends ServletFilterInterceptorService
implements HttpResponseCacheInterceptorServiceMBean {
    private static final long serialVersionUID = -4991404172406703196L;
    private static final String DEFAULT_ENC = "ISO_8859-1";
    private boolean isContainsQuery = true;
    private ServiceName cacheMapServiceName;
    private long waitTimeout = -1L;
    private CacheMap cacheMap;
    private Map lockMap;
    private int responseStatusForCache = 200;

    @Override
    public void setCacheMapServiceName(ServiceName name) {
        this.cacheMapServiceName = name;
    }

    @Override
    public ServiceName getCacheMapServiceName() {
        return this.cacheMapServiceName;
    }

    @Override
    public void setContainsQuery(boolean isContains) {
        this.isContainsQuery = isContains;
    }

    @Override
    public boolean isContainsQuery() {
        return this.isContainsQuery;
    }

    @Override
    public void setWaitTimeout(long timeout) {
        this.waitTimeout = timeout;
    }

    @Override
    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    @Override
    public void setResponseStatusForCache(int status) {
        this.responseStatusForCache = status;
    }

    @Override
    public int getResponseStatusForCache() {
        return this.responseStatusForCache;
    }

    public void setCacheMap(CacheMap map) {
        this.cacheMap = map;
    }

    @Override
    public void createService() throws Exception {
        this.lockMap = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void startService() throws Exception {
        if (this.cacheMapServiceName != null) {
            this.cacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.cacheMapServiceName);
        }
        if (this.cacheMap == null) {
            throw new IllegalArgumentException("CacheMap is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            HttpServletRequest request = (HttpServletRequest)context.getServletRequest();
            StringBuffer pathBuf = new StringBuffer();
            String path = request.getContextPath();
            if (path != null) {
                pathBuf.append(path);
            }
            if ((path = request.getServletPath()) != null) {
                pathBuf.append(path);
            }
            if ((path = request.getPathInfo()) != null) {
                pathBuf.append(path);
            }
            if (this.isContainsQuery && (path = request.getQueryString()) != null) {
                pathBuf.append('?').append(path);
            }
            path = pathBuf.toString();
            HttpResponseCache responseCache = null;
            try {
                responseCache = this.getHttpResponseCache(path);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (responseCache != null) {
                responseCache.applyResponse(context.getServletResponse());
                return null;
            }
            SynchronizeMonitor lockMonitor = null;
            Map map = this.lockMap;
            synchronized (map) {
                lockMonitor = (SynchronizeMonitor)this.lockMap.get(path);
            }
            HttpResponseCacheHttpServletResponseWrapper responseWrapper = new HttpResponseCacheHttpServletResponseWrapper((HttpServletResponse)context.getServletResponse());
            try {
                HttpResponseCache cache;
                HttpResponseCacheHttpServletResponseWrapper rw;
                context.setServletResponse((ServletResponse)responseWrapper);
                Object ret = chain.invokeNext(context);
                ServletResponse response = context.getServletResponse();
                if (response instanceof HttpResponseCacheHttpServletResponseWrapper) {
                    rw = (HttpResponseCacheHttpServletResponseWrapper)response;
                    cache = rw.toHttpResponseCache();
                    if (this.responseStatusForCache == cache.status) {
                        this.cacheMap.put(path, cache);
                    }
                    rw.flushBuffer();
                    context.setServletResponse(rw.getResponse());
                } else {
                    while (response instanceof ServletResponseWrapper && !(response instanceof HttpResponseCacheHttpServletResponseWrapper)) {
                        response = ((ServletResponseWrapper)response).getResponse();
                    }
                    if (response instanceof HttpResponseCacheHttpServletResponseWrapper) {
                        rw = (HttpResponseCacheHttpServletResponseWrapper)response;
                        cache = rw.toHttpResponseCache();
                        if (this.responseStatusForCache == cache.status) {
                            this.cacheMap.put(path, cache);
                        }
                        rw.flushBuffer();
                    }
                }
                Object object = ret;
                return object;
            }
            finally {
                Map map2 = this.lockMap;
                synchronized (map2) {
                    this.lockMap.remove(path);
                }
                if (lockMonitor != null) {
                    lockMonitor.notifyAllMonitor();
                }
                context.setServletResponse(responseWrapper.getResponse());
            }
        }
        return chain.invokeNext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private HttpResponseCache getHttpResponseCache(String path) throws InterruptedException {
        HttpResponseCache responseCache = (HttpResponseCache)this.cacheMap.get(path);
        if (responseCache != null) {
            return responseCache;
        }
        SynchronizeMonitor waitMonitor = null;
        Map map = this.lockMap;
        // MONITORENTER : map
        waitMonitor = (SynchronizeMonitor)this.lockMap.get(path);
        if (waitMonitor == null) {
            responseCache = (HttpResponseCache)this.cacheMap.get(path);
            if (responseCache != null) {
                // MONITOREXIT : map
                return responseCache;
            }
            this.lockMap.put(path, new WaitSynchronizeMonitor());
        } else {
            waitMonitor.initMonitor();
        }
        // MONITOREXIT : map
        if (waitMonitor == null) {
            return null;
        }
        if (this.waitTimeout > 0L) {
            if (!waitMonitor.waitMonitor(this.waitTimeout)) return null;
            return this.getHttpResponseCache(path);
        }
        waitMonitor.waitMonitor();
        return this.getHttpResponseCache(path);
    }

    private static class HttpResponseCacheServletOutputStreamWrapper
    extends ServletOutputStream {
        private HttpServletResponse response;
        private ByteArrayOutputStream baos;
        private PrintStream ps;
        private ServletOutputStream sos;
        private int writeLength;

        public HttpResponseCacheServletOutputStreamWrapper(HttpServletResponse response, String charEncoding) throws IOException {
            this.response = response;
            this.baos = new ByteArrayOutputStream();
            this.ps = new PrintStream((OutputStream)this.baos, true, charEncoding == null ? HttpResponseCacheInterceptorService.DEFAULT_ENC : charEncoding);
        }

        public void write(int b) throws IOException {
            this.baos.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.baos.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.baos.write(b, off, len);
        }

        public void print(String s) throws IOException {
            this.ps.print(s);
        }

        public void print(boolean b) throws IOException {
            this.ps.print(b);
        }

        public void print(char c) throws IOException {
            this.ps.print(c);
        }

        public void print(int i) throws IOException {
            this.ps.print(i);
        }

        public void print(long l) throws IOException {
            this.ps.print(l);
        }

        public void print(float f) throws IOException {
            this.ps.print(f);
        }

        public void print(double d) throws IOException {
            this.ps.print(d);
        }

        public void println() throws IOException {
            this.ps.println();
        }

        public void println(String s) throws IOException {
            this.ps.println(s);
        }

        public void println(boolean b) throws IOException {
            this.ps.println(b);
        }

        public void println(char c) throws IOException {
            this.ps.println(c);
        }

        public void println(int i) throws IOException {
            this.ps.println(i);
        }

        public void println(long l) throws IOException {
            this.ps.println(l);
        }

        public void println(float f) throws IOException {
            this.ps.println(f);
        }

        public void println(double d) throws IOException {
            this.ps.println(d);
        }

        public void flushBuffer() throws IOException {
            this.ps.flush();
            byte[] bytes = this.baos.toByteArray();
            if (bytes != null && bytes.length != 0) {
                if (this.sos == null) {
                    this.sos = this.response.getOutputStream();
                }
                this.response.setContentLength(bytes.length);
                this.sos.write(bytes);
                this.sos.flush();
                this.writeLength += bytes.length;
            }
        }

        public byte[] getBytes() throws IOException {
            this.ps.flush();
            return this.baos.toByteArray();
        }

        public int getWriteLength() {
            return this.writeLength;
        }

        public void close() throws IOException {
            this.flush();
            this.ps.close();
            this.baos.close();
            if (this.sos != null) {
                this.sos.close();
            }
            super.close();
        }
    }

    private static class HttpResponseCacheHttpServletResponseWrapper
    extends HttpServletResponseWrapper {
        private ServletOutputStream sos;
        private PrintWriter pw;
        private HttpResponseCache responseCache = new HttpResponseCache();

        public HttpResponseCacheHttpServletResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void setCharacterEncoding(String charset) {
            super.setCharacterEncoding(charset);
            this.responseCache.characterEncoding = charset;
        }

        public void setContentType(String type) {
            super.setContentType(type);
            this.responseCache.contentType = type;
        }

        public void setLocale(Locale loc) {
            super.setLocale(loc);
            this.responseCache.locale = loc;
        }

        public void addDateHeader(String name, long date) {
            super.addDateHeader(name, date);
            this.responseCache.addHeader(name, new Long(date));
        }

        public void addHeader(String name, String value) {
            super.addHeader(name, value);
            this.responseCache.addHeader(name, value);
        }

        public void addIntHeader(String name, int value) {
            super.addIntHeader(name, value);
            this.responseCache.addHeader(name, new Integer(value));
        }

        public void setDateHeader(String name, long date) {
            super.setDateHeader(name, date);
            this.responseCache.setHeader(name, new Long(date));
        }

        public void setHeader(String name, String value) {
            super.setHeader(name, value);
            this.responseCache.setHeader(name, value);
        }

        public void setIntHeader(String name, int value) {
            super.setIntHeader(name, value);
            this.responseCache.setHeader(name, new Integer(value));
        }

        public void sendError(int sc) throws IOException {
            this.responseCache.isError = true;
            this.responseCache.status = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.responseCache.isError = true;
            this.responseCache.status = sc;
            this.responseCache.message = msg;
            super.sendError(sc, msg);
        }

        public void sendRedirect(String location) throws IOException {
            this.responseCache.redirectLocation = location;
            super.sendRedirect(location);
        }

        public void setStatus(int sc) {
            this.responseCache.status = sc;
            super.setStatus(sc);
        }

        public void setStatus(int sc, String sm) {
            this.responseCache.status = sc;
            this.responseCache.message = sm;
            super.setStatus(sc, sm);
        }

        public HttpResponseCache toHttpResponseCache() throws IOException {
            HttpResponseCacheServletOutputStreamWrapper osw = (HttpResponseCacheServletOutputStreamWrapper)this.getOutputStream();
            this.responseCache.bytes = osw.getBytes();
            return this.responseCache;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.sos != null) {
                return this.sos;
            }
            String charEncoding = this.getCharacterEncoding();
            this.sos = new HttpResponseCacheServletOutputStreamWrapper((HttpServletResponse)this.getResponse(), charEncoding == null ? HttpResponseCacheInterceptorService.DEFAULT_ENC : charEncoding);
            return this.sos;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.pw == null) {
                String charEncoding = this.getCharacterEncoding();
                this.pw = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), charEncoding == null ? HttpResponseCacheInterceptorService.DEFAULT_ENC : charEncoding));
            }
            return this.pw;
        }

        public void flushBuffer() throws IOException {
            if (this.sos instanceof HttpResponseCacheServletOutputStreamWrapper) {
                ((HttpResponseCacheServletOutputStreamWrapper)this.sos).flushBuffer();
                this.setContentLength(((HttpResponseCacheServletOutputStreamWrapper)this.sos).getWriteLength());
            }
            super.flushBuffer();
        }
    }

    private static class HttpResponseCache
    implements Serializable {
        private static final long serialVersionUID = -7716787591583638107L;
        public String characterEncoding;
        public String contentType;
        public Locale locale;
        public String redirectLocation;
        public Map headerMap;
        public byte[] bytes;
        public boolean isError;
        public int status = 200;
        public String message;

        private HttpResponseCache() {
        }

        public void addHeader(String name, Object value) {
            ArrayList<Object> values;
            if (this.headerMap == null) {
                this.headerMap = new HashMap();
            }
            if ((values = (ArrayList<Object>)this.headerMap.get(name)) == null) {
                values = new ArrayList<Object>();
                this.headerMap.put(name, values);
            }
            values.add(value);
        }

        public void setHeader(String name, Object value) {
            ArrayList<Object> values;
            if (this.headerMap == null) {
                this.headerMap = new HashMap();
            }
            if ((values = (ArrayList<Object>)this.headerMap.get(name)) == null) {
                values = new ArrayList<Object>();
                this.headerMap.put(name, values);
            } else {
                values.clear();
            }
            values.add(value);
        }

        public void applyResponse(ServletResponse response) throws IOException {
            if (this.characterEncoding != null) {
                response.setCharacterEncoding(this.characterEncoding);
            }
            if (this.contentType != null) {
                response.setContentType(this.contentType);
            }
            if (this.locale != null) {
                response.setLocale(this.locale);
            }
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpRes = (HttpServletResponse)response;
                if (this.headerMap != null) {
                    for (Map.Entry entry : this.headerMap.entrySet()) {
                        String name = (String)entry.getKey();
                        List values = (List)entry.getValue();
                        int imax = values.size();
                        for (int i = 0; i < imax; ++i) {
                            Object value = values.get(i);
                            if (value instanceof Integer) {
                                httpRes.addIntHeader(name, ((Integer)value).intValue());
                                continue;
                            }
                            if (value instanceof Long) {
                                httpRes.addDateHeader(name, ((Long)value).longValue());
                                continue;
                            }
                            httpRes.addHeader(name, (String)value);
                        }
                    }
                }
                if (this.isError) {
                    if (this.message == null) {
                        httpRes.sendError(this.status);
                    } else {
                        httpRes.sendError(this.status, this.message);
                    }
                } else {
                    if (this.redirectLocation != null) {
                        httpRes.sendRedirect(this.redirectLocation);
                        return;
                    }
                    if (this.status != 0) {
                        if (this.message == null) {
                            httpRes.setStatus(this.status);
                        } else {
                            httpRes.setStatus(this.status, this.message);
                        }
                    }
                }
            }
            if (this.bytes != null && this.bytes.length != 0) {
                response.setContentLength(this.bytes.length);
                response.getOutputStream().write(this.bytes, 0, this.bytes.length);
            }
        }
    }
}

