/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.SelectableServletFilterInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;

public class SelectableServletFilterInterceptorService
extends ServletFilterInterceptorService
implements SelectableServletFilterInterceptorServiceMBean {
    private static final long serialVersionUID = 6609672536666072027L;
    protected String[] urlAndInterceptorServiceNameMapping;
    protected Map urlAndInterceptorServiceNameMap;
    protected String[] uriAndInterceptorServiceNameMapping;
    protected Map uriAndInterceptorServiceNameMap;
    protected String[] pathAndInterceptorServiceNameMapping;
    protected Map pathAndInterceptorServiceNameMap;

    @Override
    public void setURLAndInterceptorServiceNameMapping(String[] mapping) {
        this.urlAndInterceptorServiceNameMapping = mapping;
    }

    @Override
    public String[] getURLAndInterceptorServiceNameMapping() {
        return this.urlAndInterceptorServiceNameMapping;
    }

    @Override
    public void setURIAndInterceptorServiceNameMapping(String[] mapping) {
        this.uriAndInterceptorServiceNameMapping = mapping;
    }

    @Override
    public String[] getURIAndInterceptorServiceNameMapping() {
        return this.uriAndInterceptorServiceNameMapping;
    }

    @Override
    public void setPathAndInterceptorServiceNameMapping(String[] mapping) {
        this.pathAndInterceptorServiceNameMapping = mapping;
    }

    @Override
    public String[] getPathAndInterceptorServiceNameMapping() {
        return this.pathAndInterceptorServiceNameMapping;
    }

    @Override
    public void createService() throws Exception {
        this.urlAndInterceptorServiceNameMap = new LinkedHashMap();
        this.uriAndInterceptorServiceNameMap = new LinkedHashMap();
        this.pathAndInterceptorServiceNameMap = new LinkedHashMap();
    }

    @Override
    public void startService() throws Exception {
        int index;
        int i;
        super.preStartService();
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setServiceManagerName(this.getServiceManagerName());
        if (this.urlAndInterceptorServiceNameMapping != null && this.urlAndInterceptorServiceNameMapping.length != 0) {
            for (i = 0; i < this.urlAndInterceptorServiceNameMapping.length; ++i) {
                index = this.urlAndInterceptorServiceNameMapping[i].lastIndexOf(61);
                if (index == this.urlAndInterceptorServiceNameMapping[i].length() - 1 || index == -1) {
                    throw new IllegalArgumentException("Invalid format : " + this.urlAndInterceptorServiceNameMapping[i]);
                }
                editor.setAsText(this.urlAndInterceptorServiceNameMapping[i].substring(index + 1));
                this.urlAndInterceptorServiceNameMap.put(Pattern.compile(this.urlAndInterceptorServiceNameMapping[i].substring(0, index)), editor.getValue());
            }
        }
        if (this.uriAndInterceptorServiceNameMapping != null && this.uriAndInterceptorServiceNameMapping.length != 0) {
            for (i = 0; i < this.uriAndInterceptorServiceNameMapping.length; ++i) {
                index = this.uriAndInterceptorServiceNameMapping[i].lastIndexOf(61);
                if (index == this.uriAndInterceptorServiceNameMapping[i].length() - 1 || index == -1) {
                    throw new IllegalArgumentException("Invalid format : " + this.uriAndInterceptorServiceNameMapping[i]);
                }
                editor.setAsText(this.uriAndInterceptorServiceNameMapping[i].substring(index + 1));
                this.uriAndInterceptorServiceNameMap.put(Pattern.compile(this.uriAndInterceptorServiceNameMapping[i].substring(0, index)), editor.getValue());
            }
        }
        if (this.pathAndInterceptorServiceNameMapping != null && this.pathAndInterceptorServiceNameMapping.length != 0) {
            for (i = 0; i < this.pathAndInterceptorServiceNameMapping.length; ++i) {
                index = this.pathAndInterceptorServiceNameMapping[i].lastIndexOf(61);
                if (index == this.pathAndInterceptorServiceNameMapping[i].length() - 1 || index == -1) {
                    throw new IllegalArgumentException("Invalid format : " + this.pathAndInterceptorServiceNameMapping[i]);
                }
                editor.setAsText(this.pathAndInterceptorServiceNameMapping[i].substring(index + 1));
                this.pathAndInterceptorServiceNameMap.put(Pattern.compile(this.pathAndInterceptorServiceNameMapping[i].substring(0, index)), editor.getValue());
            }
        }
    }

    @Override
    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        ServletRequest request = context.getServletRequest();
        if (request instanceof HttpServletRequest) {
            String reqURI;
            String reqURL;
            Interceptor interceptor;
            HttpServletRequest httpReq = (HttpServletRequest)request;
            if (this.urlAndInterceptorServiceNameMap != null && this.urlAndInterceptorServiceNameMap.size() != 0 && (interceptor = this.getInterceptor(reqURL = httpReq.getRequestURL().toString(), this.urlAndInterceptorServiceNameMap)) != null) {
                return interceptor.invoke(context, chain);
            }
            if (this.uriAndInterceptorServiceNameMap != null && this.uriAndInterceptorServiceNameMap.size() != 0 && (interceptor = this.getInterceptor(reqURI = httpReq.getRequestURI().toString(), this.uriAndInterceptorServiceNameMap)) != null) {
                return interceptor.invoke(context, chain);
            }
            if (this.pathAndInterceptorServiceNameMap != null && this.pathAndInterceptorServiceNameMap.size() != 0) {
                String reqPath = httpReq.getServletPath();
                if (httpReq.getPathInfo() != null) {
                    reqPath = reqPath + httpReq.getPathInfo();
                }
                if ((interceptor = this.getInterceptor(reqPath, this.pathAndInterceptorServiceNameMap)) != null) {
                    return interceptor.invoke(context, chain);
                }
            }
        }
        return chain.invokeNext(context);
    }

    protected Interceptor getInterceptor(String target, Map patternMap) {
        for (Pattern pattern : patternMap.keySet()) {
            Matcher m = pattern.matcher(target);
            if (!m.matches()) continue;
            ServiceName name = (ServiceName)patternMap.get(pattern);
            try {
                return (Interceptor)ServiceManagerFactory.getServiceObject(name);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
            }
        }
        return null;
    }
}

