/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.InputExchangeException;
import jp.ossc.nimbus.service.aop.interceptor.servlet.OutputExchangeException;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.service.aop.interceptor.servlet.StreamExchangeInterceptorServiceMBean;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.servlet.BeanFlowSelector;
import jp.ossc.nimbus.servlet.DefaultBeanFlowSelectorService;
import jp.ossc.nimbus.util.converter.BindingStreamConverter;
import jp.ossc.nimbus.util.converter.StreamConverter;
import jp.ossc.nimbus.util.converter.StreamStringConverter;

public class StreamExchangeInterceptorService
extends ServletFilterInterceptorService
implements StreamExchangeInterceptorServiceMBean {
    private static final long serialVersionUID = 7618395554145055608L;
    protected static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    protected static final String CONTENT_ENCODING_DEFLATE = "deflate";
    protected static final String CONTENT_ENCODING_GZIP = "gzip";
    protected static final String CONTENT_ENCODING_X_GZIP = "x-gzip";
    protected ServiceName requestStreamConverterServiceName;
    protected StreamConverter requestStreamConverter;
    protected ServiceName responseStreamConverterServiceName;
    protected StreamConverter responseStreamConverter;
    protected ServiceName threadContextServiceName;
    protected Context threadContext;
    protected ServiceName journalServiceName;
    protected Journal journal;
    protected ServiceName exchangeEditorFinderServiceName;
    protected EditorFinder exchangeEditorFinder;
    protected ServiceName exchangeRequestEditorFinderServiceName;
    protected EditorFinder exchangeRequestEditorFinder;
    protected ServiceName exchangeResponseEditorFinderServiceName;
    protected EditorFinder exchangeResponseEditorFinder;
    protected ServiceName requestBytesEditorFinderServiceName;
    protected EditorFinder requestBytesEditorFinder;
    protected ServiceName requestObjectEditorFinderServiceName;
    protected EditorFinder requestObjectEditorFinder;
    protected ServiceName responseBytesEditorFinderServiceName;
    protected EditorFinder responseBytesEditorFinder;
    protected ServiceName responseObjectEditorFinderServiceName;
    protected EditorFinder responseObjectEditorFinder;
    protected ServiceName exceptionEditorFinderServiceName;
    protected EditorFinder exceptionEditorFinder;
    protected String responseContentType;
    protected String requestObjectAttributeName = DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME;
    protected String responseObjectAttributeName = DEFAULT_RESPONSE_OBJECT_ATTRIBUTE_NAME;
    protected String requestObjectContextKey = DEFAULT_REQUEST_OBJECT_CONTEXT_KEY;
    protected String responseObjectContextKey = DEFAULT_RESPONSE_OBJECT_CONTEXT_KEY;
    protected boolean isRequestStreamInflate = true;
    protected String exchangeJournalKey = "Exchange";
    protected String exchangeRequestJournalKey = "Request";
    protected String exchangeResponseJournalKey = "Response";
    protected String requestBytesJournalKey = "RequestBytes";
    protected String requestObjectJournalKey = "RequestObject";
    protected String responseBytesJournalKey = "ResponseBytes";
    protected String responseObjectJournalKey = "ResponseObject";
    protected String exceptionJournalKey = "Exception";
    protected ServiceName beanFlowInvokerFactoryServiceName;
    protected BeanFlowInvokerFactory beanFlowInvokerFactory;
    protected ServiceName beanFlowSelectorServiceName;
    protected BeanFlowSelector beanFlowSelector;
    protected Map requestObjectTypeMap;
    protected String requestObjectFlowNamePrefix = "request";

    @Override
    public void setRequestStreamConverterServiceName(ServiceName name) {
        this.requestStreamConverterServiceName = name;
    }

    @Override
    public ServiceName getRequestStreamConverterServiceName() {
        return this.requestStreamConverterServiceName;
    }

    @Override
    public void setResponseStreamConverterServiceName(ServiceName name) {
        this.responseStreamConverterServiceName = name;
    }

    @Override
    public ServiceName getResponseStreamConverterServiceName() {
        return this.responseStreamConverterServiceName;
    }

    @Override
    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    @Override
    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    @Override
    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    @Override
    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    @Override
    public void setExchangeEditorFinderServiceName(ServiceName name) {
        this.exchangeEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getExchangeEditorFinderServiceName() {
        return this.exchangeEditorFinderServiceName;
    }

    @Override
    public void setExchangeRequestEditorFinderServiceName(ServiceName name) {
        this.exchangeRequestEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getExchangeRequestEditorFinderServiceName() {
        return this.exchangeRequestEditorFinderServiceName;
    }

    @Override
    public void setExchangeResponseEditorFinderServiceName(ServiceName name) {
        this.exchangeResponseEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getExchangeResponseEditorFinderServiceName() {
        return this.exchangeResponseEditorFinderServiceName;
    }

    @Override
    public void setRequestBytesEditorFinderServiceName(ServiceName name) {
        this.requestBytesEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getRequestBytesEditorFinderServiceName() {
        return this.requestBytesEditorFinderServiceName;
    }

    @Override
    public void setRequestObjectEditorFinderServiceName(ServiceName name) {
        this.requestObjectEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getRequestObjectEditorFinderServiceName() {
        return this.requestObjectEditorFinderServiceName;
    }

    @Override
    public void setResponseBytesEditorFinderServiceName(ServiceName name) {
        this.responseBytesEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getResponseBytesEditorFinderServiceName() {
        return this.responseBytesEditorFinderServiceName;
    }

    @Override
    public void setResponseObjectEditorFinderServiceName(ServiceName name) {
        this.responseObjectEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getResponseObjectEditorFinderServiceName() {
        return this.responseObjectEditorFinderServiceName;
    }

    @Override
    public void setExceptionEditorFinderServiceName(ServiceName name) {
        this.exceptionEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getExceptionEditorFinderServiceName() {
        return this.exceptionEditorFinderServiceName;
    }

    @Override
    public void setResponseContentType(String type) {
        this.responseContentType = type;
    }

    @Override
    public String getResponseContentType() {
        return this.responseContentType;
    }

    @Override
    public void setRequestObjectAttributeName(String name) {
        this.requestObjectAttributeName = name;
    }

    @Override
    public String getRequestObjectAttributeName() {
        return this.requestObjectAttributeName;
    }

    @Override
    public void setResponseObjectAttributeName(String name) {
        this.responseObjectAttributeName = name;
    }

    @Override
    public String getResponseObjectAttributeName() {
        return this.responseObjectAttributeName;
    }

    @Override
    public void setRequestObjectContextKey(String key) {
        this.requestObjectContextKey = key;
    }

    @Override
    public String getRequestObjectContextKey() {
        return this.requestObjectContextKey;
    }

    @Override
    public void setResponseObjectContextKey(String key) {
        this.responseObjectContextKey = key;
    }

    @Override
    public String getResponseObjectContextKey() {
        return this.responseObjectContextKey;
    }

    @Override
    public void setRequestStreamInflate(boolean isInflate) {
        this.isRequestStreamInflate = isInflate;
    }

    @Override
    public boolean isRequestStreamInflate() {
        return this.isRequestStreamInflate;
    }

    @Override
    public void setExchangeJournalKey(String key) {
        this.exchangeJournalKey = key;
    }

    @Override
    public String getExchangeJournalKey() {
        return this.exchangeJournalKey;
    }

    @Override
    public void setExchangeRequestJournalKey(String key) {
        this.exchangeRequestJournalKey = key;
    }

    @Override
    public String getExchangeRequestJournalKey() {
        return this.exchangeRequestJournalKey;
    }

    @Override
    public void setExchangeResponseJournalKey(String key) {
        this.exchangeResponseJournalKey = key;
    }

    @Override
    public String getExchangeResponseJournalKey() {
        return this.exchangeResponseJournalKey;
    }

    @Override
    public void setRequestBytesJournalKey(String key) {
        this.requestBytesJournalKey = key;
    }

    @Override
    public String getRequestBytesJournalKey() {
        return this.requestBytesJournalKey;
    }

    @Override
    public void setRequestObjectJournalKey(String key) {
        this.requestObjectJournalKey = key;
    }

    @Override
    public String getRequestObjectJournalKey() {
        return this.requestObjectJournalKey;
    }

    @Override
    public void setResponseBytesJournalKey(String key) {
        this.responseBytesJournalKey = key;
    }

    @Override
    public String getResponseBytesJournalKey() {
        return this.responseBytesJournalKey;
    }

    @Override
    public void setResponseObjectJournalKey(String key) {
        this.responseObjectJournalKey = key;
    }

    @Override
    public String getResponseObjectJournalKey() {
        return this.responseObjectJournalKey;
    }

    @Override
    public void setExceptionJournalKey(String key) {
        this.exceptionJournalKey = key;
    }

    @Override
    public String getExceptionJournalKey() {
        return this.exceptionJournalKey;
    }

    public Map getRequestObjectTypeMap() {
        return this.requestObjectTypeMap;
    }

    @Override
    public void setBeanFlowInvokerFactoryServiceName(ServiceName name) {
        this.beanFlowInvokerFactoryServiceName = name;
    }

    @Override
    public ServiceName getBeanFlowInvokerFactoryServiceName() {
        return this.beanFlowInvokerFactoryServiceName;
    }

    @Override
    public void setRequestObjectFlowNamePrefix(String prefix) {
        this.requestObjectFlowNamePrefix = prefix;
    }

    @Override
    public String getRequestObjectFlowNamePrefix() {
        return this.requestObjectFlowNamePrefix;
    }

    @Override
    public void setBeanFlowSelectorServiceName(ServiceName name) {
        this.beanFlowSelectorServiceName = name;
    }

    @Override
    public ServiceName getBeanFlowSelectorServiceName() {
        return this.beanFlowSelectorServiceName;
    }

    @Override
    public void createService() throws Exception {
        this.requestObjectTypeMap = new HashMap();
    }

    @Override
    public void startService() throws Exception {
        if (this.requestStreamConverterServiceName == null && this.requestStreamConverter == null && this.responseStreamConverterServiceName == null && this.responseStreamConverter == null) {
            throw new IllegalArgumentException("It is necessary to specify RequestStreamConverterServiceName or RequestStreamConverter or ResponseStreamConverterServiceName or ResponseStreamConverter.");
        }
        if (this.requestStreamConverterServiceName != null) {
            this.requestStreamConverter = (StreamConverter)ServiceManagerFactory.getServiceObject(this.requestStreamConverterServiceName);
        }
        if (this.responseStreamConverterServiceName != null) {
            this.responseStreamConverter = (StreamConverter)ServiceManagerFactory.getServiceObject(this.responseStreamConverterServiceName);
        }
        if (this.threadContextServiceName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        }
        if (this.journalServiceName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        }
        if (this.exchangeEditorFinderServiceName != null) {
            this.exchangeEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.exchangeEditorFinderServiceName);
        }
        if (this.exchangeRequestEditorFinderServiceName != null) {
            this.exchangeRequestEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.exchangeRequestEditorFinderServiceName);
        }
        if (this.exchangeResponseEditorFinderServiceName != null) {
            this.exchangeResponseEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.exchangeResponseEditorFinderServiceName);
        }
        if (this.requestBytesEditorFinderServiceName != null) {
            this.requestBytesEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.requestBytesEditorFinderServiceName);
        }
        if (this.requestObjectEditorFinderServiceName != null) {
            this.requestObjectEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.requestObjectEditorFinderServiceName);
        }
        if (this.responseBytesEditorFinderServiceName != null) {
            this.responseBytesEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.responseBytesEditorFinderServiceName);
        }
        if (this.responseObjectEditorFinderServiceName != null) {
            this.responseObjectEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.responseObjectEditorFinderServiceName);
        }
        if (this.exceptionEditorFinderServiceName != null) {
            this.exceptionEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.exceptionEditorFinderServiceName);
        }
        if (this.beanFlowInvokerFactoryServiceName != null) {
            this.beanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
        }
        if (this.beanFlowInvokerFactory != null) {
            if (this.beanFlowSelectorServiceName != null) {
                this.beanFlowSelector = (BeanFlowSelector)ServiceManagerFactory.getServiceObject(this.beanFlowSelectorServiceName);
            }
            if (this.beanFlowSelector == null) {
                this.beanFlowSelector = new DefaultBeanFlowSelectorService();
                ((DefaultBeanFlowSelectorService)this.beanFlowSelector).create();
                ((DefaultBeanFlowSelectorService)this.beanFlowSelector).start();
            }
        }
    }

    @Override
    public void destroyService() throws Exception {
        this.requestObjectTypeMap = null;
    }

    public void setRequestObjectType(String path, Object type) {
        if (!(type instanceof Class) && !(type instanceof Cloneable)) {
            throw new IllegalArgumentException("Not cloneable. type=" + type);
        }
        this.requestObjectTypeMap.put(path, type);
    }

    public void setBeanFlowInvokerFactory(BeanFlowInvokerFactory factory) {
        this.beanFlowInvokerFactory = factory;
    }

    public void setBeanFlowSelector(BeanFlowSelector selector) {
        this.beanFlowSelector = selector;
    }

    public void setRequestStreamConverter(StreamConverter conv) {
        this.requestStreamConverter = conv;
    }

    public StreamConverter getRequestStreamConverter() {
        return this.requestStreamConverter;
    }

    public void setResponseStreamConverter(StreamConverter conv) {
        this.responseStreamConverter = conv;
    }

    public StreamConverter getResponseStreamConverter() {
        return this.responseStreamConverter;
    }

    public void setThreadContext(Context context) {
        this.threadContext = context;
    }

    public Context getThreadContext() {
        return this.threadContext;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setExchangeEditorFinder(EditorFinder finder) {
        this.exchangeEditorFinder = finder;
    }

    public EditorFinder getExchangeEditorFinder() {
        return this.exchangeEditorFinder;
    }

    public void setExchangeRequestEditorFinder(EditorFinder finder) {
        this.exchangeRequestEditorFinder = finder;
    }

    public EditorFinder getExchangeRequestEditorFinder() {
        return this.exchangeRequestEditorFinder;
    }

    public void setExchangeResponseEditorFinder(EditorFinder finder) {
        this.exchangeResponseEditorFinder = finder;
    }

    public EditorFinder getExchangeResponseEditorFinder() {
        return this.exchangeResponseEditorFinder;
    }

    public void setRequestBytesEditorFinder(EditorFinder finder) {
        this.requestBytesEditorFinder = finder;
    }

    public EditorFinder getRequestBytesEditorFinder() {
        return this.requestBytesEditorFinder;
    }

    public void setRequestObjectEditorFinder(EditorFinder finder) {
        this.requestObjectEditorFinder = finder;
    }

    public EditorFinder getRequestObjectEditorFinder() {
        return this.requestObjectEditorFinder;
    }

    public void setResponseBytesEditorFinder(EditorFinder finder) {
        this.responseBytesEditorFinder = finder;
    }

    public EditorFinder getResponseBytesEditorFinder() {
        return this.responseBytesEditorFinder;
    }

    public void setResponseObjectEditorFinder(EditorFinder finder) {
        this.responseObjectEditorFinder = finder;
    }

    public EditorFinder getResponseObjectEditorFinder() {
        return this.responseObjectEditorFinder;
    }

    public void setExceptionEditorFinder(EditorFinder finder) {
        this.exceptionEditorFinder = finder;
    }

    public EditorFinder getExceptionEditorFinder() {
        return this.exceptionEditorFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() != 3) {
            return chain.invokeNext(context);
        }
        try {
            ServletResponse response;
            if (this.journal != null) {
                this.journal.startJournal(this.exchangeJournalKey, this.exchangeEditorFinder);
            }
            ServletRequest request = context.getServletRequest();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[2048];
            if (this.requestStreamConverter != null) {
                try {
                    if (this.journal != null) {
                        this.journal.addStartStep(this.exchangeRequestJournalKey, this.exchangeRequestEditorFinder);
                    }
                    ServletInputStream sis = request.getInputStream();
                    try {
                        int size = 0;
                        while ((size = sis.read(bytes)) != -1) {
                            baos.write(bytes, 0, size);
                        }
                    }
                    finally {
                        if (sis != null) {
                            sis.close();
                        }
                    }
                    if (this.journal != null) {
                        this.journal.addInfo(this.requestBytesJournalKey, (Object)baos.toByteArray(), this.requestBytesEditorFinder);
                    }
                    InputStream is = new ByteArrayInputStream(baos.toByteArray());
                    if (this.isRequestStreamInflate && request instanceof HttpServletRequest) {
                        is = this.decompress((HttpServletRequest)request, is);
                    }
                    StreamConverter rsc = this.requestStreamConverter;
                    if (request.getCharacterEncoding() != null && rsc instanceof StreamStringConverter && !request.getCharacterEncoding().equals(((StreamStringConverter)rsc).getCharacterEncodingToObject())) {
                        rsc = ((StreamStringConverter)rsc).cloneCharacterEncodingToObject(request.getCharacterEncoding());
                    }
                    Object requestObj = null;
                    if (rsc instanceof BindingStreamConverter && request instanceof HttpServletRequest) {
                        HttpServletRequest httpReq = (HttpServletRequest)request;
                        if (this.requestObjectTypeMap.size() != 0) {
                            String reqPath = httpReq.getServletPath();
                            if (httpReq.getPathInfo() != null) {
                                reqPath = reqPath + httpReq.getPathInfo();
                            }
                            if (!((requestObj = this.requestObjectTypeMap.get(reqPath)) instanceof Class)) {
                                requestObj = requestObj instanceof DataSet ? ((DataSet)requestObj).cloneSchema() : (requestObj instanceof RecordList ? ((RecordList)requestObj).cloneSchema() : (requestObj instanceof Record ? ((Record)requestObj).cloneSchema() : requestObj.getClass().getMethod("clone", null).invoke(requestObj, (Object[])null)));
                            }
                        }
                        if (requestObj == null && this.beanFlowInvokerFactory != null) {
                            String requestObjectFlowName = this.beanFlowSelector.selectBeanFlow(httpReq);
                            if (this.requestObjectFlowNamePrefix != null) {
                                requestObjectFlowName = this.requestObjectFlowNamePrefix + requestObjectFlowName;
                            }
                            if (this.beanFlowInvokerFactory.containsFlow(requestObjectFlowName)) {
                                BeanFlowInvoker beanFlowInvoker = this.beanFlowInvokerFactory.createFlow(requestObjectFlowName);
                                requestObj = beanFlowInvoker.invokeFlow(context);
                            }
                        }
                        requestObj = ((BindingStreamConverter)rsc).convertToObject(is, requestObj);
                    } else {
                        requestObj = rsc.convertToObject(is);
                    }
                    if (this.journal != null) {
                        this.journal.addInfo(this.requestObjectJournalKey, requestObj, this.requestObjectEditorFinder);
                    }
                    request.setAttribute(this.requestObjectAttributeName, requestObj);
                    if (this.threadContext != null) {
                        this.threadContext.put(this.requestObjectContextKey, requestObj);
                    }
                }
                catch (Exception e) {
                    if (this.journal != null) {
                        this.journal.addInfo(this.exceptionJournalKey, (Object)e, this.exceptionEditorFinder);
                    }
                    throw new InputExchangeException(e);
                }
                catch (Throwable th) {
                    if (this.journal != null) {
                        this.journal.addInfo(this.exceptionJournalKey, (Object)th, this.exceptionEditorFinder);
                    }
                    throw th;
                }
                finally {
                    if (this.journal != null) {
                        this.journal.addEndStep();
                    }
                }
            }
            Object ret = chain.invokeNext(context);
            if (this.responseStreamConverter != null && !(response = context.getServletResponse()).isCommitted()) {
                try {
                    Object responseObj;
                    if (this.journal != null) {
                        this.journal.addStartStep(this.exchangeResponseJournalKey, this.exchangeResponseEditorFinder);
                    }
                    if (this.responseContentType != null) {
                        response.setContentType(this.responseContentType);
                    }
                    if ((responseObj = request.getAttribute(this.responseObjectAttributeName)) == null && this.threadContext != null) {
                        responseObj = this.threadContext.get(this.responseObjectContextKey);
                    }
                    if (this.journal != null) {
                        this.journal.addInfo(this.responseObjectJournalKey, responseObj, this.responseObjectEditorFinder);
                    }
                    if (responseObj != null) {
                        StreamConverter rsc = this.responseStreamConverter;
                        if (response.getCharacterEncoding() != null && rsc instanceof StreamStringConverter && !response.getCharacterEncoding().equals(((StreamStringConverter)rsc).getCharacterEncodingToStream())) {
                            rsc = ((StreamStringConverter)rsc).cloneCharacterEncodingToStream(response.getCharacterEncoding());
                        }
                        InputStream is = rsc.convertToStream(responseObj);
                        ServletOutputStream sos = response.getOutputStream();
                        int readLen = 0;
                        baos.reset();
                        while ((readLen = is.read(bytes)) != -1) {
                            baos.write(bytes, 0, readLen);
                            sos.write(bytes, 0, readLen);
                        }
                        if (this.journal != null) {
                            this.journal.addInfo(this.responseBytesJournalKey, (Object)baos.toByteArray(), this.responseBytesEditorFinder);
                        }
                    }
                }
                catch (Exception e) {
                    if (this.journal != null) {
                        this.journal.addInfo(this.exceptionJournalKey, (Object)e, this.exceptionEditorFinder);
                    }
                    throw new OutputExchangeException(e);
                }
                catch (Throwable th) {
                    if (this.journal != null) {
                        this.journal.addInfo(this.exceptionJournalKey, (Object)th, this.exceptionEditorFinder);
                    }
                    throw th;
                }
                finally {
                    if (this.journal != null) {
                        this.journal.addEndStep();
                    }
                }
            }
            Object object = ret;
            return object;
        }
        catch (Throwable th) {
            if (this.journal != null) {
                this.journal.addInfo(this.exceptionJournalKey, (Object)th, this.exceptionEditorFinder);
            }
            throw th;
        }
        finally {
            if (this.journal != null) {
                this.journal.endJournal();
            }
        }
    }

    protected InputStream decompress(HttpServletRequest request, InputStream is) throws IOException {
        Enumeration encodeEnum = request.getHeaders(HEADER_CONTENT_ENCODING);
        if (encodeEnum == null || !encodeEnum.hasMoreElements()) {
            return is;
        }
        InputStream in = is;
        ArrayList encodes = new ArrayList();
        while (encodeEnum.hasMoreElements()) {
            encodes.add(encodeEnum.nextElement());
        }
        for (int i = encodes.size() - 1; i >= 0; --i) {
            String encode = (String)encodes.get(i);
            if (encode == null) continue;
            if (encode.indexOf(CONTENT_ENCODING_DEFLATE) != -1) {
                in = new InflaterInputStream(in);
                continue;
            }
            if (encode.indexOf(CONTENT_ENCODING_GZIP) != -1 || encode.indexOf(CONTENT_ENCODING_X_GZIP) != -1) {
                in = new GZIPInputStream(in);
                continue;
            }
            throw new IOException("Can not decompress. [" + encode + "]");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        int length = 0;
        while ((length = in.read(bytes)) != -1) {
            baos.write(bytes, 0, length);
        }
        byte[] outputBytes = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(outputBytes);
        return bais;
    }
}

