/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.beancontrol;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.beancontrol.BeanFlowCoverage;
import jp.ossc.nimbus.service.beancontrol.BeanFlowCoverageRepoter;
import jp.ossc.nimbus.service.beancontrol.HtmlBeanFlowCoverageRepoterServiceMBean;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.util.converter.PaddingStringConverter;
import jp.ossc.nimbus.util.converter.StringConverter;

public class HtmlBeanFlowCoverageRepoterService
extends ServiceBase
implements BeanFlowCoverageRepoter,
HtmlBeanFlowCoverageRepoterServiceMBean {
    private static final long serialVersionUID = -4272153017484182793L;
    private ServiceName beanFlowInvokerFactoryServiceName;
    private BeanFlowInvokerFactory beanFlowInvokerFactory;
    private boolean isReportOnStop;
    private File outputPath;
    private String characterEncoding = "UTF-8";
    private final int graphWidth = 620;

    @Override
    public ServiceName getBeanFlowInvokerFactoryServiceName() {
        return this.beanFlowInvokerFactoryServiceName;
    }

    @Override
    public void setBeanFlowInvokerFactoryServiceName(ServiceName name) {
        this.beanFlowInvokerFactoryServiceName = name;
    }

    @Override
    public void setReportOnStop(boolean isReport) {
        this.isReportOnStop = isReport;
    }

    @Override
    public boolean isReportOnStop() {
        return this.isReportOnStop;
    }

    public void setOutputPath(File outputPath) {
        this.outputPath = outputPath;
    }

    public File getOutputPath() {
        return this.outputPath;
    }

    @Override
    public void setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public void startService() throws Exception {
        if (this.beanFlowInvokerFactoryServiceName != null) {
            this.beanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
        }
        if (this.beanFlowInvokerFactory == null) {
            throw new IllegalArgumentException("BeanFlowInvokerFactory is null");
        }
        if (this.outputPath == null || "".equals(this.outputPath)) {
            throw new IllegalArgumentException("OutputPath is null");
        }
        if (!this.outputPath.exists() && !this.outputPath.mkdirs()) {
            throw new IllegalArgumentException("Output dir can not make. path=" + this.outputPath);
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.isReportOnStop) {
            this.report();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report() throws Exception {
        Map resourceMap = this.getResourceData();
        PaddingStringConverter converter = new PaddingStringConverter(Integer.toString(resourceMap.size()).length(), '0', 2);
        int count = 0;
        for (Map.Entry flowFileEntry : resourceMap.entrySet()) {
            String flowFileName = (String)flowFileEntry.getKey();
            Map coverageMap = (Map)flowFileEntry.getValue();
            for (Map.Entry coverage : coverageMap.entrySet()) {
                String flowName = (String)coverage.getKey();
                File flowsDir = new File(this.outputPath, "flows");
                if (!flowsDir.exists()) {
                    flowsDir.mkdirs();
                }
                PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(flowsDir, converter.convert(++count) + ".html")), this.characterEncoding)));
                try {
                    this.reportCoverageTable(pw, (BeanFlowCoverage)coverage.getValue());
                }
                finally {
                    pw.flush();
                    pw.close();
                }
            }
        }
        this.copyResource("coverage_ok.png", new File(this.outputPath + "/coverage_ok.png"));
        this.copyResource("coverage_ng.png", new File(this.outputPath + "/coverage_ng.png"));
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.outputPath, "index.html")), this.characterEncoding)));
        try {
            this.reportFlowTable(pw, resourceMap, converter);
        }
        finally {
            pw.flush();
            pw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource(String resourcePath, File output) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(resourcePath);
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(output));
            byte[] bytes = new byte[1024];
            int len = 0;
            while ((len = is.read(bytes, 0, bytes.length)) > 0) {
                ((OutputStream)os).write(bytes, 0, len);
            }
            ((OutputStream)os).flush();
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
    }

    private void reportFlowTable(PrintWriter pw, Map resourceMap, StringConverter converter) throws IOException {
        pw.println("<html>");
        pw.println("<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.characterEncoding + "\"/><title>Nimbus BeanFlow Coverage</title></head>");
        pw.println("<body>");
        pw.println("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"70%\">");
        pw.println("<tr bgcolor=\"#cccccc\"><th>flowFileName</th><th>flowName</th><th>CoveredCount</th><th>ElementCount</th><th>CoverageRate</th></tr>");
        int count = 0;
        for (Map.Entry flowFileEntry : resourceMap.entrySet()) {
            String flowFileName = (String)flowFileEntry.getKey();
            Map coverageMap = (Map)flowFileEntry.getValue();
            pw.println("<tr><td rowspan=\"" + (coverageMap.size() + 1) + "\"><a target=\"sourcefile\" href=\"" + new File(flowFileName).toURI().toURL() + "\">" + flowFileName + "</a></td></tr>");
            for (Map.Entry coverage : coverageMap.entrySet()) {
                String flowName = (String)coverage.getKey();
                BeanFlowCoverage beanflowCoverage = (BeanFlowCoverage)coverage.getValue();
                pw.println("<tr><td><a target=\"flowfile\" href=\"" + new File(this.outputPath + "/flows/" + converter.convert(++count) + ".html").toURI().toURL() + "\">" + flowName + "</a></td>");
                pw.println("<td>" + beanflowCoverage.getCoveredElementCount() + "</td>");
                pw.println("<td>" + beanflowCoverage.getElementCount() + "</td>");
                double coverageRate = (double)beanflowCoverage.getCoveredElementCount() / (double)beanflowCoverage.getElementCount() * 100.0;
                int width = (int)(620.0 * (coverageRate / 100.0));
                int lackWidth = 620 - width;
                pw.print("<td style=\"border:solid 1px #999999;\">");
                if (coverageRate < 100.0) {
                    pw.print("&nbsp;" + (int)coverageRate);
                } else {
                    pw.print((int)coverageRate);
                }
                pw.print("%&nbsp;<img src=\"coverage_ok.png\" width=\"" + width + "\" height=\"18\" alt=\"CoverageRate\">");
                if (lackWidth > 0) {
                    pw.print("<img src=\"coverage_ng.png\" width=\"" + lackWidth + "\" height=\"18\" alt=\"CoverageRate\">");
                }
                pw.println("</td>");
                pw.println("</tr>");
            }
        }
        pw.println("</body>");
        pw.println("</html>");
        pw.flush();
    }

    private void reportCoverageTable(PrintWriter pw, BeanFlowCoverage beanflowCoverage) throws IOException {
        pw.println("<html>");
        pw.println("<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.characterEncoding + "\"/><title>Nimbus BeanFlow Coverage</title></head>");
        pw.println("<body>");
        String[] beanFlowCoverage = beanflowCoverage.toString().split(System.getProperty("line.separator"));
        boolean isCoverd = true;
        String colorCode = "#98fb98;";
        for (int index = 0; index < beanFlowCoverage.length; ++index) {
            String coverage = beanFlowCoverage[index].replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll(" ", "&nbsp;");
            if (coverage != null && coverage.indexOf("!") == 0) {
                coverage = coverage.replaceAll("!", "");
                isCoverd = false;
            } else {
                isCoverd = true;
            }
            colorCode = isCoverd ? "#98fb98;" : "#ff4500;";
            pw.print("<span style=\"background-color:" + colorCode + "\">" + coverage + "<br></span>");
        }
        pw.println("</body>");
        pw.println("</html>");
    }

    private Map getResourceData() {
        TreeMap<String, TreeMap<String, BeanFlowCoverage>> resourceMap = new TreeMap<String, TreeMap<String, BeanFlowCoverage>>();
        Iterator flowNames = this.beanFlowInvokerFactory.getBeanFlowKeySet().iterator();
        while (flowNames.hasNext()) {
            BeanFlowInvoker invoker = this.beanFlowInvokerFactory.createFlow((String)flowNames.next());
            TreeMap<String, BeanFlowCoverage> coverageMap = (TreeMap<String, BeanFlowCoverage>)resourceMap.get(invoker.getResourcePath());
            if (coverageMap == null) {
                coverageMap = new TreeMap<String, BeanFlowCoverage>();
                resourceMap.put(invoker.getResourcePath(), coverageMap);
            }
            coverageMap.put(invoker.getFlowName(), invoker.getBeanFlowCoverage());
            invoker.end();
        }
        return resourceMap;
    }
}

