/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.beancontrol;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerAccessImpl;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerFactoryCallBack;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitor;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitorImpl;
import jp.ossc.nimbus.service.beancontrol.StepParamInformation;
import jp.ossc.nimbus.service.beancontrol.interfaces.InvalidConfigurationException;
import jp.ossc.nimbus.service.beancontrol.resource.ResourceManager;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.log.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JobStep {
    private String mStepName = null;
    private String mClassName = null;
    private String mMethodName = null;
    private String mGetterMethodName = null;
    private ArrayList mStepParamInfoAry = null;
    private Object mBeanObj = null;
    private Method mBlMethod = null;
    private Method mGetterMethod = null;
    private BeanFlowInvokerFactoryCallBack mFactoryCallBack = null;
    private Class mBeanClass = null;
    private int mIncetanceType = 0;
    private String mIncetanceStepName = null;
    private BeanFlowInvokerAccessImpl invoker;
    private static final String C_STEP = "step";
    private static final String C_STEP_NAME = "name";
    private static final String C_CLASS_NAME = "className";
    private static final String C_METHOD_NAME = "methodName";
    private static final String C_GETTER_NAME = "getterName";
    private static final String C_INSTANCE_TYPE = "type";
    private static final String C_ATTRIBUTE_NAME = "attribute";
    private static final String C_NOP = "";
    private static final String C_OWN = "this";
    private static final int C_INSTACE_TYPE_NEW = 0;
    private static final int C_INSTACE_TYPE_INPUT = 1;
    private static final int C_INSTACE_TYPE_STEP = 2;
    private static final String C_TYPE_NAME_NEW = "new";
    private static final String C_TYPE_NAME_INPUT = "input";
    private static final String C_TYPE_NAME_STEP = "step.";
    private static final String C_END_STATUS = "endStatus";
    private static final String C_RESULT = "result";
    private static final String C_NORMAL_END = "normal end";
    private static final String C_ABNORMAL_END = "abnormal end";
    private static final String C_RET_NONE = "return none";

    public JobStep(BeanFlowInvokerAccessImpl impl) {
        this.invoker = impl;
        this.mStepParamInfoAry = new ArrayList();
    }

    public Object getBlObject() {
        return this.mBeanObj;
    }

    public void fillElement(Element element, BeanFlowInvokerFactoryCallBack callBack, List jobSteps) throws InvalidConfigurationException {
        Object[] ary;
        Logger logger;
        this.mFactoryCallBack = callBack;
        String name = element.getAttribute(C_STEP_NAME);
        if (name == null || C_NOP.endsWith(name)) {
            throw new InvalidConfigurationException("stepname none");
        }
        this.setStepName(name);
        String className = element.getAttribute(C_CLASS_NAME);
        if (className == null || C_NOP.endsWith(className)) {
            throw new InvalidConfigurationException("classname none");
        }
        this.setClassName(className);
        try {
            this.mBeanClass = Class.forName(this.mClassName, true, NimbusClassLoader.getInstance());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("classname invalid" + this.mClassName, e);
        }
        String methodName = element.getAttribute(C_METHOD_NAME);
        if (methodName == null || C_NOP.endsWith(methodName)) {
            throw new InvalidConfigurationException("methodname none");
        }
        this.setMethodName(methodName);
        try {
            this.mBlMethod = this.mBeanClass.getMethod(this.mMethodName, null);
        }
        catch (SecurityException e1) {
            throw new InvalidConfigurationException("methodname invalid " + className + "#" + this.mMethodName, e1);
        }
        catch (NoSuchMethodException e1) {
            throw new InvalidConfigurationException("methodname invalid" + className + "#" + this.mMethodName, e1);
        }
        String tmp = element.getAttribute(C_INSTANCE_TYPE);
        if (tmp == null || C_NOP.endsWith(tmp)) {
            this.mIncetanceType = 0;
        } else if (tmp.equals(C_TYPE_NAME_NEW)) {
            this.mIncetanceType = 0;
        } else if (tmp.equals(C_TYPE_NAME_INPUT)) {
            this.mIncetanceType = 1;
        } else if (tmp.startsWith(C_TYPE_NAME_STEP)) {
            this.mIncetanceType = 2;
            this.mIncetanceStepName = tmp.substring(C_TYPE_NAME_STEP.length());
        } else {
            throw new InvalidConfigurationException("typeis invalid value is " + tmp);
        }
        String outputGetterName = element.getAttribute(C_GETTER_NAME);
        if (outputGetterName != null && outputGetterName.length() > 0) {
            this.mGetterMethodName = outputGetterName;
        }
        if ((logger = this.mFactoryCallBack.getLogger()) != null) {
            ary = new String[]{this.mGetterMethodName == null ? "null" : this.mGetterMethodName, className};
            logger.write("BEANF00001", ary);
        }
        if (this.mGetterMethodName != null && !C_NOP.endsWith(this.mGetterMethodName) && !C_OWN.equals(this.mGetterMethodName)) {
            try {
                this.mGetterMethod = this.mBeanClass.getMethod(this.mGetterMethodName, null);
                if (logger != null) {
                    ary = new String[]{this.mGetterMethodName, className};
                    logger.write("BEANF00002", ary);
                }
            }
            catch (SecurityException e2) {
                if (logger != null) {
                    Object[] ary2 = new String[]{this.mGetterMethodName, className};
                    logger.write("BEANF00003", ary2, (Throwable)e2);
                }
                throw new InvalidConfigurationException("gettermethodname invalid " + this.mGetterMethodName, e2);
            }
            catch (NoSuchMethodException e2) {
                if (logger != null) {
                    Object[] ary3 = new String[]{this.mGetterMethodName, className};
                    logger.write("BEANF00004", ary3, (Throwable)e2);
                }
                throw new InvalidConfigurationException("gettermethodname invalid " + this.mGetterMethodName, e2);
            }
        }
        NodeList attList = element.getElementsByTagName(C_ATTRIBUTE_NAME);
        for (int cnt = 0; cnt < attList.getLength(); ++cnt) {
            StepParamInformation param = new StepParamInformation(this.invoker);
            param.fillParameter((Element)attList.item(cnt), this.mBeanClass, callBack, jobSteps);
            this.mStepParamInfoAry.add(param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeStep(Object input, HashMap execBlHash, ResourceManager rm, BeanFlowMonitor monitor) throws InvocationTargetException, InterruptedException {
        Object ret;
        block29: {
            ret = null;
            Object blObj = null;
            Journal jnl = this.invoker.getJournal();
            try {
                ((BeanFlowMonitorImpl)monitor).setCurrentStepName(this.mStepName);
                ((BeanFlowMonitorImpl)monitor).checkStop();
                ((BeanFlowMonitorImpl)monitor).checkSuspend();
                if (jnl != null) {
                    jnl.addStartStep(C_STEP, this.mFactoryCallBack.getEditorFinder());
                    jnl.addInfo(C_STEP_NAME, this.mStepName);
                    jnl.addInfo(C_CLASS_NAME, this.mClassName);
                    jnl.addInfo(C_METHOD_NAME, this.mMethodName);
                }
                switch (this.mIncetanceType) {
                    case 0: {
                        try {
                            blObj = this.mBeanClass.newInstance();
                            break;
                        }
                        catch (InstantiationException iex) {
                            throw new InvalidConfigurationException("NOT_CLASS_INSTANCE", iex);
                        }
                        catch (IllegalAccessException ilex) {
                            throw new InvalidConfigurationException("NOT_ILLEGAL_ACCESS", ilex);
                        }
                    }
                    case 1: {
                        blObj = input;
                        break;
                    }
                    default: {
                        blObj = execBlHash.get(this.mIncetanceStepName);
                    }
                }
                execBlHash.put(this.getStepName(), blObj);
                try {
                    this.setParam(blObj, execBlHash, rm, input);
                    this.mBlMethod.invoke(blObj, (Object[])null);
                }
                catch (IllegalAccessException iex) {
                    if (jnl != null) {
                        jnl.addInfo(C_END_STATUS, C_ABNORMAL_END);
                        jnl.addInfo(C_RESULT, iex);
                    }
                    throw new InvalidConfigurationException("ILLEGAL_ACCESS", iex);
                }
                catch (InvocationTargetException e) {
                    if (jnl != null) {
                        jnl.addInfo(C_END_STATUS, C_ABNORMAL_END);
                        jnl.addInfo(C_RESULT, e.getTargetException());
                    }
                    throw e;
                }
                catch (NoSuchMethodException e) {
                    if (jnl != null) {
                        jnl.addInfo(C_END_STATUS, C_ABNORMAL_END);
                        jnl.addInfo(C_RESULT, e);
                    }
                    throw new InvalidConfigurationException("NOSUCHMETHOD", e);
                }
                if (this.mGetterMethodName != null) {
                    if (C_OWN.equals(this.mGetterMethodName)) {
                        ret = blObj;
                    } else {
                        try {
                            ret = this.mGetterMethod.invoke(blObj, (Object[])null);
                        }
                        catch (IllegalAccessException iex) {
                            if (jnl != null) {
                                jnl.addInfo(C_END_STATUS, C_ABNORMAL_END);
                                jnl.addInfo(C_RESULT, iex);
                            }
                            throw new InvalidConfigurationException("NOT_ILLEGAL_ACCESS", iex);
                        }
                        catch (InvocationTargetException e) {
                            if (jnl != null) {
                                jnl.addInfo(C_END_STATUS, C_ABNORMAL_END);
                                jnl.addInfo(C_RESULT, e.getTargetException());
                            }
                            throw e;
                        }
                    }
                    if (jnl != null) {
                        jnl.addInfo(C_END_STATUS, C_NORMAL_END);
                        jnl.addInfo(C_RESULT, ret);
                    }
                    break block29;
                }
                if (jnl != null) {
                    jnl.addInfo(C_RESULT, C_RET_NONE);
                }
            }
            finally {
                if (jnl != null) {
                    jnl.addEndStep();
                }
            }
        }
        return ret;
    }

    protected void setParam(Object blInstance, HashMap execBlHash, ResourceManager rm, Object inputObj) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        int max = this.mStepParamInfoAry.size();
        for (int i = 0; i < max; ++i) {
            StepParamInformation jclParamObj = (StepParamInformation)this.mStepParamInfoAry.get(i);
            jclParamObj.invokeParameter(blInstance, execBlHash, rm, inputObj);
        }
    }

    public void setStepName(String stepName) {
        this.mStepName = stepName;
    }

    public void setClassName(String className) {
        this.mClassName = className;
    }

    public void setMethodName(String methodName) {
        this.mMethodName = methodName;
    }

    public String getStepName() {
        return this.mStepName;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getMethodName() {
        return this.mMethodName;
    }

    public Class getBeanClass() {
        return this.mBeanClass;
    }
}

