/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.AbstractCacheMapServiceMBean;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.KeyCachedReference;
import jp.ossc.nimbus.service.cache.OverflowController;

public abstract class AbstractCacheMapService
extends ServiceBase
implements CacheRemoveListener,
AbstractCacheMapServiceMBean {
    private static final long serialVersionUID = 6779186037980520151L;
    protected Map references;
    protected ServiceName[] overflowControllerServiceNames;
    protected List overflowControllers;
    protected boolean isClearOnStop;
    protected boolean isClearOnDestroy = true;

    @Override
    public void setOverflowControllerServiceNames(ServiceName[] names) {
        this.overflowControllerServiceNames = names;
    }

    @Override
    public ServiceName[] getOverflowControllerServiceNames() {
        return this.overflowControllerServiceNames;
    }

    @Override
    public void setClearOnStop(boolean isClear) {
        this.isClearOnStop = isClear;
    }

    @Override
    public boolean isClearOnStop() {
        return this.isClearOnStop;
    }

    @Override
    public void setClearOnDestroy(boolean isClear) {
        this.isClearOnDestroy = isClear;
    }

    @Override
    public boolean isClearOnDestroy() {
        return this.isClearOnDestroy;
    }

    public void setOverflowControllers(List overflowControllers) {
        this.overflowControllers = overflowControllers;
    }

    @Override
    public void preCreateService() throws Exception {
        super.preCreateService();
        this.references = Collections.synchronizedMap(new HashMap());
        this.overflowControllers = new ArrayList();
    }

    @Override
    public void preStartService() throws Exception {
        super.preStartService();
        if (this.overflowControllerServiceNames != null) {
            for (int i = 0; i < this.overflowControllerServiceNames.length; ++i) {
                this.overflowControllers.add((OverflowController)ServiceManagerFactory.getServiceObject(this.overflowControllerServiceNames[i]));
            }
        }
    }

    @Override
    public void postStopService() throws Exception {
        if (this.isClearOnStop()) {
            this.clear();
        }
        if (this.overflowControllers != null) {
            this.overflowControllers.clear();
        }
        super.postStopService();
    }

    @Override
    public void postDestroyService() throws Exception {
        if (this.isClearOnDestroy()) {
            this.clear();
        }
        this.references = null;
        this.overflowControllers = null;
        super.postDestroyService();
    }

    @Override
    public KeyCachedReference getCachedReference(Object key) {
        if (this.references == null) {
            return null;
        }
        return (KeyCachedReference)this.references.get(key);
    }

    @Override
    public int size() {
        if (this.references == null) {
            return 0;
        }
        return this.references.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.references == null) {
            return true;
        }
        return this.references.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.references == null) {
            return false;
        }
        return this.references.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        if (this.references == null) {
            return false;
        }
        Map map = this.references;
        synchronized (map) {
            Iterator keys = this.references.keySet().iterator();
            while (keys.hasNext()) {
                Object obj = this.get(keys.next(), false);
                if (value == null) {
                    if (obj != null) continue;
                    return true;
                }
                if (!value.equals(obj)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        return this.get(key, true);
    }

    protected Object get(Object key, boolean notify) {
        if (this.references == null) {
            return null;
        }
        CachedReference ref = (CachedReference)this.references.get(key);
        if (ref == null) {
            return null;
        }
        return ref.get(this, notify);
    }

    @Override
    public Object put(Object key, Object value) {
        if (this.references == null) {
            return null;
        }
        Object oldVal = null;
        if (this.references.containsKey(key)) {
            oldVal = this.remove(key);
        }
        KeyCachedReference ref = this.createKeyCachedReference(key, value);
        this.put(key, ref);
        return oldVal;
    }

    protected void put(Object key, KeyCachedReference ref) {
        if (this.references == null || this.getState() > 5 || ref == null) {
            return;
        }
        ref.addCacheRemoveListener(this);
        this.references.put(key, ref);
        if (this.overflowControllers.size() != 0) {
            for (OverflowController controller : this.overflowControllers) {
                controller.control(ref);
            }
        }
    }

    protected abstract KeyCachedReference createKeyCachedReference(Object var1, Object var2);

    @Override
    public Object remove(Object key) {
        if (this.references == null) {
            return null;
        }
        Object val = null;
        CachedReference ref = (CachedReference)this.references.remove(key);
        if (ref != null) {
            val = ref.get(this, false);
            ref.remove(this);
        }
        return val;
    }

    @Override
    public void putAll(Map map) {
        if (this.references == null || map == null || map.size() == 0) {
            return;
        }
        for (Object key : map.keySet()) {
            this.put(key, map.get(key));
        }
    }

    @Override
    public void clear() {
        if (this.references == null || this.references.size() == 0) {
            return;
        }
        Object[] keys = this.references.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            this.remove(keys[i]);
        }
    }

    @Override
    public Set keySet() {
        return new KeySet();
    }

    @Override
    public Collection values() {
        return new ValuesCollection();
    }

    @Override
    public Set entrySet() {
        return new EntrySet();
    }

    @Override
    public void removed(CachedReference ref) {
        if (this.references != null && ref instanceof KeyCachedReference) {
            KeyCachedReference keyRef = (KeyCachedReference)ref;
            this.references.remove(keyRef.getKey());
        }
    }

    protected class Entry
    implements Map.Entry,
    Serializable {
        private static final long serialVersionUID = -2047042147063848911L;
        private Object key;

        public Entry(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return AbstractCacheMapService.this.get(this.key);
        }

        public Object setValue(Object value) {
            Object result = AbstractCacheMapService.this.remove(this.key);
            AbstractCacheMapService.this.put(this.key, value);
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o instanceof Entry) {
                Entry cmp = (Entry)o;
                if (this.key.equals(cmp.key)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }
    }

    protected class EntryIterator
    implements Iterator,
    Serializable {
        private static final long serialVersionUID = -5858884191202944380L;
        private Iterator iterator;
        private Object current;

        public EntryIterator() {
            if (AbstractCacheMapService.this.references != null) {
                this.iterator = new HashSet(AbstractCacheMapService.this.references.keySet()).iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.iterator == null ? false : this.iterator.hasNext();
        }

        public Object next() {
            if (this.iterator == null) {
                throw new NoSuchElementException();
            }
            this.current = null;
            this.current = this.iterator.next();
            return new Entry(this.current);
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            AbstractCacheMapService.this.remove(this.current);
            this.iterator.remove();
            if (!this.iterator.hasNext()) {
                this.current = null;
            }
        }
    }

    protected class EntrySet
    implements Set,
    Serializable {
        private static final long serialVersionUID = -6274837740283895811L;
        private Collection collection;

        public EntrySet() {
            if (AbstractCacheMapService.this.references != null) {
                this.collection = AbstractCacheMapService.this.references.keySet();
            }
        }

        @Override
        public int size() {
            return AbstractCacheMapService.this.size();
        }

        @Override
        public boolean isEmpty() {
            return AbstractCacheMapService.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return AbstractCacheMapService.this.containsKey(entry.getKey());
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection c) {
            Iterator keys = c.iterator();
            boolean result = true;
            while (keys.hasNext()) {
                result &= this.contains(keys.next());
            }
            return result;
        }

        @Override
        public Iterator iterator() {
            return new EntryIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            if (AbstractCacheMapService.this.references == null || AbstractCacheMapService.this.references.size() == 0) {
                return new Object[0];
            }
            Object[] result = null;
            Map map = AbstractCacheMapService.this.references;
            synchronized (map) {
                result = new Entry[AbstractCacheMapService.this.references.size()];
                int count = 0;
                Iterator keys = AbstractCacheMapService.this.references.keySet().iterator();
                while (keys.hasNext()) {
                    result[count++] = new Entry(keys.next());
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray(Object[] a) {
            if (AbstractCacheMapService.this.references == null || AbstractCacheMapService.this.references.size() == 0) {
                if (a.length == 0) {
                    return a;
                }
                for (int i = 0; i < a.length; ++i) {
                    a[i] = null;
                }
                return a;
            }
            Object[] result = null;
            Map map = AbstractCacheMapService.this.references;
            synchronized (map) {
                int length = AbstractCacheMapService.this.references.size();
                result = a.length >= length ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), length);
                int count = 0;
                Iterator keys = AbstractCacheMapService.this.references.keySet().iterator();
                while (keys.hasNext()) {
                    result[count++] = new Entry(keys.next());
                }
            }
            return result;
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            if (AbstractCacheMapService.this.references == null || AbstractCacheMapService.this.references.size() == 0) {
                return false;
            }
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                Object removed = AbstractCacheMapService.this.remove(entry.getKey());
                return removed != null;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection c) {
            Iterator entries = c.iterator();
            boolean result = false;
            while (entries.hasNext()) {
                result |= this.remove(entries.next());
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection c) {
            if (AbstractCacheMapService.this.references == null || AbstractCacheMapService.this.references.size() == 0) {
                return false;
            }
            boolean result = false;
            Map map = AbstractCacheMapService.this.references;
            synchronized (map) {
                int i;
                Object[] keys = AbstractCacheMapService.this.references.keySet().toArray();
                Object[] entries = c.toArray();
                HashSet retainsKeys = new HashSet();
                for (i = 0; i < entries.length; ++i) {
                    if (!(entries[i] instanceof Map.Entry)) continue;
                    Map.Entry entry = (Map.Entry)entries[i];
                    retainsKeys.add(entry.getKey());
                }
                for (i = 0; i < keys.length; ++i) {
                    if (retainsKeys.contains(keys[i])) continue;
                    Object removed = AbstractCacheMapService.this.remove(keys[i]);
                    result |= removed != null;
                }
            }
            return result;
        }

        @Override
        public void clear() {
            AbstractCacheMapService.this.clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o instanceof EntrySet) {
                EntrySet cmp = (EntrySet)o;
                if (this.collection == null) {
                    return cmp.collection == null;
                }
                if (this.collection.equals(cmp.collection)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.collection == null ? 0 : this.collection.hashCode();
        }
    }

    protected class ValuesIterator
    implements Iterator,
    Serializable {
        private static final long serialVersionUID = 1885683078757668887L;
        private Iterator iterator;
        private KeyCachedReference current;

        public ValuesIterator() {
            if (AbstractCacheMapService.this.references != null) {
                this.iterator = new HashSet(AbstractCacheMapService.this.references.values()).iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.iterator == null ? false : this.iterator.hasNext();
        }

        public Object next() {
            if (this.iterator == null) {
                throw new NoSuchElementException();
            }
            this.current = null;
            this.current = (KeyCachedReference)this.iterator.next();
            return this.current.get(this);
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            AbstractCacheMapService.this.remove(this.current.getKey());
            this.iterator.remove();
            if (!this.iterator.hasNext()) {
                this.current = null;
            }
        }

        public String toString() {
            return this.iterator == null ? super.toString() : this.iterator.toString();
        }
    }

    protected class ValuesCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = -3991603731459237593L;
        private Collection collection;

        public ValuesCollection() {
            if (AbstractCacheMapService.this.references != null) {
                this.collection = AbstractCacheMapService.this.references.values();
            }
        }

        @Override
        public int size() {
            return AbstractCacheMapService.this.size();
        }

        @Override
        public boolean isEmpty() {
            return AbstractCacheMapService.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractCacheMapService.this.containsValue(o);
        }

        public boolean containsAll(Collection c) {
            Iterator values = c.iterator();
            boolean result = true;
            while (values.hasNext()) {
                result &= AbstractCacheMapService.this.containsValue(values.next());
            }
            return result;
        }

        @Override
        public Iterator iterator() {
            return new ValuesIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            if (AbstractCacheMapService.this.references == null || AbstractCacheMapService.this.references.size() == 0) {
                return new Object[0];
            }
            Object[] result = null;
            Map map = AbstractCacheMapService.this.references;
            synchronized (map) {
                result = new Object[AbstractCacheMapService.this.references.size()];
                int count = 0;
                for (CachedReference ref : AbstractCacheMapService.this.references.values()) {
                    if (ref != null) {
                        result[count++] = ref.get(this);
                        continue;
                    }
                    result[count++] = null;
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] a) {
            if (AbstractCacheMapService.this.references == null || AbstractCacheMapService.this.references.size() == 0) {
                if (a.length == 0) {
                    return a;
                }
                for (int i = 0; i < a.length; ++i) {
                    a[i] = null;
                }
                return a;
            }
            Object[] result = null;
            Map map = AbstractCacheMapService.this.references;
            synchronized (map) {
                int length = AbstractCacheMapService.this.references.size();
                result = a.length >= length ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), length);
                int count = 0;
                for (CachedReference ref : AbstractCacheMapService.this.references.values()) {
                    if (ref != null) {
                        result[count++] = ref.get(this);
                        continue;
                    }
                    result[count++] = null;
                }
            }
            return result;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            if (AbstractCacheMapService.this.references == null || AbstractCacheMapService.this.references.size() == 0) {
                return false;
            }
            boolean result = false;
            Object[] values = AbstractCacheMapService.this.references.values().toArray();
            for (int i = 0; i < values.length; ++i) {
                KeyCachedReference ref = (KeyCachedReference)values[i];
                Object val = null;
                if (ref != null) {
                    val = ref.get(this, false);
                }
                Object removed = null;
                if (val == null) {
                    if (o == null && ref != null) {
                        removed = AbstractCacheMapService.this.remove(ref.getKey());
                    }
                } else if (val.equals(o) && ref != null) {
                    removed = AbstractCacheMapService.this.remove(ref.getKey());
                }
                if (removed == null) continue;
                result = true;
            }
            return result;
        }

        public boolean removeAll(Collection c) {
            Iterator values = c.iterator();
            boolean result = false;
            while (values.hasNext()) {
                result |= this.remove(values.next());
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection c) {
            if (AbstractCacheMapService.this.references == null || AbstractCacheMapService.this.references.size() == 0) {
                return false;
            }
            boolean result = false;
            Map map = AbstractCacheMapService.this.references;
            synchronized (map) {
                Object[] values = AbstractCacheMapService.this.references.values().toArray();
                for (int i = 0; i < values.length; ++i) {
                    KeyCachedReference ref = (KeyCachedReference)values[i];
                    Object val = null;
                    if (ref != null) {
                        val = ref.get(this, false);
                    }
                    if (c.contains(val) || ref == null || AbstractCacheMapService.this.remove(ref.getKey()) == null) continue;
                    result = true;
                }
            }
            return result;
        }

        @Override
        public void clear() {
            AbstractCacheMapService.this.clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o instanceof ValuesCollection) {
                ValuesCollection cmp = (ValuesCollection)o;
                if (this.collection == null) {
                    return cmp.collection == null;
                }
                if (this.collection.equals(cmp.collection)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.collection == null ? 0 : this.collection.hashCode();
        }

        public String toString() {
            return this.collection == null ? super.toString() : this.collection.toString();
        }
    }

    protected class KeyIterator
    implements Iterator,
    Serializable {
        private static final long serialVersionUID = 8251697022788153149L;
        private Iterator iterator;
        private Object current;

        public KeyIterator() {
            if (AbstractCacheMapService.this.references != null) {
                this.iterator = new HashSet(AbstractCacheMapService.this.references.keySet()).iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.iterator == null ? false : this.iterator.hasNext();
        }

        public Object next() {
            if (this.iterator == null) {
                throw new NoSuchElementException();
            }
            this.current = null;
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            AbstractCacheMapService.this.remove(this.current);
            this.iterator.remove();
            if (!this.iterator.hasNext()) {
                this.current = null;
            }
        }

        public String toString() {
            return this.iterator == null ? super.toString() : this.iterator.toString();
        }
    }

    protected class KeySet
    implements Set,
    Serializable {
        private static final long serialVersionUID = 8251697022788153149L;
        private Collection collection;

        public KeySet() {
            if (AbstractCacheMapService.this.references != null) {
                this.collection = AbstractCacheMapService.this.references.keySet();
            }
        }

        @Override
        public int size() {
            return AbstractCacheMapService.this.size();
        }

        @Override
        public boolean isEmpty() {
            return AbstractCacheMapService.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractCacheMapService.this.containsKey(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            Iterator keys = c.iterator();
            boolean result = true;
            while (keys.hasNext() && (result &= AbstractCacheMapService.this.containsKey(keys.next()))) {
            }
            return result;
        }

        @Override
        public Iterator iterator() {
            return new KeyIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            if (AbstractCacheMapService.this.references == null || AbstractCacheMapService.this.references.size() == 0) {
                return new Object[0];
            }
            Object[] result = null;
            Map map = AbstractCacheMapService.this.references;
            synchronized (map) {
                int count = 0;
                result = new Object[AbstractCacheMapService.this.references.size()];
                Iterator keys = AbstractCacheMapService.this.references.keySet().iterator();
                while (keys.hasNext()) {
                    result[count++] = keys.next();
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray(Object[] a) {
            if (AbstractCacheMapService.this.references == null || AbstractCacheMapService.this.references.size() == 0) {
                if (a.length == 0) {
                    return a;
                }
                for (int i = 0; i < a.length; ++i) {
                    a[i] = null;
                }
                return a;
            }
            Object[] result = null;
            Map map = AbstractCacheMapService.this.references;
            synchronized (map) {
                int length = AbstractCacheMapService.this.references.size();
                result = a.length >= length ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), length);
                int count = 0;
                Iterator keys = AbstractCacheMapService.this.references.keySet().iterator();
                while (keys.hasNext()) {
                    result[count++] = keys.next();
                }
            }
            return result;
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            if (AbstractCacheMapService.this.references == null || AbstractCacheMapService.this.references.size() == 0) {
                return false;
            }
            Object removed = AbstractCacheMapService.this.remove(o);
            return removed != null;
        }

        @Override
        public boolean removeAll(Collection c) {
            Iterator keys = c.iterator();
            boolean result = false;
            while (keys.hasNext()) {
                result |= this.remove(keys.next());
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection c) {
            if (AbstractCacheMapService.this.references == null || AbstractCacheMapService.this.references.size() == 0) {
                return false;
            }
            boolean result = false;
            Object[] keys = AbstractCacheMapService.this.references.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                if (c.contains(keys[i])) continue;
                result = this.remove(keys[i]);
            }
            return result;
        }

        @Override
        public void clear() {
            AbstractCacheMapService.this.clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o instanceof KeySet) {
                KeySet cmp = (KeySet)o;
                if (this.collection == null) {
                    return cmp.collection == null;
                }
                if (this.collection.equals(cmp.collection)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.collection == null ? 0 : this.collection.hashCode();
        }

        public String toString() {
            return this.collection == null ? super.toString() : this.collection.toString();
        }
    }
}

