/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CacheSizeOverflowValidatorServiceMBean;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.OverflowValidator;

public class CacheSizeOverflowValidatorService
extends ServiceBase
implements OverflowValidator,
CacheRemoveListener,
Serializable,
CacheSizeOverflowValidatorServiceMBean {
    private static final long serialVersionUID = -2810585852541528435L;
    private int maxSize;
    private int overflowThreshold;
    private Set references;

    @Override
    public int size() {
        return this.references == null ? 0 : this.references.size();
    }

    @Override
    public void createService() throws Exception {
        this.references = Collections.synchronizedSet(new HashSet());
    }

    @Override
    public void destroyService() throws Exception {
        this.reset();
        this.references = null;
    }

    @Override
    public void setMaxSize(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("Invalid size : " + size);
        }
        this.maxSize = size;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setOverflowThreshold(int threshold) {
        this.overflowThreshold = threshold;
    }

    @Override
    public int getOverflowThreshold() {
        return this.overflowThreshold;
    }

    @Override
    public int validate() {
        if (this.references == null || this.references.size() == 0) {
            return 0;
        }
        if (this.getState() != 3) {
            return 0;
        }
        if (this.getMaxSize() == 0) {
            return 0;
        }
        int overflowSize = this.references.size() - this.getMaxSize();
        if (overflowSize > 0 && this.getOverflowThreshold() > 0) {
            overflowSize = this.getMaxSize() - this.getOverflowThreshold();
        }
        return overflowSize > 0 ? overflowSize : 0;
    }

    @Override
    public void add(CachedReference ref) {
        if (this.references == null || ref == null) {
            return;
        }
        if (!this.references.contains(ref)) {
            this.references.add(ref);
            ref.addCacheRemoveListener(this);
        }
    }

    @Override
    public void remove(CachedReference ref) {
        if (this.references == null || ref == null) {
            return;
        }
        if (this.references.contains(ref)) {
            this.references.remove(ref);
            ref.removeCacheRemoveListener(this);
        }
    }

    @Override
    public void reset() {
        if (this.references != null) {
            Object[] refs = this.references.toArray();
            for (int i = 0; i < refs.length; ++i) {
                CachedReference ref = (CachedReference)refs[i];
                this.remove(ref);
            }
        }
    }

    @Override
    public void removed(CachedReference ref) {
        if (this.references == null) {
            return;
        }
        this.remove(ref);
    }
}

