/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.SimpleProperty;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.CalculateMemorySizeOverflowValidatorServiceMBean;
import jp.ossc.nimbus.service.cache.OverflowValidator;

public class CalculateMemorySizeOverflowValidatorService
extends ServiceBase
implements OverflowValidator,
CacheRemoveListener,
Serializable,
CalculateMemorySizeOverflowValidatorServiceMBean {
    private static final long serialVersionUID = 6454857430979865088L;
    private static final char KILO_UNIT = 'K';
    private static final char MEGA_UNIT = 'M';
    private static final char GIGA_UNIT = 'G';
    private static final long KILO_BYTE = 1024L;
    private static final long MEGA_BYTE = 0x100000L;
    private static final long GIGA_BYTE = 0x40000000L;
    private String maxMemorySizeStr = "32M";
    private long maxMemorySize = 0x2000000L;
    private Map references;
    private Map memorySizeMap;
    private Map tmpMemorySizeMap;
    private long currentUsedMemorySize;
    private boolean isCalculateOnValidate;
    private boolean isCalculateProperty;

    public CalculateMemorySizeOverflowValidatorService() {
        Runtime runtime = Runtime.getRuntime();
        try {
            this.maxMemorySize = runtime.maxMemory() / 2L;
            this.maxMemorySizeStr = Long.toString(this.maxMemorySize);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @Override
    public void setMaxMemorySize(String size) throws IllegalArgumentException {
        this.maxMemorySize = this.convertMemorySize(size);
        this.maxMemorySizeStr = size;
    }

    @Override
    public String getMaxMemorySize() {
        return this.maxMemorySizeStr;
    }

    @Override
    public void setCalculateProperty(boolean isCalculate) {
        this.isCalculateProperty = isCalculate;
    }

    @Override
    public boolean isCalculateProperty() {
        return this.isCalculateProperty;
    }

    @Override
    public void setCalculateOnValidate(boolean isCalculate) {
        this.isCalculateOnValidate = isCalculate;
    }

    @Override
    public boolean isCalculateOnValidate() {
        return this.isCalculateOnValidate;
    }

    @Override
    public int size() {
        return this.references == null ? 0 : this.references.size();
    }

    @Override
    public long getCurrentUsedMemorySize() {
        return this.currentUsedMemorySize;
    }

    @Override
    public void setMemorySize(String className, String size) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className, true, NimbusClassLoader.getInstance());
        long val = this.convertMemorySize(size);
        this.memorySizeMap.put(clazz, new Long(val));
    }

    @Override
    public String getMemorySize(String className) throws ClassNotFoundException {
        if (this.memorySizeMap == null) {
            return null;
        }
        Class<?> clazz = Class.forName(className, true, NimbusClassLoader.getInstance());
        Number number = (Number)this.memorySizeMap.get(clazz);
        return number == null ? null : String.valueOf(number.longValue());
    }

    @Override
    public Map getMemorySizeMap() {
        return this.memorySizeMap;
    }

    @Override
    public void createService() throws Exception {
        this.references = Collections.synchronizedMap(new HashMap());
        this.memorySizeMap = Collections.synchronizedMap(new HashMap());
        this.memorySizeMap.put(Byte.TYPE, new Short(1));
        this.memorySizeMap.put(Boolean.TYPE, new Short(1));
        this.memorySizeMap.put(Character.TYPE, new Short(2));
        this.memorySizeMap.put(Short.TYPE, new Short(2));
        this.memorySizeMap.put(Integer.TYPE, new Short(4));
        this.memorySizeMap.put(Float.TYPE, new Short(4));
        this.memorySizeMap.put(Long.TYPE, new Short(8));
        this.memorySizeMap.put(Double.TYPE, new Short(8));
        this.memorySizeMap.put(Class.class, new Short(0));
        this.memorySizeMap.put(Method.class, new Short(0));
        this.memorySizeMap.put(Field.class, new Short(0));
        this.memorySizeMap.put(Constructor.class, new Short(0));
        this.tmpMemorySizeMap = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void stopService() throws Exception {
        this.tmpMemorySizeMap.clear();
    }

    @Override
    public void destroyService() throws Exception {
        this.reset();
        this.references = null;
    }

    private long convertMemorySize(String size) throws IllegalArgumentException {
        long value = 0L;
        boolean isValid = true;
        if (size == null) {
            isValid = false;
        } else {
            int length = size.length();
            if (length == 0) {
                isValid = false;
            } else {
                char unit = Character.toUpperCase(size.charAt(length - 1));
                String tmpSize = null;
                long unitValue = 0L;
                switch (unit) {
                    case 'K': {
                        tmpSize = size.substring(0, length - 1);
                        unitValue = 1024L;
                        break;
                    }
                    case 'M': {
                        tmpSize = size.substring(0, length - 1);
                        unitValue = 0x100000L;
                        break;
                    }
                    case 'G': {
                        tmpSize = size.substring(0, length - 1);
                        unitValue = 0x40000000L;
                        break;
                    }
                    default: {
                        tmpSize = size;
                        unitValue = 1L;
                    }
                }
                try {
                    value = (long)(Double.parseDouble(tmpSize) * (double)unitValue);
                }
                catch (NumberFormatException e) {
                    isValid = false;
                }
            }
        }
        if (value < 0L) {
            isValid = false;
        }
        if (!isValid) {
            throw new IllegalArgumentException("Invalid size : " + size);
        }
        return value;
    }

    private long calculateMemorySize(Object obj) {
        if (obj == null) {
            return 0L;
        }
        Class<?> clazz = obj.getClass();
        return this.calculateMemorySize(clazz, obj, true, new ArrayList());
    }

    private long roundUp(long val, int base) {
        long tmp = val % (long)base;
        return tmp == 0L ? val : val + (long)base - tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long calculateMemorySize(Class clazz, Object obj, boolean isRoundUp, List stack) {
        if (stack.contains(clazz)) {
            return 0L;
        }
        int index = 0;
        try {
            index = stack.size();
            stack.add(clazz);
            Number size = (Number)this.memorySizeMap.get(clazz);
            if (size != null) {
                long l = size.longValue();
                return l;
            }
            if (obj == null && (size = (Number)this.tmpMemorySizeMap.get(clazz)) != null) {
                long l = size.longValue();
                return l;
            }
            long result = 0L;
            if (clazz.isInterface()) {
                result = 8L;
            } else if (clazz.isArray()) {
                if (obj == null) {
                    result = 12L;
                } else {
                    int length = Array.getLength(obj);
                    result = (long)(length * 4) + 12L;
                    result = this.roundUp(result, 8);
                    for (int i = 0; i < length; ++i) {
                        Object element = Array.get(obj, i);
                        if (element == null) continue;
                        result += this.calculateMemorySize(element.getClass(), element, false, stack);
                    }
                }
                result = this.roundUp(result, 8);
            } else if (String.class.equals((Object)clazz)) {
                result = this.calculateMemorySize(clazz, null, true, stack);
                if (obj != null) {
                    String str = (String)obj;
                    result += (long)str.length() * 6L;
                    result = this.roundUp(result, 8);
                }
            } else if (Collection.class.isAssignableFrom(clazz)) {
                Collection col;
                result = this.calculateMemorySize(clazz, null, true, stack);
                if (obj != null && (col = (Collection)obj).size() != 0) {
                    for (Object element : col) {
                        if (element == null) continue;
                        result += this.calculateMemorySize(element.getClass(), element, true, stack);
                    }
                }
            } else if (Map.class.isAssignableFrom(clazz)) {
                Map map;
                result = this.calculateMemorySize(clazz, null, true, stack);
                if (obj != null && (map = (Map)obj).size() != 0) {
                    for (Map.Entry entry : map.entrySet()) {
                        Object value;
                        Object key = entry.getKey();
                        if (key != null) {
                            result += this.calculateMemorySize(key.getClass(), key, true, stack);
                        }
                        if ((value = entry.getValue()) == null) continue;
                        result += this.calculateMemorySize(value.getClass(), value, true, stack);
                    }
                }
            } else {
                int i;
                Class tmpClass = clazz;
                result += 8L;
                do {
                    Field[] fields;
                    if ((fields = tmpClass.getDeclaredFields()) == null) continue;
                    for (i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        if (Modifier.isStatic(field.getModifiers())) continue;
                        Class<?> fieldType = field.getType();
                        result += this.calculateFieldMemorySize(fieldType, true);
                    }
                    if (!isRoundUp) continue;
                    result = this.roundUp(result, 8);
                } while ((tmpClass = tmpClass.getSuperclass()) != null);
                if (obj != null && this.isCalculateProperty) {
                    SimpleProperty[] props = SimpleProperty.getProperties(obj);
                    for (i = 0; i < props.length; ++i) {
                        if (!props[i].isReadable(obj)) continue;
                        Object val = null;
                        Class type = null;
                        try {
                            Method method = props[i].getReadMethod(obj);
                            if (Modifier.isStatic(method.getModifiers()) || (type = props[i].getPropertyType(obj)).isPrimitive()) continue;
                            val = props[i].getProperty(obj);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (NoSuchPropertyException noSuchPropertyException) {
                            // empty catch block
                        }
                        if (val == null) continue;
                        result += this.calculateMemorySize(type, val, true, stack);
                    }
                }
            }
            if (obj == null) {
                this.tmpMemorySizeMap.put(clazz, new Long(result));
            }
            long l = result;
            return l;
        }
        finally {
            stack.remove(index);
        }
    }

    private long calculateFieldMemorySize(Class clazz, boolean isRoundUp) {
        if (clazz.isPrimitive()) {
            if (Byte.TYPE.equals(clazz) || Boolean.TYPE.equals(clazz)) {
                return 1L;
            }
            if (Character.TYPE.equals(clazz) || Short.TYPE.equals(clazz)) {
                return 2L;
            }
            if (Integer.TYPE.equals(clazz) || Float.TYPE.equals(clazz)) {
                return 4L;
            }
            return 8L;
        }
        if (clazz.isArray()) {
            return 16L;
        }
        return 4L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(CachedReference ref) {
        if (this.references == null || ref == null) {
            return;
        }
        Map map = this.references;
        synchronized (map) {
            if (!this.references.containsKey(ref)) {
                Long size = null;
                if (!this.isCalculateOnValidate) {
                    size = new Long(this.calculateMemorySize(ref.get(this)));
                    if (this.currentUsedMemorySize < 0L) {
                        this.currentUsedMemorySize = 0L;
                    }
                    this.currentUsedMemorySize += size.longValue();
                }
                this.references.put(ref, size);
                ref.addCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(CachedReference ref) {
        if (this.references == null || ref == null) {
            return;
        }
        Map map = this.references;
        synchronized (map) {
            if (this.references.containsKey(ref)) {
                Long size = (Long)this.references.remove(ref);
                ref.removeCacheRemoveListener(this);
                if (!this.isCalculateOnValidate && size != null) {
                    this.currentUsedMemorySize -= size.longValue();
                    if (this.currentUsedMemorySize < 0L) {
                        this.currentUsedMemorySize = 0L;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int validate() {
        if (this.references == null || this.references.size() == 0) {
            return 0;
        }
        Map map = this.references;
        synchronized (map) {
            if (this.getState() != 3) {
                return 0;
            }
            if (this.isCalculateOnValidate) {
                this.currentUsedMemorySize = 0L;
                for (Map.Entry entry : this.references.entrySet()) {
                    CachedReference ref = (CachedReference)entry.getKey();
                    long size = this.calculateMemorySize(ref.get(this));
                    if (this.currentUsedMemorySize < 0L) {
                        this.currentUsedMemorySize = 0L;
                    }
                    this.currentUsedMemorySize += size;
                }
            }
            if (this.currentUsedMemorySize < this.maxMemorySize) {
                return 0;
            }
            long overflowMemorySize = this.currentUsedMemorySize - this.maxMemorySize;
            double usedAverage = this.currentUsedMemorySize / (long)this.references.size();
            double overflowSize = (double)overflowMemorySize / usedAverage;
            int n = overflowSize > 0.0 ? (int)Math.ceil(overflowSize) : 0;
            return n;
        }
    }

    @Override
    public void reset() {
        if (this.references != null) {
            this.references.clear();
        }
        this.currentUsedMemorySize = 0L;
    }

    @Override
    public void removed(CachedReference ref) {
        this.remove(ref);
    }
}

