/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.Cache;
import jp.ossc.nimbus.service.cache.CacheChangeListener;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.IllegalCachedReferenceException;
import jp.ossc.nimbus.service.cache.KeyCachedReference;
import jp.ossc.nimbus.service.cache.LinkedReference;
import jp.ossc.nimbus.service.cache.MemoryCacheService;
import jp.ossc.nimbus.service.cache.OverflowAction;
import jp.ossc.nimbus.service.cache.OverflowAlgorithm;
import jp.ossc.nimbus.service.cache.OverflowController;
import jp.ossc.nimbus.service.cache.OverflowValidator;
import jp.ossc.nimbus.service.cache.StoreCacheOverflowActionServiceMBean;

public class StoreCacheOverflowActionService
extends ServiceBase
implements OverflowAction,
LinkedReference,
CacheRemoveListener,
CacheChangeListener,
Serializable,
StoreCacheOverflowActionServiceMBean {
    private static final long serialVersionUID = 7281680512746664647L;
    private static final String SCOA_ = "SCOA_";
    private static final String SCOA_0 = "SCOA_0";
    private static final String SCOA_00 = "SCOA_00";
    private static final String SCOA_000 = "SCOA_000";
    private static final String SCOA_0000 = "SCOA_0000";
    private static final String SCOA_00001 = "SCOA_00001";
    private static final String SCOA_00002 = "SCOA_00002";
    private ServiceName cacheServiceName;
    private Cache cache;
    private ServiceName cacheMapServiceName;
    private CacheMap cacheMap;
    private OverflowController controller;
    private MemoryCacheService defaultCache;
    private Map references;

    @Override
    public void setCacheServiceName(ServiceName name) {
        this.cacheServiceName = name;
    }

    @Override
    public ServiceName getCacheServiceName() {
        return this.cacheServiceName;
    }

    @Override
    public void setCacheMapServiceName(ServiceName name) {
        this.cacheMapServiceName = name;
    }

    @Override
    public ServiceName getCacheMapServiceName() {
        return this.cacheMapServiceName;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setCacheMap(CacheMap cacheMap) {
        this.cacheMap = cacheMap;
    }

    @Override
    public void createService() throws Exception {
        this.references = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void startService() throws Exception {
        this.cache = this.cacheServiceName != null ? (Cache)ServiceManagerFactory.getServiceObject(this.cacheServiceName) : this.getDefaultCacheService();
        if (this.cacheMapServiceName != null) {
            this.cacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.cacheMapServiceName);
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.defaultCache != null && this.cache == this.defaultCache) {
            this.defaultCache.stop();
        }
        this.cache = null;
        this.cacheMap = null;
    }

    @Override
    public void destroyService() throws Exception {
        if (this.defaultCache != null) {
            this.defaultCache.destroy();
            this.defaultCache = null;
        }
        this.references = null;
    }

    protected Cache getDefaultCacheService() throws Exception {
        if (this.defaultCache == null) {
            MemoryCacheService c = new MemoryCacheService();
            c.create();
            c.start();
            this.defaultCache = c;
        } else if (this.defaultCache.getState() != 3) {
            this.defaultCache.start();
        }
        return this.defaultCache;
    }

    @Override
    public void setOverflowController(OverflowController controller) {
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void action(OverflowValidator validator, OverflowAlgorithm algorithm, CachedReference ref) {
        if (ref == null || this.references == null) {
            return;
        }
        CachedReference cachedReference = ref;
        synchronized (cachedReference) {
            Object obj = ref.get(this, false);
            if (obj == null) {
                return;
            }
            CachedReference newRef = null;
            if (ref instanceof KeyCachedReference && this.cacheMap != null) {
                KeyCachedReference keyRef = (KeyCachedReference)ref;
                Object key = keyRef.getKey();
                if (key != null && obj != null) {
                    this.cacheMap.put(key, obj);
                    newRef = this.cacheMap.getCachedReference(key);
                }
            } else {
                newRef = this.cache.add(obj);
            }
            if (newRef != null) {
                try {
                    ref.set(this, null);
                    ref.addLinkedReference(this);
                    ref.addCacheRemoveListener(this);
                    ref.addCacheChangeListener(this);
                    this.references.put(ref, newRef);
                    if (validator != null) {
                        validator.remove(ref);
                    }
                    if (algorithm != null) {
                        algorithm.remove(ref);
                    }
                }
                catch (IllegalCachedReferenceException e) {
                    this.getLogger().write(SCOA_00001, e);
                    newRef.remove(this);
                }
                if (ref.isRemoved()) {
                    newRef.remove(this);
                }
            } else if (algorithm != null) {
                algorithm.remove(ref);
            }
        }
    }

    @Override
    public void reset() {
        if (this.references != null) {
            this.references.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(CachedReference ref) {
        if (ref == null || this.references == null) {
            return null;
        }
        CachedReference cachedReference = ref;
        synchronized (cachedReference) {
            CachedReference newRef = (CachedReference)this.references.get(ref);
            Object obj = null;
            if (newRef != null) {
                obj = newRef.get(this);
                try {
                    ref.set(this, obj);
                    newRef.remove(this);
                    this.references.remove(ref);
                    ref.removeLinkedReference(this);
                    ref.removeCacheRemoveListener(this);
                    ref.removeCacheChangeListener(this);
                    if (this.controller != null) {
                        this.controller.control(ref);
                    }
                }
                catch (IllegalCachedReferenceException e) {
                    this.getLogger().write(SCOA_00002, obj, (Throwable)e);
                }
            }
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removed(CachedReference ref) {
        if (this.references == null) {
            return;
        }
        CachedReference cachedReference = ref;
        synchronized (cachedReference) {
            if (this.references != null && this.references.containsKey(ref)) {
                CachedReference newRef = (CachedReference)this.references.remove(ref);
                newRef.remove(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changed(CachedReference ref, Object obj) {
        if (this.references == null) {
            return;
        }
        CachedReference cachedReference = ref;
        synchronized (cachedReference) {
            if (this.references != null && this.references.containsKey(ref)) {
                CachedReference newRef = (CachedReference)this.references.remove(ref);
                newRef.remove(this);
                ref.removeLinkedReference(this);
                ref.removeCacheRemoveListener(this);
                ref.removeCacheChangeListener(this);
            }
        }
    }
}

