/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.connection;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.connection.DefaultQuerySearchManagerServiceMBean;
import jp.ossc.nimbus.service.connection.PersistentException;
import jp.ossc.nimbus.service.connection.PersistentManager;
import jp.ossc.nimbus.service.connection.QuerySearchManager;

public class DefaultQuerySearchManagerService
extends ServiceBase
implements QuerySearchManager,
DefaultQuerySearchManagerServiceMBean {
    private static final Object NULL = "null";
    private String query;
    private Map statementProps;
    private Map resultSetProps;
    private Class outputClass;
    private boolean isUnique;
    private ServiceName connectionFactoryServiceName;
    private ConnectionFactory connectionFactory;
    private ServiceName persistentManagerServiceName;
    private PersistentManager persistentManager;
    private ServiceName cacheMapServiceName;
    private CacheMap cacheMap;
    private Map keyMap;
    private long caheHitCount;
    private long caheNoHitCount;

    @Override
    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setStatementProperty(String name, Object value) {
        if (this.statementProps == null) {
            this.statementProps = new HashMap();
        }
        this.statementProps.put(name, value);
    }

    @Override
    public void setStatementProperties(Map props) {
        this.statementProps = props;
    }

    @Override
    public Map getStatementProperties() {
        return this.statementProps;
    }

    @Override
    public void setResultSetProperty(String name, Object value) {
        if (this.resultSetProps == null) {
            this.resultSetProps = new HashMap();
        }
        this.resultSetProps.put(name, value);
    }

    @Override
    public void setResultSetProperties(Map props) {
        this.resultSetProps = props;
    }

    @Override
    public Map getResultSetProperties() {
        return this.resultSetProps;
    }

    @Override
    public void setOutputClass(Class clazz) {
        this.outputClass = clazz;
    }

    @Override
    public Class getOutputClass() {
        return this.outputClass;
    }

    @Override
    public void setUnique(boolean isUnique) {
        this.isUnique = isUnique;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    @Override
    public void setPersistentManagerServiceName(ServiceName name) {
        this.persistentManagerServiceName = name;
    }

    @Override
    public ServiceName getPersistentManagerServiceName() {
        return this.persistentManagerServiceName;
    }

    @Override
    public void setCacheMapServiceName(ServiceName name) {
        this.cacheMapServiceName = name;
    }

    @Override
    public ServiceName getCacheMapServiceName() {
        return this.cacheMapServiceName;
    }

    public void setConnectionFactory(ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public void setPersistentManager(PersistentManager pm) {
        this.persistentManager = pm;
    }

    public void setCacheMap(CacheMap map) {
        this.cacheMap = map;
    }

    @Override
    public float getCacheHitRatio() {
        long total = this.caheHitCount + this.caheNoHitCount;
        return total == 0L ? 0.0f : (float)this.caheHitCount / (float)total * 100.0f;
    }

    @Override
    public void resetCacheHitRatio() {
        this.caheHitCount = 0L;
        this.caheNoHitCount = 0L;
    }

    @Override
    public void createService() throws Exception {
        this.keyMap = new HashMap();
    }

    @Override
    public void startService() throws Exception {
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if (this.persistentManagerServiceName != null) {
            this.persistentManager = (PersistentManager)ServiceManagerFactory.getServiceObject(this.persistentManagerServiceName);
        }
        if (this.persistentManager == null) {
            throw new IllegalArgumentException("PersistentManager is null.");
        }
        if (this.cacheMapServiceName != null) {
            this.cacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.cacheMapServiceName);
        }
        if (this.query == null || this.query.length() == 0) {
            throw new IllegalArgumentException("Query is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService() throws Exception {
        Map map = this.keyMap;
        synchronized (map) {
            this.keyMap.clear();
        }
        this.caheHitCount = 0L;
        this.caheNoHitCount = 0L;
    }

    @Override
    public void destroyService() throws Exception {
        this.keyMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object search(Object key) throws ConnectionFactoryException, PersistentException {
        Object object;
        Key k = new Key(key);
        Map map = this.keyMap;
        synchronized (map) {
            Key cachedKey = (Key)this.keyMap.get(key);
            if (cachedKey == null) {
                this.keyMap.put(k, k);
            } else {
                k = cachedKey;
            }
        }
        Object result = null;
        if (this.cacheMap != null) {
            object = this.cacheMap;
            synchronized (object) {
                result = this.cacheMap.get(k);
                if (result != null) {
                    ++this.caheHitCount;
                    if (result == NULL) {
                        return null;
                    }
                    return result;
                }
            }
        }
        object = k;
        synchronized (object) {
            if (this.cacheMap != null) {
                CacheMap cacheMap = this.cacheMap;
                synchronized (cacheMap) {
                    result = this.cacheMap.get(k);
                    if (result != null) {
                        ++this.caheHitCount;
                        if (result == NULL) {
                            return null;
                        }
                        return result;
                    }
                }
            }
            ++this.caheNoHitCount;
            Connection con = null;
            try {
                con = this.connectionFactory.getConnection();
                result = this.persistentManager.loadQuery(con, this.query, key, this.outputClass == null ? null : (this.isUnique ? this.outputClass.newInstance() : this.outputClass), this.statementProps, this.resultSetProps);
                if (this.outputClass == null && this.isUnique) {
                    List list = (List)result;
                    result = list.size() == 0 ? null : list.get(0);
                }
            }
            catch (IllegalAccessException e) {
                throw new PersistentException(e);
            }
            catch (InstantiationException e) {
                throw new PersistentException(e);
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            if (this.cacheMap != null) {
                CacheMap cacheMap = this.cacheMap;
                synchronized (cacheMap) {
                    if (result == null) {
                        this.cacheMap.put(k, NULL);
                    } else {
                        this.cacheMap.put(k, result);
                    }
                }
            }
        }
        return result;
    }

    private static class Key
    implements Serializable {
        private final Object key;
        private final int hashCode;

        public Key(Object key) {
            if (key == null) {
                this.key = null;
            } else if (key.getClass().isArray()) {
                Object[] keys = (Object[])key;
                HashSet<Object> set = new HashSet<Object>(keys.length);
                for (int i = 0; i < keys.length; ++i) {
                    set.add(keys[i]);
                }
                this.key = set;
            } else if (key instanceof List) {
                ArrayList list = new ArrayList(((List)key).size());
                list.addAll((List)key);
                this.key = list;
            } else if (key instanceof Map) {
                HashMap map = new HashMap(((Map)key).size());
                map.putAll((Map)key);
                this.key = map;
            } else if (key instanceof Collection) {
                HashSet set = new HashSet(((Collection)key).size());
                set.addAll((Collection)key);
                this.key = set;
            } else {
                this.key = key;
            }
            this.hashCode = this.key.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key cmp = (Key)obj;
            if (this.key == null) {
                return cmp.key == null;
            }
            if (cmp.key == null) {
                return false;
            }
            return this.key.equals(cmp.key);
        }
    }
}

