/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import jp.ossc.nimbus.beans.BeanTableIndexKeyFactory;
import jp.ossc.nimbus.beans.IndexNotFoundException;
import jp.ossc.nimbus.beans.IndexPropertyAccessException;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.IllegalCachedReferenceException;
import jp.ossc.nimbus.service.cache.KeyCachedReference;
import jp.ossc.nimbus.service.context.DefaultContextService;
import jp.ossc.nimbus.service.context.NoConnectServerException;
import jp.ossc.nimbus.service.context.SharedContext;
import jp.ossc.nimbus.service.context.SharedContextIndex;
import jp.ossc.nimbus.service.context.SharedContextIndexManager;
import jp.ossc.nimbus.service.context.SharedContextSendException;
import jp.ossc.nimbus.service.context.SharedContextServiceMBean;
import jp.ossc.nimbus.service.context.SharedContextTimeoutException;
import jp.ossc.nimbus.service.context.SharedContextTransactionManager;
import jp.ossc.nimbus.service.context.SharedContextUpdateException;
import jp.ossc.nimbus.service.context.SharedContextUpdateListener;
import jp.ossc.nimbus.service.context.SharedContextValueDifference;
import jp.ossc.nimbus.service.context.SharedContextValueDifferenceSupport;
import jp.ossc.nimbus.service.context.SharedContextView;
import jp.ossc.nimbus.service.interpreter.EvaluateException;
import jp.ossc.nimbus.service.interpreter.Interpreter;
import jp.ossc.nimbus.service.keepalive.ClusterListener;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.MessageReceiver;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.RequestMessageListener;
import jp.ossc.nimbus.service.publish.RequestServerConnection;
import jp.ossc.nimbus.service.publish.RequestTimeoutException;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.service.queue.AsynchContext;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainerService;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class SharedContextService
extends DefaultContextService
implements SharedContext,
RequestMessageListener,
CacheRemoveListener,
ClusterListener,
SharedContextServiceMBean,
Serializable {
    private static final long serialVersionUID = -7616415086512838961L;
    protected ServiceName requestConnectionFactoryServiceName;
    protected RequestServerConnection serverConnection;
    protected MessageReceiver messageReceiver;
    protected ServiceName clusterServiceName;
    protected ClusterService cluster;
    protected ServiceName clientCacheMapServiceName;
    protected ServiceName serverCacheMapServiceName;
    protected CacheMap clientCacheMap;
    protected CacheMap serverCacheMap;
    protected CacheMap cacheMap;
    protected boolean isClient;
    protected ServiceName[] sharedContextUpdateListenerServiceNames;
    protected ServiceName interpreterServiceName;
    protected Interpreter interpreter;
    protected String interpretContextVariableName = "context";
    protected int executeThreadSize;
    protected QueueHandlerContainerService executeQueueHandlerContainer;
    protected ServiceName executeQueueServiceName;
    protected ServiceName sharedContextTransactionManagerServiceName;
    protected SharedContextTransactionManager sharedContextTransactionManager;
    protected long synchronizeTimeout = 5000L;
    protected long defaultTimeout = 1000L;
    protected String subject = "SharedContext";
    protected String clientSubject;
    protected boolean isSynchronizeOnStart = true;
    protected boolean isSaveOnlyMain;
    protected boolean isWaitConnectAllOnStart = false;
    protected long waitConnectTimeout = 60000L;
    protected Map keyLockMap;
    protected Map idLocksMap;
    protected Map clientCacheLockMap;
    protected Message targetMessage;
    protected Message allTargetMessage;
    protected List updateListeners;
    protected SharedContextIndexManager indexManager;
    protected Timer lockTimeoutTimer;
    protected SynchronizeLock updateLock;
    protected SynchronizeLock referLock;
    protected boolean isMain;
    protected long caheHitCount;
    protected long caheNoHitCount;

    @Override
    public void setRequestConnectionFactoryServiceName(ServiceName name) {
        this.requestConnectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getRequestConnectionFactoryServiceName() {
        return this.requestConnectionFactoryServiceName;
    }

    @Override
    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    @Override
    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    @Override
    public void setClientCacheMapServiceName(ServiceName name) {
        this.clientCacheMapServiceName = name;
    }

    @Override
    public ServiceName getClientCacheMapServiceName() {
        return this.clientCacheMapServiceName;
    }

    @Override
    public void setServerCacheMapServiceName(ServiceName name) {
        this.serverCacheMapServiceName = name;
    }

    @Override
    public ServiceName getServerCacheMapServiceName() {
        return this.serverCacheMapServiceName;
    }

    @Override
    public void setInterpreterServiceName(ServiceName name) {
        this.interpreterServiceName = name;
    }

    @Override
    public ServiceName getInterpreterServiceName() {
        return this.interpreterServiceName;
    }

    @Override
    public void setInterpretContextVariableName(String name) {
        this.interpretContextVariableName = name;
    }

    @Override
    public String getInterpretContextVariableName() {
        return this.interpretContextVariableName;
    }

    @Override
    public void setExecuteThreadSize(int size) {
        this.executeThreadSize = size;
    }

    @Override
    public int getExecuteThreadSize() {
        return this.executeThreadSize;
    }

    @Override
    public void setExecuteQueueServiceName(ServiceName name) {
        this.executeQueueServiceName = name;
    }

    @Override
    public ServiceName getExecuteQueueServiceName() {
        return this.executeQueueServiceName;
    }

    @Override
    public void setSharedContextTransactionManagerServiceName(ServiceName name) {
        this.sharedContextTransactionManagerServiceName = name;
    }

    @Override
    public ServiceName getSharedContextTransactionManagerServiceName() {
        return this.sharedContextTransactionManagerServiceName;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void setClient(boolean isClient) throws SharedContextSendException, SharedContextTimeoutException {
        if (this.getState() == 3) {
            try {
                block37: {
                    if (this.isClient == isClient) {
                        return;
                    }
                    Object id = this.cluster.getUID();
                    try {
                        this.referLock.acquireForLock(id, -1L);
                        this.updateLock.acquireForLock(id, -1L);
                        CacheMap oldCacheMap = this.cacheMap;
                        if (isClient) {
                            if (this.clientCacheMapServiceName != null) {
                                this.cacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.clientCacheMapServiceName);
                            } else if (this.clientCacheMap != null) {
                                this.cacheMap = this.clientCacheMap;
                            }
                        } else if (this.serverCacheMapServiceName != null) {
                            this.cacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.serverCacheMapServiceName);
                        } else if (this.serverCacheMap != null) {
                            this.cacheMap = this.serverCacheMap;
                        }
                        if (this.indexManager != null) {
                            this.indexManager.clear();
                        }
                        try {
                            this.messageReceiver.addSubject(this, isClient ? this.clientSubject : this.subject);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        try {
                            if (isClient) {
                                this.synchronizeForClient(this.synchronizeTimeout);
                            } else {
                                this.synchronizeWithMain(this.synchronizeTimeout);
                            }
                        }
                        catch (NoConnectServerException e) {
                            // empty catch block
                        }
                        try {
                            this.messageReceiver.removeSubject(this, isClient ? this.subject : this.clientSubject);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        if (oldCacheMap == null) break block37;
                        Object[] keys = null;
                        Map map = this.context;
                        synchronized (map) {
                            keys = super.keySet().toArray();
                        }
                        for (int i = 0; i < keys.length; ++i) {
                            KeyCachedReference ref = oldCacheMap.getCachedReference(keys[i]);
                            if (ref != null) {
                                ref.removeCacheRemoveListener(this);
                            }
                            oldCacheMap.remove(keys[i]);
                        }
                    }
                    finally {
                        this.updateLock.releaseForLock(id);
                        this.referLock.releaseForLock(id);
                    }
                }
                this.isClient = isClient;
                this.resetCacheHitRatio();
            }
            finally {
                boolean isMainTmp = this.isMain();
                if (this.isMain != isMainTmp && !isClient && this.updateListeners != null) {
                    for (int i = 0; i < this.updateListeners.size(); ++i) {
                        if (isMainTmp) {
                            ((SharedContextUpdateListener)this.updateListeners.get(i)).onChangeMain(this);
                            continue;
                        }
                        ((SharedContextUpdateListener)this.updateListeners.get(i)).onChangeSub(this);
                    }
                }
                this.isMain = isMainTmp;
            }
            try {
                Message message = this.serverConnection.createMessage(this.subject, null);
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() == 0) return;
                message.setObject(new SharedContextEvent(26, this.cluster.getUID(), isClient));
                this.serverConnection.sendAsynch(message);
                return;
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
        }
        this.isClient = isClient;
    }

    @Override
    public boolean isClient() {
        return this.isClient;
    }

    @Override
    public void setSynchronizeOnStart(boolean isSynch) {
        this.isSynchronizeOnStart = isSynch;
    }

    @Override
    public boolean isSynchronizeOnStart() {
        return this.isSynchronizeOnStart;
    }

    @Override
    public void setSaveOnlyMain(boolean isSave) {
        this.isSaveOnlyMain = isSave;
    }

    @Override
    public boolean isSaveOnlyMain() {
        return this.isSaveOnlyMain;
    }

    @Override
    public void setWaitConnectAllOnStart(boolean isWait) {
        this.isWaitConnectAllOnStart = isWait;
    }

    @Override
    public boolean isWaitConnectAllOnStart() {
        return this.isWaitConnectAllOnStart;
    }

    @Override
    public void setWaitConnectTimeout(long timeout) {
        this.waitConnectTimeout = timeout;
    }

    @Override
    public long getWaitConnectTimeout() {
        return this.waitConnectTimeout;
    }

    @Override
    public void setSynchronizeTimeout(long timeout) {
        this.synchronizeTimeout = timeout;
    }

    @Override
    public long getSynchronizeTimeout() {
        return this.synchronizeTimeout;
    }

    @Override
    public void setDefaultTimeout(long timeout) {
        this.defaultTimeout = timeout;
    }

    @Override
    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setClientCacheMap(CacheMap map) {
        this.clientCacheMap = map;
    }

    public void setServerCacheMap(CacheMap map) {
        this.serverCacheMap = map;
    }

    @Override
    public void setSharedContextUpdateListenerServiceNames(ServiceName[] names) {
        this.sharedContextUpdateListenerServiceNames = names;
    }

    @Override
    public ServiceName[] getSharedContextUpdateListenerServiceNames() {
        return this.sharedContextUpdateListenerServiceNames;
    }

    @Override
    public void setIndex(String name, String[] props) {
        this.indexManager.setIndex(name, props);
    }

    @Override
    public void setIndex(String name, BeanTableIndexKeyFactory keyFactory) {
        this.indexManager.setIndex(name, keyFactory);
    }

    @Override
    public void removeIndex(String name) {
        this.indexManager.removeIndex(name);
    }

    @Override
    public void analyzeIndex(String name) throws SharedContextSendException, SharedContextTimeoutException {
        this.analyzeIndex(name, this.synchronizeTimeout);
    }

    @Override
    public void analyzeIndex(String name, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (!this.indexManager.hasIndex(name)) {
            block10: {
                if (!this.isClient) {
                    return;
                }
                try {
                    Message message = this.serverConnection.createMessage(this.subject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(21, name, new Long(timeout)));
                        Message[] responses = this.serverConnection.request(message, 1, timeout);
                        Object ret = responses[0].getObject();
                        responses[0].recycle();
                        if (ret instanceof Throwable) {
                            throw new SharedContextSendException((Throwable)ret);
                        }
                        break block10;
                    }
                    throw new NoConnectServerException("Main server is not found.");
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
                catch (RequestTimeoutException e) {
                    throw new SharedContextTimeoutException(e);
                }
            }
            return;
        }
        if (this.isClient) {
            this.synchronize(timeout);
        } else {
            this.indexManager.replaceIndex(name, new LocalSharedContext());
        }
    }

    @Override
    public float getCacheHitRatio() {
        long total = this.caheHitCount + this.caheNoHitCount;
        return total == 0L ? 0.0f : (float)this.caheHitCount / (float)total;
    }

    @Override
    public void resetCacheHitRatio() {
        this.caheHitCount = 0L;
        this.caheNoHitCount = 0L;
    }

    @Override
    public SharedContextView createView() {
        return new SharedContextViewImpl();
    }

    @Override
    public void createService() throws Exception {
        super.createService();
        this.keyLockMap = Collections.synchronizedMap(new HashMap());
        this.idLocksMap = Collections.synchronizedMap(new HashMap());
        this.clientCacheLockMap = Collections.synchronizedMap(new HashMap());
        this.indexManager = new SharedContextIndexManager();
    }

    @Override
    public void startService() throws Exception {
        block24: {
            if (this.requestConnectionFactoryServiceName == null) {
                throw new IllegalArgumentException("RequestConnectionFactoryServiceName must be specified.");
            }
            this.updateLock = new SynchronizeLock();
            this.referLock = new SynchronizeLock();
            if (this.isClient) {
                if (this.clientCacheMapServiceName != null) {
                    this.cacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.clientCacheMapServiceName);
                } else if (this.clientCacheMap != null) {
                    this.cacheMap = this.clientCacheMap;
                }
            } else if (this.serverCacheMapServiceName != null) {
                this.cacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.serverCacheMapServiceName);
            } else if (this.serverCacheMap != null) {
                this.cacheMap = this.serverCacheMap;
            }
            if (this.interpreterServiceName != null) {
                this.interpreter = (Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
            }
            if (this.sharedContextTransactionManagerServiceName != null) {
                this.sharedContextTransactionManager = (SharedContextTransactionManager)ServiceManagerFactory.getServiceObject(this.sharedContextTransactionManagerServiceName);
            }
            this.executeQueueHandlerContainer = new QueueHandlerContainerService();
            this.executeQueueHandlerContainer.create();
            this.executeQueueHandlerContainer.setQueueHandlerSize(this.executeThreadSize);
            if (this.executeQueueServiceName != null) {
                this.executeQueueHandlerContainer.setQueueServiceName(this.executeQueueServiceName);
            } else if (this.executeThreadSize > 0) {
                DefaultQueueService executeQueue = new DefaultQueueService();
                executeQueue.create();
                executeQueue.start();
                this.executeQueueHandlerContainer.setQueueService(executeQueue);
            }
            this.executeQueueHandlerContainer.setQueueHandler(new ExecuteQueueHandler());
            this.executeQueueHandlerContainer.start();
            if (this.sharedContextUpdateListenerServiceNames != null) {
                for (int i = 0; i < this.sharedContextUpdateListenerServiceNames.length; ++i) {
                    this.addSharedContextUpdateListener((SharedContextUpdateListener)ServiceManagerFactory.getServiceObject(this.sharedContextUpdateListenerServiceNames[i]));
                }
            }
            ServerConnectionFactory factory = (ServerConnectionFactory)ServiceManagerFactory.getServiceObject(this.requestConnectionFactoryServiceName);
            this.serverConnection = (RequestServerConnection)factory.getServerConnection();
            this.targetMessage = this.serverConnection.createMessage(this.subject, null);
            this.messageReceiver = (MessageReceiver)ServiceManagerFactory.getServiceObject(this.requestConnectionFactoryServiceName);
            this.clientSubject = this.subject + ".Client";
            this.allTargetMessage = this.serverConnection.createMessage(this.subject, null);
            this.allTargetMessage.setSubject(this.clientSubject, null);
            this.messageReceiver.addSubject(this, this.isClient ? this.clientSubject : this.subject);
            if (this.clusterServiceName == null) {
                throw new IllegalArgumentException("ClusterServiceName must be specified.");
            }
            this.cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
            this.cluster.addClusterListener(this);
            this.lockTimeoutTimer = new Timer("SharedContext LockTimeoutTimerThread of " + this.getServiceNameObject(), true);
            super.startService();
            if (this.isWaitConnectAllOnStart) {
                long startTime = System.currentTimeMillis();
                Object myId = this.cluster.getUID();
                while (true) {
                    long elapsedTime;
                    List clusterMembers = this.cluster.getMembers();
                    Set clientIds = this.serverConnection.getClientIds();
                    clientIds.add(myId);
                    int clientSize = clientIds.size();
                    clientIds.addAll(clusterMembers);
                    if (clientIds.size() == clientSize) {
                        clientIds = this.serverConnection.getReceiveClientIds(this.allTargetMessage);
                        clientIds.add(myId);
                        clientSize = clientIds.size();
                        clientIds.addAll(clusterMembers);
                        if (clientIds.size() == clientSize) break;
                    }
                    if ((elapsedTime = System.currentTimeMillis() - startTime) >= this.waitConnectTimeout) {
                        throw new Exception("A timeout occurred while waiting for all to connect. elapsedTime=" + elapsedTime);
                    }
                    Thread.sleep(100L);
                }
            }
            if (this.isSynchronizeOnStart && !this.isMain()) {
                this.waitConnectMain();
                try {
                    this.synchronize();
                }
                catch (NoConnectServerException e) {
                    if (this.isClient) break block24;
                    throw e;
                }
            }
        }
    }

    protected void waitConnectMain() throws Exception {
        if (!this.isWaitConnectAllOnStart) {
            long startTime = System.currentTimeMillis();
            while (!this.serverConnection.getReceiveClientIds(this.allTargetMessage).contains(this.getMainId())) {
                Thread.sleep(100L);
                long elapsedTime = System.currentTimeMillis() - startTime;
                if (elapsedTime < this.waitConnectTimeout) continue;
                throw new Exception("A timeout occurred while waiting for main to connect. elapsedTime=" + elapsedTime);
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        this.unlockAll();
        if (this.cluster != null) {
            this.cluster.removeClusterListener(this);
        }
        if (this.messageReceiver != null) {
            try {
                this.messageReceiver.removeMessageListener(this);
            }
            catch (MessageSendException messageSendException) {
                // empty catch block
            }
        }
        if (this.updateLock != null) {
            this.updateLock.close();
        }
        if (this.referLock != null) {
            this.referLock.close();
        }
        this.executeQueueHandlerContainer.stop();
        this.executeQueueHandlerContainer.destroy();
        this.executeQueueHandlerContainer = null;
        this.resetCacheHitRatio();
        super.stopService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyService() throws Exception {
        if (this.keyLockMap != null) {
            Map map = this.keyLockMap;
            synchronized (map) {
                this.keyLockMap = null;
            }
        }
        this.idLocksMap = null;
        this.clientCacheLockMap = null;
        super.destroyService();
    }

    @Override
    public synchronized void load() throws Exception {
        this.load(-1L);
    }

    @Override
    public synchronized void load(long timeout) throws Exception {
        block8: {
            if (this.isMain()) {
                super.load();
            } else {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(16));
                        Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                        Object ret = responses[0].getObject();
                        responses[0].recycle();
                        if (ret instanceof Throwable) {
                            throw new SharedContextSendException((Throwable)ret);
                        }
                        break block8;
                    }
                    throw new NoConnectServerException("Main server is not found.");
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
                catch (RequestTimeoutException e) {
                    throw new SharedContextTimeoutException(e);
                }
            }
        }
    }

    @Override
    public synchronized void loadKey() throws Exception {
        this.loadKey(-1L);
    }

    @Override
    public synchronized void loadKey(long timeout) throws Exception {
        block8: {
            if (this.isMain()) {
                super.loadKey();
            } else {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(17));
                        Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                        Object ret = responses[0].getObject();
                        responses[0].recycle();
                        if (ret instanceof Throwable) {
                            throw new SharedContextSendException((Throwable)ret);
                        }
                        break block8;
                    }
                    throw new NoConnectServerException("Main server is not found.");
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
                catch (RequestTimeoutException e) {
                    throw new SharedContextTimeoutException(e);
                }
            }
        }
    }

    @Override
    public void load(Object key) throws Exception {
        this.load(key, -1L);
    }

    @Override
    public void load(Object key, long timeout) throws Exception {
        block8: {
            if (this.isMain()) {
                super.load(key);
            } else {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(16, key));
                        Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                        Object ret = responses[0].getObject();
                        responses[0].recycle();
                        if (ret instanceof Throwable) {
                            throw new SharedContextSendException((Throwable)ret);
                        }
                        break block8;
                    }
                    throw new NoConnectServerException("Main server is not found.");
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
                catch (RequestTimeoutException e) {
                    throw new SharedContextTimeoutException(e);
                }
            }
        }
    }

    @Override
    public synchronized void save() throws Exception {
        this.save(-1L);
    }

    @Override
    public synchronized void save(long timeout) throws Exception {
        block10: {
            if (!this.isMain()) {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        Message[] responses;
                        block9: {
                            message.setObject(new SharedContextEvent(15));
                            responses = null;
                            try {
                                responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, this.isSaveOnlyMain ? 1 : 0, timeout);
                            }
                            catch (RequestTimeoutException e) {
                                responses = e.getResponses();
                                if (this.isSaveOnlyMain && responses != null && responses.length != 0) break block9;
                                throw new SharedContextTimeoutException(e);
                            }
                        }
                        for (int i = 0; i < responses.length; ++i) {
                            Object ret = responses[i].getObject();
                            responses[i].recycle();
                            if (!(ret instanceof Throwable)) continue;
                            throw new SharedContextSendException((Throwable)ret);
                        }
                        break block10;
                    }
                    throw new NoConnectServerException("Main server is not found.");
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
            }
        }
        if (!(this.isClient || !this.isMain() && this.isSaveOnlyMain)) {
            super.save();
        }
    }

    @Override
    public void save(Object key) throws Exception {
        this.save(key, -1L);
    }

    @Override
    public void save(Object key, long timeout) throws Exception {
        block10: {
            if (!this.isMain()) {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        Message[] responses;
                        block9: {
                            message.setObject(new SharedContextEvent(15, key));
                            responses = null;
                            try {
                                responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, this.isSaveOnlyMain ? 1 : 0, timeout);
                            }
                            catch (RequestTimeoutException e) {
                                responses = e.getResponses();
                                if (this.isSaveOnlyMain && responses != null && responses.length != 0) break block9;
                                throw new SharedContextTimeoutException(e);
                            }
                        }
                        for (int i = 0; i < responses.length; ++i) {
                            Object ret = responses[i].getObject();
                            responses[i].recycle();
                            if (!(ret instanceof Throwable)) continue;
                            throw new SharedContextSendException((Throwable)ret);
                        }
                        break block10;
                    }
                    throw new NoConnectServerException("Main server is not found.");
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
            }
        }
        if (!(this.isClient || !this.isMain() && this.isSaveOnlyMain)) {
            super.save(key);
        }
    }

    @Override
    public void synchronize() throws SharedContextSendException, SharedContextTimeoutException {
        this.synchronize(this.synchronizeTimeout);
    }

    @Override
    public synchronized void synchronize(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        Object id = this.cluster.getUID();
        try {
            int i;
            Message[] responses;
            long start = System.currentTimeMillis();
            if (!this.updateLock.acquireForLock(id, timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - start) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            Message message = this.serverConnection.createMessage(this.subject, null);
            message.setSubject(this.clientSubject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(24, null, new Long(timeout)));
                responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 0, timeout);
                for (i = 0; i < responses.length; ++i) {
                    Object ret = responses[i].getObject();
                    responses[i].recycle();
                    if (ret instanceof Throwable) {
                        throw new SharedContextSendException((Throwable)ret);
                    }
                    if (ret != null && ((Boolean)ret).booleanValue()) continue;
                    throw new SharedContextTimeoutException();
                }
            }
            if (this.isClient) {
                this.synchronizeForClient(timeout);
            } else if (this.isMain()) {
                message = this.serverConnection.createMessage(this.subject, null);
                message.setSubject(this.clientSubject, null);
                receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(11, null, new Long(timeout)));
                    responses = this.serverConnection.request(message, 0, timeout);
                    for (i = 0; i < responses.length; ++i) {
                        if (responses[i].getObject() == null || !((Boolean)responses[i].getObject()).booleanValue()) {
                            throw new SharedContextSendException("It faild to synchronize.");
                        }
                        responses[i].recycle();
                    }
                }
            } else {
                this.synchronizeWithMain(timeout);
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
        catch (RequestTimeoutException e) {
            throw new SharedContextTimeoutException(e);
        }
        finally {
            try {
                Message message = this.serverConnection.createMessage(this.subject, null);
                message.setSubject(this.clientSubject, null);
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(25, this.cluster.getUID()));
                    this.serverConnection.sendAsynch(message);
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            this.updateLock.releaseForLock(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void synchronizeForClient(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        block17: {
            if (this.cacheMap != null) {
                Object[] keys = null;
                Map map = this.context;
                synchronized (map) {
                    keys = super.keySet().toArray();
                }
                for (int i = 0; i < keys.length; ++i) {
                    this.cacheMap.remove(keys[i]);
                }
            }
            if (this.updateListeners != null) {
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onClearSynchronize(this);
                }
            }
            super.clear();
            if (this.updateListeners != null || this.indexManager.hasIndex()) {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(4));
                        Message[] responses = this.serverConnection.request(message, 1, timeout);
                        Map result = (Map)responses[0].getObject();
                        responses[0].recycle();
                        if (result != null) {
                            for (Map.Entry entry : result.entrySet()) {
                                boolean isPut = true;
                                if (this.updateListeners != null) {
                                    for (int i = 0; i < this.updateListeners.size(); ++i) {
                                        if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutSynchronize(this, entry.getKey(), entry.getValue())) continue;
                                        isPut = false;
                                        break;
                                    }
                                }
                                if (!isPut || !this.indexManager.hasIndex() || entry.getValue() == null) continue;
                                this.indexManager.add(entry.getKey(), entry.getValue());
                            }
                        }
                        break block17;
                    }
                    throw new NoConnectServerException();
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
                catch (RequestTimeoutException e) {
                    throw new SharedContextTimeoutException(e);
                }
            }
        }
    }

    protected synchronized void synchronizeWithMain(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        block11: {
            try {
                Message message = this.serverConnection.createMessage(this.subject, null);
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(4));
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                    Map result = (Map)responses[0].getObject();
                    responses[0].recycle();
                    if (this.updateListeners != null) {
                        for (int i = 0; i < this.updateListeners.size(); ++i) {
                            ((SharedContextUpdateListener)this.updateListeners.get(i)).onClearSynchronize(this);
                        }
                    }
                    super.clear();
                    if (result != null) {
                        for (Map.Entry entry : result.entrySet()) {
                            boolean isPut = true;
                            if (this.updateListeners != null) {
                                for (int i = 0; i < this.updateListeners.size(); ++i) {
                                    if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutSynchronize(this, entry.getKey(), entry.getValue())) continue;
                                    isPut = false;
                                    break;
                                }
                            }
                            if (!isPut) continue;
                            super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                            if (!this.indexManager.hasIndex() || entry.getValue() == null) continue;
                            this.indexManager.add(entry.getKey(), entry.getValue());
                        }
                    }
                    break block11;
                }
                throw new NoConnectServerException("Main server is not found.");
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
        }
    }

    protected Object wrapCachedReference(Object key, Object value) {
        if (value == null || this.cacheMap == null) {
            return value;
        }
        this.cacheMap.put(key, value);
        KeyCachedReference ref = this.cacheMap.getCachedReference(key);
        if (ref != null) {
            ref.addCacheRemoveListener(this);
        }
        return ref;
    }

    protected Object unwrapCachedReference(Object value, boolean notify, boolean remove) {
        if (value == null) {
            return null;
        }
        if (this.cacheMap == null) {
            return value;
        }
        CachedReference ref = (CachedReference)value;
        Object ret = ref.get(this, notify);
        if (remove) {
            ref.remove(this);
        }
        return ret;
    }

    @Override
    public void lock(Object key) throws SharedContextSendException, SharedContextTimeoutException {
        this.lock(key, this.defaultTimeout);
    }

    @Override
    public void lock(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        this.lock(key, false, false, this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean lock(Object key, boolean ifAcquireable, boolean ifExist, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        Object id = this.cluster.getUID();
        Lock lock = null;
        Map map = this.keyLockMap;
        synchronized (map) {
            lock = (Lock)this.keyLockMap.get(key);
            if (lock == null) {
                lock = new Lock(key);
                this.keyLockMap.put(key, lock);
            }
        }
        Object lockedOwner = lock.getOwner();
        if (id.equals(lockedOwner) && Thread.currentThread().equals(lock.getOwnerThread())) {
            return true;
        }
        if (this.isMain()) {
            if (ifExist && !super.containsKey(key)) {
                return false;
            }
            long start = System.currentTimeMillis();
            if (lock.acquire(id, ifAcquireable, timeout)) {
                if (ifExist && !super.containsKey(key)) {
                    lock.release(id, false);
                    return false;
                }
                boolean isNoTimeout = timeout <= 0L;
                long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                if (!isNoTimeout && timeout <= 0L) {
                    lock.release(id, false);
                    throw new SharedContextTimeoutException();
                }
                try {
                    Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                    message.setSubject(this.clientSubject, key == null ? null : key.toString());
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() == 0) return true;
                    message.setObject(new SharedContextEvent(13, key, new Object[]{id, new Long(Thread.currentThread().getId()), new Long(timeout)}));
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 0, timeout);
                    for (int i = 0; i < responses.length; ++i) {
                        Object ret = responses[i].getObject();
                        responses[i].recycle();
                        if (ret instanceof Throwable) {
                            this.unlock(key);
                            throw new SharedContextSendException((Throwable)ret);
                        }
                        if (ret != null && ((Boolean)ret).booleanValue()) continue;
                        this.unlock(key);
                        throw new SharedContextTimeoutException();
                    }
                    return true;
                }
                catch (MessageException e) {
                    this.unlock(key);
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    this.unlock(key);
                    throw new SharedContextSendException(e);
                }
                catch (RequestTimeoutException e) {
                    this.unlock(key);
                    throw new SharedContextTimeoutException(e);
                }
                catch (RuntimeException e) {
                    this.unlock(key);
                    throw e;
                }
                catch (Error e) {
                    this.unlock(key);
                    throw e;
                }
                catch (Throwable th) {
                    this.unlock(key);
                    throw new SharedContextSendException(th);
                }
            }
            if (!ifAcquireable) throw new SharedContextTimeoutException("key=" + key + ", timeout=" + timeout + ", processTime=" + (System.currentTimeMillis() - start));
            return false;
        }
        if (ifExist && !super.containsKey(key)) {
            return false;
        }
        if (ifAcquireable && !lock.isAcquireable(id)) {
            return false;
        }
        long start = System.currentTimeMillis();
        try {
            Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() == 0) throw new NoConnectServerException("Main server is not found.");
            message.setObject(new SharedContextEvent(12, key, new Object[]{new Long(Thread.currentThread().getId()), ifAcquireable ? Boolean.TRUE : Boolean.FALSE, ifExist ? Boolean.TRUE : Boolean.FALSE, new Long(timeout)}));
            Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 1, timeout);
            Object ret = responses[0].getObject();
            responses[0].recycle();
            if (ret instanceof Throwable) {
                this.unlock(key);
                throw new SharedContextSendException((Throwable)ret);
            }
            if (ret == null || !((Boolean)ret).booleanValue()) {
                this.unlock(key);
                if (!ifAcquireable) throw new SharedContextTimeoutException("key=" + key + ", timeout=" + timeout);
                return false;
            }
        }
        catch (MessageException e) {
            this.unlock(key);
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            this.unlock(key);
            throw new SharedContextSendException(e);
        }
        catch (RequestTimeoutException e) {
            boolean isNoTimeout = timeout <= 0L;
            long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
            if (isNoTimeout || timeout > 0L) return this.lock(key, ifAcquireable, ifExist, timeout);
            this.unlock(key);
            throw new SharedContextTimeoutException("key=" + key + ", timeout=" + timeout + ", processTime=" + (System.currentTimeMillis() - start), e);
        }
        catch (RuntimeException e) {
            this.unlock(key);
            throw e;
        }
        catch (Error e) {
            this.unlock(key);
            throw e;
        }
        if (lock.acquire(id, ifAcquireable, timeout)) return true;
        this.unlock(key);
        if (!ifAcquireable) throw new SharedContextTimeoutException();
        return false;
    }

    @Override
    public boolean unlock(Object key) throws SharedContextSendException {
        return this.unlock(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unlock(Object key, boolean force) throws SharedContextSendException {
        boolean result;
        Lock lock = null;
        Map map = this.keyLockMap;
        synchronized (map) {
            lock = (Lock)this.keyLockMap.get(key);
        }
        Object id = this.cluster.getUID();
        if (force && lock != null && lock.getOwner() != null) {
            id = lock.getOwner();
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
            message.setSubject(this.clientSubject, key == null ? null : key.toString());
            message.setObject(new SharedContextEvent(14, key, id));
            this.serverConnection.sendAsynch(message);
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
        boolean bl = result = lock == null;
        if (lock != null) {
            result = lock.release(id, force);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAll() {
        Map map = this.keyLockMap;
        synchronized (map) {
            Object myId = this.cluster.getUID();
            for (Map.Entry entry : this.keyLockMap.entrySet()) {
                Object key = entry.getKey();
                Lock lock = (Lock)entry.getValue();
                Object owner = lock.getOwner();
                if (owner == null || !owner.equals(myId)) continue;
                try {
                    this.unlock(key, true);
                }
                catch (SharedContextSendException e) {
                    lock.release(myId, true);
                }
            }
        }
        map = this.clientCacheLockMap;
        synchronized (map) {
            for (ClientCacheLock lock : this.clientCacheLockMap.values()) {
                lock.notifyAllLock();
            }
        }
        this.lockTimeoutTimer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getLockOwner(Object key) {
        Lock lock = null;
        Map map = this.keyLockMap;
        synchronized (map) {
            lock = (Lock)this.keyLockMap.get(key);
        }
        return lock == null ? null : lock.getOwner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLockWaitCount(Object key) {
        Lock lock = null;
        Map map = this.keyLockMap;
        synchronized (map) {
            lock = (Lock)this.keyLockMap.get(key);
        }
        return lock == null ? 0 : lock.getWaitCount();
    }

    @Override
    public Object put(Object key, Object value) throws SharedContextSendException {
        return this.put(key, value, this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        SharedContextTransactionManager.SharedContextTransaction transaction;
        if (this.sharedContextTransactionManager != null && (transaction = this.sharedContextTransactionManager.getTransaction()) != null && transaction.getState() == 1) {
            return transaction.put(this, key, value, timeout);
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, key, value)) continue;
                return null;
            }
        }
        Object result = null;
        try {
            long startTime = System.currentTimeMillis();
            if (!this.updateLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            SharedContextTimeoutException timeoutException = null;
            try {
                Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                message.setSubject(this.clientSubject, key == null ? null : key.toString());
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(1, key, value));
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 0, timeout);
                    for (int i = 0; i < responses.length; ++i) {
                        if (responses[i].getObject() != null) {
                            result = responses[i].getObject();
                        }
                        responses[i].recycle();
                    }
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                timeoutException = new SharedContextTimeoutException(e);
            }
            boolean isContainsKey = super.containsKey(key);
            if (this.isClient) {
                if (isContainsKey) {
                    result = super.put(key, this.wrapCachedReference(key, value));
                    result = this.unwrapCachedReference(result, false, true);
                }
            } else {
                result = super.put(key, this.wrapCachedReference(key, value));
                result = this.unwrapCachedReference(result, false, true);
            }
            if (this.indexManager.hasIndex()) {
                if (isContainsKey && result != null) {
                    if (value != null) {
                        this.indexManager.replace(key, result, value);
                    } else {
                        this.indexManager.remove(key, result);
                    }
                } else if (value != null) {
                    this.indexManager.add(key, value);
                }
            }
            if (timeoutException != null) {
                throw timeoutException;
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, key, value, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putLocal(Object key, Object value) {
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, key, value)) continue;
                return null;
            }
        }
        Object result = null;
        try {
            this.updateLock.acquireForUse(-1L);
            boolean isContainsKey = super.containsKey(key);
            if (this.isClient) {
                if (isContainsKey) {
                    result = super.put(key, this.wrapCachedReference(key, value));
                    result = this.unwrapCachedReference(result, false, true);
                }
            } else {
                result = super.put(key, this.wrapCachedReference(key, value));
                result = this.unwrapCachedReference(result, false, true);
            }
            if (this.indexManager.hasIndex()) {
                if (isContainsKey && result != null) {
                    if (value != null) {
                        this.indexManager.replace(key, result, value);
                    } else {
                        this.indexManager.remove(key, result);
                    }
                } else if (value != null) {
                    this.indexManager.add(key, value);
                }
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, key, value, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAsynch(Object key, Object value) throws SharedContextSendException {
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, key, value)) continue;
                return;
            }
        }
        Object removed = null;
        try {
            this.updateLock.acquireForUse(-1L);
            if (this.isClient && this.indexManager.hasIndex()) {
                try {
                    if (!this.referLock.acquireForUse(-1L)) {
                        throw new SharedContextTimeoutException();
                    }
                    removed = this.get(key);
                }
                finally {
                    this.referLock.releaseForUse();
                }
            }
            try {
                Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                message.setSubject(this.clientSubject, key == null ? null : key.toString());
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(1, key, value));
                    this.serverConnection.sendAsynch(message);
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            boolean isContainsKey = super.containsKey(key);
            if (this.isClient) {
                if (isContainsKey) {
                    super.put(key, this.wrapCachedReference(key, value));
                }
            } else {
                removed = super.put(key, this.wrapCachedReference(key, value));
                removed = this.unwrapCachedReference(removed, false, true);
            }
            if (this.indexManager.hasIndex()) {
                if (isContainsKey && removed != null) {
                    if (value != null) {
                        this.indexManager.replace(key, removed, value);
                    } else {
                        this.indexManager.remove(key, removed);
                    }
                } else if (value != null) {
                    this.indexManager.add(key, value);
                }
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, key, value, removed);
            }
        }
    }

    @Override
    public void update(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
        this.update(key, diff, this.defaultTimeout);
    }

    @Override
    public void updateIfExists(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
        this.updateIfExists(key, diff, this.defaultTimeout);
    }

    @Override
    public void update(Object key, SharedContextValueDifference diff, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        this.update(key, diff, this.defaultTimeout, false);
    }

    @Override
    public void updateIfExists(Object key, SharedContextValueDifference diff, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        this.update(key, diff, this.defaultTimeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(Object key, SharedContextValueDifference diff, long timeout, boolean ifExists) throws SharedContextSendException, SharedContextTimeoutException {
        SharedContextTransactionManager.SharedContextTransaction transaction;
        if (diff == null) {
            return;
        }
        if (this.sharedContextTransactionManager != null && (transaction = this.sharedContextTransactionManager.getTransaction()) != null && transaction.getState() == 1) {
            if (ifExists) {
                transaction.updateIfExists(this, key, diff, timeout);
            } else {
                transaction.update(this, key, diff, timeout);
            }
            return;
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateBefore(this, true, key, diff)) continue;
                return;
            }
        }
        try {
            Object ret;
            int i;
            Message[] responses;
            Set receiveClients;
            Message message;
            Object oldValue = null;
            Object newValue = null;
            long startTime = System.currentTimeMillis();
            if (!this.updateLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L) {
                if ((timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                    throw new SharedContextTimeoutException();
                }
                startTime = System.currentTimeMillis();
            }
            if (!this.referLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L) {
                if ((timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                    throw new SharedContextTimeoutException();
                }
                startTime = System.currentTimeMillis();
            }
            if (this.isClient && !super.containsKey(key)) {
                oldValue = this.get(key, timeout);
                if (!(oldValue instanceof SharedContextValueDifferenceSupport)) {
                    throw new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + key + ", value=" + oldValue);
                }
                oldValue = ((SharedContextValueDifferenceSupport)oldValue).clone();
                if (timeout > 0L) {
                    if ((timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    startTime = System.currentTimeMillis();
                }
            }
            SharedContextTimeoutException timeoutException = null;
            try {
                message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(18, key, new Object[]{diff, ifExists ? Boolean.TRUE : Boolean.FALSE}));
                    responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 0, timeout);
                    for (i = 0; i < responses.length; ++i) {
                        ret = responses[i].getObject();
                        responses[i].recycle();
                        if (ret == null || !(ret instanceof Throwable)) continue;
                        throw new SharedContextSendException((Throwable)ret);
                    }
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                timeoutException = new SharedContextTimeoutException(e);
            }
            if (!this.isClient || super.containsKey(key)) {
                Object current = this.getRawLocal(key);
                Object currentValue = this.unwrapCachedReference(current, false, false);
                if (currentValue == null) {
                    if (!ifExists) {
                        throw new SharedContextUpdateException("Current value is null. key=" + key);
                    }
                } else if (currentValue instanceof SharedContextValueDifferenceSupport) {
                    oldValue = ((SharedContextValueDifferenceSupport)currentValue).clone();
                    int updateResult = ((SharedContextValueDifferenceSupport)currentValue).update(diff);
                    if (updateResult == -1) {
                        throw new SharedContextUpdateException("An update version is mismatching. currentVersion=" + ((SharedContextValueDifferenceSupport)currentValue).getUpdateVersion() + ", updateVersion=" + diff.getUpdateVersion());
                    }
                    if (updateResult == 0) {
                        this.getLogger().write("SCS__00009", new Object[]{key, this.subject});
                    }
                    newValue = currentValue;
                } else {
                    throw new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + key + ", value=" + currentValue);
                }
                if (currentValue != null && current instanceof CachedReference) {
                    try {
                        ((CachedReference)current).set(this, currentValue);
                    }
                    catch (IllegalCachedReferenceException e) {
                        throw new SharedContextUpdateException(e);
                    }
                }
            } else {
                newValue = this.get(key, timeout);
                if (timeout > 0L) {
                    if ((timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    startTime = System.currentTimeMillis();
                }
            }
            if (super.containsKey(key) && this.indexManager.hasIndex()) {
                this.indexManager.replace(key, oldValue, newValue);
            }
            try {
                message = this.serverConnection.createMessage(this.clientSubject, key == null ? null : key.toString());
                receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(18, key, new Object[]{diff, ifExists ? Boolean.TRUE : Boolean.FALSE}));
                    responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 0, timeout);
                    for (i = 0; i < responses.length; ++i) {
                        ret = responses[i].getObject();
                        responses[i].recycle();
                        if (ret == null || !(ret instanceof Throwable)) continue;
                        throw new SharedContextSendException((Throwable)ret);
                    }
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
            if (timeoutException != null) {
                throw timeoutException;
            }
        }
        finally {
            this.referLock.releaseForUse();
            this.updateLock.releaseForUse();
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateAfter(this, true, key, diff);
            }
        }
    }

    @Override
    public void updateLocal(Object key, SharedContextValueDifference diff) throws SharedContextUpdateException {
        this.updateLocal(key, diff, false);
    }

    @Override
    public void updateLocalIfExists(Object key, SharedContextValueDifference diff) throws SharedContextUpdateException {
        this.updateLocal(key, diff, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLocal(Object key, SharedContextValueDifference diff, boolean ifExists) throws SharedContextUpdateException {
        if (diff == null) {
            return;
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateBefore(this, true, key, diff)) continue;
                return;
            }
        }
        try {
            Object oldValue = null;
            Object newValue = null;
            this.updateLock.acquireForUse(-1L);
            Object current = this.getRawLocal(key);
            Object currentValue = this.unwrapCachedReference(current, false, false);
            if (currentValue != null) {
                if (currentValue instanceof SharedContextValueDifferenceSupport) {
                    oldValue = ((SharedContextValueDifferenceSupport)currentValue).clone();
                } else {
                    throw new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + key + ", value=" + currentValue);
                }
            }
            if (!this.isClient || super.containsKey(key)) {
                if (currentValue == null && !ifExists) {
                    throw new SharedContextUpdateException("Current value is null. key=" + key);
                }
                int updateResult = ((SharedContextValueDifferenceSupport)currentValue).update(diff);
                if (updateResult == -1) {
                    throw new SharedContextUpdateException("An update version is mismatching. currentVersion=" + ((SharedContextValueDifferenceSupport)currentValue).getUpdateVersion() + ", updateVersion=" + diff.getUpdateVersion());
                }
                if (updateResult == 0) {
                    this.getLogger().write("SCS__00009", new Object[]{key, this.subject});
                }
                newValue = currentValue;
                if (currentValue != null && current instanceof CachedReference) {
                    try {
                        ((CachedReference)current).set(this, currentValue);
                    }
                    catch (IllegalCachedReferenceException e) {
                        throw new SharedContextUpdateException(e);
                    }
                }
            }
            if (super.containsKey(key) && this.indexManager.hasIndex()) {
                this.indexManager.replace(key, oldValue, newValue);
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateAfter(this, true, key, diff);
            }
        }
    }

    @Override
    public void updateAsynch(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
        this.updateAsynch(key, diff, false);
    }

    @Override
    public void updateAsynchIfExists(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
        this.updateAsynch(key, diff, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAsynch(Object key, SharedContextValueDifference diff, boolean ifExists) throws SharedContextSendException {
        if (diff == null) {
            return;
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateBefore(this, true, key, diff)) continue;
                return;
            }
        }
        try {
            Object oldValue = null;
            Object newValue = null;
            this.updateLock.acquireForUse(-1L);
            if (this.isClient && this.indexManager.hasIndex()) {
                try {
                    if (!this.referLock.acquireForUse(-1L)) {
                        throw new SharedContextTimeoutException();
                    }
                    oldValue = this.get(key);
                }
                finally {
                    this.referLock.releaseForUse();
                }
            }
            try {
                Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                message.setSubject(this.clientSubject, key == null ? null : key.toString());
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(18, key, new Object[]{diff, ifExists ? Boolean.TRUE : Boolean.FALSE}));
                    this.serverConnection.sendAsynch(message);
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            if (!this.isClient || super.containsKey(key)) {
                Object current = this.getRawLocal(key);
                Object currentValue = this.unwrapCachedReference(current, false, false);
                if (currentValue == null) {
                    if (!ifExists) {
                        throw new SharedContextUpdateException("Current value is null. key=" + key);
                    }
                } else if (currentValue instanceof SharedContextValueDifferenceSupport) {
                    oldValue = ((SharedContextValueDifferenceSupport)currentValue).clone();
                    int updateResult = ((SharedContextValueDifferenceSupport)currentValue).update(diff);
                    if (updateResult == -1) {
                        throw new SharedContextUpdateException("An update version is mismatching. currentVersion=" + ((SharedContextValueDifferenceSupport)currentValue).getUpdateVersion() + ", updateVersion=" + diff.getUpdateVersion());
                    }
                    if (updateResult == 0) {
                        this.getLogger().write("SCS__00009", new Object[]{key, this.subject});
                    }
                    newValue = currentValue;
                } else {
                    throw new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + key + ", value=" + currentValue);
                }
                if (currentValue != null && current instanceof CachedReference) {
                    try {
                        ((CachedReference)current).set(this, currentValue);
                    }
                    catch (IllegalCachedReferenceException e) {
                        throw new SharedContextUpdateException(e);
                    }
                }
            }
            if (super.containsKey(key) && this.indexManager.hasIndex()) {
                this.indexManager.replace(key, oldValue, newValue);
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateAfter(this, true, key, diff);
            }
        }
    }

    @Override
    public Object remove(Object key) throws SharedContextSendException {
        return this.remove(key, this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        SharedContextTransactionManager.SharedContextTransaction transaction;
        if (this.isMain() && !super.containsKey(key)) {
            return null;
        }
        if (this.sharedContextTransactionManager != null && (transaction = this.sharedContextTransactionManager.getTransaction()) != null && transaction.getState() == 1) {
            return transaction.remove(this, key, timeout);
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveBefore(this, true, key)) continue;
                return null;
            }
        }
        Object result = null;
        try {
            long startTime = System.currentTimeMillis();
            if (!this.updateLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            SharedContextTimeoutException timeoutException = null;
            try {
                Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                message.setSubject(this.clientSubject, key == null ? null : key.toString());
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(2, key));
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 0, timeout);
                    if (responses != null) {
                        int i;
                        if (this.isMain()) {
                            for (i = 0; i < responses.length; ++i) {
                                responses[i].recycle();
                            }
                        } else {
                            for (i = 0; i < responses.length; ++i) {
                                if (responses[i].getObject() != null) {
                                    result = responses[i].getObject();
                                }
                                responses[i].recycle();
                            }
                        }
                    }
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                timeoutException = new SharedContextTimeoutException(e);
            }
            if (this.isMain()) {
                result = super.remove(key);
                result = this.unwrapCachedReference(result, false, true);
            } else {
                Object removed = super.remove(key);
                this.unwrapCachedReference(removed, false, true);
            }
            if (this.indexManager.hasIndex() && result != null) {
                this.indexManager.remove(key, result);
            }
            if (timeoutException != null) {
                throw timeoutException;
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveAfter(this, true, key, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeLocal(Object key) {
        if (this.isMain() && !super.containsKey(key)) {
            return null;
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveBefore(this, true, key)) continue;
                return null;
            }
        }
        Object result = null;
        try {
            this.updateLock.acquireForUse(-1L);
            result = super.remove(key);
            result = this.unwrapCachedReference(result, false, true);
            if (this.indexManager.hasIndex() && result != null) {
                this.indexManager.remove(key, result);
            }
            if (this.updateListeners != null) {
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveAfter(this, true, key, result);
                }
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAsynch(Object key) throws SharedContextSendException {
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveBefore(this, true, key)) continue;
                return;
            }
        }
        Object removed = null;
        try {
            this.updateLock.acquireForUse(-1L);
            if (this.isClient && this.indexManager.hasIndex()) {
                try {
                    if (!this.referLock.acquireForUse(-1L)) {
                        throw new SharedContextTimeoutException();
                    }
                    removed = this.get(key);
                }
                finally {
                    this.referLock.releaseForUse();
                }
            }
            try {
                Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                message.setSubject(this.clientSubject, key == null ? null : key.toString());
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(2, key));
                    this.serverConnection.sendAsynch(message);
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            if (removed == null) {
                removed = super.remove(key);
                removed = this.unwrapCachedReference(removed, false, true);
            } else {
                super.remove(key);
            }
            if (this.indexManager.hasIndex() && removed != null) {
                this.indexManager.remove(key, removed);
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveAfter(this, true, key, removed);
            }
        }
    }

    @Override
    public void putAll(Map t) {
        this.putAll(t, this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void putAll(Map t, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (t.size() == 0) {
            return;
        }
        if (this.updateListeners != null) {
            LinkedHashMap tmpMap = new LinkedHashMap();
            for (Map.Entry entry : t.entrySet()) {
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    if (this.isClient && !super.containsKey(entry.getKey()) || !((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, entry.getKey(), entry.getValue())) continue;
                    tmpMap.put(entry.getKey(), entry.getValue());
                }
            }
            if (tmpMap.size() == 0) {
                return;
            }
            t = tmpMap;
        }
        try {
            long startTime = System.currentTimeMillis();
            if (!this.updateLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            SharedContextTimeoutException timeoutException = null;
            try {
                Message message = this.serverConnection.createMessage(this.subject, null);
                message.setSubject(this.clientSubject, null);
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(6, null, t));
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 0, timeout);
                    for (int i = 0; i < responses.length; ++i) {
                        Object ret = responses[i].getObject();
                        responses[i].recycle();
                        if (ret == null || !(ret instanceof Throwable)) continue;
                        throw new SharedContextSendException((Throwable)ret);
                    }
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                timeoutException = new SharedContextTimeoutException(e);
            }
            for (Map.Entry entry : t.entrySet()) {
                boolean isContainsKey = super.containsKey(entry.getKey());
                Object old = null;
                if (this.isClient) {
                    if (isContainsKey) {
                        old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                        old = this.unwrapCachedReference(old, false, true);
                    }
                } else {
                    old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                    old = this.unwrapCachedReference(old, false, true);
                }
                if (this.indexManager.hasIndex()) {
                    if (isContainsKey && old != null) {
                        if (entry.getValue() != null) {
                            this.indexManager.replace(entry.getKey(), old, entry.getValue());
                        } else {
                            this.indexManager.remove(entry.getKey(), old);
                        }
                    } else if (entry.getValue() != null) {
                        this.indexManager.add(entry.getKey(), entry.getValue());
                    }
                }
                if (this.updateListeners == null) continue;
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, entry.getKey(), entry.getValue(), old);
                }
            }
            if (timeoutException != null) {
                throw timeoutException;
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void putAllLocal(Map t) {
        if (t.size() == 0) {
            return;
        }
        if (this.updateListeners != null) {
            LinkedHashMap tmpMap = new LinkedHashMap();
            for (Map.Entry entry : t.entrySet()) {
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    if (this.isClient && !super.containsKey(entry.getKey()) || !((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, entry.getKey(), entry.getValue())) continue;
                    tmpMap.put(entry.getKey(), entry.getValue());
                }
            }
            if (tmpMap.size() == 0) {
                return;
            }
            t = tmpMap;
        }
        try {
            this.updateLock.acquireForUse(-1L);
            for (Map.Entry entry : t.entrySet()) {
                boolean isContainsKey = super.containsKey(entry.getKey());
                Object old = null;
                if (this.isClient) {
                    if (isContainsKey) {
                        old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                        old = this.unwrapCachedReference(old, false, true);
                    }
                } else {
                    old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                    old = this.unwrapCachedReference(old, false, true);
                }
                if (this.indexManager.hasIndex()) {
                    if (isContainsKey && old != null) {
                        if (entry.getValue() != null) {
                            this.indexManager.replace(entry.getKey(), old, entry.getValue());
                        } else {
                            this.indexManager.remove(entry.getKey(), old);
                        }
                    } else if (entry.getValue() != null) {
                        this.indexManager.add(entry.getKey(), entry.getValue());
                    }
                }
                if (this.updateListeners == null) continue;
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, entry.getKey(), entry.getValue(), old);
                }
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void putAllAsynch(Map t) throws SharedContextSendException {
        if (t.size() == 0) {
            return;
        }
        if (this.updateListeners != null) {
            LinkedHashMap tmpMap = new LinkedHashMap();
            for (Map.Entry entry : t.entrySet()) {
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    if (this.isClient && !super.containsKey(entry.getKey()) || !((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, entry.getKey(), entry.getValue())) continue;
                    tmpMap.put(entry.getKey(), entry.getValue());
                }
            }
            if (tmpMap.size() == 0) {
                return;
            }
            t = tmpMap;
        }
        try {
            this.updateLock.acquireForUse(-1L);
            HashMap oldMap = null;
            if (this.isClient && this.indexManager.hasIndex()) {
                try {
                    if (!this.referLock.acquireForUse(-1L)) {
                        throw new SharedContextTimeoutException();
                    }
                    oldMap = new HashMap();
                    for (Map.Entry entry : t.entrySet()) {
                        oldMap.put(entry.getKey(), this.get(entry.getKey()));
                    }
                }
                finally {
                    this.referLock.releaseForUse();
                }
            }
            try {
                Message message = this.serverConnection.createMessage(this.subject, null);
                message.setSubject(this.clientSubject, null);
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(6, null, t));
                    this.serverConnection.sendAsynch(message);
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            for (Map.Entry entry : t.entrySet()) {
                Object old = null;
                boolean isContainsKey = super.containsKey(entry.getKey());
                if (this.isClient) {
                    if (isContainsKey) {
                        old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                        old = this.unwrapCachedReference(old, false, true);
                    } else {
                        old = oldMap.get(entry.getKey());
                    }
                } else {
                    old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                    old = this.unwrapCachedReference(old, false, true);
                }
                if (this.indexManager.hasIndex()) {
                    if (isContainsKey && old != null) {
                        if (entry.getValue() != null) {
                            this.indexManager.replace(entry.getKey(), old, entry.getValue());
                        } else {
                            this.indexManager.remove(entry.getKey(), old);
                        }
                    } else if (entry.getValue() != null) {
                        this.indexManager.add(entry.getKey(), entry.getValue());
                    }
                }
                if (this.updateListeners == null) continue;
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, entry.getKey(), entry.getValue(), old);
                }
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
    }

    @Override
    public void clear() throws SharedContextSendException {
        this.clear(this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clear(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (this.isMain() && this.size() == 0) {
            return;
        }
        try {
            Object receiveClients;
            long startTime = System.currentTimeMillis();
            if (!this.updateLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            SharedContextTimeoutException timeoutException = null;
            try {
                Message message = this.serverConnection.createMessage(this.subject, null);
                message.setSubject(this.clientSubject, null);
                receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(3));
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 0, timeout);
                    for (int i = 0; i < responses.length; ++i) {
                        Object ret = responses[i].getObject();
                        responses[i].recycle();
                        if (ret == null || !(ret instanceof Throwable)) continue;
                        throw new SharedContextSendException((Throwable)ret);
                    }
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                timeoutException = new SharedContextTimeoutException(e);
            }
            Object[] keys = null;
            receiveClients = this.context;
            synchronized (receiveClients) {
                keys = super.keySet().toArray();
            }
            for (int i = 0; i < keys.length; ++i) {
                int j;
                if (this.updateListeners != null) {
                    boolean isRemove = true;
                    for (j = 0; j < this.updateListeners.size(); ++j) {
                        if (((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveBefore(this, true, keys[i])) continue;
                        isRemove = false;
                        break;
                    }
                    if (!isRemove) continue;
                }
                Object removed = super.remove(keys[i]);
                removed = this.unwrapCachedReference(removed, false, true);
                if (this.indexManager.hasIndex() && removed != null) {
                    this.indexManager.remove(keys[i], removed);
                }
                if (this.updateListeners == null) continue;
                for (j = 0; j < this.updateListeners.size(); ++j) {
                    ((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveAfter(this, true, keys[i], removed);
                }
            }
            if (timeoutException != null) {
                throw timeoutException;
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clearLocal() {
        if (this.size() == 0) {
            return;
        }
        Object[] keys = null;
        Map map = this.context;
        synchronized (map) {
            keys = super.keySet().toArray();
        }
        try {
            this.updateLock.acquireForUse(-1L);
            for (int i = 0; i < keys.length; ++i) {
                int j;
                if (this.updateListeners != null) {
                    boolean isRemove = true;
                    for (j = 0; j < this.updateListeners.size(); ++j) {
                        if (((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveBefore(this, true, keys[i])) continue;
                        isRemove = false;
                        break;
                    }
                    if (!isRemove) continue;
                }
                Object removed = super.remove(keys[i]);
                removed = this.unwrapCachedReference(removed, false, true);
                if (this.indexManager.hasIndex() && removed != null) {
                    this.indexManager.remove(keys[i], removed);
                }
                if (this.updateListeners == null) continue;
                for (j = 0; j < this.updateListeners.size(); ++j) {
                    ((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveAfter(this, true, keys[i], removed);
                }
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clearAsynch() throws SharedContextSendException {
        if (this.isMain() && this.size() == 0) {
            return;
        }
        try {
            Object receiveClients;
            this.updateLock.acquireForUse(-1L);
            try {
                Message message = this.serverConnection.createMessage(this.subject, null);
                message.setSubject(this.clientSubject, null);
                receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(3));
                    this.serverConnection.sendAsynch(message);
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            Object[] keys = null;
            receiveClients = this.context;
            synchronized (receiveClients) {
                keys = super.keySet().toArray();
            }
            for (int i = 0; i < keys.length; ++i) {
                int j;
                if (this.updateListeners != null) {
                    boolean isRemove = true;
                    for (j = 0; j < this.updateListeners.size(); ++j) {
                        if (((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveBefore(this, true, keys[i])) continue;
                        isRemove = false;
                        break;
                    }
                    if (!isRemove) continue;
                }
                Object removed = super.remove(keys[i]);
                removed = this.unwrapCachedReference(removed, false, true);
                if (this.updateListeners == null) continue;
                for (j = 0; j < this.updateListeners.size(); ++j) {
                    ((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveAfter(this, true, keys[i], removed);
                }
            }
            if (this.indexManager.hasIndex()) {
                this.indexManager.clear();
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
    }

    @Override
    public Object get(Object key) throws SharedContextSendException {
        return this.get(key, this.defaultTimeout);
    }

    @Override
    public Object get(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        return this.get(key, timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key, long timeout, boolean withTransaction) throws SharedContextSendException, SharedContextTimeoutException {
        Object result;
        block35: {
            SharedContextTransactionManager.SharedContextTransaction transaction;
            result = null;
            if (withTransaction && this.sharedContextTransactionManager != null && (transaction = this.sharedContextTransactionManager.getTransaction()) != null && transaction.getState() == 1) {
                return transaction.get(this, key, timeout);
            }
            try {
                long startTime = System.currentTimeMillis();
                if (!this.referLock.acquireForUse(timeout)) {
                    throw new SharedContextTimeoutException();
                }
                if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                    throw new SharedContextTimeoutException();
                }
                if (this.isClient) {
                    if (super.containsKey(key)) {
                        result = this.getLocal(key);
                        if (result == null && !super.containsKey(key)) {
                            result = this.get(key, timeout);
                        }
                        break block35;
                    }
                    ClientCacheLock lock = null;
                    ClientCacheLock newLock = null;
                    Map map = this.clientCacheLockMap;
                    synchronized (map) {
                        lock = (ClientCacheLock)this.clientCacheLockMap.get(key);
                        if (lock == null) {
                            newLock = new ClientCacheLock(key);
                            this.clientCacheLockMap.put(key, newLock);
                        } else {
                            lock.init();
                        }
                    }
                    if (lock != null) {
                        long start = System.currentTimeMillis();
                        if (!lock.waitLock(timeout)) {
                            throw new SharedContextTimeoutException();
                        }
                        boolean isNoTimeout = timeout <= 0L;
                        long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                        if (!isNoTimeout && timeout <= 0L) {
                            throw new SharedContextTimeoutException();
                        }
                        result = this.get(key, timeout);
                        break block35;
                    }
                    try {
                        Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                        Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                        if (receiveClients.size() != 0) {
                            message.setObject(new SharedContextEvent(5, key));
                            Message[] responses = this.serverConnection.request(message, this.clientSubject, key == null ? null : key.toString(), 1, timeout);
                            result = responses[0].getObject();
                            responses[0].recycle();
                            ClientCacheLock clientCacheLock = newLock;
                            synchronized (clientCacheLock) {
                                if (!newLock.isRemove()) {
                                    result = newLock.updateValue(result);
                                    super.put(key, this.wrapCachedReference(key, result));
                                }
                                break block35;
                            }
                        }
                        throw new NoConnectServerException();
                    }
                    catch (MessageException e) {
                        throw new SharedContextSendException(e);
                    }
                    catch (MessageSendException e) {
                        throw new SharedContextSendException(e);
                    }
                    catch (RequestTimeoutException e) {
                        throw new SharedContextTimeoutException(e);
                    }
                    finally {
                        Map map2 = this.clientCacheLockMap;
                        synchronized (map2) {
                            this.clientCacheLockMap.remove(key);
                            newLock.notifyAllLock();
                        }
                    }
                }
                result = this.getLocal(key);
            }
            finally {
                this.referLock.releaseForUse();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getLocal(Object key) {
        try {
            Object unwrapped;
            this.referLock.acquireForUse(-1L);
            Object raw = this.getRawLocal(key, false);
            if (this.cacheMap != null) {
                if (raw != null) {
                    ++this.caheHitCount;
                } else {
                    ++this.caheNoHitCount;
                }
            }
            if (raw != (unwrapped = this.unwrapCachedReference(raw, true, false)) && unwrapped == null && !this.isClient && this.contextStore != null && super.containsKey(key)) {
                raw = this.getRawLocal(key, true);
                unwrapped = this.unwrapCachedReference(raw, false, false);
            }
            Object object = unwrapped;
            return object;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    protected Object getRawLocal(Object key) {
        return this.getRawLocal(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getRawLocal(Object key, boolean isLoadForce) {
        Object result = null;
        boolean isContainsKey = false;
        Map map = this.context;
        synchronized (map) {
            result = super.get(key);
            isContainsKey = result == null ? super.containsKey(key) : true;
        }
        if ((result == null || isLoadForce) && !this.isClient && this.contextStore != null && isContainsKey) {
            try {
                this.contextStore.load(this, key);
                result = super.get(key);
            }
            catch (Exception e) {
                this.getLogger().write("SCS__00001", new Object[]{key, this.subject}, (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public Set keySet() throws SharedContextSendException {
        return this.keySet(this.defaultTimeout);
    }

    @Override
    public synchronized Set keySet(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        try {
            long startTime = System.currentTimeMillis();
            if (!this.referLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            if (!this.isClient) {
                Set set = super.keySet();
                return set;
            }
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(7));
                Message[] responses = this.serverConnection.request(message, this.clientSubject, null, 1, timeout);
                Set result = (Set)responses[0].getObject();
                responses[0].recycle();
                Set set = result;
                return set;
            }
            try {
                throw new NoConnectServerException();
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    @Override
    public synchronized Set keySetLocal() {
        try {
            this.referLock.acquireForUse(-1L);
            Set set = super.keySet();
            return set;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    @Override
    public int size() throws SharedContextSendException {
        return this.size(this.defaultTimeout);
    }

    @Override
    public synchronized int size(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        try {
            long startTime = System.currentTimeMillis();
            if (!this.referLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            if (!this.isClient) {
                int n = super.size();
                return n;
            }
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(8));
                Message[] responses = this.serverConnection.request(message, this.clientSubject, null, 1, timeout);
                int result = (Integer)responses[0].getObject();
                responses[0].recycle();
                int n = result;
                return n;
            }
            int n = this.sizeLocal();
            return n;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    @Override
    public synchronized int sizeLocal() {
        try {
            this.referLock.acquireForUse(-1L);
            int n = super.size();
            return n;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    @Override
    public boolean isEmpty() throws SharedContextSendException {
        return this.size() == 0;
    }

    @Override
    public boolean isEmptyLocal() {
        return this.sizeLocal() == 0;
    }

    @Override
    public boolean containsKey(Object key) throws SharedContextSendException {
        return this.containsKey(key, this.defaultTimeout);
    }

    @Override
    public boolean containsKey(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        SharedContextTransactionManager.SharedContextTransaction transaction;
        if (this.sharedContextTransactionManager != null && (transaction = this.sharedContextTransactionManager.getTransaction()) != null && transaction.getState() == 1 && transaction.containsKey(this, key)) {
            return transaction.get(this, key, timeout) != null;
        }
        try {
            long startTime = System.currentTimeMillis();
            if (!this.referLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            if (!this.isClient) {
                boolean bl = super.containsKey(key);
                return bl;
            }
            Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(9, key));
                Message[] responses = this.serverConnection.request(message, this.clientSubject, key == null ? null : key.toString(), 1, timeout);
                boolean result = (Boolean)responses[0].getObject();
                responses[0].recycle();
                boolean bl = result;
                return bl;
            }
            try {
                throw new NoConnectServerException();
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    @Override
    public boolean containsKeyLocal(Object key) {
        try {
            this.referLock.acquireForUse(-1L);
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    @Override
    public boolean containsValue(Object value) throws SharedContextSendException {
        return this.containsValue(value, this.defaultTimeout);
    }

    @Override
    public boolean containsValue(Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        try {
            long startTime = System.currentTimeMillis();
            if (!this.referLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            if (!this.isClient) {
                boolean bl = this.containsValueLocal(value);
                return bl;
            }
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(10, null, value));
                Message[] responses = this.serverConnection.request(message, this.clientSubject, null, 1, timeout);
                boolean result = (Boolean)responses[0].getObject();
                responses[0].recycle();
                boolean bl = result;
                return bl;
            }
            try {
                throw new NoConnectServerException();
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValueLocal(Object value) {
        try {
            this.referLock.acquireForUse(-1L);
            if (this.cacheMap == null) {
                boolean bl = super.containsValue(value);
                return bl;
            }
            Object[] keys = null;
            Map map = this.context;
            synchronized (map) {
                keys = super.keySet().toArray();
            }
            for (int i = 0; i < keys.length; ++i) {
                Object val = this.cacheMap.get(keys[i]);
                if (val == null) {
                    if (value != null) continue;
                    boolean bl = true;
                    return bl;
                }
                if (!val.equals(value)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    @Override
    public Collection values() {
        if (!this.isClient) {
            return this.valuesLocal();
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection valuesLocal() {
        try {
            this.referLock.acquireForUse(-1L);
            if (this.cacheMap == null) {
                Collection collection = super.values();
                return collection;
            }
            ArrayList<Object> result = new ArrayList<Object>();
            Object[] keys = null;
            Map map = this.context;
            synchronized (map) {
                keys = super.keySet().toArray();
            }
            for (int i = 0; i < keys.length; ++i) {
                result.add(this.cacheMap.get(keys[i]));
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    @Override
    public Map all() {
        if (!this.isClient) {
            return this.allLocal();
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map allLocal() {
        try {
            this.referLock.acquireForUse(-1L);
            if (this.cacheMap == null) {
                Map map = super.all();
                return map;
            }
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            Object[] keys = null;
            Map map = this.context;
            synchronized (map) {
                keys = super.keySet().toArray();
            }
            for (int i = 0; i < keys.length; ++i) {
                result.put(keys[i], this.cacheMap.get(keys[i]));
            }
            HashMap<Object, Object> hashMap = result;
            return hashMap;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    @Override
    public Set entrySet() {
        if (!this.isClient) {
            return this.entrySetLocal();
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set entrySetLocal() {
        try {
            this.referLock.acquireForUse(-1L);
            if (this.cacheMap == null) {
                Set set = super.entrySet();
                return set;
            }
            HashSet<Map.Entry> reuslt = new HashSet<Map.Entry>();
            Map.Entry[] entries = null;
            Map map = this.context;
            synchronized (map) {
                entries = this.cacheMap.entrySet().toArray(new Map.Entry[this.cacheMap.size()]);
            }
            for (int i = 0; i < entries.length; ++i) {
                if (!super.containsKey(entries[i].getKey())) continue;
                reuslt.add(entries[i]);
            }
            HashSet<Map.Entry> hashSet = reuslt;
            return hashSet;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    @Override
    public boolean isMain() {
        return this.isMain(null);
    }

    protected boolean isMain(Object excludeId) {
        return this.isMain(this.cluster.getMembers(), excludeId);
    }

    protected boolean isMain(List members, Object excludeId) {
        if (this.isClient) {
            return false;
        }
        Object mainId = this.getMainId(members, excludeId);
        Object myId = this.cluster.getUID();
        return myId.equals(mainId);
    }

    @Override
    public Object getMainId() {
        return this.getMainId(this.cluster.getMembers(), null);
    }

    protected Object getMainId(List members, Object excludeId) {
        if (this.cluster == null) {
            return null;
        }
        Object myId = this.cluster.getUID();
        Set targetMembers = this.serverConnection.getReceiveClientIds(this.targetMessage);
        int imax = members.size();
        for (int i = 0; i < imax; ++i) {
            Object id = members.get(i);
            if (id.equals(excludeId)) continue;
            if (id.equals(myId)) {
                return myId;
            }
            if (!targetMembers.contains(id)) continue;
            return id;
        }
        return myId;
    }

    @Override
    public Object getId() {
        return this.cluster == null ? null : this.cluster.getUID();
    }

    @Override
    public List getMemberIdList() {
        return this.cluster == null ? new ArrayList() : this.cluster.getMembers();
    }

    @Override
    public Set getClientMemberIdSet() {
        if (this.serverConnection == null || this.clientSubject == null) {
            return new HashSet();
        }
        try {
            Message message = this.serverConnection.createMessage(this.clientSubject, null);
            Set result = this.serverConnection.getReceiveClientIds(message);
            if (this.isClient) {
                result.add(this.getId());
            }
            return result;
        }
        catch (MessageException e) {
            return new HashSet();
        }
    }

    @Override
    public Set getServerMemberIdSet() {
        if (this.serverConnection == null) {
            return new HashSet();
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set result = this.serverConnection.getReceiveClientIds(message);
            if (!this.isClient) {
                result.add(this.getId());
            }
            return result;
        }
        catch (MessageException e) {
            return new HashSet();
        }
    }

    @Override
    public Object executeInterpretQuery(String query, Map variables) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
        return this.executeInterpretQuery(query, variables, this.defaultTimeout);
    }

    @Override
    public Object executeInterpretQuery(String query, Map variables, long timeout) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
        Object result;
        block8: {
            result = null;
            if (!this.isClient && this.isMain()) {
                result = this.executeInterpretQueryLocal(query, variables);
            } else {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(23, query, variables));
                        Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                        result = responses[0].getObject();
                        responses[0].recycle();
                        if (result != null && result instanceof Throwable) {
                            throw new SharedContextSendException((Throwable)result);
                        }
                        break block8;
                    }
                    throw new NoConnectServerException();
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
                catch (RequestTimeoutException e) {
                    throw new SharedContextTimeoutException(e);
                }
            }
        }
        return result;
    }

    protected Object executeInterpretQueryLocal(String evaluate, Map variables) throws EvaluateException {
        if (this.interpreter == null) {
            throw new EvaluateException("Interpreter is null.");
        }
        if (variables == null) {
            variables = new HashMap<String, LocalSharedContext>();
        }
        variables.put(this.interpretContextVariableName, new LocalSharedContext());
        return this.interpreter.evaluate(evaluate, variables);
    }

    @Override
    public void addSharedContextUpdateListener(SharedContextUpdateListener listener) {
        if (this.updateListeners == null) {
            this.updateListeners = Collections.synchronizedList(new ArrayList());
        }
        if (!this.updateListeners.contains(listener)) {
            this.updateListeners.add(listener);
        }
    }

    @Override
    public void removeSharedContextUpdateListener(SharedContextUpdateListener listener) {
        if (this.updateListeners == null) {
            return;
        }
        this.updateListeners.remove(listener);
    }

    @Override
    public void memberInit(Object myId, List members) {
        this.isMain = this.isMain();
        if (!this.isClient && this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (this.isMain) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onChangeMain(this);
                    continue;
                }
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onChangeSub(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberChange(List oldMembers, List newMembers) {
        block25: {
            HashSet deadMembers = new HashSet(oldMembers);
            deadMembers.removeAll(newMembers);
            try {
                if (this.isClient) {
                    Set targetMembers;
                    if (this.getState() != 3) {
                        return;
                    }
                    if (this.sizeLocal() != 0 && (targetMembers = this.serverConnection.getReceiveClientIds(this.targetMessage)).size() == 0) {
                        this.clearLocal();
                    }
                    break block25;
                }
                if (this.isMain(newMembers, null)) {
                    if (!this.isMain && this.updateListeners != null) {
                        for (int i = 0; i < this.updateListeners.size(); ++i) {
                            ((SharedContextUpdateListener)this.updateListeners.get(i)).onChangeMain(this);
                        }
                    }
                    if (deadMembers.size() == 0) break block25;
                    for (Object id : deadMembers) {
                        Set keySet = null;
                        Map map = this.idLocksMap;
                        synchronized (map) {
                            keySet = (Set)this.idLocksMap.get(id);
                            if (keySet == null || keySet.size() == 0) {
                                continue;
                            }
                        }
                        Object[] keys = null;
                        Set set = keySet;
                        synchronized (set) {
                            keys = keySet.toArray();
                        }
                        for (int i = 0; i < keys.length; ++i) {
                            try {
                                this.unlock(keys[i], true);
                                continue;
                            }
                            catch (SharedContextSendException sharedContextSendException) {
                                // empty catch block
                            }
                        }
                    }
                    break block25;
                }
                if (this.isMain && this.updateListeners != null) {
                    for (int i = 0; i < this.updateListeners.size(); ++i) {
                        ((SharedContextUpdateListener)this.updateListeners.get(i)).onChangeSub(this);
                    }
                }
            }
            finally {
                if (deadMembers.size() != 0) {
                    Iterator ids = deadMembers.iterator();
                    while (ids.hasNext()) {
                        this.updateLock.releaseForLock(ids.next());
                    }
                }
                this.isMain = this.isMain(newMembers, null);
            }
        }
    }

    @Override
    public void changeMain() throws Exception {
    }

    @Override
    public void changeSub() {
    }

    @Override
    public void removed(CachedReference ref) {
        if (ref == null) {
            return;
        }
        KeyCachedReference kcr = (KeyCachedReference)ref;
        if (this.isClient) {
            super.remove(kcr.getKey());
        } else {
            super.put(kcr.getKey(), (Object)null);
        }
    }

    @Override
    public void onMessage(Message message) {
        if (this.getState() >= 5) {
            return;
        }
        SharedContextEvent event = null;
        try {
            event = (SharedContextEvent)message.getObject();
            message.recycle();
        }
        catch (MessageException e) {
            e.printStackTrace();
            return;
        }
        switch (event.type) {
            case 1: {
                this.onPut(event);
                break;
            }
            case 6: {
                this.onPutAll(event);
                break;
            }
            case 2: {
                this.onRemove(event);
                break;
            }
            case 3: {
                this.onClear(event);
                break;
            }
            case 14: {
                this.onReleaseLock(event);
                break;
            }
            case 18: {
                this.onUpdate(event);
                break;
            }
            case 20: {
                this.onPutInner(event);
                break;
            }
            case 25: {
                this.onReleaseUpdateLock(event);
                break;
            }
            case 26: {
                this.onChangeMode(event);
                break;
            }
        }
    }

    @Override
    public Message onRequestMessage(Object sourceId, int sequence, Message message, String responseSubject, String responseKey) {
        if (this.getState() >= 5) {
            return null;
        }
        SharedContextEvent event = null;
        try {
            event = (SharedContextEvent)message.getObject();
            message.recycle();
        }
        catch (MessageException e) {
            e.printStackTrace();
            return null;
        }
        Message result = null;
        switch (event.type) {
            case 1: {
                result = this.onPut(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 6: {
                result = this.onPutAll(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 2: {
                result = this.onRemove(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 3: {
                result = this.onClear(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 5: {
                result = this.onGet(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 4: {
                result = this.onGetAll(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 7: {
                result = this.onKeySet(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 8: {
                result = this.onSize(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 9: {
                result = this.onContainsKey(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 10: {
                result = this.onContainsValue(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 11: {
                result = this.onSynchronizeAll(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 19: {
                result = this.onSynchronize(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 12: {
                result = this.onGetLock(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 13: {
                result = this.onGotLock(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 15: {
                result = this.onSave(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 16: {
                result = this.onLoad(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 17: {
                result = this.onLoadKey(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 18: {
                result = this.onUpdate(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 21: {
                result = this.onAnalyzeKeyIndex(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 22: {
                result = this.onSearchIndex(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 23: {
                this.onExecuteInterpret(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 24: {
                result = this.onGetUpdateLock(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
        }
        return result;
    }

    protected Message createResponseMessage(String responseSubject, String responseKey, Object response) {
        Message result = null;
        try {
            result = this.serverConnection.createMessage(responseSubject, responseKey);
            if (responseSubject.endsWith(".Client")) {
                result.setSubject(responseSubject.substring(0, responseSubject.length() - ".Client".length()), responseKey);
            } else {
                result.setSubject(responseSubject + ".Client", responseKey);
            }
            result.setObject(response);
        }
        catch (MessageException e) {
            this.getLogger().write("SCS__00002", new Object[]{this.isClient ? this.clientSubject : this.subject, responseSubject, responseKey, response}, (Throwable)e);
            result = null;
        }
        return result;
    }

    protected void onPut(SharedContextEvent event) {
        this.onPut(event, null, -1, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onPut(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        Object result = null;
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, false, event.key, event.value)) continue;
                return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, null);
            }
        }
        Object old = null;
        boolean isContainsKey = super.containsKey(event.key);
        if (this.isClient) {
            if (isContainsKey) {
                old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
                old = this.unwrapCachedReference(old, false, true);
            } else if (this.clientCacheLockMap.containsKey(event.key)) {
                ClientCacheLock lock = null;
                Object object = this.clientCacheLockMap;
                synchronized (object) {
                    lock = (ClientCacheLock)this.clientCacheLockMap.get(event.key);
                }
                if (lock != null) {
                    object = lock;
                    synchronized (object) {
                        if (super.containsKey(event.key)) {
                            old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
                            old = this.unwrapCachedReference(old, false, true);
                        } else {
                            lock.put(event.value);
                        }
                    }
                }
            }
        } else {
            old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
            old = this.unwrapCachedReference(old, false, true);
            if (this.isMain(sourceId)) {
                result = old;
            }
        }
        if (this.indexManager.hasIndex()) {
            if (isContainsKey && old != null) {
                if (event.value != null) {
                    this.indexManager.replace(event.key, old, event.value);
                } else {
                    this.indexManager.remove(event.key, old);
                }
            } else if (event.value != null) {
                this.indexManager.add(event.key, event.value);
            }
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, false, event.key, event.value, old);
            }
        }
        return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, result);
    }

    protected void onPutAll(SharedContextEvent event) {
        this.onPutAll(event, null, -1, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onPutAll(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        Map map = (Map)event.value;
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                boolean isPut = true;
                if (this.updateListeners != null) {
                    for (int i = 0; i < this.updateListeners.size(); ++i) {
                        if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, false, entry.getKey(), entry.getValue())) continue;
                        isPut = false;
                        break;
                    }
                }
                if (!isPut) continue;
                Object old = null;
                boolean isContainsKey = super.containsKey(entry.getKey());
                if (this.isClient) {
                    if (isContainsKey) {
                        old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                        old = this.unwrapCachedReference(old, false, true);
                    } else if (this.clientCacheLockMap.containsKey(entry.getKey())) {
                        ClientCacheLock lock = null;
                        Object object = this.clientCacheLockMap;
                        synchronized (object) {
                            lock = (ClientCacheLock)this.clientCacheLockMap.get(entry.getKey());
                        }
                        if (lock != null) {
                            object = lock;
                            synchronized (object) {
                                if (super.containsKey(entry.getKey())) {
                                    old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                                    old = this.unwrapCachedReference(old, false, true);
                                } else {
                                    lock.put(entry.getValue());
                                }
                            }
                        }
                    }
                } else {
                    old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                    old = this.unwrapCachedReference(old, false, true);
                }
                if (this.indexManager.hasIndex()) {
                    if (isContainsKey && old != null) {
                        if (entry.getValue() != null) {
                            this.indexManager.replace(entry.getKey(), old, entry.getValue());
                        } else {
                            this.indexManager.remove(entry.getKey(), old);
                        }
                    } else if (entry.getValue() != null) {
                        this.indexManager.add(entry.getKey(), entry.getValue());
                    }
                }
                if (this.updateListeners == null) continue;
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, false, entry.getKey(), entry.getValue(), old);
                }
            }
        }
        return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPutInner(SharedContextEvent event) {
        Object old = null;
        boolean isContainsKey = super.containsKey(event.key);
        if (this.isClient) {
            if (isContainsKey) {
                old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
                old = this.unwrapCachedReference(old, false, true);
            } else if (this.clientCacheLockMap.containsKey(event.key)) {
                ClientCacheLock lock = null;
                Object object = this.clientCacheLockMap;
                synchronized (object) {
                    lock = (ClientCacheLock)this.clientCacheLockMap.get(event.key);
                }
                if (lock != null) {
                    object = lock;
                    synchronized (object) {
                        if (super.containsKey(event.key)) {
                            old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
                            old = this.unwrapCachedReference(old, false, true);
                        } else {
                            lock.put(event.value);
                        }
                    }
                }
            }
        } else {
            old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
            old = this.unwrapCachedReference(old, false, true);
        }
        if (this.indexManager.hasIndex()) {
            if (isContainsKey && old != null) {
                if (event.value != null) {
                    this.indexManager.replace(event.key, old, event.value);
                } else {
                    this.indexManager.remove(event.key, old);
                }
            } else if (event.value != null) {
                this.indexManager.add(event.key, event.value);
            }
        }
    }

    protected void onUpdate(SharedContextEvent event) {
        this.onUpdate(event, null, -1, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Message onUpdate(final SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        block47: {
            block45: {
                block48: {
                    block46: {
                        diff = (SharedContextValueDifference)((Object[])event.value)[0];
                        ifExists = (Boolean)((Object[])event.value)[1];
                        if (this.updateListeners != null) {
                            for (i = 0; i < this.updateListeners.size(); ++i) {
                                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateBefore(this, false, event.key, diff)) continue;
                                return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, null);
                            }
                        }
                        if (this.isClient && !super.containsKey(event.key)) break block45;
                        current = this.getRawLocal(event.key);
                        currentValue = this.unwrapCachedReference(current, false, false);
                        if (currentValue != null) break block46;
                        if (this.isClient) {
                            removed = super.remove(event.key);
                            removed = this.unwrapCachedReference(removed, false, true);
                        } else if (!ifExists) {
                            return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, new SharedContextUpdateException("Current value is null. key=" + event.key));
                        }
                        break block47;
                    }
                    if (!(currentValue instanceof SharedContextValueDifferenceSupport)) break block48;
                    try {
                        isSuccess = false;
                        try {
                            updateResult = ((SharedContextValueDifferenceSupport)currentValue).update(diff);
                            v0 = isSuccess = updateResult != -1;
                            if (updateResult == 0) {
                                this.getLogger().write("SCS__00009", new Object[]{event.key, this.isClient != false ? this.clientSubject : this.subject});
                            } else if (updateResult == -1) {
                                if (this.isClient) {
                                    this.getLogger().write("SCS__00003", new Object[]{this.clientSubject, event.key});
                                } else if (!this.isMain(sourceId)) {
                                    this.getLogger().write("SCS__00004", new Object[]{this.subject, event.key});
                                } else {
                                    this.getLogger().write("SCS__00005", new Object[]{this.subject, event.key});
                                }
                            }
                        }
                        catch (SharedContextUpdateException e) {
                            if (this.isClient) {
                                this.getLogger().write("SCS__00003", new Object[]{this.clientSubject, event.key}, (Throwable)e);
                            }
                            if (!this.isMain(sourceId)) {
                                this.getLogger().write("SCS__00004", new Object[]{this.subject, event.key}, (Throwable)e);
                            }
                            this.getLogger().write("SCS__00005", new Object[]{this.subject, event.key}, (Throwable)e);
                        }
                        if (isSuccess) {
                            if (!(current instanceof CachedReference)) ** GOTO lbl124
                            try {
                                ((CachedReference)current).set(this, currentValue);
                            }
                            catch (IllegalCachedReferenceException e) {
                                throw new SharedContextUpdateException(e);
                            }
                        }
                        if (this.isClient) {
                            removed = super.remove(event.key);
                            removed = this.unwrapCachedReference(removed, false, true);
                        }
                        if (!this.isMain(sourceId)) {
                            message = this.serverConnection.createMessage(this.subject, event.key == null ? null : event.key.toString());
                            message.setObject(new SharedContextEvent(19, event.key));
                            this.serverConnection.request(message, this.isClient != false ? this.clientSubject : this.subject, event.key == null ? null : event.key.toString(), 1, 0L, new RequestServerConnection.ResponseCallBack(){

                                @Override
                                public void onResponse(Object sourceId, Message message, boolean isLast) {
                                    SharedContextService.this.onMessage(message);
                                    if (SharedContextService.this.updateListeners != null) {
                                        for (int i = 0; i < SharedContextService.this.updateListeners.size(); ++i) {
                                            ((SharedContextUpdateListener)SharedContextService.this.updateListeners.get(i)).onUpdateAfter(SharedContextService.this, false, event.key, diff);
                                        }
                                    }
                                }
                            });
                            return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, null);
                        }
                        throw new SharedContextUpdateException("An update version is mismatching. currentVersion=" + ((SharedContextValueDifferenceSupport)currentValue).getUpdateVersion() + ", updateVersion=" + diff.getUpdateVersion());
                    }
                    catch (Throwable th) {
                        this.getLogger().write("SCS__00005", new Object[]{this.isClient != false ? this.clientSubject : this.subject, event.key}, th);
                        return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, th);
                    }
                }
                e = new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + event.key + ", value=" + currentValue);
                this.getLogger().write("SCS__00005", new Object[]{this.isClient != false ? this.clientSubject : this.subject, event.key}, (Throwable)e);
                return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, e);
            }
            if (!this.isClient || !this.clientCacheLockMap.containsKey(event.key)) break block47;
            lock = null;
            var9_12 = this.clientCacheLockMap;
            synchronized (var9_12) {
                lock = (ClientCacheLock)this.clientCacheLockMap.get(event.key);
            }
            if (lock == null) break block47;
            var9_12 = lock;
            synchronized (var9_12) {
                if (!super.containsKey(event.key)) ** GOTO lbl120
                current = this.getRawLocal(event.key);
                currentValue = this.unwrapCachedReference(current, false, false);
                if (currentValue == null) {
                    removed = super.remove(event.key);
                    removed = this.unwrapCachedReference(removed, false, true);
                } else if (currentValue instanceof SharedContextValueDifferenceSupport) {
                    try {
                        isSuccess = false;
                        try {
                            updateResult = ((SharedContextValueDifferenceSupport)currentValue).update(diff);
                            v1 = isSuccess = updateResult != -1;
                            if (updateResult == 0) {
                                this.getLogger().write("SCS__00009", new Object[]{event.key, this.clientSubject});
                            } else if (updateResult == -1) {
                                this.getLogger().write("SCS__00003", new Object[]{this.clientSubject, event.key});
                            }
                        }
                        catch (SharedContextUpdateException e) {
                            this.getLogger().write("SCS__00003", new Object[]{this.clientSubject, event.key}, (Throwable)e);
                        }
                        if (isSuccess) {
                            if (!(current instanceof CachedReference)) ** GOTO lbl124
                            try {
                                ((CachedReference)current).set(this, currentValue);
                            }
                            catch (IllegalCachedReferenceException e) {
                                throw new SharedContextUpdateException(e);
                            }
                        }
                        removed = super.remove(event.key);
                        removed = this.unwrapCachedReference(removed, false, true);
                    }
                    catch (Throwable th) {
                        this.getLogger().write("SCS__00005", new Object[]{this.isClient != false ? this.clientSubject : this.subject, event.key}, th);
                        return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, th);
                    }
                } else {
                    e = new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + event.key + ", value=" + currentValue);
                    this.getLogger().write("SCS__00005", new Object[]{this.isClient != false ? this.clientSubject : this.subject, event.key}, (Throwable)e);
                    return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, e);
lbl120:
                    // 1 sources

                    lock.update(diff);
                }
            }
        }
        if (this.updateListeners != null) {
            for (i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateAfter(this, false, event.key, diff);
            }
        }
        return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, null);
    }

    protected void onRemove(SharedContextEvent event) {
        this.onRemove(event, null, -1, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onRemove(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveBefore(this, false, event.key)) continue;
                return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, null);
            }
        }
        if (this.isClient && this.clientCacheLockMap.containsKey(event.key)) {
            ClientCacheLock lock = null;
            Object object = this.clientCacheLockMap;
            synchronized (object) {
                lock = (ClientCacheLock)this.clientCacheLockMap.get(event.key);
            }
            if (lock != null) {
                object = lock;
                synchronized (object) {
                    lock.remove();
                }
            }
        }
        Object removed = super.remove(event.key);
        removed = this.unwrapCachedReference(removed, false, true);
        if (this.indexManager.hasIndex() && removed != null) {
            this.indexManager.remove(event.key, removed);
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveAfter(this, false, event.key, removed);
            }
        }
        return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, this.isMain(sourceId) ? removed : null);
    }

    protected void onClear(SharedContextEvent event) {
        this.onClear(event, null, -1, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onClear(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        Object[] keys = null;
        Map map = this.context;
        synchronized (map) {
            keys = super.keySet().toArray();
        }
        for (int i = 0; i < keys.length; ++i) {
            int j2;
            if (this.updateListeners != null) {
                boolean isRemove = true;
                for (j2 = 0; j2 < this.updateListeners.size(); ++j2) {
                    if (((SharedContextUpdateListener)this.updateListeners.get(j2)).onRemoveBefore(this, false, keys[i])) continue;
                    isRemove = false;
                    break;
                }
                if (!isRemove) continue;
            }
            if (this.isClient && this.clientCacheLockMap.containsKey(keys[i])) {
                ClientCacheLock lock = null;
                Object j2 = this.clientCacheLockMap;
                synchronized (j2) {
                    lock = (ClientCacheLock)this.clientCacheLockMap.get(keys[i]);
                }
                if (lock != null) {
                    j2 = lock;
                    synchronized (j2) {
                        lock.remove();
                    }
                }
            }
            Object removed = super.remove(keys[i]);
            removed = this.unwrapCachedReference(removed, false, true);
            if (this.indexManager.hasIndex() && removed != null) {
                this.indexManager.remove(keys[i], removed);
            }
            if (this.updateListeners == null) continue;
            for (j2 = 0; j2 < this.updateListeners.size(); ++j2) {
                ((SharedContextUpdateListener)this.updateListeners.get(j2)).onRemoveAfter(this, false, event.key, removed);
            }
        }
        return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, null);
    }

    protected Message onGet(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain(sourceId)) {
            return this.createResponseMessage(responseSubject, responseKey, this.getLocal(event.key));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onGetAll(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain(sourceId)) {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            Map map = this.context;
            synchronized (map) {
                if (this.cacheMap == null) {
                    result.putAll(this.context);
                } else {
                    Object[] keys = null;
                    Map map2 = this.context;
                    synchronized (map2) {
                        keys = super.keySet().toArray();
                    }
                    for (int i = 0; i < keys.length; ++i) {
                        if (!this.cacheMap.containsKey(keys[i])) continue;
                        result.put(keys[i], this.cacheMap.get(keys[i]));
                    }
                }
            }
            return this.createResponseMessage(responseSubject, responseKey, result);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onKeySet(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain(sourceId)) {
            HashSet result = new HashSet();
            Map map = this.context;
            synchronized (map) {
                result.addAll(this.context.keySet());
            }
            return this.createResponseMessage(responseSubject, responseKey, result);
        }
        return null;
    }

    protected Message onSize(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain(sourceId)) {
            return this.createResponseMessage(responseSubject, responseKey, new Integer(this.size()));
        }
        return null;
    }

    protected Message onContainsKey(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain(sourceId)) {
            return this.createResponseMessage(responseSubject, responseKey, this.containsKey(event.key) ? Boolean.TRUE : Boolean.FALSE);
        }
        return null;
    }

    protected Message onContainsValue(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain(sourceId)) {
            return this.createResponseMessage(responseSubject, responseKey, this.containsValue(event.value) ? Boolean.TRUE : Boolean.FALSE);
        }
        return null;
    }

    protected Message onSynchronizeAll(final SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        Thread synchronizeThread = new Thread(){

            @Override
            public void run() {
                Message response = null;
                try {
                    SharedContextService.this.synchronize((Long)event.value);
                    response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, Boolean.TRUE);
                }
                catch (SharedContextSendException e) {
                    response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, Boolean.FALSE);
                }
                catch (SharedContextTimeoutException e) {
                    response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, Boolean.FALSE);
                }
                try {
                    SharedContextService.this.serverConnection.response(sourceId, sequence, response);
                }
                catch (MessageSendException e) {
                    SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
                }
            }
        };
        synchronizeThread.start();
        return null;
    }

    protected Message onSynchronize(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isClient || !this.isMain(sourceId)) {
            return null;
        }
        if (this.containsKeyLocal(event.key)) {
            return this.createResponseMessage(responseSubject, responseKey, new SharedContextEvent(20, event.key, this.getLocal(event.key)));
        }
        return this.createResponseMessage(responseSubject, responseKey, new SharedContextEvent(2, event.key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onGetLock(final SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain(sourceId)) {
            Object[] params = (Object[])event.value;
            long threadId = (Long)params[0];
            boolean ifAcquireable = (Boolean)params[1];
            boolean ifExist = (Boolean)params[2];
            long timeout = (Long)params[3];
            if (ifExist && !super.containsKey(event.key)) {
                return this.createResponseMessage(responseSubject, responseKey, Boolean.FALSE);
            }
            Lock lock = null;
            Map map = this.keyLockMap;
            synchronized (map) {
                lock = (Lock)this.keyLockMap.get(event.key);
                if (lock == null) {
                    lock = new Lock(event.key);
                    this.keyLockMap.put(event.key, lock);
                }
            }
            long start = System.currentTimeMillis();
            if (lock.acquireForReply(sourceId, threadId, ifAcquireable, ifExist, timeout, sourceId, sequence, responseSubject, responseKey)) {
                if (ifExist && !super.containsKey(event.key)) {
                    lock.release(sourceId, false);
                    return this.createResponseMessage(responseSubject, responseKey, Boolean.FALSE);
                }
                boolean isNoTimeout = timeout <= 0L;
                long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                if (!isNoTimeout && timeout <= 0L) {
                    lock.release(sourceId, false);
                    return this.createResponseMessage(responseSubject, responseKey, Boolean.FALSE);
                }
                try {
                    Message message = this.serverConnection.createMessage(this.subject, event.key == null ? null : event.key.toString());
                    message.setSubject(this.clientSubject, event.key == null ? null : event.key.toString());
                    final Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    receiveClients.remove(sourceId);
                    if (receiveClients.size() != 0) {
                        message.setDestinationIds(receiveClients);
                        message.setObject(new SharedContextEvent(13, event.key, new Object[]{sourceId, new Long(threadId), new Long(timeout)}));
                        this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, event.key == null ? null : event.key.toString(), 0, timeout, new RequestServerConnection.ResponseCallBack(){

                            @Override
                            public void onResponse(Object fromId, Message response, boolean isLast) {
                                if (receiveClients.size() == 0) {
                                    return;
                                }
                                try {
                                    if (response == null) {
                                        SharedContextService.this.serverConnection.response(sourceId, sequence, SharedContextService.this.createResponseMessage(responseSubject, responseKey, Boolean.FALSE));
                                        receiveClients.clear();
                                        return;
                                    }
                                    receiveClients.remove(fromId);
                                    Object ret = response.getObject();
                                    response.recycle();
                                    if (ret == null || ret instanceof Throwable || !((Boolean)ret).booleanValue()) {
                                        SharedContextService.this.unlock(event.key);
                                        SharedContextService.this.serverConnection.response(sourceId, sequence, SharedContextService.this.createResponseMessage(responseSubject, responseKey, ret));
                                        receiveClients.clear();
                                    } else if (isLast) {
                                        SharedContextService.this.serverConnection.response(sourceId, sequence, SharedContextService.this.createResponseMessage(responseSubject, responseKey, ret));
                                    }
                                }
                                catch (Throwable th) {
                                    try {
                                        SharedContextService.this.unlock(event.key);
                                    }
                                    catch (SharedContextSendException e) {
                                        SharedContextService.this.getLogger().write("SCS__00007", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, event.key}, (Throwable)e);
                                    }
                                    try {
                                        SharedContextService.this.serverConnection.response(sourceId, sequence, SharedContextService.this.createResponseMessage(responseSubject, responseKey, th));
                                    }
                                    catch (MessageSendException e) {
                                        SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, event.key}, (Throwable)e);
                                    }
                                }
                            }
                        });
                        return null;
                    }
                    return this.createResponseMessage(responseSubject, responseKey, Boolean.TRUE);
                }
                catch (Throwable th) {
                    try {
                        this.unlock(event.key);
                    }
                    catch (SharedContextSendException e) {
                        this.getLogger().write("SCS__00007", new Object[]{this.isClient ? this.clientSubject : this.subject, event.key}, (Throwable)e);
                    }
                    return this.createResponseMessage(responseSubject, responseKey, th);
                }
            }
            if (ifAcquireable) {
                return this.createResponseMessage(responseSubject, responseKey, Boolean.FALSE);
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onGotLock(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        Lock lock = null;
        Map map = this.keyLockMap;
        synchronized (map) {
            lock = (Lock)this.keyLockMap.get(event.key);
            if (lock == null) {
                lock = new Lock(event.key);
                this.keyLockMap.put(event.key, lock);
            }
        }
        Object[] params = (Object[])event.value;
        Object id = params[0];
        long threadId = (Long)params[1];
        if (this.getId().equals(id)) {
            return null;
        }
        long timeout = (Long)params[2];
        try {
            if (lock.acquireForReply(id, threadId, false, false, timeout, sourceId, sequence, responseSubject, responseKey)) {
                return this.createResponseMessage(responseSubject, responseKey, Boolean.TRUE);
            }
            return null;
        }
        catch (Throwable th) {
            lock.release(id, false);
            return this.createResponseMessage(responseSubject, responseKey, th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onReleaseLock(SharedContextEvent event) {
        Lock lock = null;
        Map map = this.keyLockMap;
        synchronized (map) {
            lock = (Lock)this.keyLockMap.get(event.key);
        }
        if (lock != null) {
            lock.release(event.value, true);
        }
    }

    protected Message onSave(final SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (!(this.isClient || !this.isMain(sourceId) && this.isSaveOnlyMain)) {
            Thread saveThread = new Thread(){

                @Override
                public void run() {
                    Message response = null;
                    try {
                        if (event.key == null) {
                            SharedContextService.super.save();
                        } else {
                            SharedContextService.super.save(event.key);
                        }
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        SharedContextService.this.serverConnection.response(sourceId, sequence, response);
                    }
                    catch (MessageSendException e) {
                        SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            saveThread.start();
        }
        return null;
    }

    protected Message onLoad(final SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain(sourceId)) {
            Thread loadThread = new Thread(){

                @Override
                public void run() {
                    Message response = null;
                    try {
                        if (event.key == null) {
                            SharedContextService.super.load();
                        } else {
                            SharedContextService.super.load(event.key);
                        }
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        SharedContextService.this.serverConnection.response(sourceId, sequence, response);
                    }
                    catch (MessageSendException e) {
                        SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            loadThread.start();
        }
        return null;
    }

    protected Message onLoadKey(SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain(sourceId)) {
            Thread loadThread = new Thread(){

                @Override
                public void run() {
                    Message response = null;
                    try {
                        SharedContextService.super.loadKey();
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        SharedContextService.this.serverConnection.response(sourceId, sequence, response);
                    }
                    catch (MessageSendException e) {
                        SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            loadThread.start();
        }
        return null;
    }

    protected Message onAnalyzeKeyIndex(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isClient) {
            return null;
        }
        try {
            this.analyzeIndex((String)event.key, (Long)event.value);
            return this.createResponseMessage(responseSubject, responseKey, null);
        }
        catch (Throwable th) {
            this.getLogger().write("SCS__00008", new Object[]{this.isClient ? this.clientSubject : this.subject, event.key}, th);
            return this.createResponseMessage(responseSubject, responseKey, th);
        }
    }

    protected Message onSearchIndex(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain(sourceId)) {
            SearchEvent searchEvent = (SearchEvent)event.value;
            Object result = null;
            byte type = searchEvent.type;
            Object[] args = searchEvent.arguments;
            try {
                switch (type) {
                    case 1: {
                        result = this.indexManager.searchKey((String)args[0], (String[])args[1]);
                        break;
                    }
                    case 2: {
                        result = this.indexManager.searchNull((String)args[0], (String)args[1]);
                        break;
                    }
                    case 3: {
                        result = this.indexManager.searchNotNull((String)args[0], (String)args[1]);
                        break;
                    }
                    case 4: {
                        result = this.indexManager.searchBy(args[0], (String)args[1], (String[])args[2]);
                        break;
                    }
                    case 5: {
                        result = this.indexManager.searchIn((String)args[0], (String[])args[1], (Object[])args[2]);
                        break;
                    }
                    case 6: {
                        result = this.indexManager.searchByProperty(args[0], (String)args[1], (String)args[2]);
                        break;
                    }
                    case 7: {
                        result = this.indexManager.searchInProperty((String)args[0], (String)args[1], (Object[])args[2]);
                        break;
                    }
                    case 8: {
                        result = this.indexManager.searchByProperty((Map)args[0], (String)args[1]);
                        break;
                    }
                    case 9: {
                        result = this.indexManager.searchInProperty((String)args[0], (Map[])args[1]);
                        break;
                    }
                    case 10: {
                        if (args[0] == null) {
                            result = this.indexManager.searchFrom(args[3], (Boolean)args[4], (String)args[1], (String)args[2]);
                            break;
                        }
                        result = this.indexManager.createTemporaryIndex((Set)args[0], (String)args[1], (String)args[2]).searchFrom(args[3], (Boolean)args[4]);
                        break;
                    }
                    case 11: {
                        if (args[0] == null) {
                            result = this.indexManager.searchFromProperty(args[3], (Boolean)args[4], (String)args[1], (String)args[2]);
                            break;
                        }
                        result = this.indexManager.createTemporaryIndex((Set)args[0], (String)args[1], (String)args[2]).searchFromProperty(args[3], (Boolean)args[4]);
                        break;
                    }
                    case 12: {
                        if (args[0] == null) {
                            result = this.indexManager.searchTo(args[3], (Boolean)args[4], (String)args[1], (String)args[2]);
                            break;
                        }
                        result = this.indexManager.createTemporaryIndex((Set)args[0], (String)args[1], (String)args[2]).searchTo(args[3], (Boolean)args[4]);
                        break;
                    }
                    case 13: {
                        if (args[0] == null) {
                            result = this.indexManager.searchToProperty(args[3], (Boolean)args[4], (String)args[1], (String)args[2]);
                            break;
                        }
                        result = this.indexManager.createTemporaryIndex((Set)args[0], (String)args[1], (String)args[2]).searchToProperty(args[3], (Boolean)args[4]);
                        break;
                    }
                    case 14: {
                        if (args[0] == null) {
                            result = this.indexManager.searchRange(args[3], (Boolean)args[4], args[5], (Boolean)args[6], (String)args[1], (String)args[2]);
                            break;
                        }
                        result = this.indexManager.createTemporaryIndex((Set)args[0], (String)args[1], (String)args[2]).searchRange(args[3], (Boolean)args[4], args[5], (Boolean)args[6]);
                        break;
                    }
                    case 15: {
                        result = args[0] == null ? this.indexManager.searchRangeProperty(args[3], (Boolean)args[4], args[5], (Boolean)args[6], (String)args[1], (String)args[2]) : this.indexManager.createTemporaryIndex((Set)args[0], (String)args[1], (String)args[2]).searchRangeProperty(args[3], (Boolean)args[4], args[5], (Boolean)args[6]);
                    }
                }
            }
            catch (Throwable th) {
                result = th;
            }
            return this.createResponseMessage(responseSubject, responseKey, result);
        }
        return null;
    }

    protected void onExecuteInterpret(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain(sourceId)) {
            this.executeQueueHandlerContainer.push(new AsynchContext(new Object[]{event.key, event.value, responseSubject, responseKey, sourceId, new Integer(sequence)}));
        }
    }

    protected Message onGetUpdateLock(final SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        Thread lockThread = new Thread(){

            @Override
            public void run() {
                long timeout = (Long)event.value;
                Message response = null;
                try {
                    boolean locked = SharedContextService.this.updateLock.acquireForLock(sourceId, timeout);
                    response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, locked ? Boolean.TRUE : Boolean.FALSE);
                }
                catch (Throwable th) {
                    response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                }
                try {
                    SharedContextService.this.serverConnection.response(sourceId, sequence, response);
                }
                catch (MessageSendException e) {
                    SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
                }
            }
        };
        lockThread.start();
        return null;
    }

    protected void onReleaseUpdateLock(SharedContextEvent event) {
        this.updateLock.releaseForLock(event.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChangeMode(SharedContextEvent event) {
        boolean isMainTmp = this.isMain();
        try {
            if (this.isMain != isMainTmp && !this.isClient && this.updateListeners != null) {
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    if (isMainTmp) {
                        ((SharedContextUpdateListener)this.updateListeners.get(i)).onChangeMain(this);
                        continue;
                    }
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onChangeSub(this);
                }
            }
        }
        finally {
            this.isMain = isMainTmp;
        }
    }

    protected static class SearchEvent
    implements Externalizable {
        public static final byte TYPE_KEY = 1;
        public static final byte TYPE_NULL = 2;
        public static final byte TYPE_NOT_NULL = 3;
        public static final byte TYPE_BY = 4;
        public static final byte TYPE_IN = 5;
        public static final byte TYPE_BY_PROP = 6;
        public static final byte TYPE_IN_PROP = 7;
        public static final byte TYPE_BY_PROP_MAP = 8;
        public static final byte TYPE_IN_PROP_MAP = 9;
        public static final byte TYPE_FROM = 10;
        public static final byte TYPE_FROM_PROP = 11;
        public static final byte TYPE_TO = 12;
        public static final byte TYPE_TO_PROP = 13;
        public static final byte TYPE_RANGE = 14;
        public static final byte TYPE_RANGE_PROP = 15;
        public byte type;
        public Object[] arguments;

        public SearchEvent(byte type, Object[] args) {
            this.type = type;
            this.arguments = args;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.write(this.type);
            out.writeObject(this.arguments);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = (byte)in.read();
            this.arguments = (Object[])in.readObject();
        }
    }

    protected class SharedContextViewImpl
    implements SharedContextView,
    Cloneable {
        protected static final int OPERATOR_AND = 1;
        protected static final int OPERATOR_OR = 2;
        protected static final int OPERATOR_NAND = 3;
        protected static final int OPERATOR_NOR = 4;
        protected static final int OPERATOR_XOR = 5;
        protected static final int OPERATOR_XNOR = 6;
        protected static final int OPERATOR_IMP = 7;
        protected static final int OPERATOR_NIMP = 8;
        protected static final int OPERATOR_CIMP = 9;
        protected static final int OPERATOR_CNIMP = 10;
        protected Set resultSet;
        protected int operator = 1;

        @Override
        public Set getResultSet() {
            return this.resultSet == null ? SharedContextService.this.indexManager.keySet() : this.resultSet;
        }

        @Override
        public SharedContextView and() {
            this.operator = 1;
            return this;
        }

        @Override
        public SharedContextView or() {
            this.operator = 2;
            return this;
        }

        @Override
        public SharedContextView nand() {
            this.operator = 3;
            return this;
        }

        @Override
        public SharedContextView nor() {
            this.operator = 4;
            return this;
        }

        @Override
        public SharedContextView xor() {
            this.operator = 5;
            return this;
        }

        @Override
        public SharedContextView xnor() {
            this.operator = 6;
            return this;
        }

        @Override
        public SharedContextView imp() {
            this.operator = 7;
            return this;
        }

        @Override
        public SharedContextView nimp() {
            this.operator = 8;
            return this;
        }

        @Override
        public SharedContextView cimp() {
            this.operator = 9;
            return this;
        }

        @Override
        public SharedContextView cnimp() {
            this.operator = 10;
            return this;
        }

        protected void operate(Set keys) {
            if (keys == null) {
                keys = new HashSet(0);
            }
            switch (this.operator) {
                case 2: {
                    this.resultSet.addAll(keys);
                    break;
                }
                case 3: {
                    this.resultSet.retainAll(keys);
                    Set all = SharedContextService.this.indexManager.keySet();
                    all.removeAll(this.resultSet);
                    this.resultSet = all;
                    break;
                }
                case 4: {
                    this.resultSet.addAll(keys);
                    Set all = SharedContextService.this.indexManager.keySet();
                    all.removeAll(this.resultSet);
                    this.resultSet = all;
                    break;
                }
                case 5: {
                    HashSet tmpSet = new HashSet(this.resultSet);
                    tmpSet.retainAll(keys);
                    this.resultSet.addAll(keys);
                    this.resultSet.removeAll(tmpSet);
                    break;
                }
                case 6: {
                    Set tmpSet = new HashSet(this.resultSet);
                    tmpSet.retainAll(keys);
                    this.resultSet.addAll(keys);
                    this.resultSet.removeAll(tmpSet);
                    tmpSet = SharedContextService.this.indexManager.keySet();
                    tmpSet.removeAll(this.resultSet);
                    this.resultSet = tmpSet;
                    break;
                }
                case 7: {
                    Set all = SharedContextService.this.indexManager.keySet();
                    all.removeAll(this.resultSet);
                    all.addAll(keys);
                    this.resultSet = all;
                    break;
                }
                case 8: {
                    this.resultSet.removeAll(keys);
                    break;
                }
                case 9: {
                    Set all = SharedContextService.this.indexManager.keySet();
                    all.removeAll(keys);
                    all.addAll(this.resultSet);
                    this.resultSet = all;
                    break;
                }
                case 10: {
                    HashSet targetSet = new HashSet(keys);
                    targetSet.removeAll(this.resultSet);
                    this.resultSet = targetSet;
                    break;
                }
                default: {
                    this.resultSet.retainAll(keys);
                }
            }
        }

        @Override
        public SharedContextView not() {
            Set all = SharedContextService.this.indexManager.keySet();
            all.removeAll(this.resultSet);
            this.resultSet = all;
            return this;
        }

        @Override
        public SharedContextView and(SharedContextView view) {
            this.resultSet.retainAll(view.getResultSet());
            return this;
        }

        @Override
        public SharedContextView or(SharedContextView view) {
            this.resultSet.addAll(view.getResultSet());
            return this;
        }

        @Override
        public SharedContextView nand(SharedContextView view) {
            this.resultSet.retainAll(view.getResultSet());
            Set all = SharedContextService.this.indexManager.keySet();
            all.removeAll(this.resultSet);
            this.resultSet = all;
            return this;
        }

        @Override
        public SharedContextView nor(SharedContextView view) {
            this.resultSet.addAll(view.getResultSet());
            Set all = SharedContextService.this.indexManager.keySet();
            all.removeAll(this.resultSet);
            this.resultSet = all;
            return this;
        }

        @Override
        public SharedContextView xor(SharedContextView view) {
            HashSet andSet = new HashSet(this.resultSet);
            andSet.retainAll(view.getResultSet());
            this.resultSet.addAll(view.getResultSet());
            this.resultSet.removeAll(andSet);
            return this;
        }

        @Override
        public SharedContextView xnor(SharedContextView view) {
            Set tmpSet = new HashSet(this.resultSet);
            tmpSet.retainAll(view.getResultSet());
            this.resultSet.addAll(view.getResultSet());
            this.resultSet.removeAll(tmpSet);
            tmpSet = SharedContextService.this.indexManager.keySet();
            tmpSet.removeAll(this.resultSet);
            this.resultSet = tmpSet;
            return this;
        }

        @Override
        public SharedContextView imp(SharedContextView view) {
            Set all = SharedContextService.this.indexManager.keySet();
            all.removeAll(this.resultSet);
            all.addAll(view.getResultSet());
            this.resultSet = all;
            return this;
        }

        @Override
        public SharedContextView nimp(SharedContextView view) {
            this.resultSet.removeAll(view.getResultSet());
            return this;
        }

        @Override
        public SharedContextView cimp(SharedContextView view) {
            Set all = SharedContextService.this.indexManager.keySet();
            all.removeAll(view.getResultSet());
            all.addAll(this.resultSet);
            this.resultSet = all;
            return this;
        }

        @Override
        public SharedContextView cnimp(SharedContextView view) {
            HashSet targetSet = new HashSet(view.getResultSet());
            targetSet.removeAll(this.resultSet);
            this.resultSet = targetSet;
            return this;
        }

        @Override
        public SharedContextView searchKey(String indexName, String[] propNames) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchKey(SharedContextService.this.defaultTimeout, indexName, propNames);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchKey(long timeout, String indexName, String[] propNames) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propNames)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(1, new Object[]{indexName, propNames})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchKey(this.resultSet, indexName, propNames);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchKey(indexName, propNames));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchNull(String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchNull(SharedContextService.this.defaultTimeout, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchNull(long timeout, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(2, new Object[]{indexName, propName})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchNull(new HashSet(), indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchNull(indexName, propName));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchNotNull(String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchNotNull(SharedContextService.this.defaultTimeout, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchNotNull(long timeout, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(3, new Object[]{indexName, propName})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchNotNull(new HashSet(), indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchNotNull(indexName, propName));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchBy(Object value, String indexName, String[] propNames) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchBy(SharedContextService.this.defaultTimeout, value, indexName, propNames);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchBy(long timeout, Object value, String indexName, String[] propNames) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propNames)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(4, new Object[]{value, indexName, propNames})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchBy(new HashSet(), value, indexName, propNames);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchBy(value, indexName, propNames));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchIn(String indexName, String[] propNames, Object[] values) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchIn(SharedContextService.this.defaultTimeout, indexName, propNames, values);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchIn(long timeout, String indexName, String[] propNames, Object[] values) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propNames)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(5, new Object[]{indexName, propNames, values})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchIn(this.resultSet, indexName, propNames, values);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchIn(indexName, propNames, values));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchByProperty(Object prop, String indexName, String propName) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchByProperty(SharedContextService.this.defaultTimeout, prop, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchByProperty(long timeout, Object prop, String indexName, String propName) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(6, new Object[]{prop, indexName, propName})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchByProperty(new HashSet(), prop, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchByProperty(prop, indexName, propName));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchInProperty(String indexName, String propName, Object[] props) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchInProperty(SharedContextService.this.defaultTimeout, indexName, propName, props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchInProperty(long timeout, String indexName, String propName, Object[] props) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(7, new Object[]{indexName, propName, props})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchInProperty(this.resultSet, indexName, propName, props);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchInProperty(indexName, propName, props));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchByProperty(Map props, String indexName) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchByProperty(SharedContextService.this.defaultTimeout, props, indexName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchByProperty(long timeout, Map props, String indexName) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, indexName == null && props != null ? props.keySet().toArray(new String[props.size()]) : null)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(8, new Object[]{props, indexName})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchByProperty(new HashSet(), props, indexName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchByProperty(props, indexName));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchInProperty(String indexName, Map[] props) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchInProperty(SharedContextService.this.defaultTimeout, indexName, props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchInProperty(long timeout, String indexName, Map[] props) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, indexName == null && props != null && props.length != 0 ? props[0].keySet().toArray(new String[props[0].size()]) : null)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(9, new Object[]{indexName, props})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchInProperty(this.resultSet, indexName, props);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchInProperty(indexName, props));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchFrom(Object fromValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchFrom(SharedContextService.this.defaultTimeout, fromValue, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchFrom(long timeout, Object fromValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(10, new Object[]{this.resultSet, indexName, propName, fromValue})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchFrom(this.resultSet, fromValue, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchFrom(fromValue));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchFromProperty(Object fromProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchFromProperty(SharedContextService.this.defaultTimeout, fromProp, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchFromProperty(long timeout, Object fromProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(11, new Object[]{this.resultSet, indexName, propName, fromProp})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchFromProperty(this.resultSet, fromProp, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchFromProperty(fromProp));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchTo(Object toValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchTo(SharedContextService.this.defaultTimeout, toValue, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchTo(long timeout, Object toValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(12, new Object[]{this.resultSet, indexName, propName, toValue})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchTo(this.resultSet, toValue, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchTo(toValue));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchToProperty(Object toProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchToProperty(SharedContextService.this.defaultTimeout, toProp, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchToProperty(long timeout, Object toProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(13, new Object[]{this.resultSet, indexName, propName, toProp})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchToProperty(this.resultSet, toProp, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchToProperty(toProp));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchRange(Object fromValue, Object toValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchRange(SharedContextService.this.defaultTimeout, fromValue, toValue, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchRange(long timeout, Object fromValue, Object toValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(14, new Object[]{this.resultSet, indexName, propName, fromValue, toValue})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchRange(this.resultSet, fromValue, toValue, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchRange(fromValue, toValue));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchRangeProperty(Object fromProp, Object toProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchRangeProperty(SharedContextService.this.defaultTimeout, fromProp, toProp, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchRangeProperty(long timeout, Object fromProp, Object toProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(15, new Object[]{fromProp, toProp, indexName, propName, this.resultSet})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchRangeProperty(this.resultSet, fromProp, toProp, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchRangeProperty(fromProp, toProp));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchFrom(Object fromValue, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchFrom(SharedContextService.this.defaultTimeout, fromValue, inclusive, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchFrom(long timeout, Object fromValue, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(10, new Object[]{this.resultSet, indexName, propName, fromValue, inclusive ? Boolean.TRUE : Boolean.FALSE})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchFrom(this.resultSet, fromValue, inclusive, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchFrom(fromValue, inclusive));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchFromProperty(Object fromProp, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchFromProperty(SharedContextService.this.defaultTimeout, fromProp, inclusive, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchFromProperty(long timeout, Object fromProp, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(11, new Object[]{this.resultSet, indexName, propName, fromProp, inclusive ? Boolean.TRUE : Boolean.FALSE})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchFromProperty(this.resultSet, fromProp, inclusive, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchFromProperty(fromProp, inclusive));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchTo(Object toValue, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchTo(SharedContextService.this.defaultTimeout, toValue, inclusive, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchTo(long timeout, Object toValue, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(12, new Object[]{this.resultSet, indexName, propName, toValue, inclusive ? Boolean.TRUE : Boolean.FALSE})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchTo(this.resultSet, toValue, inclusive, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchTo(toValue, inclusive));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchToProperty(Object toProp, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchToProperty(SharedContextService.this.defaultTimeout, toProp, inclusive, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchToProperty(long timeout, Object toProp, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(13, new Object[]{this.resultSet, indexName, propName, toProp, inclusive ? Boolean.TRUE : Boolean.FALSE})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchToProperty(this.resultSet, toProp, inclusive, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchToProperty(toProp, inclusive));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchRange(Object fromValue, boolean fromInclusive, Object toValue, boolean toInclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchRange(SharedContextService.this.defaultTimeout, fromValue, fromInclusive, toValue, toInclusive, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchRange(long timeout, Object fromValue, boolean fromInclusive, Object toValue, boolean toInclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(14, new Object[]{this.resultSet, indexName, propName, fromValue, fromInclusive ? Boolean.TRUE : Boolean.FALSE, toValue, toInclusive ? Boolean.TRUE : Boolean.FALSE})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchRange(this.resultSet, fromValue, fromInclusive, toValue, toInclusive, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchRange(fromValue, fromInclusive, toValue, toInclusive));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public SharedContextView searchRangeProperty(Object fromProp, boolean fromInclusive, Object toProp, boolean toInclusive, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchRangeProperty(SharedContextService.this.defaultTimeout, fromProp, fromInclusive, toProp, toInclusive, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedContextView searchRangeProperty(long timeout, Object fromProp, boolean fromInclusive, Object toProp, boolean toInclusive, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(15, new Object[]{fromProp, fromInclusive ? Boolean.TRUE : Boolean.FALSE, toProp, toInclusive ? Boolean.TRUE : Boolean.FALSE, indexName, propName, this.resultSet})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchRangeProperty(this.resultSet, fromProp, fromInclusive, toProp, toInclusive, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchRangeProperty(fromProp, fromInclusive, toProp, toInclusive));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        @Override
        public Object clone() {
            SharedContextViewImpl clone = null;
            try {
                clone = (SharedContextViewImpl)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (this.resultSet != null) {
                clone.resultSet = new HashSet(this.resultSet);
            }
            this.operator = 1;
            return clone;
        }
    }

    protected class LocalSharedContext
    implements SharedContext {
        protected LocalSharedContext() {
        }

        @Override
        public void lock(Object key) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void lock(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean lock(Object key, boolean ifAcquireable, boolean ifExist, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean unlock(Object key) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean unlock(Object key, boolean force) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getLockOwner(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLockWaitCount(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(Object key, Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object putLocal(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAsynch(Object key, Object value) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void update(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void update(Object key, SharedContextValueDifference diff, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void updateLocal(Object key, SharedContextValueDifference diff) throws SharedContextUpdateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void updateAsynch(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void updateIfExists(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void updateIfExists(Object key, SharedContextValueDifference diff, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void updateLocalIfExists(Object key, SharedContextValueDifference diff) throws SharedContextUpdateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void updateAsynchIfExists(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map t, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAllLocal(Map t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAllAsynch(Map t) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            return SharedContextService.this.getLocal(key);
        }

        @Override
        public Object get(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.getLocal(key);
        }

        @Override
        public Object get(Object key, long timeout, boolean withTransaction) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.getLocal(key);
        }

        @Override
        public Object getLocal(Object key) {
            return SharedContextService.this.getLocal(key);
        }

        @Override
        public Object remove(Object key) {
            return SharedContextService.this.removeLocal(key);
        }

        @Override
        public Object remove(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.removeLocal(key);
        }

        @Override
        public Object removeLocal(Object key) {
            return SharedContextService.this.removeLocal(key);
        }

        @Override
        public void removeAsynch(Object key) throws SharedContextSendException {
            SharedContextService.this.removeLocal(key);
        }

        @Override
        public void clear() {
            SharedContextService.this.clearLocal();
        }

        @Override
        public void clear(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            SharedContextService.this.clearLocal();
        }

        @Override
        public void clearLocal() {
            SharedContextService.this.clearLocal();
        }

        @Override
        public void clearAsynch() throws SharedContextSendException {
            SharedContextService.this.clearLocal();
        }

        @Override
        public Set keySet() {
            return SharedContextService.this.keySetLocal();
        }

        @Override
        public Set keySet(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.keySetLocal();
        }

        @Override
        public Set keySetLocal() {
            return SharedContextService.this.keySetLocal();
        }

        @Override
        public int size() {
            return SharedContextService.this.sizeLocal();
        }

        @Override
        public int size(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.sizeLocal();
        }

        @Override
        public int sizeLocal() {
            return SharedContextService.this.sizeLocal();
        }

        @Override
        public boolean isEmpty() throws SharedContextSendException {
            return SharedContextService.this.isEmptyLocal();
        }

        @Override
        public boolean isEmptyLocal() {
            return SharedContextService.this.isEmptyLocal();
        }

        @Override
        public boolean containsKey(Object key) {
            return SharedContextService.this.containsKeyLocal(key);
        }

        @Override
        public boolean containsKey(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.containsKeyLocal(key);
        }

        @Override
        public boolean containsKeyLocal(Object key) {
            return SharedContextService.this.containsKeyLocal(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return SharedContextService.this.containsValueLocal(value);
        }

        @Override
        public boolean containsValue(Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.containsValueLocal(value);
        }

        @Override
        public boolean containsValueLocal(Object value) {
            return SharedContextService.this.containsValueLocal(value);
        }

        @Override
        public Map all() {
            return SharedContextService.this.allLocal();
        }

        @Override
        public Map allLocal() {
            return SharedContextService.this.allLocal();
        }

        @Override
        public Set entrySet() {
            return SharedContextService.this.entrySetLocal();
        }

        @Override
        public Set entrySetLocal() {
            return SharedContextService.this.entrySetLocal();
        }

        @Override
        public Collection values() {
            return SharedContextService.this.valuesLocal();
        }

        @Override
        public Collection valuesLocal() {
            return SharedContextService.this.valuesLocal();
        }

        @Override
        public void synchronize() throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void synchronize(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isClient() {
            return SharedContextService.this.isClient();
        }

        @Override
        public boolean isMain() {
            return SharedContextService.this.isMain();
        }

        @Override
        public Object getId() {
            return SharedContextService.this.getId();
        }

        @Override
        public Object getMainId() {
            return SharedContextService.this.getMainId();
        }

        @Override
        public List getMemberIdList() {
            return SharedContextService.this.getMemberIdList();
        }

        @Override
        public Set getClientMemberIdSet() {
            return SharedContextService.this.getClientMemberIdSet();
        }

        @Override
        public Set getServerMemberIdSet() {
            return SharedContextService.this.getServerMemberIdSet();
        }

        @Override
        public void addSharedContextUpdateListener(SharedContextUpdateListener listener) {
            SharedContextService.this.addSharedContextUpdateListener(listener);
        }

        @Override
        public void removeSharedContextUpdateListener(SharedContextUpdateListener listener) {
            SharedContextService.this.removeSharedContextUpdateListener(listener);
        }

        @Override
        public void setIndex(String name, String[] props) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIndex(String name, BeanTableIndexKeyFactory keyFactory) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeIndex(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void analyzeIndex(String name) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void analyzeIndex(String name, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public SharedContextView createView() {
            return SharedContextService.this.createView();
        }

        @Override
        public Object executeInterpretQuery(String query, Map variables) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object executeInterpretQuery(String query, Map variables, long timeout) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void load() throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        public void loadKey() throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        public void load(Object key) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        public void save() throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        public void save(Object key) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        public void load(long timeout) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        public void loadKey(long timeout) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        public void load(Object key, long timeout) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        public void save(long timeout) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        public void save(Object key, long timeout) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    protected class ExecuteQueueHandler
    implements QueueHandler {
        protected ExecuteQueueHandler() {
        }

        @Override
        public void handleDequeuedObject(Object obj) throws Throwable {
            AsynchContext ac = (AsynchContext)obj;
            if (ac == null) {
                return;
            }
            Object[] params = (Object[])ac.getInput();
            String query = (String)params[0];
            Map variables = (Map)params[1];
            String responseSubject = (String)params[2];
            String responseKey = (String)params[3];
            Object sourceId = params[4];
            int sequence = (Integer)params[5];
            Object ret = SharedContextService.this.executeInterpretQueryLocal(query, variables);
            Message response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, ret);
            try {
                SharedContextService.this.serverConnection.response(sourceId, sequence, response);
            }
            catch (MessageSendException e) {
                SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
            }
        }

        @Override
        public boolean handleError(Object obj, Throwable th) throws Throwable {
            return false;
        }

        @Override
        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
            AsynchContext ac = (AsynchContext)obj;
            Object[] params = (Object[])ac.getInput();
            String responseSubject = (String)params[2];
            String responseKey = (String)params[3];
            Object sourceId = params[4];
            int sequence = (Integer)params[5];
            Message response = null;
            try {
                response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                SharedContextService.this.serverConnection.response(sourceId, sequence, response);
            }
            catch (MessageSendException e) {
                SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
            }
        }
    }

    protected class SynchronizeLock {
        protected int useCount;
        protected final SynchronizeMonitor useMonitor = new WaitSynchronizeMonitor();
        protected final SynchronizeMonitor lockMonitor = new WaitSynchronizeMonitor();
        protected final Set lockOwners = new HashSet();

        protected SynchronizeLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acquireForUse(long timeout) {
            if (this.lockOwners.size() > 0 || this.lockMonitor.isWait()) {
                SynchronizeMonitor synchronizeMonitor = this.useMonitor;
                synchronized (synchronizeMonitor) {
                    if (this.lockOwners.size() > 0 || this.lockMonitor.isWait()) {
                        if (this.useCount == 0) {
                            this.lockMonitor.notifyAllMonitor();
                        }
                        try {
                            if (!this.useMonitor.initAndWaitMonitor(timeout)) {
                                return false;
                            }
                        }
                        catch (InterruptedException e) {
                            return false;
                        }
                    }
                    ++this.useCount;
                }
            }
            SynchronizeMonitor synchronizeMonitor = this.useMonitor;
            synchronized (synchronizeMonitor) {
                if (this.lockOwners.size() > 0 || this.lockMonitor.isWait()) {
                    if (this.useCount == 0) {
                        this.lockMonitor.notifyAllMonitor();
                    }
                    try {
                        if (!this.useMonitor.initAndWaitMonitor(timeout)) {
                            return false;
                        }
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                }
                ++this.useCount;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseForUse() {
            SynchronizeMonitor synchronizeMonitor = this.useMonitor;
            synchronized (synchronizeMonitor) {
                if (this.useCount > 0) {
                    --this.useCount;
                    if (this.useCount == 0) {
                        this.lockMonitor.notifyAllMonitor();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acquireForLock(Object id, long timeout) {
            long start = System.currentTimeMillis();
            SynchronizeMonitor synchronizeMonitor = this.useMonitor;
            synchronized (synchronizeMonitor) {
                if (this.useCount <= 0) {
                    this.lockOwners.add(id);
                    return true;
                }
                this.lockMonitor.initMonitor();
            }
            try {
                if (!this.lockMonitor.waitMonitor(timeout)) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            if (timeout > 0L) {
                long processTime = System.currentTimeMillis() - start;
                if (processTime < timeout) {
                    return this.acquireForLock(id, timeout - processTime);
                }
                return false;
            }
            return this.acquireForLock(id, timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseForLock(Object id) {
            SynchronizeMonitor synchronizeMonitor = this.useMonitor;
            synchronized (synchronizeMonitor) {
                if (this.lockOwners.size() > 0) {
                    this.lockOwners.remove(id);
                    if (this.lockOwners.size() == 0) {
                        this.useMonitor.notifyAllMonitor();
                    }
                }
            }
        }

        public void close() {
            this.useMonitor.close();
            this.lockMonitor.close();
        }
    }

    protected class ClientCacheLock {
        protected final SynchronizeMonitor monitor = new WaitSynchronizeMonitor();
        protected Object key;
        protected Object putVlaue;
        protected List updateDiffList;
        protected boolean isRemove;
        protected boolean isNotify;

        public ClientCacheLock(Object key) {
            this.key = key;
        }

        public void init() {
            this.monitor.initMonitor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitLock(long timeout) {
            if (this.isNotify) {
                return true;
            }
            try {
                if (this.monitor.waitMonitor(timeout)) {
                    if (SharedContextService.this.getState() != 3) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.monitor.releaseMonitor();
            }
        }

        public void update(SharedContextValueDifference diff) {
            if (this.updateDiffList == null) {
                this.updateDiffList = new ArrayList();
            }
            this.updateDiffList.add(diff);
        }

        public void remove() {
            this.isRemove = true;
            this.updateDiffList = null;
            this.putVlaue = null;
        }

        public void put(Object value) {
            this.isRemove = false;
            this.updateDiffList = null;
            this.putVlaue = value;
        }

        protected boolean isRemove() {
            return this.isRemove;
        }

        public Object updateValue(Object value) throws SharedContextUpdateException {
            if (this.putVlaue != null) {
                return this.putVlaue;
            }
            if (this.updateDiffList != null) {
                if (value instanceof SharedContextValueDifferenceSupport) {
                    for (int i = 0; i < this.updateDiffList.size(); ++i) {
                        SharedContextValueDifference diff = (SharedContextValueDifference)this.updateDiffList.get(i);
                        int updateResult = ((SharedContextValueDifferenceSupport)value).update(diff);
                        if (updateResult == -1) {
                            throw new SharedContextUpdateException("An update version is mismatching. currentVersion=" + ((SharedContextValueDifferenceSupport)value).getUpdateVersion() + ", updateVersion=" + diff.getUpdateVersion());
                        }
                        if (updateResult != 0) continue;
                        SharedContextService.this.getLogger().write("SCS__00009", new Object[]{this.key, SharedContextService.this.subject});
                    }
                } else {
                    throw new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + this.key + ", value=" + value);
                }
            }
            return value;
        }

        public void notifyAllLock() {
            this.isNotify = true;
            this.monitor.notifyAllMonitor();
        }
    }

    protected class Lock {
        protected Object key;
        protected Object owner;
        protected Thread ownerThread;
        protected long ownerThreadId = -1L;
        protected final SynchronizeMonitor lockMonitor = new WaitSynchronizeMonitor();
        protected Set callbacks = new LinkedHashSet();

        public Lock(Object key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isAcquireable(Object id) {
            Lock lock = this;
            synchronized (lock) {
                Set targetMembers = SharedContextService.this.serverConnection.getReceiveClientIds(SharedContextService.this.allTargetMessage);
                if (SharedContextService.this.getState() == 3) {
                    if (this.owner == null) {
                        return true;
                    }
                    return id.equals(this.owner) && Thread.currentThread().equals(this.ownerThread);
                    {
                    }
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public boolean acquire(Object id, boolean ifAcquireable, long timeout) {
            NotifyCallback callback = null;
            Lock lock = this;
            // MONITORENTER : lock
            Set targetMembers = SharedContextService.this.serverConnection.getReceiveClientIds(SharedContextService.this.allTargetMessage);
            if (SharedContextService.this.getState() == 3) {
                if (this.owner == null) {
                    this.owner = id;
                    this.ownerThread = Thread.currentThread();
                    this.ownerThreadId = this.ownerThread.getId();
                    Map map = SharedContextService.this.idLocksMap;
                    // MONITORENTER : map
                    HashSet<Object> keySet = (HashSet<Object>)SharedContextService.this.idLocksMap.get(id);
                    if (keySet == null) {
                        keySet = new HashSet<Object>();
                        SharedContextService.this.idLocksMap.put(id, keySet);
                    }
                    HashSet<Object> hashSet = keySet;
                    // MONITORENTER : hashSet
                    keySet.add(this.key);
                    // MONITOREXIT : hashSet
                    // MONITOREXIT : map
                    // MONITOREXIT : lock
                    return true;
                }
                if (id.equals(this.owner) && Thread.currentThread().equals(this.ownerThread)) {
                    // MONITOREXIT : lock
                    return true;
                }
            } else {
                Set set = this.callbacks;
                // MONITORENTER : set
                if (this.callbacks.size() > 1) {
                    this.lockMonitor.notifyMonitor();
                }
                // MONITOREXIT : set
                // MONITOREXIT : lock
                return false;
            }
            if (ifAcquireable) {
                // MONITOREXIT : lock
                return false;
            }
            callback = new NotifyCallback();
            Object object = this.callbacks;
            // MONITORENTER : object
            this.callbacks.add(callback);
            // MONITOREXIT : object
            this.lockMonitor.initMonitor();
            // MONITOREXIT : lock
            try {
                long start = System.currentTimeMillis();
                if (this.lockMonitor.waitMonitor(timeout)) {
                    object = this;
                    // MONITORENTER : object
                    Object object2 = this.callbacks;
                    // MONITORENTER : object2
                    this.callbacks.remove(callback);
                    // MONITOREXIT : object2
                    if ((timeout -= System.currentTimeMillis() - start) > 0L) {
                        // MONITOREXIT : object
                        boolean bl = this.acquire(id, false, timeout);
                        return bl;
                    }
                    object2 = this.callbacks;
                    // MONITORENTER : object2
                    if (this.callbacks.size() > 1) {
                        this.lockMonitor.notifyMonitor();
                    }
                    // MONITOREXIT : object2
                    boolean bl = false;
                    // MONITOREXIT : object
                    return bl;
                }
                object = this;
                // MONITORENTER : object
                Set set = this.callbacks;
                // MONITORENTER : set
                if (this.callbacks.size() > 1) {
                    this.lockMonitor.notifyMonitor();
                }
                // MONITOREXIT : set
                // MONITOREXIT : object
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException e) {
                Lock lock2 = this;
                // MONITORENTER : lock2
                object = this.callbacks;
                // MONITORENTER : object
                if (this.callbacks.size() > 1) {
                    this.lockMonitor.notifyMonitor();
                }
                // MONITOREXIT : object
                // MONITOREXIT : lock2
                boolean bl = false;
                return bl;
            }
            finally {
                object = this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acquireForReply(Object id, long threadId, boolean ifAcquireable, boolean ifExist, long timeout, Object sourceId, int sequence, String responseSubject, String responseKey) {
            boolean isLocal = id.equals(SharedContextService.this.getId());
            Lock lock = this;
            synchronized (lock) {
                Set targetMembers = SharedContextService.this.serverConnection.getReceiveClientIds(SharedContextService.this.allTargetMessage);
                if (SharedContextService.this.getState() == 3 && (isLocal || targetMembers.contains(id))) {
                    if (this.owner == null) {
                        this.owner = id;
                        if (isLocal) {
                            this.ownerThread = Thread.currentThread();
                            this.ownerThreadId = -1L;
                        } else {
                            this.ownerThread = null;
                            this.ownerThreadId = threadId;
                        }
                        Map map = SharedContextService.this.idLocksMap;
                        synchronized (map) {
                            HashSet<Object> keySet = (HashSet<Object>)SharedContextService.this.idLocksMap.get(id);
                            if (keySet == null) {
                                keySet = new HashSet<Object>();
                                SharedContextService.this.idLocksMap.put(id, keySet);
                            }
                            HashSet<Object> hashSet = keySet;
                            synchronized (hashSet) {
                                keySet.add(this.key);
                            }
                        }
                        return true;
                    }
                    if (id.equals(this.owner) && (isLocal && Thread.currentThread().equals(this.ownerThread) || !isLocal && threadId == this.ownerThreadId)) {
                        return true;
                    }
                } else {
                    Set set = this.callbacks;
                    synchronized (set) {
                        if (this.callbacks.size() > 1) {
                            this.lockMonitor.notifyMonitor();
                        }
                    }
                    return false;
                }
                if (ifAcquireable) {
                    return false;
                }
                NotifyCallback callback = new NotifyCallback(id, this.ownerThreadId, ifExist, timeout, sourceId, sequence, responseSubject, responseKey);
                Set set = this.callbacks;
                synchronized (set) {
                    this.callbacks.add(callback);
                }
                if (timeout > 0L) {
                    SharedContextService.this.lockTimeoutTimer.schedule((TimerTask)callback, timeout);
                }
                set = this.callbacks;
                synchronized (set) {
                    if (this.callbacks.size() > 1) {
                        this.lockMonitor.notifyMonitor();
                    }
                }
            }
            return false;
        }

        public Object getOwner() {
            return this.owner;
        }

        public Thread getOwnerThread() {
            return this.ownerThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getWaitCount() {
            Set set = this.callbacks;
            synchronized (set) {
                return this.callbacks.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean release(Object id, boolean force) {
            boolean isLocal = id.equals(SharedContextService.this.getId());
            boolean result = false;
            NotifyCallback callback = null;
            Lock lock = this;
            synchronized (lock) {
                if (this.owner == null || id.equals(this.owner) && (force || !isLocal || Thread.currentThread().equals(this.ownerThread))) {
                    this.owner = null;
                    this.ownerThread = null;
                    this.ownerThreadId = -1L;
                    result = true;
                }
                Object object = SharedContextService.this.idLocksMap;
                synchronized (object) {
                    Set keySet = (Set)SharedContextService.this.idLocksMap.get(id);
                    if (keySet != null) {
                        Set set = keySet;
                        synchronized (set) {
                            keySet.remove(this.key);
                        }
                    }
                }
                object = this.callbacks;
                synchronized (object) {
                    if (this.callbacks.size() != 0) {
                        callback = (NotifyCallback)this.callbacks.iterator().next();
                    }
                }
            }
            if (callback != null) {
                callback.notify(true);
            }
            return result;
        }

        protected class NotifyCallback
        extends TimerTask {
            protected boolean isLocal;
            protected Object id;
            protected long threadId;
            protected long startTime;
            protected long timeout;
            protected Object sourceId;
            protected int sequence;
            protected String responseSubject;
            protected String responseKey;
            protected boolean ifExist;

            public NotifyCallback() {
                this.isLocal = true;
            }

            public NotifyCallback(Object id, long threadId, boolean ifExist, long timeout, Object sourceId, int sequence, String responseSubject, String responseKey) {
                this.isLocal = false;
                this.id = id;
                this.threadId = threadId;
                this.sourceId = sourceId;
                this.sequence = sequence;
                this.responseSubject = responseSubject;
                this.responseKey = responseKey;
                this.ifExist = ifExist;
                this.timeout = timeout;
                this.startTime = System.currentTimeMillis();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notify(boolean notify) {
                if (this.isLocal) {
                    Lock.this.lockMonitor.notifyMonitor();
                    return;
                }
                if (notify) {
                    if (this.timeout <= 0L) {
                        if (!Lock.this.acquireForReply(this.id, this.threadId, false, this.ifExist, this.timeout, this.sourceId, this.sequence, this.responseSubject, this.responseKey)) {
                            return;
                        }
                    } else {
                        long currentTimeout = this.startTime + this.timeout - System.currentTimeMillis();
                        if (currentTimeout > 0L) {
                            if (!Lock.this.acquireForReply(this.id, this.threadId, false, this.ifExist, currentTimeout, this.sourceId, this.sequence, this.responseSubject, this.responseKey)) {
                                return;
                            }
                        } else {
                            notify = false;
                        }
                    }
                    if (this.ifExist && SharedContextService.this.isMain() && !SharedContextService.super.containsKey(Lock.this.key)) {
                        Lock.this.release(this.id, false);
                        notify = false;
                    }
                }
                this.cancel();
                Message response = null;
                try {
                    response = SharedContextService.this.createResponseMessage(this.responseSubject, this.responseKey, notify ? Boolean.TRUE : Boolean.FALSE);
                }
                catch (Throwable th) {
                    response = SharedContextService.this.createResponseMessage(this.responseSubject, this.responseKey, th);
                }
                try {
                    SharedContextService.this.serverConnection.response(this.sourceId, this.sequence, response);
                }
                catch (MessageSendException e) {
                    SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
                }
                Set set = Lock.this.callbacks;
                synchronized (set) {
                    Lock.this.callbacks.remove(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean isRemoved = false;
                Set set = Lock.this.callbacks;
                synchronized (set) {
                    isRemoved = Lock.this.callbacks.remove(this);
                }
                if (isRemoved) {
                    this.notify(false);
                }
            }
        }
    }

    protected static class SharedContextEvent
    implements Externalizable {
        private static final long serialVersionUID = 2159594639856055423L;
        public static final byte EVENT_PUT = 1;
        public static final byte EVENT_REMOVE = 2;
        public static final byte EVENT_CLEAR = 3;
        public static final byte EVENT_GET_ALL = 4;
        public static final byte EVENT_GET = 5;
        public static final byte EVENT_PUT_ALL = 6;
        public static final byte EVENT_KEY_SET = 7;
        public static final byte EVENT_SIZE = 8;
        public static final byte EVENT_CONTAINS_KEY = 9;
        public static final byte EVENT_CONTAINS_VALUE = 10;
        public static final byte EVENT_SYNCH_ALL = 11;
        public static final byte EVENT_GET_LOCK = 12;
        public static final byte EVENT_GOT_LOCK = 13;
        public static final byte EVENT_RELEASE_LOCK = 14;
        public static final byte EVENT_SAVE = 15;
        public static final byte EVENT_LOAD = 16;
        public static final byte EVENT_LOAD_KEY = 17;
        public static final byte EVENT_UPDATE = 18;
        public static final byte EVENT_SYNCH = 19;
        public static final byte EVENT_PUT_INNER = 20;
        public static final byte EVENT_ANALYZE_KEY_INDEX = 21;
        public static final byte EVENT_SEARCH_INDEX = 22;
        public static final byte EVENT_EXECUTE_INTERPRET = 23;
        public static final byte EVENT_GET_UPDATE_LOCK = 24;
        public static final byte EVENT_RELEASE_UPDATE_LOCK = 25;
        public static final byte EVENT_CHANGE_MODE = 26;
        public byte type;
        public Object key;
        public Object value;

        public SharedContextEvent() {
        }

        public SharedContextEvent(byte type) {
            this(type, null, null);
        }

        public SharedContextEvent(byte type, Object key) {
            this(type, key, null);
        }

        public SharedContextEvent(byte type, Object key, Object value) {
            this.type = type;
            this.key = key;
            this.value = value;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.write(this.type);
            out.writeObject(this.key);
            out.writeObject(this.value);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = (byte)in.read();
            this.key = in.readObject();
            this.value = in.readObject();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append('{');
            buf.append("type=").append(this.type);
            buf.append(", key=").append(this.key);
            buf.append(", value=").append(this.value);
            buf.append('}');
            return buf.toString();
        }
    }
}

