/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.graph.DatabaseDatasetCondition;
import jp.ossc.nimbus.service.graph.DatabaseOHLCDatasetFactoryServiceMBean;
import jp.ossc.nimbus.service.graph.DatasetCondition;
import jp.ossc.nimbus.service.graph.DatasetConnection;
import jp.ossc.nimbus.service.graph.DatasetCreateException;
import jp.ossc.nimbus.service.graph.OHLCDatasetFactoryService;

public class DatabaseOHLCDatasetFactoryService
extends OHLCDatasetFactoryService
implements DatabaseOHLCDatasetFactoryServiceMBean {
    private static final long serialVersionUID = -3149613092108949933L;
    protected ConnectionFactory connFactory;
    protected String seriesName;
    protected String sql;
    protected List dsConditionList;
    protected int fetchSize = 10000;
    protected String dateFormatPattern;
    protected ServiceName dateFormatServiceName;
    protected String dateColumnName;
    protected String timeColumnName;
    protected String openPriceColumnName;
    protected String highPriceColumnName;
    protected String lowPriceColumnName;
    protected String closePriceColumnName;
    protected String volumeColumnName;
    protected int dateColumnIndex = -1;
    protected int timeColumnIndex = -1;
    protected int openPriceColumnIndex = -1;
    protected int highPriceColumnIndex = -1;
    protected int lowPriceColumnIndex = -1;
    protected int closePriceColumnIndex = -1;
    protected int volumeColumnIndex = -1;

    public void setConnectionFactory(ConnectionFactory connFactory) {
        this.connFactory = connFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connFactory;
    }

    public void setSeriesName(String name) {
        this.seriesName = name;
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public void setFetchSize(int size) {
        this.fetchSize = size;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setDateFormatPattern(String pattern) {
        this.dateFormatPattern = pattern;
    }

    @Override
    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    @Override
    public void setDateFormatServiceName(ServiceName serviceName) {
        this.dateFormatServiceName = serviceName;
    }

    @Override
    public ServiceName getDateFormatServiceName() {
        return this.dateFormatServiceName;
    }

    @Override
    public void setDateColumnName(String columnName) {
        this.dateColumnName = columnName;
    }

    @Override
    public String getDateColumnName() {
        return this.dateColumnName;
    }

    @Override
    public void setTimeColumnName(String columnName) {
        this.timeColumnName = columnName;
    }

    @Override
    public String getTimeColumnName() {
        return this.timeColumnName;
    }

    @Override
    public void setOpenPriceColumnName(String columnName) {
        this.openPriceColumnName = columnName;
    }

    @Override
    public String getOpenPriceColumnName() {
        return this.openPriceColumnName;
    }

    @Override
    public void setHighPriceColumnName(String columnName) {
        this.highPriceColumnName = columnName;
    }

    @Override
    public String getHighPriceColumnName() {
        return this.highPriceColumnName;
    }

    @Override
    public void setLowPriceColumnName(String columnName) {
        this.lowPriceColumnName = columnName;
    }

    @Override
    public String getLowPriceColumnName() {
        return this.lowPriceColumnName;
    }

    @Override
    public void setClosePriceColumnName(String columnName) {
        this.closePriceColumnName = columnName;
    }

    @Override
    public String getClosePriceColumnName() {
        return this.closePriceColumnName;
    }

    @Override
    public void setVolumeColumnName(String columnName) {
        this.volumeColumnName = columnName;
    }

    @Override
    public String getVolumeColumnName() {
        return this.volumeColumnName;
    }

    @Override
    public void setDateColumnIndex(int index) {
        this.dateColumnIndex = index;
    }

    @Override
    public int getDateColumnIndex() {
        return this.dateColumnIndex;
    }

    @Override
    public void setTimeColumnIndex(int index) {
        this.timeColumnIndex = index;
    }

    @Override
    public int getTimeColumnIndex() {
        return this.timeColumnIndex;
    }

    @Override
    public void setOpenPriceColumnIndex(int index) {
        this.openPriceColumnIndex = index;
    }

    @Override
    public int getOpenPriceColumnIndex() {
        return this.openPriceColumnIndex;
    }

    @Override
    public void setHighPriceColumnIndex(int index) {
        this.highPriceColumnIndex = index;
    }

    @Override
    public int getHighPriceColumnIndex() {
        return this.highPriceColumnIndex;
    }

    @Override
    public void setLowPriceColumnIndex(int index) {
        this.lowPriceColumnIndex = index;
    }

    @Override
    public int getLowPriceColumnIndex() {
        return this.lowPriceColumnIndex;
    }

    @Override
    public void setClosePriceColumnIndex(int index) {
        this.closePriceColumnIndex = index;
    }

    @Override
    public int getClostePriceColumnIndex() {
        return this.closePriceColumnIndex;
    }

    @Override
    public void setVolumeColumnIndex(int index) {
        this.volumeColumnIndex = index;
    }

    @Override
    public int getVolumeColumnIndex() {
        return this.volumeColumnIndex;
    }

    @Override
    public void createService() throws Exception {
        this.dsConditionList = new ArrayList();
    }

    @Override
    public void startService() throws Exception {
        if (this.connFactory == null) {
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if (this.sql == null || this.sql.length() == 0) {
            throw new IllegalArgumentException("SQL must be specified.");
        }
        if (this.dateFormatPattern != null) {
            new SimpleDateFormat(this.dateFormatPattern);
        }
        if (this.dateColumnName == null && this.dateColumnIndex <= 0 && this.timeColumnName == null && this.timeColumnIndex <= 0) {
            throw new IllegalArgumentException("dateColumnName or dateColumnIndex or timeColumnName or timeColumnIndex must be specified.");
        }
        if (this.openPriceColumnName == null && this.openPriceColumnIndex <= 0) {
            throw new IllegalArgumentException("openPriceColumnName or openPriceColumnIndex must be specified.");
        }
        if (this.highPriceColumnName == null && this.highPriceColumnIndex <= 0) {
            throw new IllegalArgumentException("highPriceColumnName or highPriceColumnIndex must be specified.");
        }
        if (this.lowPriceColumnName == null && this.lowPriceColumnIndex <= 0) {
            throw new IllegalArgumentException("lowPriceColumnName or lowPriceColumnIndex must be specified.");
        }
        if (this.closePriceColumnName == null && this.closePriceColumnIndex <= 0) {
            throw new IllegalArgumentException("closePriceColumnName or closePriceColumnIndex must be specified.");
        }
    }

    @Override
    public void destroyService() throws Exception {
        this.dsConditionList = null;
    }

    @Override
    protected DatasetConnection createConnection(DatasetCondition[] dsConditions) throws DatasetCreateException {
        int i;
        DateFormat dateFormat = null;
        if (this.dateFormatServiceName != null) {
            dateFormat = (DateFormat)ServiceManagerFactory.getServiceObject(this.dateFormatServiceName);
        } else if (this.dateFormatPattern != null) {
            dateFormat = new SimpleDateFormat(this.dateFormatPattern);
        }
        Connection conn = null;
        try {
            conn = this.connFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new DatasetCreateException("Dataset [" + this.getName() + "]", e);
        }
        DatabaseOHLCDatasetConnection connection = new DatabaseOHLCDatasetConnection(this.getName(), conn);
        DatabaseOHLCDatasetSeriesCursor cursor = new DatabaseOHLCDatasetSeriesCursor(this.seriesName, conn, this.sql, dateFormat);
        int imax = this.dsConditionList.size();
        for (i = 0; i < imax; ++i) {
            cursor.addCondition((DatasetCondition)this.dsConditionList.get(i));
        }
        if (dsConditions != null) {
            for (i = 0; i < dsConditions.length; ++i) {
                cursor.addCondition(dsConditions[i]);
            }
        }
        cursor.execute();
        connection.addSeriesCursor(cursor);
        return connection;
    }

    protected class DatabaseOHLCDatasetSeriesCursor
    extends OHLCDatasetFactoryService.OHLCDatasetSeriesCursor {
        protected PreparedStatement pstmt;
        protected DateFormat dateFormat;
        protected ResultSet rs;

        public DatabaseOHLCDatasetSeriesCursor(String seriesName, Connection conn, String sql, DateFormat dateFormat) throws DatasetCreateException {
            super(DatabaseOHLCDatasetFactoryService.this, seriesName);
            try {
                this.pstmt = conn.prepareStatement(sql, 1003, 1007);
                this.pstmt.setFetchSize(DatabaseOHLCDatasetFactoryService.this.fetchSize);
                this.pstmt.setFetchDirection(1000);
            }
            catch (SQLException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseOHLCDatasetFactoryService.this.dataSetName + ", " + seriesName + "]", e);
            }
            this.dateFormat = dateFormat;
        }

        @Override
        public boolean addCondition(DatasetCondition condition) throws DatasetCreateException {
            if (!super.addCondition(condition)) {
                return false;
            }
            if (condition instanceof DatabaseDatasetCondition) {
                DatabaseDatasetCondition dbDsCondition = (DatabaseDatasetCondition)condition;
                try {
                    ParameterMetaData paramMetaData = this.pstmt.getParameterMetaData();
                    if (paramMetaData == null) {
                        throw new DatasetCreateException("ParameterMetaData is null.");
                    }
                    int imax = paramMetaData.getParameterCount();
                    for (int i = 0; i < imax; ++i) {
                        Object paramObj = dbDsCondition.getParamObject(i);
                        if (paramObj == null) continue;
                        this.pstmt.setObject(i + 1, paramObj);
                    }
                }
                catch (SQLException e) {
                    throw new DatasetCreateException(e);
                }
            }
            return true;
        }

        public void execute() throws DatasetCreateException {
            try {
                this.rs = this.pstmt.executeQuery();
            }
            catch (SQLException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseOHLCDatasetFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
        }

        @Override
        public boolean next() throws DatasetCreateException {
            try {
                return this.rs.next();
            }
            catch (SQLException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseOHLCDatasetFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
        }

        @Override
        public Date getDate() throws DatasetCreateException {
            Date date = null;
            try {
                if (this.dateFormat != null) {
                    String dateStr = null;
                    String dateVal = null;
                    String timeVal = null;
                    if (DatabaseOHLCDatasetFactoryService.this.dateColumnIndex > 0) {
                        dateVal = this.rs.getString(DatabaseOHLCDatasetFactoryService.this.dateColumnIndex);
                    } else if (DatabaseOHLCDatasetFactoryService.this.dateColumnName != null) {
                        dateVal = this.rs.getString(DatabaseOHLCDatasetFactoryService.this.dateColumnName);
                    }
                    if (DatabaseOHLCDatasetFactoryService.this.timeColumnIndex > 0) {
                        timeVal = this.rs.getString(DatabaseOHLCDatasetFactoryService.this.timeColumnIndex);
                    } else if (DatabaseOHLCDatasetFactoryService.this.timeColumnName != null) {
                        timeVal = this.rs.getString(DatabaseOHLCDatasetFactoryService.this.timeColumnName);
                    }
                    boolean isTimeOnly = false;
                    if (dateVal != null && timeVal != null) {
                        dateStr = dateVal + timeVal;
                    } else if (dateVal != null) {
                        dateStr = dateVal;
                    } else {
                        dateStr = timeVal;
                        isTimeOnly = true;
                    }
                    date = this.dateFormat.parse(dateStr);
                    if (isTimeOnly) {
                        Calendar cal = Calendar.getInstance();
                        int year = cal.get(1);
                        int month = cal.get(2);
                        int day = cal.get(5);
                        cal.clear();
                        cal.setTime(date);
                        cal.set(1, year);
                        cal.set(2, month);
                        cal.set(5, day);
                        date = cal.getTime();
                    }
                } else if (DatabaseOHLCDatasetFactoryService.this.dateColumnIndex > 0) {
                    date = this.rs.getDate(DatabaseOHLCDatasetFactoryService.this.dateColumnIndex);
                } else if (DatabaseOHLCDatasetFactoryService.this.dateColumnName != null) {
                    date = this.rs.getDate(DatabaseOHLCDatasetFactoryService.this.dateColumnName);
                }
            }
            catch (ParseException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseOHLCDatasetFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
            catch (SQLException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseOHLCDatasetFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
            return date;
        }

        @Override
        public double getOpenPrice() throws DatasetCreateException {
            double value = Double.NaN;
            try {
                if (DatabaseOHLCDatasetFactoryService.this.openPriceColumnIndex > 0) {
                    value = this.rs.getDouble(DatabaseOHLCDatasetFactoryService.this.openPriceColumnIndex);
                } else if (DatabaseOHLCDatasetFactoryService.this.openPriceColumnName != null) {
                    value = this.rs.getDouble(DatabaseOHLCDatasetFactoryService.this.openPriceColumnName);
                }
            }
            catch (SQLException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseOHLCDatasetFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
            return value;
        }

        @Override
        public double getHighPrice() throws DatasetCreateException {
            double value = Double.NaN;
            try {
                if (DatabaseOHLCDatasetFactoryService.this.highPriceColumnIndex > 0) {
                    value = this.rs.getDouble(DatabaseOHLCDatasetFactoryService.this.highPriceColumnIndex);
                } else if (DatabaseOHLCDatasetFactoryService.this.highPriceColumnName != null) {
                    value = this.rs.getDouble(DatabaseOHLCDatasetFactoryService.this.highPriceColumnName);
                }
            }
            catch (SQLException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseOHLCDatasetFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
            return value;
        }

        @Override
        public double getLowPrice() throws DatasetCreateException {
            double value = Double.NaN;
            try {
                if (DatabaseOHLCDatasetFactoryService.this.lowPriceColumnIndex > 0) {
                    value = this.rs.getDouble(DatabaseOHLCDatasetFactoryService.this.lowPriceColumnIndex);
                } else if (DatabaseOHLCDatasetFactoryService.this.lowPriceColumnName != null) {
                    value = this.rs.getDouble(DatabaseOHLCDatasetFactoryService.this.lowPriceColumnName);
                }
            }
            catch (SQLException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseOHLCDatasetFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
            return value;
        }

        @Override
        public double getClosePrice() throws DatasetCreateException {
            double value = Double.NaN;
            try {
                if (DatabaseOHLCDatasetFactoryService.this.closePriceColumnIndex > 0) {
                    value = this.rs.getDouble(DatabaseOHLCDatasetFactoryService.this.closePriceColumnIndex);
                } else if (DatabaseOHLCDatasetFactoryService.this.closePriceColumnName != null) {
                    value = this.rs.getDouble(DatabaseOHLCDatasetFactoryService.this.closePriceColumnName);
                }
            }
            catch (SQLException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseOHLCDatasetFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
            return value;
        }

        @Override
        public double getVolume() throws DatasetCreateException {
            double value = Double.NaN;
            try {
                if (DatabaseOHLCDatasetFactoryService.this.volumeColumnIndex > 0) {
                    value = this.rs.getDouble(DatabaseOHLCDatasetFactoryService.this.volumeColumnIndex);
                } else if (DatabaseOHLCDatasetFactoryService.this.volumeColumnName != null) {
                    value = this.rs.getDouble(DatabaseOHLCDatasetFactoryService.this.volumeColumnName);
                }
            }
            catch (SQLException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseOHLCDatasetFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
            return value;
        }

        @Override
        public boolean wasNull() throws DatasetCreateException {
            try {
                return this.rs.wasNull();
            }
            catch (SQLException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseOHLCDatasetFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
        }

        @Override
        public void close() {
            if (this.pstmt != null) {
                try {
                    this.pstmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.pstmt = null;
            }
            if (this.rs != null) {
                try {
                    this.rs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.rs = null;
            }
            super.close();
        }
    }

    protected class DatabaseOHLCDatasetConnection
    extends DatasetConnection {
        protected Connection connection;

        public DatabaseOHLCDatasetConnection(String datasetName, Connection con) {
            super(datasetName);
            this.connection = con;
        }

        @Override
        public void close() {
            super.close();
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = null;
            }
        }
    }
}

