/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.graph.DatabaseDatasetCondition;
import jp.ossc.nimbus.service.graph.DatabaseTimeSeriesCollectionFactoryServiceMBean;
import jp.ossc.nimbus.service.graph.DatasetCondition;
import jp.ossc.nimbus.service.graph.DatasetConnection;
import jp.ossc.nimbus.service.graph.DatasetCreateException;
import jp.ossc.nimbus.service.graph.TimeSeriesCollectionFactoryService;

public class DatabaseTimeSeriesCollectionFactoryService
extends TimeSeriesCollectionFactoryService
implements DatabaseTimeSeriesCollectionFactoryServiceMBean {
    private static final long serialVersionUID = 62063250205247679L;
    protected static final String SEPARATOR = "=";
    protected ConnectionFactory connFactory;
    protected String[] sqls;
    protected List dsConditionList;
    protected Map seriesSqlMap;
    protected int fetchSize = 10000;
    protected String dateColumnName;
    protected String timeColumnName;
    protected String valueColumnName;
    protected int dateColumnIndex = -1;
    protected int timeColumnIndex = -1;
    protected int valueColumnIndex = -1;
    protected String dateFormatPattern;
    protected ServiceName dateFormatServiceName;

    public void setConnectionFactory(ConnectionFactory connFactory) {
        this.connFactory = connFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connFactory;
    }

    public void setSqls(String[] sqls) {
        this.sqls = sqls;
    }

    public String[] getSqls() {
        return this.sqls;
    }

    public void setFetchSize(int size) {
        this.fetchSize = size;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setDateFormatPattern(String pattern) {
        this.dateFormatPattern = pattern;
    }

    @Override
    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    @Override
    public void setDateFormatServiceName(ServiceName serviceName) {
        this.dateFormatServiceName = serviceName;
    }

    @Override
    public ServiceName getDateFormatServiceName() {
        return this.dateFormatServiceName;
    }

    @Override
    public void setDateColumnName(String columnName) {
        this.dateColumnName = columnName;
    }

    @Override
    public String getDateColumnName() {
        return this.dateColumnName;
    }

    @Override
    public void setDateColumnIndex(int index) {
        this.dateColumnIndex = index;
    }

    @Override
    public int getDateColumnIndex() {
        return this.dateColumnIndex;
    }

    @Override
    public void setTimeColumnName(String columnName) {
        this.timeColumnName = columnName;
    }

    @Override
    public String getTimeColumnName() {
        return this.timeColumnName;
    }

    @Override
    public void setTimeColumnIndex(int index) {
        this.timeColumnIndex = index;
    }

    @Override
    public int getTimeColumnIndex() {
        return this.timeColumnIndex;
    }

    @Override
    public void setValueColumnName(String columnName) {
        this.valueColumnName = columnName;
    }

    @Override
    public String getValueColumnName() {
        return this.valueColumnName;
    }

    @Override
    public void setValueColumnIndex(int index) {
        this.valueColumnIndex = index;
    }

    @Override
    public int getValueColumnIndex() {
        return this.valueColumnIndex;
    }

    public void addDatasetCondition(DatasetCondition dsCondition) {
        this.dsConditionList.add(dsCondition);
    }

    public DatasetCondition[] getDatasetConditions() {
        return this.dsConditionList.toArray(new DatasetCondition[this.dsConditionList.size()]);
    }

    @Override
    public void createService() throws Exception {
        this.dsConditionList = new ArrayList();
        this.seriesSqlMap = new LinkedHashMap();
    }

    @Override
    public void startService() throws Exception {
        if (this.connFactory == null) {
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if (this.sqls == null || this.sqls.length == 0) {
            throw new IllegalArgumentException("sqls must be specified.");
        }
        for (int i = 0; i < this.sqls.length; ++i) {
            String seriesSql = this.sqls[i];
            int index = seriesSql.indexOf(SEPARATOR);
            if (index == -1) {
                throw new IllegalArgumentException("sqls is invalid." + seriesSql);
            }
            String seriesName = seriesSql.substring(0, index);
            String sql = seriesSql.substring(index + 1);
            this.seriesSqlMap.put(seriesName, sql);
        }
        if (this.dateFormatPattern != null) {
            new SimpleDateFormat(this.dateFormatPattern);
        }
        if (this.dateColumnName == null && this.dateColumnIndex <= 0 && this.timeColumnName == null && this.timeColumnIndex <= 0) {
            throw new IllegalArgumentException("dateColumnName or dateColumnIndex or timeColumnName or timeColumnIndex must be specified.");
        }
        if (this.valueColumnName == null && this.valueColumnIndex <= 0) {
            throw new IllegalArgumentException("valueColumnName or valueColumnIndex must be specified.");
        }
    }

    @Override
    public void stopService() throws Exception {
        this.seriesSqlMap.clear();
    }

    @Override
    public void destroyService() throws Exception {
        this.dsConditionList = null;
        this.seriesSqlMap = null;
    }

    @Override
    protected DatasetConnection createConnection(DatasetCondition[] dsConditions) throws DatasetCreateException {
        DateFormat dateFormat = null;
        if (this.dateFormatServiceName != null) {
            dateFormat = (DateFormat)ServiceManagerFactory.getServiceObject(this.dateFormatServiceName);
        } else if (this.dateFormatPattern != null) {
            dateFormat = new SimpleDateFormat(this.dateFormatPattern);
        }
        Connection conn = null;
        try {
            conn = this.connFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new DatasetCreateException("Dataset [" + this.getName() + "]", e);
        }
        DatabaseTimeSeriesDatasetConnection connection = new DatabaseTimeSeriesDatasetConnection(this.getName(), conn);
        for (String series : this.seriesSqlMap.keySet()) {
            int i;
            DatabaseTimeSeriesCursor cursor = new DatabaseTimeSeriesCursor(series, conn, (String)this.seriesSqlMap.get(series), dateFormat);
            int imax = this.dsConditionList.size();
            for (i = 0; i < imax; ++i) {
                cursor.addCondition((DatasetCondition)this.dsConditionList.get(i));
            }
            if (dsConditions != null) {
                for (i = 0; i < dsConditions.length; ++i) {
                    cursor.addCondition(dsConditions[i]);
                }
            }
            cursor.execute();
            connection.addSeriesCursor(cursor);
        }
        return connection;
    }

    protected class DatabaseTimeSeriesCursor
    extends TimeSeriesCollectionFactoryService.TimeSeriesCursor {
        protected PreparedStatement pstmt;
        protected DateFormat dateFormat;
        protected ResultSet rs;

        public DatabaseTimeSeriesCursor(String seriesName, Connection conn, String sql, DateFormat dateFormat) throws DatasetCreateException {
            super(DatabaseTimeSeriesCollectionFactoryService.this, seriesName);
            try {
                this.pstmt = conn.prepareStatement(sql, 1003, 1007);
                this.pstmt.setFetchSize(DatabaseTimeSeriesCollectionFactoryService.this.fetchSize);
                this.pstmt.setFetchDirection(1000);
            }
            catch (SQLException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseTimeSeriesCollectionFactoryService.this.dataSetName + ", " + seriesName + "]", e);
            }
            this.dateFormat = dateFormat;
        }

        @Override
        public boolean addCondition(DatasetCondition condition) throws DatasetCreateException {
            if (!super.addCondition(condition)) {
                return false;
            }
            if (condition instanceof DatabaseDatasetCondition) {
                DatabaseDatasetCondition dbDsCondition = (DatabaseDatasetCondition)condition;
                try {
                    ParameterMetaData paramMetaData = this.pstmt.getParameterMetaData();
                    if (paramMetaData == null) {
                        throw new DatasetCreateException("ParameterMetaData is null.");
                    }
                    int imax = paramMetaData.getParameterCount();
                    for (int i = 0; i < imax; ++i) {
                        Object paramObj = dbDsCondition.getParamObject(i);
                        if (paramObj == null) continue;
                        this.pstmt.setObject(i + 1, paramObj);
                    }
                }
                catch (SQLException e) {
                    throw new DatasetCreateException(e);
                }
            }
            return true;
        }

        public void execute() throws DatasetCreateException {
            try {
                this.rs = this.pstmt.executeQuery();
            }
            catch (SQLException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseTimeSeriesCollectionFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
        }

        @Override
        public boolean next() throws DatasetCreateException {
            try {
                return this.rs.next();
            }
            catch (SQLException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseTimeSeriesCollectionFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
        }

        @Override
        public Date getDate() throws DatasetCreateException {
            Date date = null;
            try {
                if (this.dateFormat != null) {
                    String dateStr = null;
                    String dateVal = null;
                    String timeVal = null;
                    if (DatabaseTimeSeriesCollectionFactoryService.this.dateColumnIndex > 0) {
                        dateVal = this.rs.getString(DatabaseTimeSeriesCollectionFactoryService.this.dateColumnIndex);
                    } else if (DatabaseTimeSeriesCollectionFactoryService.this.dateColumnName != null) {
                        dateVal = this.rs.getString(DatabaseTimeSeriesCollectionFactoryService.this.dateColumnName);
                    }
                    if (DatabaseTimeSeriesCollectionFactoryService.this.timeColumnIndex > 0) {
                        timeVal = this.rs.getString(DatabaseTimeSeriesCollectionFactoryService.this.timeColumnIndex);
                    } else if (DatabaseTimeSeriesCollectionFactoryService.this.timeColumnName != null) {
                        timeVal = this.rs.getString(DatabaseTimeSeriesCollectionFactoryService.this.timeColumnName);
                    }
                    boolean isTimeOnly = false;
                    if (dateVal != null && timeVal != null) {
                        dateStr = dateVal + timeVal;
                    } else if (dateVal != null) {
                        dateStr = dateVal;
                    } else {
                        dateStr = timeVal;
                        isTimeOnly = true;
                    }
                    date = this.dateFormat.parse(dateStr);
                    if (isTimeOnly) {
                        Calendar cal = Calendar.getInstance();
                        int year = cal.get(1);
                        int month = cal.get(2);
                        int day = cal.get(5);
                        cal.clear();
                        cal.setTime(date);
                        cal.set(1, year);
                        cal.set(2, month);
                        cal.set(5, day);
                        date = cal.getTime();
                    }
                } else if (DatabaseTimeSeriesCollectionFactoryService.this.dateColumnIndex > 0) {
                    date = this.rs.getDate(DatabaseTimeSeriesCollectionFactoryService.this.dateColumnIndex);
                } else if (DatabaseTimeSeriesCollectionFactoryService.this.dateColumnName != null) {
                    date = this.rs.getDate(DatabaseTimeSeriesCollectionFactoryService.this.dateColumnName);
                }
            }
            catch (ParseException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseTimeSeriesCollectionFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
            catch (SQLException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseTimeSeriesCollectionFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
            return date;
        }

        @Override
        public double getValue() throws DatasetCreateException {
            double value = Double.NaN;
            try {
                value = DatabaseTimeSeriesCollectionFactoryService.this.valueColumnIndex > 0 ? this.rs.getDouble(DatabaseTimeSeriesCollectionFactoryService.this.valueColumnIndex) : this.rs.getDouble(DatabaseTimeSeriesCollectionFactoryService.this.valueColumnName);
            }
            catch (SQLException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseTimeSeriesCollectionFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
            return value;
        }

        @Override
        public boolean wasNull() throws DatasetCreateException {
            try {
                return this.rs.wasNull();
            }
            catch (SQLException e) {
                throw new DatasetCreateException("Dataset[" + DatabaseTimeSeriesCollectionFactoryService.this.dataSetName + ", " + this.seriesName + "]", e);
            }
        }

        @Override
        public void close() {
            if (this.pstmt != null) {
                try {
                    this.pstmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.pstmt = null;
            }
            if (this.rs != null) {
                try {
                    this.rs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.rs = null;
            }
            super.close();
        }
    }

    protected class DatabaseTimeSeriesDatasetConnection
    extends DatasetConnection {
        protected Connection connection;

        public DatabaseTimeSeriesDatasetConnection(String datasetName, Connection con) {
            super(datasetName);
            this.connection = con;
        }

        @Override
        public void close() {
            super.close();
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = null;
            }
        }
    }
}

