/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.http.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.http.proxy.HttpProcessServiceBase;
import jp.ossc.nimbus.service.http.proxy.HttpRequest;
import jp.ossc.nimbus.service.http.proxy.HttpResponse;
import jp.ossc.nimbus.service.http.proxy.TestHttpProcessServiceMBean;
import jp.ossc.nimbus.service.interpreter.EvaluateException;
import jp.ossc.nimbus.service.interpreter.Interpreter;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class TestHttpProcessService
extends HttpProcessServiceBase
implements TestHttpProcessServiceMBean {
    private static final long serialVersionUID = 8149760369064471308L;
    private static final String HTTP_METHOD_CONNECT = "CONNECT";
    private String requestOutputFileEncoding;
    private String responseInputFileEncoding;
    private List conditionActions = new ArrayList();
    private List actions = new ArrayList();

    @Override
    public String getRequestOutputFileEncoding() {
        return this.requestOutputFileEncoding;
    }

    @Override
    public void setRequestOutputFileEncoding(String encoding) {
        this.requestOutputFileEncoding = encoding;
    }

    @Override
    public String getResponseInputFileEncoding() {
        return this.responseInputFileEncoding;
    }

    @Override
    public void setResponseInputFileEncoding(String encoding) {
        this.responseInputFileEncoding = encoding;
    }

    public void setAction(String condition, Action action) throws Exception {
        Condition cond = new Condition(condition, action);
        if (this.conditionActions.contains(cond)) {
            this.conditionActions.remove(cond);
        }
        this.conditionActions.add(cond);
    }

    public void addAction(Action action) {
        if (this.actions.contains(action)) {
            this.actions.remove(action);
        }
        this.actions.add(action);
    }

    public void clearAction() {
        this.actions.clear();
    }

    @Override
    public void doProcess(HttpRequest request, HttpResponse response) throws Exception {
        if (request.getHeader().getMethod().equals(HTTP_METHOD_CONNECT)) {
            response.setHeader("Connection", "Keep-Alive");
            return;
        }
        if (request.body != null) {
            request.body.read();
        }
        Action targetAction = null;
        if (this.actions.size() != 0) {
            targetAction = (Action)this.actions.remove(0);
        } else {
            for (int i = 0; i < this.conditionActions.size(); ++i) {
                Condition cond = (Condition)this.conditionActions.get(i);
                if (!cond.matchRequest(request)) continue;
                targetAction = cond.action;
                break;
            }
        }
        if (targetAction == null) {
            response.setStatusCode(404);
            response.setStatusMessage("No action.");
            return;
        }
        targetAction.processAction(request, this.requestOutputFileEncoding, response, this.responseInputFileEncoding);
    }

    private static class Condition
    implements Serializable {
        private static final long serialVersionUID = -5495011425410843307L;
        private static final String DELIMITER = "@";
        private transient List properties;
        private transient Expression expression;
        private transient List keyList;
        private String condition;
        Action action;

        public Condition(String cond, Action action) throws Exception {
            this.initCondition(cond);
            this.action = action;
        }

        public void initCondition(String cond) throws Exception {
            this.keyList = new ArrayList();
            this.properties = new ArrayList();
            StringTokenizer token = new StringTokenizer(cond, DELIMITER, true);
            boolean keyFlg = false;
            String beforeToken = null;
            StringBuffer condBuf = new StringBuffer();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                if (!keyFlg) {
                    if (DELIMITER.equals(str)) {
                        keyFlg = true;
                    } else {
                        condBuf.append(str);
                    }
                } else if (DELIMITER.equals(str)) {
                    keyFlg = false;
                    if (beforeToken != null) {
                        String tmpKey = "_conditionKey$" + this.keyList.size();
                        this.keyList.add(tmpKey);
                        condBuf.append(tmpKey);
                        Property prop = PropertyFactory.createProperty(beforeToken);
                        prop.setIgnoreNullProperty(true);
                        this.properties.add(prop);
                    } else {
                        condBuf.append(str);
                    }
                }
                beforeToken = str;
            }
            this.expression = ExpressionFactory.createExpression((String)condBuf.toString());
            this.matchRequest(new HttpRequest(), true);
            this.condition = cond;
        }

        protected boolean matchRequest(HttpRequest request) {
            return this.matchRequest(request, false);
        }

        protected boolean matchRequest(HttpRequest request, boolean isTest) {
            JexlContext jexlContext = JexlHelper.createContext();
            int size = this.keyList.size();
            for (int i = 0; i < size; ++i) {
                String keyString = (String)this.keyList.get(i);
                Property property = (Property)this.properties.get(i);
                Object val = null;
                try {
                    val = property.getProperty(request);
                }
                catch (NoSuchPropertyException noSuchPropertyException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                jexlContext.getVars().put(keyString, val);
            }
            try {
                Object exp = this.expression.evaluate(jexlContext);
                if (exp instanceof Boolean) {
                    return (Boolean)exp;
                }
                if (exp == null && isTest) {
                    return true;
                }
                throw new IllegalArgumentException("Result of condition is not boolean : " + this.condition);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            try {
                this.initCondition(this.condition);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Condition)) {
                return false;
            }
            Condition comp = (Condition)obj;
            if (this.condition == null) {
                return comp.condition == null;
            }
            return this.condition.equals(comp.condition);
        }

        public int hashCode() {
            return this.condition == null ? 0 : this.condition.hashCode();
        }
    }

    public static class Action
    implements Serializable {
        private static final long serialVersionUID = 4155428986485777449L;
        public static final String INTERPRET_VAR_NAME_REQUEST = "request";
        public static final String INTERPRET_VAR_NAME_RESPONSE_INPUT_STREAM = "inputStream";
        public static final String INTERPRET_VAR_NAME_RESPONSE_OUTPUT_STREAM = "outputStream";
        public static final String INTERPRET_VAR_NAME_RESPONSE_STRING = "response";
        protected String requestOutputFile;
        protected String requestHeaderOutputFile;
        protected String requestBodyOutputFile;
        protected String responseVersion;
        protected int responseStatusCode = -1;
        protected String responseStatusMessage;
        protected Map responseHeaderMap = new LinkedHashMap();
        protected String responseBodyInputFile;
        protected boolean isBinaryResponse;
        protected long processTime = 0L;
        protected ServiceName interpreterServiceName;
        protected Interpreter interpreter;
        protected String responseBodyEditScript;

        public String getRequestOutputFile() {
            return this.requestOutputFile;
        }

        public void setRequestOutputFile(String file) {
            this.requestOutputFile = file;
        }

        public String getRequestHeaderOutputFile() {
            return this.requestHeaderOutputFile;
        }

        public void setRequestHeaderOutputFile(String file) {
            this.requestHeaderOutputFile = file;
        }

        public String getRequestBodyOutputFile() {
            return this.requestBodyOutputFile;
        }

        public void setRequestBodyOutputFile(String file) {
            this.requestBodyOutputFile = file;
        }

        public void setResponseVersion(String version) {
            this.responseVersion = version;
        }

        public void setResponseStatusCode(int code) {
            this.responseStatusCode = code;
        }

        public void setResponseStatusMessage(String message) {
            this.responseStatusMessage = message;
        }

        public void setProcessTime(long time) {
            this.processTime = time;
        }

        public void setHeader(String name, String val) {
            String[] vals = (String[])this.responseHeaderMap.get(name);
            if (vals == null) {
                vals = new String[]{val};
                this.responseHeaderMap.put(name, vals);
            } else {
                String[] newVals = new String[vals.length + 1];
                System.arraycopy(vals, 0, newVals, 0, vals.length);
                newVals[newVals.length - 1] = val;
                this.responseHeaderMap.put(name, newVals);
            }
        }

        public void setHeaders(String name, String[] vals) {
            this.responseHeaderMap.put(name, vals);
        }

        protected Set getHeaderNameSet() {
            return this.responseHeaderMap.keySet();
        }

        protected String getHeader(String name) {
            String[] vals = (String[])this.responseHeaderMap.get(name);
            return vals == null ? null : vals[0];
        }

        protected String[] getHeaders(String name) {
            return (String[])this.responseHeaderMap.get(name);
        }

        public String getResponseBodyInputFile() {
            return this.responseBodyInputFile;
        }

        public void setResponseBodyInputFile(String file) {
            this.responseBodyInputFile = file;
        }

        public void setBinaryResponse(boolean isBinary) {
            this.isBinaryResponse = isBinary;
        }

        public boolean isBinaryResponse() {
            return this.isBinaryResponse;
        }

        public void setInterpreterServiceName(ServiceName name) {
            this.interpreterServiceName = name;
        }

        public void setInterpreter(Interpreter interpreter) {
            this.interpreter = interpreter;
        }

        protected Interpreter getInterpreter() {
            if (this.interpreterServiceName != null) {
                return (Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
            }
            return this.interpreter;
        }

        public void setResponseBodyEditScript(String script) {
            this.responseBodyEditScript = script;
        }

        private void mkdirs(String path) throws IOException {
            File parent;
            File file = new File(path);
            if (!file.exists() && (parent = file.getParentFile()) != null && !parent.exists()) {
                parent.mkdirs();
            }
        }

        public void processAction(HttpRequest request, String requestOutputFileEncoding, HttpResponse response, String responseInputFileEncoding) throws Exception {
            if (this.processTime > 0L) {
                Thread.sleep(this.processTime);
            }
            this.writeRequest(request, requestOutputFileEncoding);
            this.writeResponse(request, response, responseInputFileEncoding);
        }

        protected void writeRequest(HttpRequest request, String requestOutputFileEncoding) throws IOException {
            if (this.requestOutputFile != null) {
                this.mkdirs(this.requestOutputFile);
                FileOutputStream fos = new FileOutputStream(this.requestOutputFile);
                fos.write(requestOutputFileEncoding == null ? request.header.header.getBytes() : request.header.header.getBytes(requestOutputFileEncoding));
                if (request.body != null) {
                    fos.write(request.body.body);
                }
                fos.close();
            } else {
                FileOutputStream fos;
                if (this.requestHeaderOutputFile != null) {
                    this.mkdirs(this.requestHeaderOutputFile);
                    fos = new FileOutputStream(this.requestHeaderOutputFile);
                    fos.write(requestOutputFileEncoding == null ? request.header.header.getBytes() : request.header.header.getBytes(requestOutputFileEncoding));
                    fos.close();
                }
                if (request.body != null && this.requestBodyOutputFile != null) {
                    this.mkdirs(this.requestBodyOutputFile);
                    fos = new FileOutputStream(this.requestBodyOutputFile);
                    fos.write(request.body.body);
                    fos.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeResponse(HttpRequest request, HttpResponse response, String responseInputFileEncoding) throws IOException, EvaluateException {
            if (this.responseVersion != null) {
                response.setVersion(this.responseVersion);
            }
            if (this.responseStatusCode != -1) {
                response.setStatusCode(this.responseStatusCode);
            }
            if (this.responseStatusMessage != null) {
                response.setStatusMessage(this.responseStatusMessage);
            }
            for (String headerName : this.getHeaderNameSet()) {
                response.setHeaders(headerName, this.getHeaders(headerName));
            }
            if (this.responseBodyInputFile != null) {
                OutputStream os = response.getOutputStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FileInputStream fis = new FileInputStream(this.responseBodyInputFile);
                try {
                    int length = 0;
                    byte[] buf = new byte[1024];
                    while ((length = fis.read(buf)) != -1) {
                        baos.write(buf, 0, length);
                    }
                    if (this.isBinaryResponse) {
                        buf = baos.toByteArray();
                        Interpreter interpreter = this.getInterpreter();
                        if (interpreter != null && this.responseBodyEditScript != null) {
                            HashMap<String, Object> variables = new HashMap<String, Object>();
                            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
                            variables.put(INTERPRET_VAR_NAME_RESPONSE_INPUT_STREAM, bais);
                            baos.reset();
                            variables.put(INTERPRET_VAR_NAME_RESPONSE_OUTPUT_STREAM, baos);
                            variables.put(INTERPRET_VAR_NAME_REQUEST, request);
                            interpreter.evaluate(this.responseBodyEditScript, variables);
                            buf = baos.toByteArray();
                        }
                    } else {
                        String responseStr = null;
                        responseStr = responseInputFileEncoding == null ? new String(baos.toByteArray()) : new String(baos.toByteArray(), responseInputFileEncoding);
                        Interpreter interpreter = this.getInterpreter();
                        if (interpreter != null && this.responseBodyEditScript != null) {
                            HashMap<String, Object> variables = new HashMap<String, Object>();
                            variables.put(INTERPRET_VAR_NAME_RESPONSE_STRING, responseStr);
                            variables.put(INTERPRET_VAR_NAME_REQUEST, request);
                            responseStr = interpreter.evaluate(this.responseBodyEditScript, variables).toString();
                        }
                        buf = responseStr.getBytes(response.getCharacterEncoding());
                    }
                    os.write(buf);
                }
                finally {
                    fis.close();
                }
            }
        }
    }
}

